/********************************************************************
        Actel Axcelerator Family Verilog Library
        NAME: axcelerator.v
        DATE: May 29, 2007
*********************************************************************/

`timescale 1 ns / 100 ps

//----------------------------------------------------------------------
//---             VERILOG LIBRRAY PRIMITIVE SECTION                     
//----------------------------------------------------------------------

 primitive       U_MAJ_3 (Y, A, B, C);
        output Y;
        input  A, B, C;

        table
        //      A       B       C       :       Y

                0       0       ?       :       0       ;
                0       ?       0       :       0       ;
                ?       0       0       :       0       ;
                ?       1       1       :       1       ;
                1       ?       1       :       1       ;
                1       1       ?       :       1       ;

        endtable
endprimitive




 //---------------------------------------------------------------------
 // primitibe module (Dffpr) state table definition
 // FUNCTION : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
 //            ASYNCHRONOUS SET AND CLEAR. CLR PRIORITY WHEN BOTH
 //            SET AND CLEAR ARE LOW ( Q OUTPUT UDP ).
 //            Enable active low.

 //----------------------------------------------------------------------
primitive Dffpr (Q, D, CLK, CLR, PRE, E, NOTIFIER_REG);
  output Q;
  input  NOTIFIER_REG;
  input  D, CLK, E, CLR, PRE;
  reg Q;

	table

	//  D   CLK   CLR  PRE   E  NOTIFIER_REG  :   Qt  :  Qt+1

	    1   (01)    1   1    0      ?         :   ?   :   1;  // clocked data
	    0   (01)    1   1    0      ?         :   ?   :   0;  // clocked data
	    1   (01)    1   1    x      ?         :   1   :   1;  // clocked data
	    0   (01)    1   1    x      ?         :   0   :   0; 
	    0   (01)    1   1    x      ?         :   1   :   x;
	    1   (01)    1   1    x      ?         :   0   :   x;
	    0   (01)    x   1    0      ?         :   ?   :   0;  // pessimism
	    1   (01)    1   x    0      ?         :   ?   :   1;  // pessimism
	    ?    ?      1   x    ?      ?         :   1   :   1;  // pessimism
	    0    ?      1   x    ?      ?         :   x   :   x;  // pessimism
	    ?    ?      1   x    ?      ?         :   0   :   x;
	    ?    ?      x   x    ?      ?         :   ?   :   x;
	    ?    ?      x   0    ?      ?         :   ?   :   x;
	    ?    ?      x   1    ?      ?         :   0   :   0;
	    ?    ?      x   1    ?      ?         :   1   :   x;
	    ?    ?      0   ?    ?      ?         :   ?   :   0;
	    ?    ?      1   0    ?      ?         :   ?   :   1;
	    1   (x1)    1   1    0      ?         :   1   :   1;  // reducing pessimism
	    0   (x1)    1   1    0      ?         :   0   :   0;
	    1   (0x)    1   1    0      ?         :   1   :   1;
     0   (0x)    1   1    0      ?         :   0   :   0;
	    1   (x1)    1   1    x      ?         :   1   :   1;  // reducing pessimism
	    0   (x1)    1   1    x      ?         :   0   :   0;
	    1   (0x)    1   1    x      ?         :   1   :   1;
	    0   (0x)    1   1    x      ?         :   0   :   0;
	    ?  (?1)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	    ?  (0x)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	    ?   ?       ?   ?    *      ?         :   ?   :   -;
	    ?   (?0)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	    ?   (1x)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	    *    ?      ?   ?    ?      ?         :   ?   :   -;  // ignore data edges
	    ?   ?     (?1)  ?    ?      ?         :   ?   :   -;  // ignore the edges on
	    ?   ?       ?  (?1)  ?      ?         :   ?   :   -;  //       set and clear
	    ?   ?       ?   ?    ?      *         :   ?   :   x;

	endtable
 endprimitive


 //---------------------------------------------------------------------
 // primitibe module (Dffpf) logic table definition
 // FUNCTION : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
 //            ASYNCHRONOUS SET AND CLEAR. CLR PRIORITY WHEN BOTH
 //            SET AND CLEAR ARE LOW ( Q OUTPUT UDP ).
 //            Enable active low.

 //----------------------------------------------------------------------
primitive Dffpf (Q, D, CLK, CLR, PRE, E, NOTIFIER_REG);
  output Q;
  input  NOTIFIER_REG;
  input  D, CLK, E, CLR, PRE;
  reg Q;

 table

//    D   CLK     CLR PRE  E  NOTIFIER_REG  :   Qt  :  Qt+1	
	     1   (10)    1   1    0      ?         :   ?   :   1;  // clocked data
	     0   (10)    1   1    0      ?         :   ?   :   0;  // clocked data
	     1   (10)    1   1    x      ?         :   1   :   1;  // clocked data
	     0   (10)    1   1    x      ?         :   0   :   0;
	     0   (10)    1   x    x      ?         :   1   :   1;
	     0   (10)    1   1    x      ?         :   1   :   x;
	     1   (10)    1   1    x      ?         :   0   :   x;
	     0   (10)    1   x    0      ?         :   1   :   1;
	     0   (10)    x   1    0      ?         :   ?   :   0;
	     1   (10)    1   ?    0      ?         :   ?   :   1;  // pessimism
	     1    ?      1   x    0      ?         :   1   :   1;  // pessimism
	     ?    ?      1   x    ?      ?         :   0   :   x;
	     0    1      1   x    0      ?         :   1   :   1;  // pessimism
	     0    x      1 (?x)   0      ?         :   1   :   1;  // pessimism
	     0    ?      1 (?x)   0      ?         :   1   :   1;  // baoxian
	     0    ?      x   1    ?      ?         :   0   :   0;
	     0    ?      x   0    ?      ?         :   ?   :   x;
	     0    ?      x   1    ?      ?         :   1   :   x;
	     x    1      1   x    0      ?         :   1   :   1;  // pessimism
	     x    x      1 (?x)   0      ?         :   1   :   1;  // pessimism
	     x    0      1   x    0      ?         :   1   :   1;  // pessimism
	     1    ?      1   x    x      ?         :   1   :   1;  // pessimism
	     0    1      1   x    x      ?         :   1   :   1;  // pessimism
	     0    x      1 (?x)   x      ?         :   1   :   1;  // pessimism
	     0    0      1 (?x)   x      ?         :   1   :   1;  // pessimism
	     x    1      1   x    x      ?         :   1   :   1;  // pessimism
	     x    ?      1   x    x      ?         :   1   :   1;  // pessimism
	     1    0      x   1    0      ?         :   0   :   0;  // pessimism
	     1    x    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     1    1    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     x    0      x   1    0      ?         :   0   :   0;  // pessimism
	     x    x    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     x    1    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     1    0      x   1    x      ?         :   0   :   0;  // pessimism
	     1    x    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     1    1    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     x    0      x   1    x      ?         :   0   :   0;  // pessimism
	     x    x    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     x    1    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     1   (1x)    1   1    0      ?         :   1   :   1;  // reducing pessimism
	     0   (1x)    1   1    0      ?         :   0   :   0;
	     1   (x0)    1   1    0      ?         :   1   :   1;
	     0   (x0)    1   1    0      ?         :   0   :   0;
	     1   (1x)    1   1    x      ?         :   1   :   1;  // reducing pessimism
	     0   (1x)    1   1    x      ?         :   0   :   0;
	     1   (x0)    1   1    x      ?         :   1   :   1;
	     0   (x0)    1   1    x      ?         :   0   :   0;
	     ?   ?       0   1    ?      ?         :   ?   :   0;  // asynchronous clear
	     ?   ?       1   0    ?      ?         :   ?   :   1;  // asynchronous set
	     ?  (?0)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	     ?  (1x)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	     ?   (?0)    x   1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?   (1x)    x   1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?    ?    (?x)  1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?   (?0)    1   x    1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?   (1x)    1   x    1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?    ?      1  (?x)  1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?   ?       ?   ?    *      ?         :   ?   :   -;
	     ?   (?1)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	     ?   (0x)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	     *    ?      ?   ?    ?      ?         :   ?   :   -;  // ignore data edges
	     ?   ?     (?1)  ?    ?      ?         :   ?   :   -;  // ignore the edges on
	     ?   ?       ?  (?1)  ?      ?         :   ?   :   -;  //       set and clear
	     ?   ?       0   0    ?      ?         :   ?   :   0; // CLR Priority (added 0n 11/12/97)
	     ?   ?       0   x    ?      ?         :   ?   :   0; // CLR Priority (added 0n 11/12/97)
	     ?   ?       ?   ?    ?      *         :   ?   :   x;
	endtable
 endprimitive

//--------------------------------------------------------------------
//-                    cell  UFPRB.v                                  -
//--------------------------------------------------------------------

primitive UFPRB (Q, D, CP, RB, NOTIFIER_REG);

    output Q;
    input  NOTIFIER_REG,
           D, CP, RB;
    reg    Q;

// FUNCTION : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
//            ASYNCHRONOUS CLEAR ( Q OUTPUT UDP ).

    table
    //  D   CP      RB     NOTIFIER_REG  :   Qt  :   Qt+1

        1   (01)    1         ?          :   ?   :   1;  // clocked data
        0   (01)    1         ?          :   ?   :   0;

        0   (01)    x         ?          :   ?   :   0;  // pessimism
        0    ?      x         ?          :   0   :   0;  // pessimism

        1    0      x         ?          :   0   :   0;  // pessimism
        1    x    (?x)        ?          :   0   :   0;  // pessimism
        1    1    (?x)        ?          :   0   :   0;  // pessimism
        x    0      x         ?          :   0   :   0;  // pessimism
        x    x    (?x)        ?          :   0   :   0;  // pessimism
        x    1    (?x)        ?          :   0   :   0;  // pessimism
        1   (x1)    1         ?          :   1   :   1;  // reducing pessimism
        0   (x1)    1         ?          :   0   :   0;
        1   (0x)    1         ?          :   1   :   1;
        0   (0x)    1         ?          :   0   :   0;
        ?   ?       0         ?          :   ?   :   0;  // asynchronous clear
        ?   (?0)    ?         ?          :   ?   :   -;  // ignore falling clock
        ?   (1x)    ?         ?          :   ?   :   -;  // ignore falling clock
        *    ?      ?         ?          :   ?   :   -;  // ignore the edges on data
        ?    ?    (?1)        ?          :   ?   :   -;  // ignore the edges on clear
        ?    ?      ?         *          :   ?   :   x;
    endtable
endprimitive

//--------------------------------------------------------------------
//-                    cell  UFNRB.v                                  -
//--------------------------------------------------------------------
primitive UFNRB (Q, D, CP, RB, NOTIFIER_REG);
    output Q;
    input  NOTIFIER_REG,
           D, CP, RB;
    reg    Q;
// FUNCTION : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
//            ASYNCHRONOUS CLEAR ( Q OUTPUT UDP ).
    table
    //  D   CP      RB     NOTIFIER_REG  :   Qt  :   Qt+1
        1   (10)    1         ?          :   ?   :   1;  // clocked data
        0   (10)    1         ?          :   ?   :   0;
        0   (10)    x         ?          :   ?   :   0;  // pessimism
        0    ?      x         ?          :   0   :   0;  // pessimism
        1    1      x         ?          :   0   :   0;  // pessimism
        1    x    (?x)        ?          :   0   :   0;  // pessimism
        1    0    (?x)        ?          :   0   :   0;  // pessimism
        x    1      x         ?          :   0   :   0;  // pessimism
        x    x    (?x)        ?          :   0   :   0;  // pessimism
        x    0    (?x)        ?          :   0   :   0;  // pessimism
        1   (1x)    1         ?          :   1   :   1;  // reducing pessimism
        0   (1x)    1         ?          :   0   :   0;
        1   (x0)    1         ?          :   1   :   1;
        0   (x0)    1         ?          :   0   :   0;
        ?   ?       0         ?          :   ?   :   0;  // asynchronous clear
        ?   (?1)    ?         ?          :   ?   :   -;  // ignore falling clock
        ?   (0x)    ?         ?          :   ?   :   -;  // ignore falling clock
        *    ?      ?         ?          :   ?   :   -;  // ignore the edges on data
        ?    ?    (?1)        ?          :   ?   :   -;  // ignore the edges on clear
        ?    ?      ?         *          :   ?   :   x;
    endtable
endprimitive

//------------------------------------------------------------------------
// primitive DL2C_UDP functional description
// FUNCTION : NEGATIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE HIGH
//            ASYNCHRONOUS SET AND RESET.
//-------------------------------------------------------------------------


primitive DL2C_UDP (q, d, g, c, p, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        g,              // CLOCK
        c,              // CLEAR ACTIVE HIGH
        p,              // SET ACTIVE HIGH
        NOTIFIER_REG;

 reg q;

    table
    //  D     G     C     P  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     1     ?     ?          :   ?   :   0;  // active low clear
        ?     ?     0     1     ?          :   ?   :   1;  // active high preset

        ?     1     0     0     ?          :   ?   :   -;  // latch
        0     0     0     0     ?          :   ?   :   0;  // transparent

        0     0     x     0     ?          :   ?   :   0;  // CLR==x
        ?     1     x     0     ?          :   0   :   0;  // CLR==x
        0     x     ?     0     ?          :   0   :   0;  // CLR,G==x

        1     x     0     ?     ?          :   1   :   1;  // PRE==x/?,G==x
        1     0     0     ?     ?          :   ?   :   1;  // PRE==x/?
        ?     1     0     x     ?          :   1   :   1;  // PRE==x
    endtable


endprimitive

//--------------------------------------------------------------------------
// primitive DLE3B_UDP
// FUNCTION : D LATCH WITH DUAL CLOCK INPUTS ACTIVE HIGH ASYNCHRONOUS PRESET.
//            TWO CLOCKS: E G
//-------------------------------------------------------------------------

primitive DLE3B_UDP (q, d, g, e, p, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        g,              // CLOCK
        e,              // CLEAR ACTIVE HIGH
        p,              // SET ACTIVE HIGH
        NOTIFIER_REG;

 reg    q;

    table
    //  D     G     E     P  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     ?     1     ?          :   ?   :   1;  // active high preset

        ?     1     ?     0     ?          :   ?   :   -;  // latch
        ?     ?     1     0     ?          :   ?   :   -;  // latch

        1     0     0     0     ?          :   ?   :   1;  // transparent
        0     0     0     0     ?          :   ?   :   0;  // transparent

        1     x     ?     0     ?          :   1   :   1;  // o/p mux pessimism
        1     ?     x     0     ?          :   1   :   1;  // o/p mux pessimism
        0     x     ?     0     ?          :   0   :   0;  // o/p mux pessimism
        0     ?     x     0     ?          :   0   :   0;  // o/p mux pessimism

        1     0     0     x     ?          :   ?   :   1;  // PRE==x
        ?     1     ?     x     ?          :   1   :   1;  // PRE==x
        ?     ?     1     x     ?          :   1   :   1;  // PRE==x
        1     0     x     x     ?          :   1   :   1;  // PRE==x
        1     x     0     x     ?          :   1   :   1;  // PRE==x
        1     x     x     x     ?          :   1   :   1;  // PRE==x
    endtable

endprimitive


//--------------------------------------------------------------------------
// primitive DLE2B_UDP
// FUNCTION : D LATCH WITH DUAL CLOCK INPUTS ACTIVE HIGH ASYNCHRONOUS CLEAR.
//            TWO CLOCKS: E G
//-------------------------------------------------------------------------

primitive DLE2B_UDP (q, d, e, g, c, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        e,              // CLOCK
        g,              // CLOCK
        c,              // CLEAR ACTIVE HIGH
        NOTIFIER_REG;

 reg    q;

    table
    //  D     E     G     C  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     ?     0     ?          :   ?   :   0;  // active low clear

        ?     ?     1     1     ?          :   ?   :   -;  // latch
        ?     1     ?     1     ?          :   ?   :   -;  // latch

        1     0     0     1     ?          :   ?   :   1;  // transparent
        0     0     0     1     ?          :   ?   :   0;  // transparent

        0     ?     ?     1     ?          :   0   :   0;  // o/p mux pessimism
        1     ?     ?     1     ?          :   1   :   1;  // o/p mux pessimism

        0     ?     ?     x     ?          :   0   :   0;  // CLR==x, o/p mux pessimism
        ?     ?     1     x     ?          :   0   :   0;  // PRE==x, o/p mux pessimism, latch
        ?     1     ?     x     ?          :   0   :   0;  // PRE==x, o/p mux pessimism, latch
        0     0     0     x     ?          :   ?   :   0;  // PRE==x, o/p mux pessimism
    endtable

endprimitive


//--------------------------------------------------------------------
//-                 primitive  JKFFF  -- falling edge                -
//--------------------------------------------------------------------

primitive JKFFF (Q, J, K, CP, RB, SB, NOTIFIER_REG);
    output Q;
    reg    Q; 
    input  NOTIFIER_REG,
           J,K,
            CP,                                  // Clock.
            RB,                                  // Clear input
            SB;                                  // Set input
// FUNCTION :NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW
//           ASYNCHRONOUS CLEAR AND  SET
//           OUTPUT GOES TO X WHEN BOTH CLEAR AND SET ARE ACTIVE
    table
      // J   K   CP  RB   SB       NOTIFIER_REG  : Qtn : Qtn+1
         0   1  (10) 1    1           ?          :  ?  :   - ;    // Output retains the
         0   0  (10) 1    1           ?          :  ?  :   0 ;    // Clocked J and K.
         0   0  (10) x    1           ?          :  ?  :   0 ;    // pessimism
         ?   ?   ?   x    1           ?          :  0  :   0 ;    // pessimism
         1   1  (10) 1    1           ?          :  ?  :   1 ;
         1   1  (10) 1    x           ?          :  ?  :   1 ;    // pessimism
         ?   ?   ?   1    x           ?          :  1  :   1 ;    // pessimis
         1   0  (10) 1    1           ?          :  0  :   1 ;    // Clocked toggle.
         1   0  (10) 1    1           ?          :  1  :   0 ;
         ?   0  (10) x    1           ?          :  1  :   0 ;    //pessimism
         1   ?  (10) 1    x           ?          :  0  :   1 ;
         0   1  (1x) 1    1           ?          :  ?  :   - ;    //possible clocked JK
         0   0  (1x) 1    1           ?          :  0  :   0 ;
         1   1  (1x) 1    1           ?          :  1  :   1 ;
         0   1  (x0) 1    1           ?          :  ?  :   - ;
         0   0  (x0) 1    1           ?          :  0  :   0 ;
         1   1  (x0) 1    1           ?          :  1  :   1 ;
         *   ?   ?   1    1           ?          :  ?  :   - ;    // Insensitive to
         ?   *   ?   1    1           ?          :  ?  :   - ;    // transitions on J and K
         ?   ?   ?   0    1           ?          :  ?  :   0 ;    // Clear
         ?   ?   ?   1    0           ?          :  ?  :   1 ;    // Set.
         ?   ?   ?   0    0           ?          :  ?  :   x ;    // ILLEGAL
         x   1   f   1    1           ?          :  1  :   1 ;
         x   0   f   1    1           ?          :  1  :   0 ;
         0   x   f   1    1           ?          :  0  :   0 ;
         1   x   f   1    1           ?          :  0  :   1 ;
         x   1 (1x)  1    1           ?          :  1  :   1 ;    //possible clocked with
         0   x (1x)  1    1           ?          :  0  :   0 ;    //possible J & K
         x   1 (x0)  1    1           ?          :  1  :   1 ;
         0   x (x0)  1    1           ?          :  0  :   0 ;
         ?   ? (?1)  ?    ?           ?          :  ?  :   - ;
         ?   ? (0x)  ?    ?           ?          :  ?  :   - ;
         ?   ?   ? (?1)   1           ?          :  ?  :   - ;    //ignore changes on set and
         ?   ?   ?   1  (?1)          ?          :  ?  :   - ;    //reset.
         ?   ?   ?   ?    ?           *          :  ?  :   x ;
    endtable
endprimitive

//--------------------------------------------------------------------
//-                   primitive  JKFFR                                -
//--------------------------------------------------------------------
primitive JKFFR (Q, J, K, CP, RB, SB, NOTIFIER_REG);
    output Q;
    reg    Q; 
    input  NOTIFIER_REG,
           J,K,
           CP,                                  // Clock.
           RB,                                  // Clear input
           SB;                                  // Set input
// FUNCTION :POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW
//           ASYNCHRONOUS CLEAR AND  SET
//           OUTPUT GOES TO x WHEN BOTH CLEAR AND SET ARE ACTIVE
    table
      // J   K  CP  RB   SB        NOTIFIER_REG  : Qtn : Qtn+1
         0   1  (01) 1    1           ?          :  ?  :   - ;    // Output retains the
         0   0  (01) 1    1           ?          :  ?  :   0 ;    // Clocked J and K.
         0   0  (01) x    1           ?          :  ?  :   0 ;    // pessimism
         ?   ?   ?   x    1           ?          :  0  :   0 ;    // pessimism
         1   1  (01) 1    1           ?          :  ?  :   1 ;
         1   1  (01) 1    x           ?          :  ?  :   1 ;    // pessimism
         ?   ?   ?   1    x           ?          :  1  :   1 ;    // pessimism
         1   0  (01) 1    1           ?          :  0  :   1 ;    // Clocked toggle.
         1   0  (01) 1    1           ?          :  1  :   0 ;
         ?   0  (01) x    1           ?          :  1  :   0 ;     //pessimism
         1   ?  (01) 1    x           ?          :  0  :   1 ;
         0   1  (x1) 1    1           ?          :  ?  :   - ;   //possible clocked JK
         0   0  (x1) 1    1           ?          :  0  :   0 ;
         1   1  (x1) 1    1           ?          :  1  :   1 ;
         0   1  (0x) 1    1           ?          :  ?  :   - ;
         0   0  (0x) 1    1           ?          :  0  :   0 ;
         1   1  (0x) 1    1           ?          :  1  :   1 ;
         *   ?   ?   1    1           ?          :  ?  :   - ;    // Insensitive to
         ?   *   ?   1    1           ?          :  ?  :   - ;    // transitions on J and K
         ?   ?   ?   0    1           ?          :  ?  :   0 ;    // Clear
         ?   ?   ?   1    0           ?          :  ?  :   1 ;    // Set.
         ?   ?   ?   0    0           ?          :  ?  :   x ;    // ILLEGAL
         x   1   r   1    1           ?          :  1  :   1 ;
         x   0   r   1    1           ?          :  1  :   0 ;
         0   x   r   1    1           ?          :  0  :   0 ;
         1   x   r   1    1           ?          :  0  :   1 ;
         x   1 (x1)  1    1           ?          :  1  :   1 ;        //possible clocked with
         0   x (x1)  1    1           ?          :  0  :   0 ;        //possible J & K
         x   1 (0x)  1    1           ?          :  1  :   1 ;
         0   x (0x)  1    1           ?          :  0  :   0 ;
         ?   ? (?0)  1    1           ?          :  ?  :   - ;    //ignore falling clock.
         ?   ? (1x)  1    1           ?          :  ?  :   - ;
         ?   ?   ? (?1)   1           ?          :  ?  :   - ;    //ignore changes on set and
         ?   ?   ?   1  (?1)          ?          :  ?  :   - ;    //reset.
         ?   ?   ?   ?    ?           *          :  ?  :   x ;
    endtable
endprimitive
 // --------------------------------------------------------------------
 // 2-1 MUX  primitive   
 // FUNCTION : when select signal S= 1, A will be selected, S= 0, B will 
 //            be selected; when S=X, if A=B, A will be selected, if A!=B,
 //            X will be the output!
 // --------------------------------------------------------------------
primitive UDP_MUX2 (Q, A, B, SL);
output Q;
input A, B, SL;

// FUNCTION :  TWO TO ONE MULTIPLEXER

    table
    //  A   B   SL  :   Q
        0   0   ?   :   0 ;
        1   1   ?   :   1 ;

        0   ?   1   :   0 ;
        1   ?   1   :   1 ;

        ?   0   0   :   0 ;
        ?   1   0   :   1 ;

    endtable
endprimitive

primitive UDPN_MUX2 (Q, A, B, SL);
output Q;
input A, B, SL;

// FUNCTION :  TWO TO ONE MULTIPLEXER

    table
    //  A   B   SL  :   Q
        0   0   ?   :   1 ;
        1   1   ?   :   0 ;

        0   ?   1   :   1 ;
        1   ?   1   :   0 ;

        ?   0   0   :   1 ;
        ?   1   0   :   0 ;

    endtable
endprimitive


//---------------  END OF VERILOG PRIMITIVE SECTION --------------------

primitive CMA9_primitive (Y, D0,DB, D3,S01,S11);
output Y;
input D0,DB, D3,S01,S11;


	table
	// D0   DB   D3   S01  S11 :       Y
	   ?    0    ?    0    ?  :       1;
	   ?    1    ?    ?    1  :       0;
	   ?    0    0    1    ?  :       0;
	   1    1    ?    ?    0  :       1;
	   1    ?    1    ?    0  :       1;
	   ?    0    1    ?    ?  :       1;
	   0    1    ?    ?    ?  :       0;
	   0    ?    0    1    ?  :       0;
	   1    ?    ?    0    0  :       1;
	   ?    ?    0    1    1  :       0;

	endtable
endprimitive

primitive CMAF_primitive (Y, D0, D2,  D3, DB, S01, S11);
output Y;
input D0, D2,  D3, DB, S01, S11;


	table
	// D0   D2   D3   DB   S01  S11       Y
	   0    0    0     ?    ?    ? :    0;
	   1    1    1     ?    ?    ? :    1;
	   0    0    ?     ?    0    0 :    0;
	   1    1    ?     ?    0    0 :    1;
	   0    0    ?     1    ?    ? :    0;
	   1    1    ?     1    ?    ? :    1;
	   0    0    ?     ?    0    ? :    0;
	   1    1    ?     ?    0    ? :    1;
	   ?    0    0     ?    1    1 :    0;
	   ?    1    1     ?    1    1 :    1;
	   ?    0    0     0    ?    ? :    0;
	   ?    1    1     0    ?    ? :    1;
	   ?    0    0     ?    ?    1 :    0;
	   ?    1    1     ?    ?    1 :    1;
	   0    ?    0     ?    1    0 :    0;
	   1    ?    1     ?    1    0 :    1;
	   ?    0    ?     0    0    ? :    0;
	   ?    1    ?     0    0    ? :    1;
	   ?    0    ?     1    ?    1 :    0;
	   ?    1    ?     1    ?    1 :    1;
	   ?    0    ?     ?    0    1 :    0;
	   ?    1    ?     ?    0    1 :    1;
	   ?    ?    0     0    1    ? :    0;
	   ?    ?    1     0    1    ? :    1;
	   0    ?    ?     1    ?    0 :    0;
	   1    ?    ?     1    ?    0 :     1;

	endtable
endprimitive

primitive CMB7_primitive (Y, D0, D1, D2, DB, S00, S01, S11);
output Y;
input D0, D1, D2, DB, S00, S01, S11;


   table
	//D0   D1   D2   DB   S00  S01  S11          Y
	  0    0    0    1    ?    ?    ?  :       0;
	  ?    ?    1    0    ?    ?    ?  :      1;
	  ?    0    ?    1    1    1    0  :      0;
	  ?    1    ?    ?    1    1    0  :      1;
	  0    ?    ?    1    0    ?    0  :      0;
	  0    ?    ?    1    ?    0    0  :      0;
	  1    ?    ?    1    0    ?    0  :      1;
	  1    ?    ?    1    ?    0    0  :      1;
	  ?    ?    ?    1    1    1    1  :      0;
	  ?    ?    ?    0    1    1    ?  :      1;
	  ?    ?    0    0    0    ?    ?  :      0;
	  ?    ?    0    0    ?    0    ?  :      0;
	  ?    ?    0    ?    0    ?    1  :      0;
	  ?    ?    0    ?    ?    0    1  :      0;
	  0    ?    0    ?    0    ?    ?  :      0;
	  0    ?    0    ?    ?    0    ?  :      0;
	  1    ?    1    ?    0    ?    ?  :      1;
	  1    ?    1    ?    ?    0    ?  :      1;
	  ?    ?    1    ?    0    ?    1  :      1;
	  ?    ?    1    ?    ?    0    1  :      1;
	  ?    0    ?    1    1    1    ?  :      0;
	  0    0    ?    1    ?    ?    0  :      0;
	  1    1    ?    1    ?    ?    0  :      1;
	  ?    ?    0    1    ?    ?    1  :      0;
	  1    1    1    ?    ?    ?    0  :      1;

	endtable
endprimitive

primitive CMBB_primitive (Y, D0,D1,DB,D3,S00,S01,S11);
output Y;
input D0,D1,DB,D3,S00,S01,S11;


	table
// D0   D1   DB   D3   S00  S01  S11          Y
	0    0    1    0    ?    ?    ? :        0;
	?    ?    0    1    ?    ?    ? :       1;
	?    ?    0    ?    ?    0    ? :       1;
	?    ?    1    ?    ?    0    1 :       0;
	?    ?    0    ?    0    ?    ? :       1;
	?    ?    1    ?    0    ?    1 :       0;
	0    ?    1    ?    ?    0    0 :       0;
	1    ?    ?    ?    ?    0    0 :       1;
	0    ?    1    ?    0    ?    0 :       0;
	1    ?    ?    ?    0    ?    0 :       1;
	?    0    1    ?    1    1    0 :       0;
	?    1    1    ?    1    1    0 :       1;
	?    ?    ?    0    1    1    1 :       0;
	?    ?    ?    1    1    1    1 :       1;
	?    ?    0    0    1    1    ? :       0;
	?    ?    1    0    ?    ?    1 :       0;
	?    0    ?    0    1    1    ? :       0;
	?    1    ?    1    1    1    ? :       1;
	0    ?    1    ?    0    ?    ? :       0;
	0    0    1    ?    ?    ?    0 :       0;
	1    1    1    ?    ?    ?    0 :       1;
	0    ?    1    ?    ?    0    ? :       0;
	1    1    ?    1    ?    ?    0 :       1;

	endtable
endprimitive

primitive CMEA_primitive (Y, DB,D1,D3,S01,S10,S11);
output Y;
input DB,D1,D3,S01,S10,S11;


	table
// DB   D1   D3   S01  S10  S11          Y
	1     ?    ?    ?   ?    ? :       0;
	0     1    1    ?   ?    ? :       1;
	?     0    ?    1   0    0 :       0;
	0     1    ?    ?   0    0 :       1;
	?     ?    0    1   1    ? :       0;
	?     ?    0    1   ?    1 :       0;
	0     ?    ?    0   ?    ? :       1;
	?     0    0    1   ?    ? :       0;
	0     ?    1    ?   1    ? :       1;
	0     ?    1    ?   ?    1 :       1;

   endtable
endprimitive

primitive CMEB_primitive (Y,D0,D1,DB,D3,S01,S10,S11);
output Y;
input D0,D1,DB,D3,S01,S10,S11;


   table
	// D0   D1   DB   D3   S01  S10  S11          Y
	0   0   1   0   ?   ?   ? :        0;
	1   1   0   1   ?   ?   ? :       1;
	0   ?   ?   ?   0   0   0 :       0;
	1   ?   ?   ?   0   0   0 :       1;
	0   ?   1   ?   ?   0   0 :       0;
	1   ?   1   ?   ?   0   0 :       1;
	?   ?   0   1   1   1   ? :       1;
	?   ?   0   1   1   ?   1 :       1;
	?   0   0   ?   1   0   0 :       0;
	?   1   0   ?   1   0   0 :       1;
	?   ?   ?   0   1   1   ? :       0;
	?   ?   ?   0   1   ?   1 :       0;
	?   ?   1   ?   ?   1   ? :       0;
	?   ?   1   ?   ?   ?   1 :       0;
	?   ?   0   ?   0   1   ? :       1;
	?   0   0   0   1   ?   ? :       0;
	?   1   0   1   1   ?   ? :       1;
	0   0   ?   ?   ?   0   0 :       0;
	1   1   ?   ?   ?   0   0 :       1;
	0   ?   1   ?   ?   ?   ? :       0;
	1   ?   0   ?   0   ?   ? :       1;
	?   ?   0   1   ?   1   ? :       1;
	?   ?   0   1   ?   ?   1 :       1;
	?   ?   0   ?   0   ?   1 :       1;
	0   0   ?   0   1   ?   ? :       0;

	endtable
endprimitive

primitive CMEE_primitive (Y,DB, D1, D2, D3, S01,S10, S11);
output Y;
input DB, D1, D2, D3, S01,S10, S11;


   table
	//DB   D1   D2   D3   S01  S10  S11          Y
	1 0 0 0 ? ? ? :       0;
	0 1 1 1 ? ? ? :       1;
	? 0 ? ? 1 0 0 :       0;
	0 1 ? ? 1 0 0 :       1;
	0 ? ? 0 1 1 ? :       0;
	0 ? ? 1 1 1 ? :       1;
	0 ? ? 0 1 ? 1 :       0;
	0 ? ? 1 1 ? 1 :       1;
	1 ? ? ? ? 0 0 :       0;
	0 ? ? ? 0 0 0 :       1;
	? ? 0 ? 0 ? 1 :       0;
	? ? 1 ? 0 ? 1 :       1;
	? ? 0 ? 0 1 ? :       0;
	? ? 1 ? 0 1 ? :       1;
	1 ? 0 ? ? ? 1 :       0;
	1 ? 1 ? ? ? 1 :       1;
	1 ? 0 ? ? 1 ? :       0;
	1 ? 1 ? ? 1 ? :       1;
	1 ? 0 ? ? ? ? :       0;
	0 ? 1 ? 0 ? ? :       1;
	? ? 0 0 ? 1 ? :       0;
	? ? 1 1 ? 1 ? :       1;
	? ? 0 0 ? ? 1 :       0;
	0 0 ? 0 1 ? ? :       0;
	0 1 ? 1 1 ? ? :       1;
	? ? 1 1 ? ? 1 :       1;
	0 1 ? ? ? 0 0 :       1;
	? 0 0 0 1 ? ? :       0;

   endtable
endprimitive




/*--------------------------------------------------------------------
 CELL NAME : ADD1
 CELL TYPE : comb
 CELL LOGIC : S = A ^ B ^ FCI ; FCO = A & B + A & FCI + B & FCI
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module ADD1(S,FCO,A,B,FCI);
 input A,B,FCI;
 output S,FCO;
 wire NET_0_0;
 wire NET_1_0, NET_1_1, NET_1_2, NET_1_3;

 not	INV_0(A_, A);
 not	INV_1(B_, B);
 UDP_MUX2   U3(NET_0_0, B, B_, A_);
 xor      U5(S, NET_0_0, FCI);
 not	INV_2(A_, A);
 not	INV_3(B_, B);
 and      U10(NET_1_0, A, B);
 or       U11(NET_1_2, NET_1_0, NET_1_1);
 and      U13(NET_1_1, A, FCI);
 or       U14(FCO, NET_1_2, NET_1_3);
 and      U16(NET_1_3, B, FCI);

       specify

		specparam tpdLH_A_to_S = (0.1:0.1:0.1);
		specparam tpdHL_A_to_S = (0.1:0.1:0.1);
		specparam tpdLH_B_to_S = (0.1:0.1:0.1);
		specparam tpdHL_B_to_S = (0.1:0.1:0.1);
		specparam tpdLH_FCI_to_S = (0.1:0.1:0.1);
		specparam tpdHL_FCI_to_S = (0.1:0.1:0.1);
		specparam tpdLH_A_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_FCO = (0.1:0.1:0.1);
		specparam tpdLH_B_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_B_to_FCO = (0.1:0.1:0.1);
		specparam tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => S ) = ( tpdLH_A_to_S, tpdHL_A_to_S );
		(B => S ) = ( tpdLH_B_to_S, tpdHL_B_to_S );
		(FCI => S ) = ( tpdLH_FCI_to_S, tpdHL_FCI_to_S );
		(A => FCO ) = ( tpdLH_A_to_FCO, tpdHL_A_to_FCO );
		(B => FCO ) = ( tpdLH_B_to_FCO, tpdHL_B_to_FCO );
		(FCI => FCO ) = ( tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND2
 CELL TYPE : comb
 CELL LOGIC : Y = A & B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND2(Y,A,B);
 input A,B;
 output Y;

 and      U19(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND2A
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND2A(Y,A,B);
 input A,B;
 output Y;

 not	INV_4(A_, A);
 and      U22(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND2B
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND2B(Y,A,B);
 input A,B;
 output Y;

 not	INV_5(A_, A);
 not	INV_6(B_, B);
 and      U25(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U29(NET_0_0, A, B);
 and      U30(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3A
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_7(A_, A);
 and      U34(NET_0_0, A_, B);
 and      U35(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3B
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_8(A_, A);
 not	INV_9(B_, B);
 and      U39(NET_0_0, A_, B_);
 and      U40(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3C
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_10(A_, A);
 not	INV_11(B_, B);
 not	INV_12(C_, C);
 and      U44(NET_0_0, A_, B_);
 and      U45(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND4
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C & D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND4(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 and      U50(NET_0_0, A, B);
 and      U51(NET_0_1, NET_0_0, C);
 and      U52(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND4A
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & B & C & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND4A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_13(A_, A);
 and      U57(NET_0_0, A_, B);
 and      U58(NET_0_1, NET_0_0, C);
 and      U59(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND4B
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & C & D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND4B(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_14(A_, A);
 not	INV_15(B_, B);
 and      U64(NET_0_0, A_, B_);
 and      U65(NET_0_1, NET_0_0, C);
 and      U66(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND4C
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & !C & D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND4C(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_16(A_, A);
 not	INV_17(B_, B);
 not	INV_18(C_, C);
 and      U71(NET_0_0, A_, B_);
 and      U72(NET_0_1, NET_0_0, C_);
 and      U73(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND4D
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & !C & !D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND4D(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_19(A_, A);
 not	INV_20(B_, B);
 not	INV_21(C_, C);
 not	INV_22(D_, D);
 and      U78(NET_0_0, A_, B_);
 and      U79(NET_0_1, NET_0_0, C_);
 and      U80(Y, NET_0_1, D_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND5A
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B & C & D & E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND5A(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_23(A_, A);
 and      U86(NET_0_0, A_, B);
 and      U87(NET_0_1, NET_0_0, C);
 and      U88(NET_0_2, NET_0_1, D);
 and      U89(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND5B
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & C & D & E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND5B(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_24(A_, A);
 not	INV_25(B_, B);
 and      U95(NET_0_0, A_, B_);
 and      U96(NET_0_1, NET_0_0, C);
 and      U97(NET_0_2, NET_0_1, D);
 and      U98(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND5C
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & !C & D & E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND5C(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_26(A_, A);
 not	INV_27(B_, B);
 not	INV_28(C_, C);
 and      U104(NET_0_0, A_, B_);
 and      U105(NET_0_1, NET_0_0, C_);
 and      U106(NET_0_2, NET_0_1, D);
 and      U107(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1
 CELL TYPE : comb
 CELL LOGIC : Y = (A & B) + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U111(NET_0_0, A, B);
 or       U112(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO10
 CELL TYPE : comb
 CELL LOGIC : Y = (A & B + C) * (D + E)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO10(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 and      U117(NET_0_0, A, B);
 or       U118(NET_0_1, NET_0_0, C);
 and      U119(Y, NET_0_1, NET_0_2);
 or       U121(NET_0_2, D, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO11
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + (A + B) & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO11(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 and      U125(NET_0_0, A, B);
 or       U126(Y, NET_0_0, NET_0_2);
 or       U129(NET_0_1, A, B);
 and      U130(NET_0_2, NET_0_1, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO12
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + !A & !C + A & !B & C + B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO12(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_29(A_, A);
 not	INV_30(B_, B);
 not	INV_31(C_, C);
 UDP_MUX2   U134(NET_0_5, B, NET_0_3, C_);
 and      U137(NET_0_3, A, B_);
 or       U138(Y, NET_0_5, NET_0_2);
 and      U141(NET_0_0, A_, B);
 or       U142(NET_0_2, NET_0_0, NET_0_1);
 and      U144(NET_0_1, A_, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO13
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + A & !C + B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO13(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_32(C_, C);
 and      U149(NET_0_0, A, B);
 or       U150(NET_0_2, NET_0_0, NET_0_1);
 and      U152(NET_0_1, A, C_);
 or       U153(Y, NET_0_2, NET_0_3);
 and      U155(NET_0_3, B, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO14
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + A & !C + B & !C + !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO14(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_33(A_, A);
 not	INV_34(B_, B);
 not	INV_35(C_, C);
 and      U160(NET_0_5, A_, B_);
 UDP_MUX2   U161(NET_0_4, NET_0_5, B, C);
 or       U163(Y, NET_0_4, NET_0_2);
 and      U166(NET_0_0, A, B);
 or       U167(NET_0_2, NET_0_0, NET_0_1);
 and      U169(NET_0_1, A, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO15
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B & C + !A & B & C + !A & !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO15(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_36(A_, A);
 not	INV_37(B_, B);
 not	INV_38(C_, C);
 and      U174(NET_0_0, A, B_);
 UDP_MUX2   U175(NET_0_4, NET_0_0, NET_0_5, C);
 and      U178(NET_0_5, A_, B_);
 or       U179(Y, NET_0_4, NET_0_3);
 and      U182(NET_0_2, A_, B);
 and      U183(NET_0_3, NET_0_2, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO16
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & !C + !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO16(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_39(A_, A);
 not	INV_40(B_, B);
 not	INV_41(C_, C);
 and      U187(NET_0_0, A, B);
 UDP_MUX2   U188(Y, NET_0_0, NET_0_2, C_);
 and      U191(NET_0_2, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO17
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C + !A & B & !C + !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO17(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_42(A_, A);
 not	INV_43(B_, B);
 not	INV_44(C_, C);
 and      U196(NET_0_5, A_, B_);
 UDP_MUX2   U197(NET_0_4, NET_0_5, NET_0_2, C);
 and      U200(NET_0_2, A_, B);
 or       U201(Y, NET_0_4, NET_0_1);
 and      U204(NET_0_0, A, B);
 and      U205(NET_0_1, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO18
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + !A & !C + B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO18(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_45(A_, A);
 not	INV_46(C_, C);
 and      U210(NET_0_0, A_, B);
 or       U211(NET_0_2, NET_0_0, NET_0_1);
 and      U213(NET_0_1, A_, C_);
 or       U214(Y, NET_0_2, NET_0_3);
 and      U216(NET_0_3, B, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1A
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_47(A_, A);
 and      U220(NET_0_0, A_, B);
 or       U221(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1B
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_48(C_, C);
 and      U225(NET_0_0, A, B);
 or       U226(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1C
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_49(A_, A);
 not	INV_50(C_, C);
 and      U230(NET_0_0, A_, B);
 or       U231(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1D
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1D(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_51(A_, A);
 not	INV_52(B_, B);
 and      U235(NET_0_0, A_, B_);
 or       U236(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO1E
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO1E(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_53(A_, A);
 not	INV_54(B_, B);
 not	INV_55(C_, C);
 and      U240(NET_0_0, A_, B_);
 or       U241(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO2
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO2(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 and      U246(NET_0_0, A, B);
 or       U247(NET_0_1, NET_0_0, C);
 or       U248(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO2A
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO2A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_56(A_, A);
 and      U253(NET_0_0, A_, B);
 or       U254(NET_0_1, NET_0_0, C);
 or       U255(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO2B
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B + C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO2B(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_57(A_, A);
 not	INV_58(B_, B);
 and      U260(NET_0_0, A_, B_);
 or       U261(NET_0_1, NET_0_0, C);
 or       U262(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO2C
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + !C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO2C(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_59(A_, A);
 not	INV_60(C_, C);
 and      U267(NET_0_0, A_, B);
 or       U268(NET_0_1, NET_0_0, C_);
 or       U269(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO2D
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B + !C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO2D(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_61(A_, A);
 not	INV_62(B_, B);
 not	INV_63(C_, C);
 and      U274(NET_0_0, A_, B_);
 or       U275(NET_0_1, NET_0_0, C_);
 or       U276(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO2E
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B + !C + !D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO2E(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_64(A_, A);
 not	INV_65(B_, B);
 not	INV_66(C_, C);
 not	INV_67(D_, D);
 and      U281(NET_0_0, A_, B_);
 or       U282(NET_0_1, NET_0_0, C_);
 or       U283(Y, NET_0_1, D_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO3
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B & C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO3(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_68(A_, A);
 and      U288(NET_0_0, A_, B);
 and      U289(NET_0_1, NET_0_0, C);
 or       U290(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO3A
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO3A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 and      U295(NET_0_0, A, B);
 and      U296(NET_0_1, NET_0_0, C);
 or       U297(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO3B
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO3B(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_69(A_, A);
 not	INV_70(B_, B);
 and      U302(NET_0_0, A_, B_);
 and      U303(NET_0_1, NET_0_0, C);
 or       U304(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO3C
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !B & !C) + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO3C(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_71(A_, A);
 not	INV_72(B_, B);
 not	INV_73(C_, C);
 and      U309(NET_0_0, A_, B_);
 and      U310(NET_0_1, NET_0_0, C_);
 or       U311(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO4A
 CELL TYPE : comb
 CELL LOGIC : Y = !A & (B & C) + A & (C & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO4A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_74(A_, A);
 and      U315(NET_0_0, B, C);
 UDP_MUX2   U316(Y, NET_0_0, NET_0_2, A_);
 and      U319(NET_0_2, C, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO5A
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & B) + (A & C) + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO5A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_75(A_, A);
 UDP_MUX2   U323(NET_0_2, B, C, A_);
 or       U325(Y, NET_0_2, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO6
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + C & D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO6(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 and      U329(NET_0_0, A, B);
 or       U330(Y, NET_0_0, NET_0_1);
 and      U332(NET_0_1, C, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO6A
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + C & !D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO6A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_76(D_, D);
 and      U336(NET_0_0, A, B);
 or       U337(Y, NET_0_0, NET_0_1);
 and      U339(NET_0_1, C, D_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO7
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C + D + E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO7(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 and      U345(NET_0_0, A, B);
 and      U346(NET_0_1, NET_0_0, C);
 or       U347(NET_0_2, NET_0_1, D);
 or       U348(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO8
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + !C & !D + E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO8(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_77(C_, C);
 not	INV_78(D_, D);
 and      U353(NET_0_0, A, B);
 or       U354(NET_0_2, NET_0_0, NET_0_1);
 and      U356(NET_0_1, C_, D_);
 or       U357(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO9
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + C + D + E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO9(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 and      U363(NET_0_0, A, B);
 or       U364(NET_0_1, NET_0_0, C);
 or       U365(NET_0_2, NET_0_1, D);
 or       U366(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI1
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U370(NET_0_0, A, B);
 nor      U371(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI1A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_79(A_, A);
 and      U375(NET_0_0, A_, B);
 nor      U376(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI1B
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B + !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI1B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_80(C_, C);
 and      U380(NET_0_0, A, B);
 nor      U381(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI1C
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI1C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_81(A_, A);
 not	INV_82(B_, B);
 and      U385(NET_0_0, A_, B_);
 nor      U386(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI1D
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B + !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI1D(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_83(A_, A);
 not	INV_84(B_, B);
 not	INV_85(C_, C);
 and      U390(NET_0_0, A_, B_);
 nor      U391(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI2A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B + C + D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI2A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_86(A_, A);
 and      U396(NET_0_0, A_, B);
 or       U397(NET_0_1, NET_0_0, C);
 nor      U398(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI2B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B + !C + D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI2B(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_87(A_, A);
 not	INV_88(C_, C);
 and      U403(NET_0_0, A_, B);
 or       U404(NET_0_1, NET_0_0, C_);
 nor      U405(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI3A
 CELL TYPE : comb
 CELL LOGIC : Y = (A + B + C) & (A + D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI3A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 or       U410(NET_0_0, A, B);
 or       U411(NET_0_1, NET_0_0, C);
 and      U412(Y, NET_0_1, NET_0_2);
 or       U414(NET_0_2, A, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI4
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B+C & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI4(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 and      U418(NET_0_0, A, B);
 nor      U419(Y, NET_0_0, NET_0_1);
 and      U421(NET_0_1, C, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI4A
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B + !C & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI4A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_89(C_, C);
 and      U425(NET_0_0, A, B);
 nor      U426(Y, NET_0_0, NET_0_1);
 and      U428(NET_0_1, C_, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI5
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B & C + A & !B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI5(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_90(A_, A);
 not	INV_91(B_, B);
 not	INV_92(C_, C);
 and      U432(NET_0_0, A_, B);
 UDPN_MUX2  U433(Y, NET_0_0, NET_0_2, C);
 and      U436(NET_0_2, A, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : AFCNTECP1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _CLR=CLR, _PRE=PRE, D=Q ^ UD ^ FCI ];
 CELL COMB EQN : "FCO = ((Q & UD) + (Q & FCI) + (FCI & UD))"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AFCNTECP1(PRE, CLR, E, CLK, FCO,UD,FCI,Q);
 input UD,FCI,PRE,CLR,E,CLK;
 output FCO;
 output Q;
 wire NET_0_0,NET_1_0,NET_1_1,NET_1_2,NET_1_3;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 
 and      U441(NET_1_0, Q, UD);
 or       U442(NET_1_2, NET_1_0, NET_1_1);
 and      U444(NET_1_1, Q, FCI);
 or       U445(FCO, NET_1_2, NET_1_3);
 and      U447(NET_1_3, FCI, UD);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 xor      U451(NET_0_0, Q, UD);
 xor      U452(NET_0_1, NET_0_0, FCI);

 Dffpf DF_0(Q, NET_0_1,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	//(Q => FCO) = (tpdLH_Q_to_FCO, tpdHL_Q_to_FCO);
	(UD => FCO) = (tpdLH_UD_to_FCO, tpdHL_UD_to_FCO);
	(FCI => FCO) = (tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO);

	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge Q,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge Q,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge Q,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge Q,0.0, NOTIFY_REG);
	$setup(posedge UD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge UD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge UD,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge UD,0.0, NOTIFY_REG);
	$setup(posedge FCI,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge FCI,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge FCI,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge FCI,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : ARCNTECP1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _CLR=CLR, _PRE=PRE, D=Q ^ UD ^ FCI ];
 CELL COMB EQN : "FCO = ((Q & UD) + (Q & FCI) + (FCI & UD))"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module ARCNTECP1(PRE, CLR, E, CLK, FCO,UD,FCI,Q);
 input UD,FCI,PRE,CLR,E,CLK;
 output FCO;
 output Q;
 wire NET_0_0,NET_1_0,NET_1_1,NET_1_2,NET_1_3;
 reg NOTIFY_REG;

	// create Logics for combinatorial output Logics! 
 and      U457(NET_1_0, Q, UD);
 or       U458(NET_1_2, NET_1_0, NET_1_1);
 and      U460(NET_1_1, Q, FCI);
 or       U461(FCO, NET_1_2, NET_1_3);
 and      U463(NET_1_3, FCI, UD);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 xor      U467(NET_0_0, Q, UD);
 xor      U468(NET_0_1, NET_0_0, FCI);

 Dffpr DF_0(Q, NET_0_1,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	//(Q => FCO) = (tpdLH_Q_to_FCO, tpdHL_Q_to_FCO);
	(UD => FCO) = (tpdLH_UD_to_FCO, tpdHL_UD_to_FCO);
	(FCI => FCO) = (tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO);

	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge Q,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge Q,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge Q,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge Q,0.0, NOTIFY_REG);
	$setup(posedge UD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge UD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge UD,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge UD,0.0, NOTIFY_REG);
	$setup(posedge FCI,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge FCI,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge FCI,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge FCI,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : AFCNTELDCP1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _CLR=CLR, _PRE=PRE, D=!LD & (Q ^ UD ^ FCI) + LD & D ];
 CELL COMB EQN : "FCO = ((Q & UD) + (Q & FCI) + (FCI & UD))"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AFCNTELDCP1(PRE, CLR, E, CLK, FCO,LD,UD,FCI,D,Q);
 input LD,UD,FCI,D,PRE,CLR,E,CLK;
 output FCO;
 output Q;
 wire NET_0_0,NET_0_1,NET_0_2,NET_0_3,NET_1_0,NET_1_1,NET_1_2,NET_1_3;
 reg NOTIFY_REG;

 not	INV_93(LD_, LD);
	// create Logics for combinatorial output Logics! 
 and      U473(NET_1_0, Q, UD);
 or       U474(NET_1_2, NET_1_0, NET_1_1);
 and      U476(NET_1_1, Q, FCI);
 or       U477(FCO, NET_1_2, NET_1_3);
 and      U479(NET_1_3, FCI, UD);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 xor      U484(NET_0_0, Q, UD);
 xor      U485(NET_0_1, NET_0_0, FCI);
 UDP_MUX2   U486(NET_0_4, NET_0_1, D, LD_);

 Dffpf DF_0(Q, NET_0_4,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	//(Q => FCO) = (tpdLH_Q_to_FCO, tpdHL_Q_to_FCO);
	(UD => FCO) = (tpdLH_UD_to_FCO, tpdHL_UD_to_FCO);
	(FCI => FCO) = (tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO);

	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge LD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge LD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge LD,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge LD,0.0, NOTIFY_REG);
	$setup(posedge Q,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge Q,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge Q,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge Q,0.0, NOTIFY_REG);
	$setup(posedge UD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge UD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge UD,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge UD,0.0, NOTIFY_REG);
	$setup(posedge FCI,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge FCI,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge FCI,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge FCI,0.0, NOTIFY_REG);
	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : ARCNTELDCP1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _CLR=CLR, _PRE=PRE, D=!LD & (Q ^ UD ^ FCI) + LD*D ];
 CELL COMB EQN : "FCO = ((Q & UD) + (Q & FCI)+ (FCI & UD))"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module ARCNTELDCP1(PRE, CLR, E, CLK, FCO,LD,UD,FCI,D,Q);
 input LD,UD,FCI,D,PRE,CLR,E,CLK;
 output FCO;
 output Q;
 wire NET_0_0,NET_0_1,NET_0_2,NET_0_3,NET_1_0,NET_1_1,NET_1_2,NET_1_3;
 reg NOTIFY_REG;

 not	INV_94(LD_, LD);
	// create Logics for combinatorial output Logics! 
 and      U492(NET_1_0, Q, UD);
 or       U493(NET_1_2, NET_1_0, NET_1_1);
 and      U495(NET_1_1, Q, FCI);
 or       U496(FCO, NET_1_2, NET_1_3);
 and      U498(NET_1_3, FCI, UD);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 xor      U503(NET_0_0, Q, UD);
 xor      U504(NET_0_1, NET_0_0, FCI);
 UDP_MUX2   U505(NET_0_4, NET_0_1, D, LD_);

 Dffpr DF_0(Q, NET_0_4,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	//(Q => FCO) = (tpdLH_Q_to_FCO, tpdHL_Q_to_FCO);
	(UD => FCO) = (tpdLH_UD_to_FCO, tpdHL_UD_to_FCO);
	(FCI => FCO) = (tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO);

	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge LD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge LD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge LD,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge LD,0.0, NOTIFY_REG);
	$setup(posedge Q,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge Q,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge Q,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge Q,0.0, NOTIFY_REG);
	$setup(posedge UD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge UD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge UD,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge UD,0.0, NOTIFY_REG);
	$setup(posedge FCI,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge FCI,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge FCI,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge FCI,0.0, NOTIFY_REG);
	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & B) ^ C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_95(A_, A);
 and      U510(NET_0_0, A_, B);
 xor      U511(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_96(A_, A);
 and      U515(NET_0_0, A_, B);
 xnor     U516(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1B
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !B) ^ C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_97(A_, A);
 not	INV_98(B_, B);
 and      U520(NET_0_0, A_, B_);
 xor      U521(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1C
 CELL TYPE : comb
 CELL LOGIC : Y = (A & B) ^ C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U525(NET_0_0, A, B);
 xor      U526(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1D
 CELL TYPE : comb
 CELL LOGIC : Y = !((!A & !B) ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1D(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_99(A_, A);
 not	INV_100(B_, B);
 and      U530(NET_0_0, A_, B_);
 xnor     U531(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AX1E
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AX1E(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U535(NET_0_0, A, B);
 xnor     U536(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO1
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + (B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_101(B_, B);
 not	INV_102(C_, C);
 and      U540(NET_0_1_XOR_REXT, B, C_);
 or       U541(Y, NET_0_1_XOR_REXT, NET_0_1);
 UDP_MUX2   U543(NET_0_1, C, A, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO2
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + (B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO2(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_103(A_, A);
 not	INV_104(B_, B);
 not	INV_105(C_, C);
 and      U548(NET_0_1_XOR_REXT, B, C_);
 or       U549(Y, NET_0_1_XOR_REXT, NET_0_1);
 UDP_MUX2   U551(NET_0_1, C, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO3
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B + (B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_106(B_, B);
 not	INV_107(C_, C);
 and      U556(NET_0_1_XOR_LEXT, B_, C);
 or       U557(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U559(NET_0_1, A, C_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO5
 CELL TYPE : comb
 CELL LOGIC : Y =  !A & B + (!B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO5(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_108(A_, A);
 not	INV_109(B_, B);
 not	INV_110(C_, C);
 and      U564(NET_0_1_XOR_LEXT, B, C);
 or       U565(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U567(NET_0_1, A_, C_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO6
 CELL TYPE : comb
 CELL LOGIC : Y =  A & !B + (!B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO6(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_111(B_, B);
 not	INV_112(C_, C);
 and      U572(NET_0_1_XOR_REXT, B_, C_);
 or       U573(Y, NET_0_1_XOR_REXT, NET_0_1);
 UDP_MUX2   U575(NET_0_1, C, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXO7
 CELL TYPE : comb
 CELL LOGIC : Y =  !A & !B + (B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXO7(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_113(A_, A);
 not	INV_114(B_, B);
 not	INV_115(C_, C);
 and      U580(NET_0_1_XOR_LEXT, B_, C);
 or       U581(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U583(NET_0_1, A_, C_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI1
 CELL TYPE : comb
 CELL LOGIC : Y =  !(A & B + (B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_116(B_, B);
 not	INV_117(C_, C);
 and      U588(NET_0_1_XOR_REXT, B, C_);
 nor      U589(Y, NET_0_1_XOR_REXT, NET_0_1);
 UDP_MUX2   U591(NET_0_1, C, A, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI2
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B + (B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI2(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_118(A_, A);
 not	INV_119(B_, B);
 not	INV_120(C_, C);
 and      U596(NET_0_1_XOR_REXT, B, C_);
 nor      U597(Y, NET_0_1_XOR_REXT, NET_0_1);
 UDP_MUX2   U599(NET_0_1, C, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI3
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & !B + (B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_121(B_, B);
 not	INV_122(C_, C);
 and      U604(NET_0_1_XOR_LEXT, B_, C);
 nor      U605(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U607(NET_0_1, A, C_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI4
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B + (!B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI4(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_123(B_, B);
 not	INV_124(C_, C);
 and      U612(NET_0_1_XOR_LEXT, B, C);
 nor      U613(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U615(NET_0_1, A, C_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI5
 CELL TYPE : comb
 CELL LOGIC : Y =  !(!A & B + (!B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI5(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_125(A_, A);
 not	INV_126(B_, B);
 not	INV_127(C_, C);
 and      U620(NET_0_1_XOR_LEXT, B, C);
 nor      U621(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U623(NET_0_1, A_, C_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AXOI7
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B + (B ^ C))
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AXOI7(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_128(A_, A);
 not	INV_129(B_, B);
 not	INV_130(C_, C);
 and      U628(NET_0_1_XOR_LEXT, B_, C);
 nor      U629(Y, NET_0_1_XOR_LEXT, NET_0_1);
 UDP_MUX2   U631(NET_0_1, A_, C_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U635(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
                (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD );

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_8(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U638(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_8D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_8D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U641(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_8U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_8U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U644(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_12(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U647(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_12D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_12D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U650(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_12U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_12U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U653(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_16(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U656(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_16D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_16D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U659(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_16U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_16U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U662(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_24(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U665(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_24D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_24D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U668(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_S_24U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_S_24U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U671(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_8(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U674(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_8D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_8D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U677(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_8U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_8U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U680(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_12(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U683(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_12D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_12D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U686(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_12U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_12U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U689(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_16(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U692(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_16D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_16D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U695(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_16U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_16U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U698(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_24(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U701(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_24D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_24D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U704(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_F_24U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_F_24U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U707(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS25(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U710(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS25D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS25D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U713(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS25U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS25U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U716(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS18(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U719(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS18D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS18D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U722(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS18U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS18U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U725(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS15(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U728(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS15D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS15D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri0 PAD;
 bufif1   U731(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_LVCMOS15U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_LVCMOS15U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U734(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_PCI
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_PCI(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U737(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_PCIX
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_PCIX(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U740(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_GTLP33
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_GTLP33(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U743(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_GTLP25
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_GTLP25(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U746(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BUFA
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BUFA(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BUFD
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BUFD(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : CLKBIBUF
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBIBUF(PAD, D, E, Y);
 inout PAD;
 input D, E;
 output Y;

 bufif1   U1567(PAD, D, E);
 buf    BUF_U_01(Y, PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
                specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
                specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
                specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

            //if(~D)
                (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

                (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
                (D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                (E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : CLKBUF
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVCMOS25(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVCMOS18(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVCMOS15(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_PCI
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_PCI(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_PCIX
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_PCIX(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_GTLP33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_GTLP33(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_GTLP25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_GTLP25(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_HSTL_I
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_HSTL_I(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_SSTL3_I
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_SSTL3_I(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_SSTL3_II
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_SSTL3_II(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_SSTL2_I
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_SSTL2_I(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKBUF_SSTL2_II
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_SSTL2_II(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CM7
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !S0 + D1 & S0) & !(S10+S11) + (D2 & !S0 + D3 & S0) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CM7(Y,D0,S0,D1,S10,S11,D2,D3);
 input D0,S0,D1,S10,S11,D2,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9;

 not	INV_131(S0_, S0);
 UDP_MUX2   U750(NET_0_2, D0, D1, S0_);
 UDP_MUX2   U752(Y, NET_0_2, NET_0_7, NET_0_3);
 nor      U754(NET_0_3, S10, S11);
 UDP_MUX2   U757(NET_0_7, D2, D3, S0_);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S0 => Y ) = ( tpdLH_S0_to_Y, tpdHL_S0_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CM8
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S00 & S01) + D1 & (S00 & S01)) & !(S10+S11) + (D2 & !(S00 & S01) + D3 & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CM8(Y,D0,S00,S01,D1,S10,S11,D2,D3);
 input D0,S00,S01,D1,S10,S11,D2,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;

 UDP_MUX2   U762(NET_0_4, D0, D1, NET_0_0);
 nand     U764(NET_0_0, S00, S01);
 UDP_MUX2   U766(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U768(NET_0_5, S10, S11);
 UDP_MUX2   U771(NET_0_11, D2, D3, NET_0_7);
 nand     U773(NET_0_7, S00, S01);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CM8BUFF
 CELL TYPE : comb
 CELL LOGIC : Y = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CM8BUFF(Y,A);
 input A;
 output Y;

 reg NOTIFY_REG;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
                specparam PATHPULSE$A$Y = (0.1, 0.1);
                $width(negedge A, 0.0, 0, NOTIFY_REG);
                $width(posedge A, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CM8INV
 CELL TYPE : comb
 CELL LOGIC : Y = !A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CM8INV(Y,A);
 input A;
 output Y;

 not	INV_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMA9
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(!DB & S01) + !DB & (!DB & S01)) & !(!DB+S11) + (!DB & !(!DB & S01) + D3 & (!DB & S01)) & (!DB+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMA9(Y,D0,DB,S01,S11,D3);
 input D0,DB,S01,S11,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;


	CMA9_primitive U_CMA9(Y, D0,   DB,   D3,   S01,  S11);


       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMAF
 CELL TYPE : comb
 CELL LOGIC : Y = D0 & (DB & !S11) + (D2 & !(!DB & S01) + D3 & (!DB & S01)) & (!DB+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMAF(Y,D0,DB,S11,D2,S01,D3);
 input D0,DB,S11,D2,S01,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8;


	CMAF_primitive U_CM9A(Y, D0,D2, D3,  DB, S01, S11);


       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMB3
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S00 & S01) + D1 & (S00 & S01)) & !(!DB+S11) + (!DB & !(S00 & S01) + !DB & (S00 & S01)) & (!DB+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMB3(Y,D0,S00,S01,D1,DB,S11);
 input D0,S00,S01,D1,DB,S11;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;

 not	INV_132(DB_, DB);
 UDP_MUX2   U778(NET_0_4, D0, D1, NET_0_0);
 nand     U780(NET_0_0, S00, S01);
 UDP_MUX2   U782(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U784(NET_0_5, DB_, S11);
 UDP_MUX2   U787(NET_0_11, DB_, DB_, NET_0_7);
 nand     U789(NET_0_7, S00, S01);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMB7
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S00 & S01)+D1 & (S00 & S01)) & !( !DB +S11)+(D2 & !(S00 & S01)+ !DB & (S00 & S01)) & ( !DB +S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMB7(Y,D0,S00,S01,D1,DB,S11,D2);
 input D0,S00,S01,D1,DB,S11,D2;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;


       CMB7_primitive U_CMB7(Y, D0, D1, D2, DB, S00, S01, S11);


       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMBB
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S00 & S01)+D1 & (S00 & S01)) & !( !DB +S11)+( !DB & !(S00 & S01)+D3 & (S00 & S01)) & ( !DB +S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMBB(Y,D0,S00,S01,D1,DB,S11,D3);
 input D0,S00,S01,D1,DB,S11,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;


	CMBB_primitive U_CMBB(Y, D0, D1, DB, D3, S00, S01, S11);


       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMBF
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S00 & S01)+D1 & (S00 & S01)) & !( !DB +S11)+(D2 & !(S00 & S01)+D3 & (S00 & S01)) & ( !DB +S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMBF(Y,D0,S00,S01,D1,DB,S11,D2,D3);
 input D0,S00,S01,D1,DB,S11,D2,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;

 not	INV_133(DB_, DB);
 UDP_MUX2   U794(NET_0_4, D0, D1, NET_0_0);
 nand     U796(NET_0_0, S00, S01);
 UDP_MUX2   U798(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U800(NET_0_5, DB_, S11);
 UDP_MUX2   U803(NET_0_11, D2, D3, NET_0_7);
 nand     U805(NET_0_7, S00, S01);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMEA
 CELL TYPE : comb
 CELL LOGIC : Y = (!DB & !(!DB & S01) + D1 & (!DB & S01)) & !(S10+S11) + (!DB & !(!DB & S01) + D3 & (!DB & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMEA(Y,DB,S01,D1,S10,S11,D3);
 input DB,S01,D1,S10,S11,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;


	CMEA_primitive U_CMEA(Y, DB, D1,  D3,  S01, S10,   S11);


       specify

		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMEB
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !( !DB & S01)+D1 & ( !DB & S01)) & !(S10+S11)+( !DB & !( !DB & S01)+D3 & ( !DB & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMEB(Y,D0,DB,S01,D1,S10,S11,D3);
 input D0,DB,S01,D1,S10,S11,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;


	CMEB_primitive U_CMEB(Y, D0,   D1,   DB,   D3,   S01,  S10,  S11);


       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMEE
 CELL TYPE : comb
 CELL LOGIC : Y = ( !DB & !( !DB & S01)+D1 & ( !DB & S01)) & !(S10+S11)+(D2 & !( !DB & S01)+D3 & ( !DB & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMEE(Y,DB,S01,D1,S10,S11,D2,D3);
 input DB,S01,D1,S10,S11,D2,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;


	CMEE_primitive U_CMEE(Y, DB, D1,   D2,   D3,   S01,  S10,  S11);


       specify

		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMEF
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !( !DB & S01)+D1 & ( !DB & S01)) & !(S10+S11)+(D2 & !( !DB & S01)+D3 & ( !DB & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMEF(Y,D0,DB,S01,D1,S10,S11,D2,D3);
 input D0,DB,S01,D1,S10,S11,D2,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;

 not	INV_134(DB_, DB);
 UDP_MUX2   U810(NET_0_4, D0, D1, NET_0_0);
 nand     U812(NET_0_0, DB_, S01);
 UDP_MUX2   U814(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U816(NET_0_5, S10, S11);
 UDP_MUX2   U819(NET_0_11, D2, D3, NET_0_7);
 nand     U821(NET_0_7, DB_, S01);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMF1
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S00 & S01) + !DB & (S00 & S01)) & !(S10+S11) + !DB & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMF1(Y,D0,S00,S01,DB,S10,S11);
 input D0,S00,S01,DB,S10,S11;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8;

 not	INV_135(DB_, DB);
 UDP_MUX2   U826(NET_0_4, D0, DB_, NET_0_0);
 nand     U828(NET_0_0, S00, S01);
 UDP_MUX2   U830(Y, NET_0_4, DB_, NET_0_5);
 nor      U832(NET_0_5, S10, S11);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMF2
 CELL TYPE : comb
 CELL LOGIC : Y = (!DB & !(S00 & S01) + D1 & (S00 & S01)) & !(S10+S11) + !DB & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMF2(Y,DB,S00,S01,D1,S10,S11);
 input DB,S00,S01,D1,S10,S11;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8;

 not	INV_136(DB_, DB);
 UDP_MUX2   U837(NET_0_4, DB_, D1, NET_0_0);
 nand     U839(NET_0_0, S00, S01);
 UDP_MUX2   U841(Y, NET_0_4, DB_, NET_0_5);
 nor      U843(NET_0_5, S10, S11);

       specify

		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMF3
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S00 & S01)+ D1 & (S00 & S01)) & !(S10+S11) + !DB & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMF3(Y,D0,S00,S01,D1,S10,S11,DB);
 input D0,S00,S01,D1,S10,S11,DB;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8;

 not	INV_137(DB_, DB);
 UDP_MUX2   U848(NET_0_4, D0, D1, NET_0_0);
 nand     U850(NET_0_0, S00, S01);
 UDP_MUX2   U852(Y, NET_0_4, DB_, NET_0_5);
 nor      U854(NET_0_5, S10, S11);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMF4
 CELL TYPE : comb
 CELL LOGIC : Y = !DB & !(S10+S11) + (D2 & !(S00 & S01) + !DB & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMF4(Y,DB,S10,S11,D2,S00,S01);
 input DB,S10,S11,D2,S00,S01;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8;

 not	INV_138(DB_, DB);
 UDP_MUX2   U858(Y, DB_, NET_0_6, NET_0_0);
 nor      U860(NET_0_0, S10, S11);
 UDP_MUX2   U863(NET_0_6, D2, DB_, NET_0_2);
 nand     U865(NET_0_2, S00, S01);

       specify

		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMF5
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S10+S11) + D2 & (S10+S11)) & !(S00 & S01) +  !DB & (S00 & S01)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMF5(Y,D0,S10,S11,D2,S00,S01,DB);
 input D0,S10,S11,D2,S00,S01,DB;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8;

 not	INV_139(DB_, DB);
 UDP_MUX2   U870(NET_0_4, D0, D2, NET_0_0);
 nor      U872(NET_0_0, S10, S11);
 UDP_MUX2   U874(Y, NET_0_4, DB_, NET_0_5);
 nand     U876(NET_0_5, S00, S01);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMF6
 CELL TYPE : comb
 CELL LOGIC : Y = ( !DB & !(S00 & S01)+D1 & (S00 & S01)) & !(S10+S11) + (D2 & !(S00 & S01)+ !DB & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMF6(Y,DB,S00,S01,D1,S10,S11,D2);
 input DB,S00,S01,D1,S10,S11,D2;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;

 not	INV_140(DB_, DB);
 UDP_MUX2   U881(NET_0_4, DB_, D1, NET_0_0);
 nand     U883(NET_0_0, S00, S01);
 UDP_MUX2   U885(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U887(NET_0_5, S10, S11);
 UDP_MUX2   U890(NET_0_11, D2, DB_, NET_0_7);
 nand     U892(NET_0_7, S00, S01);

       specify

		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMF7
 CELL TYPE : comb
 CELL LOGIC : Y = ( D0 & !(S00 & S01) + D1 & (S00 & S01)) & !(S10+S11) + (D2 & !(S00 & S01) +  !DB & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMF7(Y,D0,S00,S01,D1,S10,S11,D2,DB);
 input D0,S00,S01,D1,S10,S11,D2,DB;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;

 not	INV_141(DB_, DB);
 UDP_MUX2   U897(NET_0_4, D0, D1, NET_0_0);
 nand     U899(NET_0_0, S00, S01);
 UDP_MUX2   U901(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U903(NET_0_5, S10, S11);
 UDP_MUX2   U906(NET_0_11, D2, DB_, NET_0_7);
 nand     U908(NET_0_7, S00, S01);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMF8
 CELL TYPE : comb
 CELL LOGIC : Y = !DB & !(S10+S11) + (!DB & !(S00 & S01) + D3 & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMF8(Y,DB,S10,S11,S00,S01,D3);
 input DB,S10,S11,S00,S01,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8;

 not	INV_142(DB_, DB);
 UDP_MUX2   U912(Y, DB_, NET_0_6, NET_0_0);
 nor      U914(NET_0_0, S10, S11);
 UDP_MUX2   U917(NET_0_6, DB_, D3, NET_0_2);
 nand     U919(NET_0_2, S00, S01);

       specify

		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMF9
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S00 & S01)+ !DB & (S00 & S01)) & !(S10+S11) + ( !DB & !(S00 & S01)+D3 & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMF9(Y,D0,S00,S01,DB,S10,S11,D3);
 input D0,S00,S01,DB,S10,S11,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;

 not	INV_143(DB_, DB);
 UDP_MUX2   U924(NET_0_4, D0, DB_, NET_0_0);
 nand     U926(NET_0_0, S00, S01);
 UDP_MUX2   U928(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U930(NET_0_5, S10, S11);
 UDP_MUX2   U933(NET_0_11, DB_, D3, NET_0_7);
 nand     U935(NET_0_7, S00, S01);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMFA
 CELL TYPE : comb
 CELL LOGIC : Y = (!DB & !(S00 & S01)) + (D1 & !(S10+S11)+D3 & (S10+S11)) & (S00 & S01)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMFA(Y,DB,S00,S01,D1,S10,S11,D3);
 input DB,S00,S01,D1,S10,S11,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8;

 not	INV_144(DB_, DB);
 UDP_MUX2   U939(Y, DB_, NET_0_6, NET_0_0);
 nand     U941(NET_0_0, S00, S01);
 UDP_MUX2   U944(NET_0_6, D1, D3, NET_0_2);
 nor      U946(NET_0_2, S10, S11);

       specify

		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMFB
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S00 & S01) + D1 & (S00 & S01)) & !(S10+S11) + (  !DB & !(S00 & S01) + D3 & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMFB(Y,D0,S00,S01,D1,S10,S11,DB,D3);
 input D0,S00,S01,D1,S10,S11,DB,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;

 not	INV_145(DB_, DB);
 UDP_MUX2   U951(NET_0_4, D0, D1, NET_0_0);
 nand     U953(NET_0_0, S00, S01);
 UDP_MUX2   U955(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U957(NET_0_5, S10, S11);
 UDP_MUX2   U960(NET_0_11, DB_, D3, NET_0_7);
 nand     U962(NET_0_7, S00, S01);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMFC
 CELL TYPE : comb
 CELL LOGIC : Y =!DB & !(S10+S11) + (D2 & !(S00 & S01)+D3 & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMFC(Y,DB,S10,S11,D2,S00,S01,D3);
 input DB,S10,S11,D2,S00,S01,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8;

 not	INV_146(DB_, DB);
 UDP_MUX2   U966(Y, DB_, NET_0_6, NET_0_0);
 nor      U968(NET_0_0, S10, S11);
 UDP_MUX2   U971(NET_0_6, D2, D3, NET_0_2);
 nand     U973(NET_0_2, S00, S01);

       specify

		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMFD
 CELL TYPE : comb
 CELL LOGIC : Y = ( D0 & !(S00 & S01) +  !DB & (S00 & S01)) & !(S10+S11) + (D2 & !(S00 & S01) + D3 & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMFD(Y,D0,S00,S01,DB,S10,S11,D2,D3);
 input D0,S00,S01,DB,S10,S11,D2,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;

 not	INV_147(DB_, DB);
 UDP_MUX2   U978(NET_0_4, D0, DB_, NET_0_0);
 nand     U980(NET_0_0, S00, S01);
 UDP_MUX2   U982(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U984(NET_0_5, S10, S11);
 UDP_MUX2   U987(NET_0_11, D2, D3, NET_0_7);
 nand     U989(NET_0_7, S00, S01);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CMFE
 CELL TYPE : comb
 CELL LOGIC : Y = (!DB & !(S00 & S01) + D1 & (S00 & S01)) & !(S10+S11) + (D2 & !(S00 & S01) + D3 & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CMFE(Y,DB,S00,S01,D1,S10,S11,D2,D3);
 input DB,S00,S01,D1,S10,S11,D2,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;

 not	INV_148(DB_, DB);
 UDP_MUX2   U994(NET_0_4, DB_, D1, NET_0_0);
 nand     U996(NET_0_0, S00, S01);
 UDP_MUX2   U998(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U1000(NET_0_5, S10, S11);
 UDP_MUX2   U1003(NET_0_11, D2, D3, NET_0_7);
 nand     U1005(NET_0_7, S00, S01);

       specify

		specparam tpdLH_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_DB_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(DB => Y ) = ( tpdLH_DB_to_Y, tpdHL_DB_to_Y );
		(S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
		(S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
		(S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CS1
 CELL TYPE : comb
 CELL LOGIC : Y = !(A + S & B) & C + D & (A + S & B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CS1(Y,A,S,B,C,D);
 input A,S,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;

 UDP_MUX2   U1009(Y, C, D, NET_0_1);
 nor      U1011(NET_0_1, A, NET_0_0);
 and      U1013(NET_0_0, S, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CS2
 CELL TYPE : comb
 CELL LOGIC : Y = !((A+S) & B) & C + ((A+S) & B) & D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CS2(Y,A,S,B,C,D);
 input A,S,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;

 UDP_MUX2   U1017(Y, C, D, NET_0_1);
 or       U1020(NET_0_0, A, S);
 nand     U1021(NET_0_1, NET_0_0, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CY2A
 CELL TYPE : comb
 CELL LOGIC : Y = A1 & B1 + A0 & B0 & A1 + A0 & B0 & B1
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CY2A(Y,A1,B1,A0,B0);
 input A1,B1,A0,B0;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;

 and      U1027(NET_0_0, A1, B1);
 or       U1028(NET_0_3, NET_0_0, NET_0_2);
 and      U1031(NET_0_1, A0, B0);
 and      U1032(NET_0_2, NET_0_1, A1);
 or       U1033(Y, NET_0_3, NET_0_5);
 and      U1036(NET_0_4, A0, B0);
 and      U1037(NET_0_5, NET_0_4, B1);

       specify

		specparam tpdLH_A1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B0_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A1 => Y ) = ( tpdLH_A1_to_Y, tpdHL_A1_to_Y );
		(B1 => Y ) = ( tpdLH_B1_to_Y, tpdHL_B1_to_Y );
		(A0 => Y ) = ( tpdLH_A0_to_Y, tpdHL_A0_to_Y );
		(B0 => Y ) = ( tpdLH_B0_to_Y, tpdHL_B0_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CY2B
 CELL TYPE : comb
 CELL LOGIC : Y = A1 & B1 + (A0+B0) & A1 + (A0+B0) & B1
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CY2B(Y,A1,B1,A0,B0);
 input A1,B1,A0,B0;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;

 and      U1042(NET_0_0, A1, B1);
 or       U1043(NET_0_3, NET_0_0, NET_0_2);
 or       U1046(NET_0_1, A0, B0);
 and      U1047(NET_0_2, NET_0_1, A1);
 or       U1048(Y, NET_0_3, NET_0_5);
 or       U1051(NET_0_4, A0, B0);
 and      U1052(NET_0_5, NET_0_4, B1);

       specify

		specparam tpdLH_A1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B0_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A1 => Y ) = ( tpdLH_A1_to_Y, tpdHL_A1_to_Y );
		(B1 => Y ) = ( tpdLH_B1_to_Y, tpdHL_B1_to_Y );
		(A0 => Y ) = ( tpdLH_A0_to_Y, tpdHL_A0_to_Y );
		(B0 => Y ) = ( tpdLH_B0_to_Y, tpdHL_B0_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DF1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DF1(CLK, Q,D);
 input D,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DF1_CC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DF1_CC(CLK, Q,D);
 input D,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DF1B
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DF1B(CLK, Q,D);
 input D,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFC1B
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFC1B(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,CLR, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,CLR);
       buf U_c2 (Enable2, CLR);
      buf U_c6 (Enable5, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFC1B_CC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFC1B_CC(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,CLR, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,CLR);
       buf U_c2 (Enable2, CLR);
      buf U_c6 (Enable5, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFC1D
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFC1D(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,CLR, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,CLR);
       buf U_c2 (Enable2, CLR);
      buf U_c6 (Enable5, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFE1C
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFE1C(E, CLK, Q,D);
 input D,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,VCC_0, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I3 (_E, E);
      buf U_c0 (Enable1,_E);
      buf U_c2 (Enable2, _E);
      buf U_c4 (Enable4, _E);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK,  0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFE1B
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFE1B(E, CLK, Q,D);
 input D,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I3 (_E, E);
      buf U_c0 (Enable1,_E);
      buf U_c2 (Enable2, _E);
      buf U_c4 (Enable4, _E);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK,  0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFE3C
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFE3C(CLR, E, CLK, Q,D);
 input D,CLR,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,CLR, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR);
      and U_c2 (Enable2, _E, CLR);
      buf U_c4 (Enable4, _E);
      buf U_c6 (Enable5, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFE3D
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFE3D(CLR, E, CLK, Q,D);
 input D,CLR,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,CLR, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR);
      and U_c2 (Enable2, _E, CLR);
      buf U_c4 (Enable4, _E);
      buf U_c6 (Enable5, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFE4F
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFE4F(PRE, E, CLK, Q,D);
 input D,PRE,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, PRE);
      buf U_c2 (Enable2, _E);
      and U_c4 (Enable4, _E, PRE);
       buf U_c6 (Enable5, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFE4G
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFE4G(PRE, E, CLK, Q,D);
 input D,PRE,E,CLK;
 output Q;
 supply1 VCC_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,VCC_0, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, PRE);
      buf U_c2 (Enable2, _E);
      and U_c4 (Enable4, _E, PRE);
       buf U_c6 (Enable5, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFEG
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _CLR=CLR, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFEG(PRE, CLR, E, CLK, Q,D);
 input D,PRE,CLR,E,CLK;
 output Q;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFEH
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _CLR=CLR, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFEH(PRE, CLR, E, CLK, Q,D);
 input D,PRE,CLR,E,CLK;
 output Q;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFP1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFP1(PRE, CLK, Q,D);
 input D,PRE,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(Q, D,CLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      buf U_c0 (Enable1, _PRE);
       buf U_c4 (Enable4, _PRE);
       buf U_c6 (Enable5, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFP1A
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFP1A(PRE, CLK, Q,D);
 input D,PRE,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpf DF_0(Q, D,CLK,VCC_0, PRE_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      buf U_c0 (Enable1, _PRE);
       buf U_c4 (Enable4, _PRE);
       buf U_c6 (Enable5, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, negedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge PRE,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFP1B
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFP1B(PRE, CLK, Q,D);
 input D,PRE,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      buf U_c0 (Enable1, PRE);       buf U_c4 (Enable4, PRE);
       buf U_c6 (Enable5, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFP1B_CC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFP1B_CC(PRE, CLK, Q,D);
 input D,PRE,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      buf U_c0 (Enable1, PRE);       buf U_c4 (Enable4, PRE);
       buf U_c6 (Enable5, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFP1D
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFP1D(PRE, CLK, Q,D);
 input D,PRE,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,VCC_0, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      buf U_c0 (Enable1, PRE);       buf U_c4 (Enable4, PRE);
       buf U_c6 (Enable5, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFPC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _CLR=CLR, PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFPC(PRE, CLR, CLK, Q,D);
 input D,PRE,CLR,CLK;
 output Q;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(PRE_0, PRE);

 Dffpr DF_0(Q, D,CLK,CLR, PRE_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, CLR, _PRE);
       buf U_c2 (Enable2, CLR);
       buf U_c4 (Enable4, _PRE);
      and U_c6 (Enable5, CLR, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK &&& Enable2, negedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFPCB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _CLR=CLR, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFPCB(PRE, CLR, CLK, Q,D);
 input D,PRE,CLR,CLK;
 output Q;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,CLR, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, CLR, PRE);
       buf U_c2 (Enable2, CLR);
       buf U_c4 (Enable4, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFPCC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _CLR=CLR, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFPCC(PRE, CLR, CLK, Q,D);
 input D,PRE,CLR,CLK;
 output Q;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,CLR, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, CLR, PRE);
       buf U_c2 (Enable2, CLR);
       buf U_c4 (Enable4, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DL1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, D=D ];
-----------------------------------------------------------------*/

module DL1(G, Q,D);
 input D,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, G);
	buf U_c3 (Enable4, G);
	buf U_c5 (Enable6, G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DL1A
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, CLK =G, D=D ];
-----------------------------------------------------------------*/

module DL1A(G, QN,D);
 input D,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(QN_, D, G_, GND, GND, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, G);
	buf U_c3 (Enable4, G);
	buf U_c5 (Enable6, G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if(G )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	(posedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DL1B
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, D=D ];
-----------------------------------------------------------------*/

module DL1B(G, Q,D);
 input D,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 DL2C_UDP DL_U0(Q, D, G, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	buf U_c1 (Enable2, _G);
	buf U_c3 (Enable4, _G);
	buf U_c5 (Enable6, _G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DL1C
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, _CLK=G, D=D ];
-----------------------------------------------------------------*/

module DL1C(G, QN,D);
 input D,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 DL2C_UDP DL_U0(QN_, D, G, GND, GND, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	buf U_c1 (Enable2, _G);
	buf U_c3 (Enable4, _G);
	buf U_c5 (Enable6, _G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	(negedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DL2A
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, _CLR=CLR, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DL2A(PRE, CLR, G, Q,D);
 input D,PRE,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, CLR_, PRE, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I1 (_PRE, PRE);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, CLR, _PRE);
	and U_c1 (Enable2, G, CLR, _PRE);
	buf U_c2 (Enable3, CLR);
	and U_c3 (Enable4, G, CLR);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, G, _PRE);
	and U_c6 (Enable7, CLR, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G && CLR && !PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	if(CLR)
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if(G && CLR )
	(negedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, negedge G &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (negedge G &&& Enable3 , negedge PRE, 0.0, NOTIFY_REG);
	$recovery (posedge  CLR, negedge G &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable5,  posedge  CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DL2C
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _CLR=CLR, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DL2C(PRE, CLR, G, Q,D);
 input D,PRE,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, D, G, CLR_, PRE, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, CLR, _PRE);
	and U_c1 (Enable2, _G, CLR, _PRE);
	buf U_c2 (Enable3, CLR);
	and U_c3 (Enable4, _G, CLR);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, _G, _PRE);
	and U_c6 (Enable7, CLR, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && CLR && !PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	if(CLR)
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if(!G && CLR )
	(negedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, posedge G &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (posedge G &&& Enable3 , negedge PRE, 0.0, NOTIFY_REG);
	$recovery (posedge  CLR, posedge G &&& Enable5, 0.0, NOTIFY_REG);
	$hold (posedge G &&& Enable5, posedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLC
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, _CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLC(CLR, G, Q,D);
 input D,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, CLR_, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,CLR);
	and U_c1 (Enable2, G,CLR);
	buf U_c2 (Enable3, CLR);
	and U_c3 (Enable4, G, CLR);
	buf U_c5 (Enable6, G);
	buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G && CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  CLR, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, posedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLC1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLC1(CLR, G, Q,D);
 input D,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, CLR, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, G,_CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, G, _CLR);
	buf U_c5 (Enable6, G);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G && !CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLC1A
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLC1A(CLR, G, Q,D);
 input D,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, D, G, CLR, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, _G, _CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _G, _CLR);
	buf U_c5 (Enable6, _G);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && !CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLC1F
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, CLK =G, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLC1F(CLR, G, QN,D);
 input D,CLR,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(QN_, D, G_, CLR, GND, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, G,_CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, G, _CLR);
	buf U_c5 (Enable6, G);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if(G && !CLR )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if(Enable1)
	(posedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	(negedge CLR => (QN+:D)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLC1G
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, _CLK=G, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLC1G(CLR, G, QN,D);
 input D,CLR,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(QN_, D, G, CLR, GND, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, _G, _CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _G, _CLR);
	buf U_c5 (Enable6, _G);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && !CLR )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if(Enable1)
	(negedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(posedge CLR => (QN +: 1'b0)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);
	(negedge CLR => (QN+:D)) = (tpdLH_CLR_to_QN, tpdHL_CLR_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLCA
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLCA(CLR, G, Q,D);
 input D,CLR,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, D, G, CLR_, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,CLR);
	and U_c1 (Enable2, _G, CLR);
	buf U_c2 (Enable3, CLR);
	and U_c3 (Enable4, _G, CLR);
	buf U_c5 (Enable6, _G);
	buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  CLR, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, posedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLE
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, E=E, D=D ];
-----------------------------------------------------------------*/

module DLE(E, G, Q,D);
 input D,E,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_EN(E_,E);
 not INV_CLK(G_, G);
 DLE3B_UDP DL_U0(Q,D,G_,E_, GND,NOTIFY_REG);

// some temp signals created for timing checking sections

	buf U_c0 (Enable1,E);
	buf U_c1 (Enable2, G);
	buf U_c2 (Enable3, E);
	buf U_c3 (Enable4, G);
	buf U_c4 (Enable5, E);
	buf U_c5 (Enable6, G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_E_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_E_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G && E )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	if(G)
	(posedge E => (Q +:D)) = (tpdLH_E_to_Q, tpdHL_E_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// setup/hold check for the E to G

	$setup(posedge E, posedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge E, 0.0, NOTIFY_REG);

	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLE1D
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, _CLK=G, _E=E, D=D ];
-----------------------------------------------------------------*/

module DLE1D(E, G, QN,D);
 input D,E,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_EN(E_,E);
 DLE3B_UDP DL_U0(QN_,D,G,E, GND,NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I3 (_E, E);
	buf U_c0 (Enable1,_E);
	buf U_c1 (Enable2, _G);
	buf U_c2 (Enable3, _E);
	buf U_c3 (Enable4, _G);
	buf U_c4 (Enable5, _E);
	buf U_c5 (Enable6, _G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_E_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_E_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && !E )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if(Enable1)
	(negedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	if(!G)
	(negedge E => (QN+:D)) = (tpdLH_E_to_QN, tpdHL_E_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// setup/hold check for the E to G

	$setup(negedge E, negedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge E, 0.0, NOTIFY_REG);

	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLE2B
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _E=E, _CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLE2B ( CLR, E, G, Q, D );
  input   D, CLR, E, G;
  output  Q;
  supply1 VCC;
  supply0 GND;
  reg     NOTIFY_REG;

  not       INV_CLR ( CLR_, CLR );
  not       INV_EN ( E_, E );
  DLE2B_UDP DL_U0 ( Q, D, E, G, CLR, NOTIFY_REG );

  // some temp signals created for timing checking sections

	not U_I0 ( _G, G );
	not U_I2 ( _CLR, CLR );
	not U_I3 ( _E, E );
	and U_c0 ( Enable1, _E, CLR );
	and U_c1 ( Enable2, _G, CLR );
	and U_c2 ( Enable3, _E, CLR );
	and U_c3 ( Enable4, _G, CLR );
	buf U_c4 ( Enable5, _E );
	buf U_c5 ( Enable6, _G );
	buf U_c6 ( Enable7, CLR );

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

  specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_E_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_E_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && CLR && !E )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	if(CLR && !G)
	(negedge E => (Q+:D)) = (tpdLH_E_to_Q, tpdHL_E_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// setup/hold check for the E to G

	$setup(negedge E, negedge G &&& CLR, 0.0, NOTIFY_REG);
	$hold(posedge G &&& CLR, posedge E, 0.0, NOTIFY_REG);

	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  CLR, posedge G &&& Enable5, 0.0, NOTIFY_REG);
	$hold (posedge G &&& Enable5, posedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLE2C
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _E=E, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module DLE2C(CLR, E, G, Q,D);
 input D,CLR,E,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_EN(E_,E);
 DLE2B_UDP DL_U0(Q,D,E,G,CLR_,NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I2 (_CLR, CLR);
	not U_I3 (_E, E);
	and U_c0 (Enable1, _E, _CLR);
	and U_c1 (Enable2, _G, _CLR);
	and U_c2 (Enable3, _E, _CLR);
	and U_c3 (Enable4, _G, _CLR);
	buf U_c4 (Enable5, _E);
	buf U_c5 (Enable6, _G);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_E_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_E_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && !CLR && !E )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	if(!CLR && !G)
	(negedge E => (Q+:D)) = (tpdLH_E_to_Q, tpdHL_E_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// setup/hold check for the E to G

	$setup(negedge E, negedge G &&& Enable7, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable7, posedge E, 0.0, NOTIFY_REG);

	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, posedge G &&& Enable5, 0.0, NOTIFY_REG);
	$hold (posedge G &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);
	$recovery (negedge CLR,  posedge E &&& Enable6, 0.0, NOTIFY_REG);
	$hold (posedge E &&& Enable6, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLE3B
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _E=E, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLE3B(PRE, E, G, Q,D);
 input D,PRE,E,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_EN(E_,E);
 DLE3B_UDP DL_U0(Q,D,G,E, PRE,NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	not U_I3 (_E, E);
	and U_C0 (Enable1, _E, _PRE);
	and U_c1 (Enable2, _G, _PRE);
	buf U_c2 (Enable3, _E);
	buf U_c3 (Enable4, _G);
	and U_c4 (Enable5, _E, _PRE);
	and U_c5 (Enable6, _G, _PRE);
	buf U_c6 (Enable7, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_E_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_E_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && !PRE && !E )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if(!G && !E )
	(negedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
	if(!PRE && !G)
	(negedge E => (Q+:D)) = (tpdLH_E_to_Q, tpdHL_E_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// setup/hold check for the E to G

	$setup(negedge E, negedge G &&& Enable7, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable7, posedge E, 0.0, NOTIFY_REG);

	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, posedge G &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (posedge G &&& Enable3 , negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLE3C
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _E=E, _PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLE3C(PRE, E, G, Q,D);
 input D,PRE,E,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_EN(E_,E);
 DLE3B_UDP DL_U0(Q,D,G,E, PRE_,NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	not U_I3 (_E, E);
	and U_C0 (Enable1, _E, PRE);
	and U_c1 (Enable2, _G, PRE);
	buf U_c2 (Enable3, _E);
	buf U_c3 (Enable4, _G);
	and U_c4 (Enable5, _E, PRE);
	and U_c5 (Enable6, _G, PRE);
	buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_E_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_E_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && PRE && !E )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if(!G && !E )
       (posedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
	if(PRE && !G)
	(negedge E => (Q+:D)) = (tpdLH_E_to_Q, tpdHL_E_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// setup/hold check for the E to G

	$setup(negedge E, negedge G &&& Enable7, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable7, posedge E, 0.0, NOTIFY_REG);

	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  PRE, posedge G &&& Enable3 , 0.0, NOTIFY_REG);
	$hold (posedge G &&& Enable3 , posedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLEA
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, _E=E, D=D ];
-----------------------------------------------------------------*/

module DLEA(E, G, Q,D);
 input D,E,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_EN(E_,E);
 not INV_CLK(G_, G);
 DLE3B_UDP DL_U0(Q,D,G_,E, GND,NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I3 (_E, E);
	buf U_c0 (Enable1,_E);
	buf U_c1 (Enable2, G);
	buf U_c2 (Enable3, _E);
	buf U_c3 (Enable4, G);
	buf U_c4 (Enable5, _E);
	buf U_c5 (Enable6, G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_E_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_E_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G && !E )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	if(G)
	(negedge E => (Q+:D)) = (tpdLH_E_to_Q, tpdHL_E_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// setup/hold check for the E to G

	$setup(negedge E, posedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge E, 0.0, NOTIFY_REG);

	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLEB
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, E=E, D=D ];
-----------------------------------------------------------------*/

module DLEB(E, G, Q,D);
 input D,E,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_EN(E_,E);
 DLE3B_UDP DL_U0(Q,D,G,E_, GND,NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	buf U_c0 (Enable1,E);
	buf U_c1 (Enable2, _G);
	buf U_c2 (Enable3, E);
	buf U_c3 (Enable4, _G);
	buf U_c4 (Enable5, E);
	buf U_c5 (Enable6, _G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_E_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_E_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && E )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	if(!G)
	(posedge E => (Q +:D)) = (tpdLH_E_to_Q, tpdHL_E_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// setup/hold check for the E to G

	$setup(posedge E, negedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge E, 0.0, NOTIFY_REG);

	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLEC
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _E=E, D=D ];
-----------------------------------------------------------------*/

module DLEC(E, G, Q,D);
 input D,E,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_EN(E_,E);
 DLE3B_UDP DL_U0(Q,D,G,E, GND,NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I3 (_E, E);
	buf U_c0 (Enable1,_E);
	buf U_c1 (Enable2, _G);
	buf U_c2 (Enable3, _E);
	buf U_c3 (Enable4, _G);
	buf U_c4 (Enable5, _E);
	buf U_c5 (Enable6, _G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_E_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_E_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && !E )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	if(!G)
	(negedge E => (Q+:D)) = (tpdLH_E_to_Q, tpdHL_E_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	// setup/hold check for the E to G

	$setup(negedge E, negedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge E, 0.0, NOTIFY_REG);

	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLM
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, D=A & !S + B & S ];
-----------------------------------------------------------------*/

module DLM(G, Q,A,S,B);
 input A,S,B,G;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_149(S_, S);
 UDP_MUX2   U1055(NET_0_2, A, B, S_);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, NET_0_2, G_, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, G);
	buf U_c3 (Enable4, G);
	buf U_c5 (Enable6, G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$A = 0.0;
	specparam    InputLoad$S = 0.0;
	specparam    InputLoad$B = 0.0;
        specparam    tpdLH_A_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_A_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_B_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_B_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G )
        (A => Q) = (tpdLH_A_to_Q, tpdHL_A_to_Q);
	if(G )
        (S => Q) = (tpdLH_S_to_Q, tpdHL_S_to_Q);
	if(G )
        (B => Q) = (tpdLH_B_to_Q, tpdHL_B_to_Q);

	(posedge G => (Q+:Q))=(tpdLH_G_to_Q, tpdHL_G_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge A,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge A,0.0, NOTIFY_REG);
	$setup(posedge S,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge S,0.0, NOTIFY_REG);
	$setup(posedge B,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge B,0.0, NOTIFY_REG);
	$setup(negedge A,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge A,0.0, NOTIFY_REG);
	$setup(negedge S,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge S,0.0, NOTIFY_REG);
	$setup(negedge B,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLM2
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, _CLR=CLR, D=A & !S + B & S ];
-----------------------------------------------------------------*/

module DLM2(CLR, G, Q,A,S,B);
 input A,S,B,CLR,G;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_150(S_, S);
 UDP_MUX2   U1059(NET_0_2, A, B, S_);
 not INV_CLR(CLR_, CLR);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, NET_0_2, G_, CLR_, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,CLR);
	and U_c1 (Enable2, G,CLR);
	buf U_c2 (Enable3, CLR);
	and U_c3 (Enable4, G, CLR);
	buf U_c5 (Enable6, G);
	buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$A = 0.0;
	specparam    InputLoad$S = 0.0;
	specparam    InputLoad$B = 0.0;
        specparam    tpdLH_A_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_A_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_B_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_B_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G && CLR )
        (A => Q) = (tpdLH_A_to_Q, tpdHL_A_to_Q);
	if(G && CLR )
        (S => Q) = (tpdLH_S_to_Q, tpdHL_S_to_Q);
	if(G && CLR )
        (B => Q) = (tpdLH_B_to_Q, tpdHL_B_to_Q);

	if(Enable1)
	(posedge G => (Q+:Q))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge CLR => (Q+:Q)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge A,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$setup(posedge S,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$setup(posedge B,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$setup(negedge A,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(negedge S,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(negedge B,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  CLR, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, posedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLM2B
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _CLR=CLR, D=A & !S + B & S ];
-----------------------------------------------------------------*/

module DLM2B(CLR, G, Q,A,S,B);
 input A,S,B,CLR,G;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_151(S_, S);
 UDP_MUX2   U1063(NET_0_2, A, B, S_);
 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, NET_0_2, G, CLR_, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,CLR);
	and U_c1 (Enable2, _G, CLR);
	buf U_c2 (Enable3, CLR);
	and U_c3 (Enable4, _G, CLR);
	buf U_c5 (Enable6, _G);
	buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$A = 0.0;
	specparam    InputLoad$S = 0.0;
	specparam    InputLoad$B = 0.0;
        specparam    tpdLH_A_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_A_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_B_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_B_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && CLR )
        (A => Q) = (tpdLH_A_to_Q, tpdHL_A_to_Q);
	if(!G && CLR )
        (S => Q) = (tpdLH_S_to_Q, tpdHL_S_to_Q);
	if(!G && CLR )
        (B => Q) = (tpdLH_B_to_Q, tpdHL_B_to_Q);

	if(Enable1)
	(negedge G => (Q+:Q))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge CLR => (Q+:Q)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge A,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$setup(posedge S,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$setup(posedge B,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$setup(negedge A,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(negedge S,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(negedge B,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  CLR, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, posedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLM3
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, D=(D0 & !S0 + D1 & S0) & !S1 + (D2 & !S0 + D3 & S0) & S1 ];
-----------------------------------------------------------------*/

module DLM3(G, Q,D0,S0,D1,S1,D2,D3);
 input D0,S0,D1,S1,D2,D3,G;
 output Q;
 wire NET_0_0,NET_0_1,NET_0_2,NET_0_3,NET_0_4,NET_0_5,NET_0_6,NET_0_7;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_152(S0_, S0);
 not	INV_153(S1_, S1);
 UDP_MUX2   U1068(NET_0_2, D0, D1, S0_);
 UDP_MUX2   U1070(NET_0_8, NET_0_2, NET_0_6, S1_);
 UDP_MUX2   U1073(NET_0_6, D2, D3, S0_);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, NET_0_8, G_, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, G);
	buf U_c3 (Enable4, G);
	buf U_c5 (Enable6, G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D0 = 0.0;
	specparam    InputLoad$S0 = 0.0;
	specparam    InputLoad$D1 = 0.0;
	specparam    InputLoad$S1 = 0.0;
	specparam    InputLoad$D2 = 0.0;
	specparam    InputLoad$D3 = 0.0;
        specparam    tpdLH_D0_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D0_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S0_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S0_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D1_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D1_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S1_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S1_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D2_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D2_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D3_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D3_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G )
        (D0 => Q) = (tpdLH_D0_to_Q, tpdHL_D0_to_Q);
	if(G )
        (S0 => Q) = (tpdLH_S0_to_Q, tpdHL_S0_to_Q);
	if(G )
        (D1 => Q) = (tpdLH_D1_to_Q, tpdHL_D1_to_Q);
	if(G )
        (S1 => Q) = (tpdLH_S1_to_Q, tpdHL_S1_to_Q);
	if(G )
        (D2 => Q) = (tpdLH_D2_to_Q, tpdHL_D2_to_Q);
	if(G )
        (D3 => Q) = (tpdLH_D3_to_Q, tpdHL_D3_to_Q);

	(posedge G => (Q+:Q))=(tpdLH_G_to_Q, tpdHL_G_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D0,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D0,0.0, NOTIFY_REG);
	$setup(posedge S0,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge S0,0.0, NOTIFY_REG);
	$setup(posedge D1,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D1,0.0, NOTIFY_REG);
	$setup(posedge S1,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge S1,0.0, NOTIFY_REG);
	$setup(posedge D2,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D2,0.0, NOTIFY_REG);
	$setup(posedge D3,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D3,0.0, NOTIFY_REG);
	$setup(negedge D0,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D0,0.0, NOTIFY_REG);
	$setup(negedge S0,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge S0,0.0, NOTIFY_REG);
	$setup(negedge D1,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D1,0.0, NOTIFY_REG);
	$setup(negedge S1,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge S1,0.0, NOTIFY_REG);
	$setup(negedge D2,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D2,0.0, NOTIFY_REG);
	$setup(negedge D3,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D3,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLM3A
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, D=(D0 & !S0 + D1 & S0) & !S1 + (D2 & !S0 + D3 & S0) & S1 ];
-----------------------------------------------------------------*/

module DLM3A(G, Q,D0,S0,D1,S1,D2,D3);
 input D0,S0,D1,S1,D2,D3,G;
 output Q;
 wire NET_0_0,NET_0_1,NET_0_2,NET_0_3,NET_0_4,NET_0_5,NET_0_6,NET_0_7;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_154(S0_, S0);
 not	INV_155(S1_, S1);
 UDP_MUX2   U1078(NET_0_2, D0, D1, S0_);
 UDP_MUX2   U1080(NET_0_8, NET_0_2, NET_0_6, S1_);
 UDP_MUX2   U1083(NET_0_6, D2, D3, S0_);
 DL2C_UDP DL_U0(Q, NET_0_8, G, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	buf U_c1 (Enable2, _G);
	buf U_c3 (Enable4, _G);
	buf U_c5 (Enable6, _G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$D0 = 0.0;
	specparam    InputLoad$S0 = 0.0;
	specparam    InputLoad$D1 = 0.0;
	specparam    InputLoad$S1 = 0.0;
	specparam    InputLoad$D2 = 0.0;
	specparam    InputLoad$D3 = 0.0;
        specparam    tpdLH_D0_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D0_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S0_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S0_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D1_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D1_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S1_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S1_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D2_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D2_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D3_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D3_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G )
        (D0 => Q) = (tpdLH_D0_to_Q, tpdHL_D0_to_Q);
	if(!G )
        (S0 => Q) = (tpdLH_S0_to_Q, tpdHL_S0_to_Q);
	if(!G )
        (D1 => Q) = (tpdLH_D1_to_Q, tpdHL_D1_to_Q);
	if(!G )
        (S1 => Q) = (tpdLH_S1_to_Q, tpdHL_S1_to_Q);
	if(!G )
        (D2 => Q) = (tpdLH_D2_to_Q, tpdHL_D2_to_Q);
	if(!G )
        (D3 => Q) = (tpdLH_D3_to_Q, tpdHL_D3_to_Q);

	(negedge G => (Q+:Q))=(tpdLH_G_to_Q, tpdHL_G_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D0,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D0,0.0, NOTIFY_REG);
	$setup(posedge S0,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge S0,0.0, NOTIFY_REG);
	$setup(posedge D1,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D1,0.0, NOTIFY_REG);
	$setup(posedge S1,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge S1,0.0, NOTIFY_REG);
	$setup(posedge D2,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D2,0.0, NOTIFY_REG);
	$setup(posedge D3,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D3,0.0, NOTIFY_REG);
	$setup(negedge D0,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D0,0.0, NOTIFY_REG);
	$setup(negedge S0,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge S0,0.0, NOTIFY_REG);
	$setup(negedge D1,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D1,0.0, NOTIFY_REG);
	$setup(negedge S1,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge S1,0.0, NOTIFY_REG);
	$setup(negedge D2,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D2,0.0, NOTIFY_REG);
	$setup(negedge D3,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D3,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLM4
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, D=!S10 & (!S11 & (!S0 & D0 + S0 & D1) + S11 & (!S0 & D2 + S0 & D3)) + S10 & (S11 & (!S0 & D2 + S0 & D3) + !S11 & (!S0 & D2 + S0 & D3)) ];
-----------------------------------------------------------------*/

module DLM4(G, Q,S10,S11,S0,D0,D1,D2,D3);
 input S10,S11,S0,D0,D1,D2,D3,G;
 output Q;
 wire NET_0_0,NET_0_1,NET_0_2,NET_0_3,NET_0_4,NET_0_5,NET_0_6,NET_0_7,NET_0_8,NET_0_9,NET_0_10,NET_0_11,NET_0_12,NET_0_13,NET_0_14,NET_0_15,NET_0_16,NET_0_17,NET_0_18,NET_0_19;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_156(S10_, S10);
 not	INV_157(S11_, S11);
 not	INV_158(S0_, S0);
 UDP_MUX2   U1089(NET_0_2, D0, D1, S0_);
 UDP_MUX2   U1091(NET_0_8, NET_0_2, NET_0_6, S11_);
 UDP_MUX2   U1094(NET_0_6, D2, D3, S0_);
 UDP_MUX2   U1096(NET_0_20, NET_0_8, NET_0_18, S10_);
 UDP_MUX2   U1100(NET_0_12, D2, D3, S0_);
 UDP_MUX2   U1102(NET_0_18, NET_0_12, NET_0_16, S11);
 UDP_MUX2   U1105(NET_0_16, D2, D3, S0_);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, NET_0_20, G_, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, G);
	buf U_c3 (Enable4, G);
	buf U_c5 (Enable6, G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$S10 = 0.0;
	specparam    InputLoad$S11 = 0.0;
	specparam    InputLoad$S0 = 0.0;
	specparam    InputLoad$D0 = 0.0;
	specparam    InputLoad$D1 = 0.0;
	specparam    InputLoad$D2 = 0.0;
	specparam    InputLoad$D3 = 0.0;
        specparam    tpdLH_S10_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S10_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S11_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S11_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S0_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S0_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D0_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D0_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D1_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D1_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D2_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D2_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D3_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D3_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G )
        (S10 => Q) = (tpdLH_S10_to_Q, tpdHL_S10_to_Q);
	if(G )
        (S11 => Q) = (tpdLH_S11_to_Q, tpdHL_S11_to_Q);
	if(G )
        (S0 => Q) = (tpdLH_S0_to_Q, tpdHL_S0_to_Q);
	if(G )
        (D0 => Q) = (tpdLH_D0_to_Q, tpdHL_D0_to_Q);
	if(G )
        (D1 => Q) = (tpdLH_D1_to_Q, tpdHL_D1_to_Q);
	if(G )
        (D2 => Q) = (tpdLH_D2_to_Q, tpdHL_D2_to_Q);
	if(G )
        (D3 => Q) = (tpdLH_D3_to_Q, tpdHL_D3_to_Q);

	(posedge G => (Q+:Q))=(tpdLH_G_to_Q, tpdHL_G_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S10,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge S10,0.0, NOTIFY_REG);
	$setup(posedge S11,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge S11,0.0, NOTIFY_REG);
	$setup(posedge S0,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge S0,0.0, NOTIFY_REG);
	$setup(posedge D0,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D0,0.0, NOTIFY_REG);
	$setup(posedge D1,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D1,0.0, NOTIFY_REG);
	$setup(posedge D2,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D2,0.0, NOTIFY_REG);
	$setup(posedge D3,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, posedge D3,0.0, NOTIFY_REG);
	$setup(negedge S10,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge S10,0.0, NOTIFY_REG);
	$setup(negedge S11,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge S11,0.0, NOTIFY_REG);
	$setup(negedge S0,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge S0,0.0, NOTIFY_REG);
	$setup(negedge D0,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D0,0.0, NOTIFY_REG);
	$setup(negedge D1,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D1,0.0, NOTIFY_REG);
	$setup(negedge D2,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D2,0.0, NOTIFY_REG);
	$setup(negedge D3,negedge G, 0.0, NOTIFY_REG);
	$hold(negedge G, negedge D3,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLM4A
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, D=!S10 & (!S11 & (!S0 & D0 + S0 & D1) + S11 & (!S0 & D2 + S0 & D3)) + S10 & (S11 & (!S0 & D2 + S0 & D3) + !S11 & (!S0 & D2 + S0 & D3)) ];
-----------------------------------------------------------------*/

module DLM4A(G, Q,S10,S11,S0,D0,D1,D2,D3);
 input S10,S11,S0,D0,D1,D2,D3,G;
 output Q;
 wire NET_0_0,NET_0_1,NET_0_2,NET_0_3,NET_0_4,NET_0_5,NET_0_6,NET_0_7,NET_0_8,NET_0_9,NET_0_10,NET_0_11,NET_0_12,NET_0_13,NET_0_14,NET_0_15,NET_0_16,NET_0_17,NET_0_18,NET_0_19;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_159(S10_, S10);
 not	INV_160(S11_, S11);
 not	INV_161(S0_, S0);
 UDP_MUX2   U1111(NET_0_2, D0, D1, S0_);
 UDP_MUX2   U1113(NET_0_8, NET_0_2, NET_0_6, S11_);
 UDP_MUX2   U1116(NET_0_6, D2, D3, S0_);
 UDP_MUX2   U1118(NET_0_20, NET_0_8, NET_0_18, S10_);
 UDP_MUX2   U1122(NET_0_12, D2, D3, S0_);
 UDP_MUX2   U1124(NET_0_18, NET_0_12, NET_0_16, S11);
 UDP_MUX2   U1127(NET_0_16, D2, D3, S0_);
 DL2C_UDP DL_U0(Q, NET_0_20, G, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	buf U_c1 (Enable2, _G);
	buf U_c3 (Enable4, _G);
	buf U_c5 (Enable6, _G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$S10 = 0.0;
	specparam    InputLoad$S11 = 0.0;
	specparam    InputLoad$S0 = 0.0;
	specparam    InputLoad$D0 = 0.0;
	specparam    InputLoad$D1 = 0.0;
	specparam    InputLoad$D2 = 0.0;
	specparam    InputLoad$D3 = 0.0;
        specparam    tpdLH_S10_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S10_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S11_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S11_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S0_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S0_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D0_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D0_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D1_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D1_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D2_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D2_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_D3_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D3_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G )
        (S10 => Q) = (tpdLH_S10_to_Q, tpdHL_S10_to_Q);
	if(!G )
        (S11 => Q) = (tpdLH_S11_to_Q, tpdHL_S11_to_Q);
	if(!G )
        (S0 => Q) = (tpdLH_S0_to_Q, tpdHL_S0_to_Q);
	if(!G )
        (D0 => Q) = (tpdLH_D0_to_Q, tpdHL_D0_to_Q);
	if(!G )
        (D1 => Q) = (tpdLH_D1_to_Q, tpdHL_D1_to_Q);
	if(!G )
        (D2 => Q) = (tpdLH_D2_to_Q, tpdHL_D2_to_Q);
	if(!G )
        (D3 => Q) = (tpdLH_D3_to_Q, tpdHL_D3_to_Q);

	(negedge G => (Q+:Q))=(tpdLH_G_to_Q, tpdHL_G_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S10,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge S10,0.0, NOTIFY_REG);
	$setup(posedge S11,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge S11,0.0, NOTIFY_REG);
	$setup(posedge S0,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge S0,0.0, NOTIFY_REG);
	$setup(posedge D0,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D0,0.0, NOTIFY_REG);
	$setup(posedge D1,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D1,0.0, NOTIFY_REG);
	$setup(posedge D2,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D2,0.0, NOTIFY_REG);
	$setup(posedge D3,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge D3,0.0, NOTIFY_REG);
	$setup(negedge S10,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge S10,0.0, NOTIFY_REG);
	$setup(negedge S11,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge S11,0.0, NOTIFY_REG);
	$setup(negedge S0,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge S0,0.0, NOTIFY_REG);
	$setup(negedge D0,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D0,0.0, NOTIFY_REG);
	$setup(negedge D1,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D1,0.0, NOTIFY_REG);
	$setup(negedge D2,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D2,0.0, NOTIFY_REG);
	$setup(negedge D3,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge D3,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLMA
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, D=A & !S + B & S ];
-----------------------------------------------------------------*/

module DLMA(G, Q,A,S,B);
 input A,S,B,G;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_162(S_, S);
 UDP_MUX2   U1131(NET_0_2, A, B, S_);
 DL2C_UDP DL_U0(Q, NET_0_2, G, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	buf U_c1 (Enable2, _G);
	buf U_c3 (Enable4, _G);
	buf U_c5 (Enable6, _G);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$A = 0.0;
	specparam    InputLoad$S = 0.0;
	specparam    InputLoad$B = 0.0;
        specparam    tpdLH_A_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_A_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_S_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_S_to_Q = (0.1:0.1:0.1);
        specparam    tpdLH_B_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_B_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G )
        (A => Q) = (tpdLH_A_to_Q, tpdHL_A_to_Q);
	if(!G )
        (S => Q) = (tpdLH_S_to_Q, tpdHL_S_to_Q);
	if(!G )
        (B => Q) = (tpdLH_B_to_Q, tpdHL_B_to_Q);

	(negedge G => (Q+:Q))=(tpdLH_G_to_Q, tpdHL_G_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge A,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge A,0.0, NOTIFY_REG);
	$setup(posedge S,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge S,0.0, NOTIFY_REG);
	$setup(posedge B,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, posedge B,0.0, NOTIFY_REG);
	$setup(negedge A,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge A,0.0, NOTIFY_REG);
	$setup(negedge S,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge S,0.0, NOTIFY_REG);
	$setup(negedge B,posedge G, 0.0, NOTIFY_REG);
	$hold(posedge G, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLME1A
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _E=E, D=A & !S + B & S ];
-----------------------------------------------------------------*/

module DLME1A ( E, G, Q, A, S, B );

  input   A, S, B, E, G;
  output  Q;
  wire    NET_0_0, NET_0_1;
  supply1 VCC;
  supply0 GND;
  reg     NOTIFY_REG;
 
  not       INV_163 ( S_, S );
  UDP_MUX2  U1135 ( NET_0_2, A, B, S_ );
  not       INV_EN ( E_, E );
  DLE3B_UDP DL_U0 ( Q, NET_0_2, G, E, GND, NOTIFY_REG );

  // some temp signals created for timing checking sections

  not U_I0 ( _G, G );
  not U_I3 ( _E, E );
  buf U_c0 ( Enable1, _E );
  buf U_c1 ( Enable2, _G );
  buf U_c2 ( Enable3, _E );
  buf U_c3 ( Enable4, _G );
  buf U_c4 ( Enable5, _E );
  buf U_c5 ( Enable6, _G );

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	  ="AXCELERATOR";
	specparam    macroType    ="seq_dlatch";
	specparam    InputLoad$G  = 0.0;
	specparam    InputLoad$A  = 0.0;
	specparam    InputLoad$S  = 0.0;
	specparam    InputLoad$B  = 0.0;
        specparam    tpdLH_A_to_Q = ( 0.1 : 0.1 : 0.1 );
        specparam    tpdHL_A_to_Q = ( 0.1 : 0.1 : 0.1 );
        specparam    tpdLH_S_to_Q = ( 0.1 : 0.1 : 0.1 );
        specparam    tpdHL_S_to_Q = ( 0.1 : 0.1 : 0.1 );
        specparam    tpdLH_B_to_Q = ( 0.1 : 0.1 : 0.1 );
        specparam    tpdHL_B_to_Q = ( 0.1 : 0.1 : 0.1 );
	specparam    tpdLH_G_to_Q = ( 0.1 : 0.1 : 0.1 );
	specparam    tpdHL_G_to_Q = ( 0.1 : 0.1 : 0.1 );
	specparam    tpdLH_E_to_Q = ( 0.1 : 0.1 : 0.1 );
	specparam    tpdHL_E_to_Q = ( 0.1 : 0.1 : 0.1 );

        //check timing delay for output



	if ( !G && !E )
          ( A => Q ) = ( tpdLH_A_to_Q, tpdHL_A_to_Q );
	if ( !G && !E )
          ( S => Q ) = ( tpdLH_S_to_Q, tpdHL_S_to_Q );
	if ( !G && !E )
          ( B => Q ) = ( tpdLH_B_to_Q, tpdHL_B_to_Q );

	if ( Enable1 )
	  ( negedge G => ( Q +:Q )) = ( tpdLH_G_to_Q, tpdHL_G_to_Q );
	if ( !G )
	  ( negedge E => ( Q +:Q )) = ( tpdLH_E_to_Q, tpdHL_E_to_Q );

	//checking setup and hold timing for inputs

	$setup ( posedge A , posedge G &&& Enable1, 0.0, NOTIFY_REG );
	$hold  ( posedge G &&& Enable1, posedge A, 0.0, NOTIFY_REG );
	$setup ( posedge S , posedge G &&& Enable1, 0.0, NOTIFY_REG );
	$hold  ( posedge G &&& Enable1, posedge S, 0.0, NOTIFY_REG );
	$setup ( posedge B , posedge G &&& Enable1, 0.0, NOTIFY_REG );
	$hold  ( posedge G &&& Enable1, posedge B, 0.0, NOTIFY_REG );
	$setup ( negedge A , posedge G &&& Enable1, 0.0, NOTIFY_REG );
	$hold  ( posedge G &&& Enable1, negedge A, 0.0, NOTIFY_REG );
	$setup ( negedge S , posedge G &&& Enable1, 0.0, NOTIFY_REG );
	$hold  ( posedge G &&& Enable1, negedge S, 0.0, NOTIFY_REG );
	$setup ( negedge B , posedge G &&& Enable1, 0.0, NOTIFY_REG );
	$hold  ( posedge G &&& Enable1, negedge B, 0.0, NOTIFY_REG );

	// setup/hold check for the E to G

	$setup ( negedge E, negedge G, 0.0, NOTIFY_REG );
	$hold  ( posedge G, posedge E, 0.0, NOTIFY_REG );

	// check signal width

	$width ( negedge G &&& Enable1, 0.0, 0, NOTIFY_REG );


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLP1
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLP1(PRE, G, Q,D);
 input D,PRE,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, GND, PRE, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,_PRE);
	and U_c1 (Enable2, G, _PRE);
	buf U_c3 (Enable4, G);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, G, _PRE);
	buf U_c6 (Enable7, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G && !PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if(G )
	(negedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLP1A
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLP1A(PRE, G, Q,D);
 input D,PRE,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 DL2C_UDP DL_U0(Q, D, G, GND, PRE, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,_PRE);
	and U_c1 (Enable2, _G, _PRE);
	buf U_c3 (Enable4, _G);
	buf U_c4 (Enable5, _PRE);
	and U_c5 (Enable6, _G, _PRE);
	buf U_c6 (Enable7, _PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && !PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(posedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if(!G )
	(negedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (negedge PRE, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, negedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLP1B
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =G, _PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLP1B(PRE, G, Q,D);
 input D,PRE,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(Q, D, G_, GND, PRE_, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,PRE);	and U_c1 (Enable2, G, PRE);
	buf U_c3 (Enable4, G);
	buf U_c4 (Enable5, PRE);
	and U_c5 (Enable6, G, PRE);
	buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(G && PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if(G )
       (posedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  PRE, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, posedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLP1C
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=G, _PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLP1C(PRE, G, Q,D);
 input D,PRE,G;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 DL2C_UDP DL_U0(Q, D, G, GND, PRE_, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,PRE);	and U_c1 (Enable2, _G, PRE);
	buf U_c3 (Enable4, _G);
	buf U_c4 (Enable5, PRE);
	and U_c5 (Enable6, _G, PRE);
	buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && PRE )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge G => (Q+:D))=(tpdLH_G_to_Q, tpdHL_G_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);
       if(!G )
       (posedge PRE => (Q+:D)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  PRE, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, posedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLP1D
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, CLK =G, _PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLP1D(PRE, G, QN,D);
 input D,PRE,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 not INV_CLK(G_, G);
 DL2C_UDP DL_U0(QN_, D, G_, GND, PRE_, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,PRE);	and U_c1 (Enable2, G, PRE);
	buf U_c3 (Enable4, G);
	buf U_c4 (Enable5, PRE);
	and U_c5 (Enable6, G, PRE);
	buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if(G && PRE )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if(Enable1)
	(posedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(negedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);
       if(G )
       (posedge PRE => (QN+:D)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  PRE, negedge G, 0.0, NOTIFY_REG);
	$hold (negedge G, posedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : DLP1E
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QN, _CLK=G, _PRE=PRE, D=D ];
-----------------------------------------------------------------*/

module DLP1E(PRE, G, QN,D);
 input D,PRE,G;
 output QN;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(PRE_, PRE);
 DL2C_UDP DL_U0(QN_, D, G, GND, PRE_, NOTIFY_REG);
  not INV_Q(QN, QN_);

// some temp signals created for timing checking sections

	not U_I0 (_G, G);
	not U_I1 (_PRE, PRE);
	buf U_c0 (Enable1,PRE);	and U_c1 (Enable2, _G, PRE);
	buf U_c3 (Enable4, _G);
	buf U_c4 (Enable5, PRE);
	and U_c5 (Enable6, _G, PRE);
	buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="AXCELERATOR";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$G = 0.0;
	specparam    InputLoad$PRE = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QN = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_G_to_QN = (0.1:0.1:0.1);
	specparam    tpdLH_PRE_to_QN = (0.1:0.1:0.1);
	specparam    tpdHL_PRE_to_QN = (0.1:0.1:0.1);

        //check timing delay for output



	if(!G && PRE )
        (D => QN) = (tpdLH_D_to_QN, tpdHL_D_to_QN);

	if(Enable1)
	(negedge G => (QN+:D))=(tpdLH_G_to_QN, tpdHL_G_to_QN);
	(negedge PRE => (QN +: 1'b1)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);
       if(!G )
       (posedge PRE => (QN+:D)) = (tpdLH_PRE_to_QN, tpdHL_PRE_to_QN);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge G &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge G &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge G &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	$recovery (posedge  PRE, posedge G, 0.0, NOTIFY_REG);
	$hold (posedge G, posedge PRE, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : FA1
 CELL TYPE : comb
 CELL LOGIC : S = A ^ B ^ CI ; CO =A & B + A & CI + B & CI
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FA1(S,CO,A,B,CI);
 input A,B,CI;
 output S,CO;
 wire NET_0_0;
 wire NET_1_0, NET_1_1, NET_1_2, NET_1_3;

 not	INV_164(A_, A);
 not	INV_165(B_, B);
 UDP_MUX2   U1140(NET_0_0, B, B_, A_);
 xor      U1142(S, NET_0_0, CI);
 not	INV_166(A_, A);
 not	INV_167(B_, B);
 and      U1147(NET_1_0, A, B);
 or       U1148(NET_1_2, NET_1_0, NET_1_1);
 and      U1150(NET_1_1, A, CI);
 or       U1151(CO, NET_1_2, NET_1_3);
 and      U1153(NET_1_3, B, CI);

       specify

		specparam tpdLH_A_to_S = (0.1:0.1:0.1);
		specparam tpdHL_A_to_S = (0.1:0.1:0.1);
		specparam tpdLH_B_to_S = (0.1:0.1:0.1);
		specparam tpdHL_B_to_S = (0.1:0.1:0.1);
		specparam tpdLH_CI_to_S = (0.1:0.1:0.1);
		specparam tpdHL_CI_to_S = (0.1:0.1:0.1);
		specparam tpdLH_A_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_CO = (0.1:0.1:0.1);
		specparam tpdLH_B_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_B_to_CO = (0.1:0.1:0.1);
		specparam tpdLH_CI_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_CI_to_CO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => S ) = ( tpdLH_A_to_S, tpdHL_A_to_S );
		(B => S ) = ( tpdLH_B_to_S, tpdHL_B_to_S );
		(CI => S ) = ( tpdLH_CI_to_S, tpdHL_CI_to_S );
		(A => CO ) = ( tpdLH_A_to_CO, tpdHL_A_to_CO );
		(B => CO ) = ( tpdLH_B_to_CO, tpdHL_B_to_CO );
		(CI => CO ) = ( tpdLH_CI_to_CO, tpdHL_CI_to_CO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : FCEND_BUFF
 CELL TYPE : comb
 CELL LOGIC : CO = FCI
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FCEND_BUFF(CO,FCI);
 input FCI;
 output CO;

 buf	BUF_U_00(CO,FCI);

       specify

		specparam tpdLH_FCI_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_FCI_to_CO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(FCI => CO ) = ( tpdLH_FCI_to_CO, tpdHL_FCI_to_CO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : FCEND_INV
 CELL TYPE : comb
 CELL LOGIC : CO = !FCI
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FCEND_INV(CO,FCI);
 input FCI;
 output CO;

 not	INV_U_00(CO,FCI);

       specify

		specparam tpdLH_FCI_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_FCI_to_CO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(FCI => CO ) = ( tpdLH_FCI_to_CO, tpdHL_FCI_to_CO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : FCINIT_BUFF
 CELL TYPE : comb
 CELL LOGIC : FCO = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FCINIT_BUFF(FCO,A);
 input A;
 output FCO;

 buf	BUF_U_00(FCO,A);

       specify

		specparam tpdLH_A_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_FCO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => FCO ) = ( tpdLH_A_to_FCO, tpdHL_A_to_FCO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : FCINIT_GND
 CELL TYPE : comb
 CELL LOGIC : FCO = 0
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FCINIT_GND(FCO);
 output FCO;

 supply0	FCO;

       specify

		specparam MacroType = "comb";

		//pin to pin path delay 

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : FCINIT_INV
 CELL TYPE : comb
 CELL LOGIC : FCO = !A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FCINIT_INV(FCO,A);
 input A;
 output FCO;

 not	INV_U_00(FCO,A);

       specify

		specparam tpdLH_A_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_FCO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => FCO ) = ( tpdLH_A_to_FCO, tpdHL_A_to_FCO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : FCINIT_VCC
 CELL TYPE : comb
 CELL LOGIC : FCO = 1
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FCINIT_VCC(FCO);
 output FCO;

 supply1    FCO;

       specify

		specparam MacroType = "comb";

		//pin to pin path delay 

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GAND2
 CELL TYPE : comb
 CELL LOGIC : Y = A & G
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GAND2(Y,A,G);
 input A,G;
 output Y;

 and      U1156(Y, A, G);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_G_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_G_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(G => Y ) = ( tpdLH_G_to_Y, tpdHL_G_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GMX4
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !S0 + D1 & S0) & !G + (D2 & !S0 + D3 & S0) & G
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GMX4(Y,D0,S0,D1,G,D2,D3);
 input D0,S0,D1,G,D2,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7;

 not	INV_168(S0_, S0);
 not	INV_169(G_, G);
 UDP_MUX2   U1160(NET_0_2, D0, D1, S0_);
 UDP_MUX2   U1162(Y, NET_0_2, NET_0_6, G_);
 UDP_MUX2   U1165(NET_0_6, D2, D3, S0_);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_G_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_G_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S0 => Y ) = ( tpdLH_S0_to_Y, tpdHL_S0_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(G => Y ) = ( tpdLH_G_to_Y, tpdHL_G_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GNAND2
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & G)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GNAND2(Y,A,G);
 input A,G;
 output Y;

 nand     U1169(Y, A, G);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_G_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_G_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(G => Y ) = ( tpdLH_G_to_Y, tpdHL_G_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GND
 CELL TYPE : comb
 CELL LOGIC : Y=0
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GND(Y);
 output Y;

 supply0	Y;

       specify

		specparam MacroType = "comb";

		//pin to pin path delay 

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GNOR2
 CELL TYPE : comb
 CELL LOGIC : Y = !(A + G)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GNOR2(Y,A,G);
 input A,G;
 output Y;

 nor      U1172(Y, A, G);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_G_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_G_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(G => Y ) = ( tpdLH_G_to_Y, tpdHL_G_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GOR2
 CELL TYPE : comb
 CELL LOGIC : Y = A + G
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GOR2(Y,A,G);
 input A,G;
 output Y;

 or       U1175(Y, A, G);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_G_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_G_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(G => Y ) = ( tpdLH_G_to_Y, tpdHL_G_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GXOR2
 CELL TYPE : comb
 CELL LOGIC : Y = A ^ G
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GXOR2(Y,A,G);
 input A,G;
 output Y;

 not	INV_170(A_, A);
 not	INV_171(G_, G);
 UDP_MUX2   U1178(Y, G, G_, A_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_G_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_G_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(G => Y ) = ( tpdLH_G_to_Y, tpdHL_G_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HA1
 CELL TYPE : comb
 CELL LOGIC : S=A ^ B ; CO = A & B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HA1(S,CO,A,B);
 input A,B;
 output S,CO;

 not	INV_172(A_, A);
 not	INV_173(B_, B);
 UDP_MUX2   U1182(S, B, B_, A_);
 not	INV_174(A_, A);
 not	INV_175(B_, B);
 and      U1186(CO, A, B);

       specify

		specparam tpdLH_A_to_S = (0.1:0.1:0.1);
		specparam tpdHL_A_to_S = (0.1:0.1:0.1);
		specparam tpdLH_B_to_S = (0.1:0.1:0.1);
		specparam tpdHL_B_to_S = (0.1:0.1:0.1);
		specparam tpdLH_A_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_CO = (0.1:0.1:0.1);
		specparam tpdLH_B_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_B_to_CO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => S ) = ( tpdLH_A_to_S, tpdHL_A_to_S );
		(B => S ) = ( tpdLH_B_to_S, tpdHL_B_to_S );
		(A => CO ) = ( tpdLH_A_to_CO, tpdHL_A_to_CO );
		(B => CO ) = ( tpdLH_B_to_CO, tpdHL_B_to_CO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HA1A
 CELL TYPE : comb
 CELL LOGIC : S=!A ^ B ; CO = !A & B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HA1A(S,CO,A,B);
 input A,B;
 output S,CO;

 not	INV_176(A_, A);
 not	INV_177(B_, B);
 UDP_MUX2   U1189(S, B, B_, A);
 not	INV_178(A_, A);
 not	INV_179(B_, B);
 and      U1193(CO, A_, B);

       specify

		specparam tpdLH_A_to_S = (0.1:0.1:0.1);
		specparam tpdHL_A_to_S = (0.1:0.1:0.1);
		specparam tpdLH_B_to_S = (0.1:0.1:0.1);
		specparam tpdHL_B_to_S = (0.1:0.1:0.1);
		specparam tpdLH_A_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_CO = (0.1:0.1:0.1);
		specparam tpdLH_B_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_B_to_CO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => S ) = ( tpdLH_A_to_S, tpdHL_A_to_S );
		(B => S ) = ( tpdLH_B_to_S, tpdHL_B_to_S );
		(A => CO ) = ( tpdLH_A_to_CO, tpdHL_A_to_CO );
		(B => CO ) = ( tpdLH_B_to_CO, tpdHL_B_to_CO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HA1B
 CELL TYPE : comb
 CELL LOGIC : S=!(A ^ B) ; CO = !(A & B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HA1B(S,CO,A,B);
 input A,B;
 output S,CO;

 not	INV_180(A_, A);
 not	INV_181(B_, B);
 UDPN_MUX2  U1196(S, B, B_, A_);
 not	INV_182(A_, A);
 not	INV_183(B_, B);
 nand     U1200(CO, A, B);

       specify

		specparam tpdLH_A_to_S = (0.1:0.1:0.1);
		specparam tpdHL_A_to_S = (0.1:0.1:0.1);
		specparam tpdLH_B_to_S = (0.1:0.1:0.1);
		specparam tpdHL_B_to_S = (0.1:0.1:0.1);
		specparam tpdLH_A_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_CO = (0.1:0.1:0.1);
		specparam tpdLH_B_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_B_to_CO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => S ) = ( tpdLH_A_to_S, tpdHL_A_to_S );
		(B => S ) = ( tpdLH_B_to_S, tpdHL_B_to_S );
		(A => CO ) = ( tpdLH_A_to_CO, tpdHL_A_to_CO );
		(B => CO ) = ( tpdLH_B_to_CO, tpdHL_B_to_CO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HA1C
 CELL TYPE : comb
 CELL LOGIC : S= A^B ; CO=!(A & B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HA1C(S,CO,A,B);
 input A,B;
 output S,CO;

 not	INV_184(A_, A);
 not	INV_185(B_, B);
 UDP_MUX2   U1203(S, B, B_, A_);
 not	INV_186(A_, A);
 not	INV_187(B_, B);
 nand     U1207(CO, A, B);

       specify

		specparam tpdLH_A_to_S = (0.1:0.1:0.1);
		specparam tpdHL_A_to_S = (0.1:0.1:0.1);
		specparam tpdLH_B_to_S = (0.1:0.1:0.1);
		specparam tpdHL_B_to_S = (0.1:0.1:0.1);
		specparam tpdLH_A_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_CO = (0.1:0.1:0.1);
		specparam tpdLH_B_to_CO = (0.1:0.1:0.1);
		specparam tpdHL_B_to_CO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => S ) = ( tpdLH_A_to_S, tpdHL_A_to_S );
		(B => S ) = ( tpdLH_B_to_S, tpdHL_B_to_S );
		(A => CO ) = ( tpdLH_A_to_CO, tpdHL_A_to_CO );
		(B => CO ) = ( tpdLH_B_to_CO, tpdHL_B_to_CO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : HCLKBIBUF
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBIBUF(PAD, D, E, Y);
 inout PAD;
 input D, E;
 output Y;

 bufif1   U1567(PAD, D, E);
 buf    BUF_U_01(Y, PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
                specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
                specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
                specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
                specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

            //if(~D)
                (E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

                (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
                (D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                (E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                (PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_LVCMOS25(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_LVCMOS18(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_LVCMOS15(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_PCI
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_PCI(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_PCIX
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_PCIX(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_GTLP33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_GTLP33(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_GTLP25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_GTLP25(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_HSTL_I
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_HSTL_I(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_SSTL3_I
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_SSTL3_I(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_SSTL3_II
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_SSTL3_II(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_SSTL2_I
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_SSTL2_I(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKBUF_SSTL2_II
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_SSTL2_II(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKINT
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKINT(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS25(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS25D
 CELL TYPE : comb
 CELL LOGIC : Y#Down=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS25D(Y,PAD);
 input PAD;
 output Y;

 pulldown	DN(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS25U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS25U(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS18(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS18D
 CELL TYPE : comb
 CELL LOGIC : Y#Down=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS18D(Y,PAD);
 input PAD;
 output Y;

 pulldown	DN(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS18U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS18U(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS15(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS15D
 CELL TYPE : comb
 CELL LOGIC : Y#Down=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS15D(Y,PAD);
 input PAD;
 output Y;

 pulldown	DN(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_LVCMOS15U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVCMOS15U(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_PCI
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_PCI(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_PCIX
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_PCIX(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_GTLP33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_GTLP33(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_GTLP25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_GTLP25(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_HSTL_I
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_HSTL_I(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_SSTL3_I
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_SSTL3_I(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_SSTL3_II
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_SSTL3_II(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_SSTL2_I
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_SSTL2_I(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INBUF_SSTL2_II
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_SSTL2_II(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INV
 CELL TYPE : comb
 CELL LOGIC : Y = !A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INV(Y,A);
 input A;
 output Y;

 not	INV_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INVA
 CELL TYPE : comb
 CELL LOGIC : Y = !A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INVA(Y,A);
 input A;
 output Y;

 not	INV_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INVD
 CELL TYPE : comb
 CELL LOGIC : Y=!A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INVD(Y,A);
 input A;
 output Y;

 not	INV_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOI_DFEG
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _CLR=CLR, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOI_DFEG(PRE, CLR, E, CLK, Q,D);
 input D,PRE,CLR,E,CLK;
 output Q;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : IOI_DFEH
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _CLR=CLR, _PRE=PRE, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOI_DFEH(PRE, CLR, E, CLK, Q,D);
 input D,PRE,CLR,E,CLK;
 output Q;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOI_BUFF
 CELL TYPE : comb
 CELL LOGIC : Y = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOI_BUFF(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_BUFF
 CELL TYPE : comb
 CELL LOGIC : Y = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_BUFF(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_DFEG
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_DFEG(Q,YOUT,D,CLK,CLR,E,PRE);
 input D,CLK,CLR,E,PRE;
 output Q,YOUT;



 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,CLR, PRE, E, NOTIFY_REG);


 Dffpr DF_1(YOUT, D,CLK,CLR, PRE, E, NOTIFY_REG);

 
  // some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

	specparam   tpdLH_CLK_to_YOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_YOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_YOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_YOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_YOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_YOUT = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);




	//check timing delay for output

	(posedge CLK => (YOUT +: D))=(tpdLH_CLK_to_YOUT, tpdHL_CLK_to_YOUT);
	(negedge CLR => (YOUT +: 1'b0)) = (tpdLH_CLR_to_YOUT, tpdHL_CLR_to_YOUT);
	(negedge PRE => (YOUT +: 1'b1)) = (tpdLH_PRE_to_YOUT, tpdHL_PRE_to_YOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_DFEH
 CELL TYPE : multi
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_DFEH(Q,YOUT,D,CLK,CLR,E,PRE);
 input D,CLK,CLR,E,PRE;
 output Q,YOUT;



 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,CLR, PRE, E, NOTIFY_REG);


 Dffpf DF_1(YOUT, D,CLK,CLR, PRE, E, NOTIFY_REG);


 // some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

	specparam   tpdLH_CLK_to_YOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_YOUT = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_YOUT = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_YOUT = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_YOUT = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_YOUT = (0.1:0.1:0.1);

		specparam MacroType = "multi";



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);




	//check timing delay for output

	(negedge CLK => (YOUT +: D))=(tpdLH_CLK_to_YOUT, tpdHL_CLK_to_YOUT);
	(negedge CLR => (YOUT +: 1'b0)) = (tpdLH_CLR_to_YOUT, tpdHL_CLR_to_YOUT);
	(negedge PRE => (YOUT +: 1'b1)) = (tpdLH_PRE_to_YOUT, tpdHL_PRE_to_YOUT);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_IN
 CELL TYPE : comb
 CELL LOGIC : Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_IN(Y,PAD);
 input PAD;
 output Y;

 reg NOTIFY_REG;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_TRI
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_TRI(PAD,D,E);
 input D,E;
 output PAD;

 reg NOTIFY_REG;

 bufif1   U1210(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_BI
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_BI(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 reg NOTIFY_REG;

 bufif1   U1213(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                specparam PATHPULSE$D$Y = (0.1, 0.1);
                specparam PATHPULSE$E$Y = (0.1, 0.1);
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : JKF
 CELL TYPE : sequential Logic
 CELL SEQ EQN: JKFF[Q=Q,CLK =CLK, J=J,k=!K];
-----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module JKF(CLK, Q,J,K);
 input J,K,CLK;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_188(K_, K);

 JKFFR JK_U0(Q, J,K,CLK,VCC,VCC, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   libname	="AXCELERATOR";
	specparam   InputLoad$CLK = 0.0;
	specparam   InputLoad$J = 0.0;
	specparam   InputLoad$K = 0.0;

        // checking timing path for combinatorial output

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);

	//check timing delay for output




        //check timing delay for output

	if(J == K)
	(posedge CLK => (Q +:J))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	if(J&& !K)
	(posedge CLK => (Q +: ~Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge J,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge J,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge J,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge J,0.0, NOTIFY_REG);
	$setup(posedge K,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge K,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge K,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge K,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checking the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : JKF1B
 CELL TYPE : sequential Logic
 CELL SEQ EQN: JKFF[Q=Q,_CLK=CLK, J=J,k=!K];
-----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module JKF1B(CLK, Q,J,K);
 input J,K,CLK;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_189(K_, K);

 JKFFF JK_U0(Q, J,K,CLK,VCC,VCC, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   libname	="AXCELERATOR";
	specparam   InputLoad$CLK = 0.0;
	specparam   InputLoad$J = 0.0;
	specparam   InputLoad$K = 0.0;

        // checking timing path for combinatorial output

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);

	//check timing delay for output




        //check timing delay for output

	if(J == K)
	(negedge CLK => (Q +:J))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	if(J&& !K)
	(negedge CLK => (Q +: ~Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge J,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge J,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge J,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge J,0.0, NOTIFY_REG);
	$setup(posedge K,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge K,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge K,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge K,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checking the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : JKF2A
 CELL TYPE : sequential Logic
 CELL SEQ EQN: JKFF[Q=Q,CLK =CLK, _CLR=CLR, J=J,k=!K];
-----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module JKF2A(CLR, CLK, Q,J,K);
 input J,K,CLR,CLK;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_190(K_, K);

 JKFFR JK_U0(Q, J,K,CLK,CLR,VCC, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I3 (_CLR, CLR);
      buf U_c0 (Enable1,CLR);
      buf U_c2 (Enable2, CLR);
      buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   libname	="AXCELERATOR";
	specparam   InputLoad$CLK = 0.0;
	specparam   InputLoad$J = 0.0;
	specparam   InputLoad$K = 0.0;

        // checking timing path for combinatorial output

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
        specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
        specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);

	//check timing delay for output




        //check timing delay for output

	if(J == K)
	(posedge CLK => (Q +:J))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	if(J&& !K)
	(posedge CLK => (Q +: ~Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge J,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge J,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge J,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge J,0.0, NOTIFY_REG);
	$setup(posedge K,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge K,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge K,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge K,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable7,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable7, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checking the recovery data

	$recovery(posedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : JKF2B
 CELL TYPE : sequential Logic
 CELL SEQ EQN: JKFF[Q=Q,_CLK=CLK, _CLR=CLR, J=J,k=!K];
-----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module JKF2B(CLR, CLK, Q,J,K);
 input J,K,CLR,CLK;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_191(K_, K);

 JKFFF JK_U0(Q, J,K,CLK,CLR,VCC, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I3 (_CLR, CLR);
      buf U_c0 (Enable1,CLR);
      buf U_c2 (Enable2, CLR);
      buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   libname	="AXCELERATOR";
	specparam   InputLoad$CLK = 0.0;
	specparam   InputLoad$J = 0.0;
	specparam   InputLoad$K = 0.0;

        // checking timing path for combinatorial output

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
        specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
        specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);

	//check timing delay for output




        //check timing delay for output

	if(J == K)
	(negedge CLK => (Q +:J))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	if(J&& !K)
	(negedge CLK => (Q +: ~Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge J,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge J,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge J,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge J,0.0, NOTIFY_REG);
	$setup(posedge K,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge K,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge K,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge K,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK,posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable7,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable7, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checking the recovery data

	$recovery(posedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : JKF3A
 CELL TYPE : sequential Logic
 CELL SEQ EQN: JKFF[Q=Q,CLK =CLK, _PRE=PRE, J=J,k=!K];
-----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module JKF3A(PRE, CLK, Q,J,K);
 input J,K,PRE,CLK;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_192(K_, K);

 JKFFR JK_U0(Q, J,K,CLK,VCC,PRE, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      buf U_c0 (Enable1,PRE);      buf U_c4 (Enable5, PRE);
      buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   libname	="AXCELERATOR";
	specparam   InputLoad$CLK = 0.0;
	specparam   InputLoad$PRE = 0.0;
	specparam   InputLoad$J = 0.0;
	specparam   InputLoad$K = 0.0;

        // checking timing path for combinatorial output

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
        specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
        specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

	//check timing delay for output




        //check timing delay for output

	if(J == K)
	(posedge CLK => (Q +:J))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	if(J&& !K)
	(posedge CLK => (Q +: ~Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge J,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge J,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge J,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge J,0.0, NOTIFY_REG);
	$setup(posedge K,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge K,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge K,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge K,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable7,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable7, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checking the recovery data

	$recovery(posedge PRE, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : JKF3B
 CELL TYPE : sequential Logic
 CELL SEQ EQN: JKFF[Q=Q,_CLK=CLK, _PRE=PRE, J=J,k=!K];
-----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module JKF3B(PRE, CLK, Q,J,K);
 input J,K,PRE,CLK;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not	INV_193(K_, K);

 JKFFF JK_U0(Q, J,K,CLK,VCC,PRE, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      buf U_c0 (Enable1,PRE);      buf U_c4 (Enable5, PRE);
      buf U_c6 (Enable7, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   libname	="AXCELERATOR";
	specparam   InputLoad$CLK = 0.0;
	specparam   InputLoad$PRE = 0.0;
	specparam   InputLoad$J = 0.0;
	specparam   InputLoad$K = 0.0;

        // checking timing path for combinatorial output

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
        specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
        specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

	//check timing delay for output




        //check timing delay for output

	if(J == K)
	(negedge CLK => (Q +:J))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	if(J&& !K)
	(negedge CLK => (Q +: ~Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge J,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge J,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge J,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge J,0.0, NOTIFY_REG);
	$setup(posedge K,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge K,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge K,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge K,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable7,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable7, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checking the recovery data

	$recovery(posedge PRE, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MAJ3
 CELL TYPE : comb
 CELL LOGIC : Y = (A & B) + (B & C) + (A & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MAJ3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 and      U1218(NET_0_0, A, B);
 or       U1219(NET_0_2, NET_0_0, NET_0_1);
 and      U1221(NET_0_1, B, C);
 or       U1222(Y, NET_0_2, NET_0_3);
 and      U1224(NET_0_3, A, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MAJ3X
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & !C + A & !B & C + !A & B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MAJ3X(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_194(A_, A);
 not	INV_195(B_, B);
 not	INV_196(C_, C);
 and      U1229(NET_0_0, A, B);
 UDP_MUX2   U1230(NET_0_4, NET_0_0, NET_0_5, C_);
 and      U1233(NET_0_5, A_, B);
 or       U1234(Y, NET_0_4, NET_0_3);
 and      U1237(NET_0_2, A, B_);
 and      U1238(NET_0_3, NET_0_2, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MAJ3XI
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B & !C + A & !B & C + !A & B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MAJ3XI(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_197(A_, A);
 not	INV_198(B_, B);
 not	INV_199(C_, C);
 and      U1243(NET_0_0, A, B);
 UDP_MUX2   U1244(NET_0_4, NET_0_0, NET_0_5, C_);
 and      U1247(NET_0_5, A_, B);
 nor      U1248(Y, NET_0_4, NET_0_3);
 and      U1251(NET_0_2, A, B_);
 and      U1252(NET_0_3, NET_0_2, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MIN3
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B + !A & !C + !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MIN3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_200(A_, A);
 not	INV_201(B_, B);
 not	INV_202(C_, C);
 and      U1257(NET_0_0, A_, B_);
 or       U1258(NET_0_2, NET_0_0, NET_0_1);
 and      U1260(NET_0_1, A_, C_);
 or       U1261(Y, NET_0_2, NET_0_3);
 and      U1263(NET_0_3, B_, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MIN3X
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B & !C + !A & B & !C + !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MIN3X(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_203(A_, A);
 not	INV_204(B_, B);
 not	INV_205(C_, C);
 and      U1268(NET_0_0, A, B_);
 UDP_MUX2   U1269(NET_0_4, NET_0_0, NET_0_5, C_);
 and      U1272(NET_0_5, A_, B_);
 or       U1273(Y, NET_0_4, NET_0_3);
 and      U1276(NET_0_2, A_, B);
 and      U1277(NET_0_3, NET_0_2, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MIN3XI
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & !B & !C + !A & B & !C + !A & !B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MIN3XI(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6;

 not	INV_206(A_, A);
 not	INV_207(B_, B);
 not	INV_208(C_, C);
 and      U1282(NET_0_0, A, B_);
 UDP_MUX2   U1283(NET_0_4, NET_0_0, NET_0_5, C_);
 and      U1286(NET_0_5, A_, B_);
 nor      U1287(Y, NET_0_4, NET_0_3);
 and      U1290(NET_0_2, A_, B);
 and      U1291(NET_0_3, NET_0_2, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MULT1
 CELL TYPE : comb
 CELL LOGIC : PO = (A & B) ^PI ^ FCI ; FCO = ( A & B ) & PI + ( A & B ) & FCI + PI & FCI
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MULT1(PO,FCO,A,B,PI,FCI);
 input A,B,PI,FCI;
 output PO,FCO;
 wire NET_0_0, NET_0_1;
 wire NET_1_0, NET_1_1, NET_1_2, NET_1_3, NET_1_4, NET_1_5;

 and      U1296(NET_0_0, A, B);
 xor      U1297(NET_0_1, NET_0_0, PI);
 xor      U1298(PO, NET_0_1, FCI);
 and      U1304(NET_1_0, A, B);
 and      U1305(NET_1_1, NET_1_0, PI);
 or       U1306(NET_1_4, NET_1_1, NET_1_3);
 and      U1309(NET_1_2, A, B);
 and      U1310(NET_1_3, NET_1_2, FCI);
 or       U1311(FCO, NET_1_4, NET_1_5);
 and      U1313(NET_1_5, PI, FCI);

       specify

		specparam tpdLH_A_to_PO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PO = (0.1:0.1:0.1);
		specparam tpdLH_B_to_PO = (0.1:0.1:0.1);
		specparam tpdHL_B_to_PO = (0.1:0.1:0.1);
		specparam tpdLH_PI_to_PO = (0.1:0.1:0.1);
		specparam tpdHL_PI_to_PO = (0.1:0.1:0.1);
		specparam tpdLH_FCI_to_PO = (0.1:0.1:0.1);
		specparam tpdHL_FCI_to_PO = (0.1:0.1:0.1);
		specparam tpdLH_A_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_FCO = (0.1:0.1:0.1);
		specparam tpdLH_B_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_B_to_FCO = (0.1:0.1:0.1);
		specparam tpdLH_PI_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_PI_to_FCO = (0.1:0.1:0.1);
		specparam tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PO ) = ( tpdLH_A_to_PO, tpdHL_A_to_PO );
		(B => PO ) = ( tpdLH_B_to_PO, tpdHL_B_to_PO );
		(PI => PO ) = ( tpdLH_PI_to_PO, tpdHL_PI_to_PO );
		(FCI => PO ) = ( tpdLH_FCI_to_PO, tpdHL_FCI_to_PO );
		(A => FCO ) = ( tpdLH_A_to_FCO, tpdHL_A_to_FCO );
		(B => FCO ) = ( tpdLH_B_to_FCO, tpdHL_B_to_FCO );
		(PI => FCO ) = ( tpdLH_PI_to_FCO, tpdHL_PI_to_FCO );
		(FCI => FCO ) = ( tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MX2
 CELL TYPE : comb
 CELL LOGIC : Y = (A & !S) + (B & S)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MX2(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_209(S_, S);
 UDP_MUX2   U1316(Y, A, B, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MX2A
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !S) + (B & S)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MX2A(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_210(A_, A);
 not	INV_211(S_, S);
 UDP_MUX2   U1320(Y, A_, B, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MX2B
 CELL TYPE : comb
 CELL LOGIC : Y = (A & !S) + (!B & S)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MX2B(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_212(S_, S);
 not	INV_213(B_, B);
 UDP_MUX2   U1324(Y, A, B_, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MX2C
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !S) + (!B & S)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MX2C(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_214(A_, A);
 not	INV_215(S_, S);
 not	INV_216(B_, B);
 UDP_MUX2   U1328(Y, A_, B_, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MX4
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !S0 + D1 & S0) & !S1 + (D2 & !S0 + D3 & S0) & S1
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MX4(Y,D0,S0,D1,S1,D2,D3);
 input D0,S0,D1,S1,D2,D3;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7;

 not	INV_217(S0_, S0);
 not	INV_218(S1_, S1);
 UDP_MUX2   U1333(NET_0_2, D0, D1, S0_);
 UDP_MUX2   U1335(Y, NET_0_2, NET_0_6, S1_);
 UDP_MUX2   U1338(NET_0_6, D2, D3, S0_);

       specify

		specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S0_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S0_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S1_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S1_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
		(S0 => Y ) = ( tpdLH_S0_to_Y, tpdHL_S0_to_Y );
		(D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
		(S1 => Y ) = ( tpdLH_S1_to_Y, tpdHL_S1_to_Y );
		(D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
		(D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND2
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND2(Y,A,B);
 input A,B;
 output Y;

 nand     U1342(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND2A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND2A(Y,A,B);
 input A,B;
 output Y;

 not	INV_219(A_, A);
 nand     U1345(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND2B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND2B(Y,A,B);
 input A,B;
 output Y;

 not	INV_220(A_, A);
 not	INV_221(B_, B);
 nand     U1348(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U1352(NET_0_0, A, B);
 nand     U1353(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_222(A_, A);
 and      U1357(NET_0_0, A_, B);
 nand     U1358(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_223(A_, A);
 not	INV_224(B_, B);
 and      U1362(NET_0_0, A_, B_);
 nand     U1363(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3C
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_225(A_, A);
 not	INV_226(B_, B);
 not	INV_227(C_, C);
 and      U1367(NET_0_0, A_, B_);
 nand     U1368(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND4
 CELL TYPE : comb
 CELL LOGIC : Y = !A+!B+!C+!D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND4(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_228(A_, A);
 not	INV_229(B_, B);
 not	INV_230(C_, C);
 not	INV_231(D_, D);
 or       U1373(NET_0_0, A_, B_);
 or       U1374(NET_0_1, NET_0_0, C_);
 or       U1375(Y, NET_0_1, D_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND4A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & B & C & D )
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND4A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_232(A_, A);
 and      U1380(NET_0_0, A_, B);
 and      U1381(NET_0_1, NET_0_0, C);
 nand     U1382(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND4B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B & C & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND4B(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_233(A_, A);
 not	INV_234(B_, B);
 and      U1387(NET_0_0, A_, B_);
 and      U1388(NET_0_1, NET_0_0, C);
 nand     U1389(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND4C
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B & !C & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND4C(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_235(A_, A);
 not	INV_236(B_, B);
 not	INV_237(C_, C);
 and      U1394(NET_0_0, A_, B_);
 and      U1395(NET_0_1, NET_0_0, C_);
 nand     U1396(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND4D
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B & !C & !D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND4D(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_238(A_, A);
 not	INV_239(B_, B);
 not	INV_240(C_, C);
 not	INV_241(D_, D);
 and      U1401(NET_0_0, A_, B_);
 and      U1402(NET_0_1, NET_0_0, C_);
 nand     U1403(Y, NET_0_1, D_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND5B
 CELL TYPE : comb
 CELL LOGIC : Y = ! ( !A & !B & C & D & E )
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND5B(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_242(A_, A);
 not	INV_243(B_, B);
 and      U1409(NET_0_0, A_, B_);
 and      U1410(NET_0_1, NET_0_0, C);
 and      U1411(NET_0_2, NET_0_1, D);
 nand     U1412(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND5C
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A & !B & !C & D & E)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND5C(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_244(A_, A);
 not	INV_245(B_, B);
 not	INV_246(C_, C);
 and      U1418(NET_0_0, A_, B_);
 and      U1419(NET_0_1, NET_0_0, C_);
 and      U1420(NET_0_2, NET_0_1, D);
 nand     U1421(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR2
 CELL TYPE : comb
 CELL LOGIC : Y = !(A + B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR2(Y,A,B);
 input A,B;
 output Y;

 nor      U1424(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR2A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR2A(Y,A,B);
 input A,B;
 output Y;

 not	INV_247(A_, A);
 nor      U1427(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR2B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + !B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR2B(Y,A,B);
 input A,B;
 output Y;

 not	INV_248(A_, A);
 not	INV_249(B_, B);
 nor      U1430(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3
 CELL TYPE : comb
 CELL LOGIC : Y = !(A + B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 or       U1434(NET_0_0, A, B);
 nor      U1435(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_250(A_, A);
 or       U1439(NET_0_0, A_, B);
 nor      U1440(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + !B + C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_251(A_, A);
 not	INV_252(B_, B);
 or       U1444(NET_0_0, A_, B_);
 nor      U1445(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3C
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + !B + !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_253(A_, A);
 not	INV_254(B_, B);
 not	INV_255(C_, C);
 or       U1449(NET_0_0, A_, B_);
 nor      U1450(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR4
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & !C & !D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR4(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_256(A_, A);
 not	INV_257(B_, B);
 not	INV_258(C_, C);
 not	INV_259(D_, D);
 and      U1455(NET_0_0, A_, B_);
 and      U1456(NET_0_1, NET_0_0, C_);
 and      U1457(Y, NET_0_1, D_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR4A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + B + C + D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR4A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_260(A_, A);
 or       U1462(NET_0_0, A_, B);
 or       U1463(NET_0_1, NET_0_0, C);
 nor      U1464(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR4B
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + !B + C + D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR4B(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_261(A_, A);
 not	INV_262(B_, B);
 or       U1469(NET_0_0, A_, B_);
 or       U1470(NET_0_1, NET_0_0, C);
 nor      U1471(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR4C
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + !B + !C + D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR4C(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_263(A_, A);
 not	INV_264(B_, B);
 not	INV_265(C_, C);
 or       U1476(NET_0_0, A_, B_);
 or       U1477(NET_0_1, NET_0_0, C_);
 nor      U1478(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR4D
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + !B + !C + !D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR4D(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_266(A_, A);
 not	INV_267(B_, B);
 not	INV_268(C_, C);
 not	INV_269(D_, D);
 or       U1483(NET_0_0, A_, B_);
 or       U1484(NET_0_1, NET_0_0, C_);
 nor      U1485(Y, NET_0_1, D_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR5B
 CELL TYPE : comb
 CELL LOGIC : Y = ! ( !A + !B + C + D + E )
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR5B(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_270(A_, A);
 not	INV_271(B_, B);
 or       U1491(NET_0_0, A_, B_);
 or       U1492(NET_0_1, NET_0_0, C);
 or       U1493(NET_0_2, NET_0_1, D);
 nor      U1494(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR5C
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A + !B + !C + D + E)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR5C(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_272(A_, A);
 not	INV_273(B_, B);
 not	INV_274(C_, C);
 or       U1500(NET_0_0, A_, B_);
 or       U1501(NET_0_1, NET_0_0, C_);
 or       U1502(NET_0_2, NET_0_1, D);
 nor      U1503(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA1
 CELL TYPE : comb
 CELL LOGIC : Y = (A + B) & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 or       U1507(NET_0_0, A, B);
 and      U1508(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA1A
 CELL TYPE : comb
 CELL LOGIC : Y = (!A + B) & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_275(A_, A);
 or       U1512(NET_0_0, A_, B);
 and      U1513(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA1B
 CELL TYPE : comb
 CELL LOGIC : Y = !C & (A + B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA1B(Y,C,A,B);
 input C,A,B;
 output Y;
 wire NET_0_0;

 not	INV_276(C_, C);
 and      U1516(Y, C_, NET_0_0);
 or       U1518(NET_0_0, A, B);

       specify

		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA1C
 CELL TYPE : comb
 CELL LOGIC : Y = !C & (!A + B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA1C(Y,C,A,B);
 input C,A,B;
 output Y;
 wire NET_0_0;

 not	INV_277(C_, C);
 not	INV_278(A_, A);
 and      U1521(Y, C_, NET_0_0);
 or       U1523(NET_0_0, A_, B);

       specify

		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA2
 CELL TYPE : comb
 CELL LOGIC : Y = (A + B) & (C + D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA2(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 or       U1527(NET_0_0, A, B);
 and      U1528(Y, NET_0_0, NET_0_1);
 or       U1530(NET_0_1, C, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA2A
 CELL TYPE : comb
 CELL LOGIC : Y = (!A + B) & (C + D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA2A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_279(A_, A);
 or       U1534(NET_0_0, A_, B);
 and      U1535(Y, NET_0_0, NET_0_1);
 or       U1537(NET_0_1, C, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA3
 CELL TYPE : comb
 CELL LOGIC : Y = ((A + B) & C & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA3(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 or       U1542(NET_0_0, A, B);
 and      U1543(NET_0_1, NET_0_0, C);
 and      U1544(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA3A
 CELL TYPE : comb
 CELL LOGIC : Y = ((A + B) & !C & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA3A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_280(C_, C);
 or       U1549(NET_0_0, A, B);
 and      U1550(NET_0_1, NET_0_0, C_);
 and      U1551(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA3B
 CELL TYPE : comb
 CELL LOGIC : Y = ((!A + B) & !C & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA3B(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_281(A_, A);
 not	INV_282(C_, C);
 or       U1556(NET_0_0, A_, B);
 and      U1557(NET_0_1, NET_0_0, C_);
 and      U1558(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA4
 CELL TYPE : comb
 CELL LOGIC : Y = (A + B + C) & D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA4(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 or       U1563(NET_0_0, A, B);
 or       U1564(NET_0_1, NET_0_0, C);
 and      U1565(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA4A
 CELL TYPE : comb
 CELL LOGIC : Y = ((A + B + !C) & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA4A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_283(C_, C);
 or       U1570(NET_0_0, A, B);
 or       U1571(NET_0_1, NET_0_0, C_);
 and      U1572(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA5
 CELL TYPE : comb
 CELL LOGIC : Y = (A+B+C) & (A+D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA5(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 or       U1577(NET_0_0, A, B);
 or       U1578(NET_0_1, NET_0_0, C);
 and      U1579(Y, NET_0_1, NET_0_2);
 or       U1581(NET_0_2, A, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI1
 CELL TYPE : comb
 CELL LOGIC : Y = !((A + B) & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 or       U1585(NET_0_0, A, B);
 nand     U1586(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI2A
 CELL TYPE : comb
 CELL LOGIC : Y = !((A + B + C) & !D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI2A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_284(D_, D);
 or       U1591(NET_0_0, A, B);
 or       U1592(NET_0_1, NET_0_0, C);
 nand     U1593(Y, NET_0_1, D_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI3
 CELL TYPE : comb
 CELL LOGIC : Y = !((A + B) & C & D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI3(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 or       U1598(NET_0_0, A, B);
 and      U1599(NET_0_1, NET_0_0, C);
 nand     U1600(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI3A
 CELL TYPE : comb
 CELL LOGIC : Y = !((A + B) & !C & !D )
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI3A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_285(C_, C);
 not	INV_286(D_, D);
 or       U1605(NET_0_0, A, B);
 and      U1606(NET_0_1, NET_0_0, C_);
 nand     U1607(Y, NET_0_1, D_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR2
 CELL TYPE : comb
 CELL LOGIC : Y = A + B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR2(Y,A,B);
 input A,B;
 output Y;

 or       U1610(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR2A
 CELL TYPE : comb
 CELL LOGIC : Y = !A + B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR2A(Y,A,B);
 input A,B;
 output Y;

 not	INV_287(A_, A);
 or       U1613(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR2B
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR2B(Y,A,B);
 input A,B;
 output Y;

 not	INV_288(A_, A);
 not	INV_289(B_, B);
 or       U1616(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3
 CELL TYPE : comb
 CELL LOGIC : Y = A + B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 or       U1620(NET_0_0, A, B);
 or       U1621(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3A
 CELL TYPE : comb
 CELL LOGIC : Y = !A + B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_290(A_, A);
 or       U1625(NET_0_0, A_, B);
 or       U1626(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3B
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_291(A_, A);
 not	INV_292(B_, B);
 or       U1630(NET_0_0, A_, B_);
 or       U1631(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3C
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_293(A_, A);
 not	INV_294(B_, B);
 not	INV_295(C_, C);
 or       U1635(NET_0_0, A_, B_);
 or       U1636(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR4
 CELL TYPE : comb
 CELL LOGIC : Y = A + B + C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR4(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 or       U1641(NET_0_0, A, B);
 or       U1642(NET_0_1, NET_0_0, C);
 or       U1643(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR4A
 CELL TYPE : comb
 CELL LOGIC : Y = !A + B + C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR4A(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_296(A_, A);
 or       U1648(NET_0_0, A_, B);
 or       U1649(NET_0_1, NET_0_0, C);
 or       U1650(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR4B
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR4B(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_297(A_, A);
 not	INV_298(B_, B);
 or       U1655(NET_0_0, A_, B_);
 or       U1656(NET_0_1, NET_0_0, C);
 or       U1657(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR4C
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + !C + D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR4C(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_299(A_, A);
 not	INV_300(B_, B);
 not	INV_301(C_, C);
 or       U1662(NET_0_0, A_, B_);
 or       U1663(NET_0_1, NET_0_0, C_);
 or       U1664(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR4D
 CELL TYPE : comb
 CELL LOGIC : Y = !A+!B+!C+!D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR4D(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_302(A_, A);
 not	INV_303(B_, B);
 not	INV_304(C_, C);
 not	INV_305(D_, D);
 or       U1669(NET_0_0, A_, B_);
 or       U1670(NET_0_1, NET_0_0, C_);
 or       U1671(Y, NET_0_1, D_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR5A
 CELL TYPE : comb
 CELL LOGIC : Y =  !A + B + C + D + E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR5A(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_306(A_, A);
 or       U1677(NET_0_0, A_, B);
 or       U1678(NET_0_1, NET_0_0, C);
 or       U1679(NET_0_2, NET_0_1, D);
 or       U1680(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR5B
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + C + D + E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR5B(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_307(A_, A);
 not	INV_308(B_, B);
 or       U1686(NET_0_0, A_, B_);
 or       U1687(NET_0_1, NET_0_0, C);
 or       U1688(NET_0_2, NET_0_1, D);
 or       U1689(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR5C
 CELL TYPE : comb
 CELL LOGIC : Y = !A+!B+!C+D+E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR5C(Y,A,B,C,D,E);
 input A,B,C,D,E;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2;

 not	INV_309(A_, A);
 not	INV_310(B_, B);
 not	INV_311(C_, C);
 or       U1695(NET_0_0, A_, B_);
 or       U1696(NET_0_1, NET_0_0, C_);
 or       U1697(NET_0_2, NET_0_1, D);
 or       U1698(Y, NET_0_2, E);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_E_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_E_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
		(E => Y ) = ( tpdLH_E_to_Y, tpdHL_E_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_8(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_12(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_16(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_S_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_S_24(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_8(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_12(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_16(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_F_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_F_24(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVCMOS25(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVCMOS18(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVCMOS15(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_PCI
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_PCI(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_PCIX
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_PCIX(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_GTLP33
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_GTLP33(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_GTLP25
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_GTLP25(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_HSTL_I
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_HSTL_I(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_SSTL3_I
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_SSTL3_I(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_SSTL3_II
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_SSTL3_II(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_SSTL2_I
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_SSTL2_I(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OUTBUF_SSTL2_II
 CELL TYPE : comb
 CELL LOGIC : PAD=D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_SSTL2_II(PAD,D);
 input D;
 output PAD;

 buf	BUF_U_00(PAD,D);

       specify

		specparam tpdLH_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(D => PAD ) = ( tpdLH_D_to_PAD, tpdHL_D_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : PLLHCLK
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module PLLHCLK(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : PLLRCLK
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module PLLRCLK(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : SFCNTECP1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _CLR=CLR, _PRE=PRE, D=Q^!UD^FCI ];
 CELL COMB EQN : "FCO = Q & !UD + Q & FCI + !UD & FCI"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module SFCNTECP1(PRE, CLR, E, CLK, FCO,UD,FCI,Q);
 input UD,FCI,PRE,CLR,E,CLK;
 output FCO;
 output Q;
 wire NET_0_0,NET_1_0,NET_1_1,NET_1_2,NET_1_3;
 reg NOTIFY_REG;

 not	INV_312(UD_, UD);
	// create Logics for combinatorial output Logics! 
 and      U1703(NET_1_0, Q, UD_);
 or       U1704(NET_1_2, NET_1_0, NET_1_1);
 and      U1706(NET_1_1, Q, FCI);
 or       U1707(FCO, NET_1_2, NET_1_3);
 and      U1709(NET_1_3, UD_, FCI);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 xor      U1713(NET_0_0, Q, UD_);
 xor      U1714(NET_0_1, NET_0_0, FCI);

 Dffpf DF_0(Q, NET_0_1,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	//(Q => FCO) = (tpdLH_Q_to_FCO, tpdHL_Q_to_FCO);
	(UD => FCO) = (tpdLH_UD_to_FCO, tpdHL_UD_to_FCO);
	(FCI => FCO) = (tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO);

	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge Q,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge Q,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge Q,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge Q,0.0, NOTIFY_REG);
	$setup(posedge UD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge UD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge UD,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge UD,0.0, NOTIFY_REG);
	$setup(posedge FCI,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge FCI,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge FCI,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge FCI,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : SRCNTECP1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _CLR=CLR, _PRE=PRE, D=(Q ^ !UD ^ FCI) ];
 CELL COMB EQN : "FCO = Q & !UD + Q & FCI + !UD & FCI"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module SRCNTECP1(PRE, CLR, E, CLK, FCO,UD,FCI,Q);
 input UD,FCI,PRE,CLR,E,CLK;
 output FCO;
 output Q;
 wire NET_0_0,NET_1_0,NET_1_1,NET_1_2,NET_1_3;
 reg NOTIFY_REG;

 not	INV_313(UD_, UD);
	// create Logics for combinatorial output Logics! 
 and      U1719(NET_1_0, Q, UD_);
 or       U1720(NET_1_2, NET_1_0, NET_1_1);
 and      U1722(NET_1_1, Q, FCI);
 or       U1723(FCO, NET_1_2, NET_1_3);
 and      U1725(NET_1_3, UD_, FCI);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 xor      U1729(NET_0_0, Q, UD_);
 xor      U1730(NET_0_1, NET_0_0, FCI);

 Dffpr DF_0(Q, NET_0_1,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	//(Q => FCO) = (tpdLH_Q_to_FCO, tpdHL_Q_to_FCO);
	(UD => FCO) = (tpdLH_UD_to_FCO, tpdHL_UD_to_FCO);
	(FCI => FCO) = (tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO);

	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge Q,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge Q,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge Q,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge Q,0.0, NOTIFY_REG);
	$setup(posedge UD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge UD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge UD,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge UD,0.0, NOTIFY_REG);
	$setup(posedge FCI,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge FCI,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge FCI,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge FCI,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : SFCNTELDCP1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _CLR=CLR, _PRE=PRE, D=(Q^!UD^FCI)*!LD + D*LD ];
 CELL COMB EQN : "FCO = Q & !UD+Q & FCI + !UD & FCI"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module SFCNTELDCP1(PRE, CLR, E, CLK, FCO,UD,FCI,LD,D,Q);
 input UD,FCI,LD,D,PRE,CLR,E,CLK;
 output FCO;
 output Q;
 wire NET_0_0,NET_0_1,NET_0_2,NET_0_3,NET_1_0,NET_1_1,NET_1_2,NET_1_3;
 reg NOTIFY_REG;

 not	INV_314(UD_, UD);
 not	INV_315(LD_, LD);
	// create Logics for combinatorial output Logics! 
 and      U1735(NET_1_0, Q, UD_);
 or       U1736(NET_1_2, NET_1_0, NET_1_1);
 and      U1738(NET_1_1, Q, FCI);
 or       U1739(FCO, NET_1_2, NET_1_3);
 and      U1741(NET_1_3, UD_, FCI);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 xor      U1746(NET_0_0, Q, UD_);
 xor      U1747(NET_0_1, NET_0_0, FCI);
 UDP_MUX2   U1748(NET_0_4, NET_0_1, D, LD_);

 Dffpf DF_0(Q, NET_0_4,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	//(Q => FCO) = (tpdLH_Q_to_FCO, tpdHL_Q_to_FCO);
	(UD => FCO) = (tpdLH_UD_to_FCO, tpdHL_UD_to_FCO);
	(FCI => FCO) = (tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO);

	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge Q,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge Q,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge Q,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge Q,0.0, NOTIFY_REG);
	$setup(posedge UD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge UD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge UD,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge UD,0.0, NOTIFY_REG);
	$setup(posedge FCI,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge FCI,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge FCI,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge FCI,0.0, NOTIFY_REG);
	$setup(posedge LD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge LD,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge LD,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge LD,0.0, NOTIFY_REG);
	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : SRCNTELDCP1
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _CLR=CLR, _PRE=PRE, D=(Q ^ !UD ^ FCI)*!LD + D*LD ];
 CELL COMB EQN : "FCO = Q & !UD + Q & FCI +!UD & FCI"
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module SRCNTELDCP1(PRE, CLR, E, CLK, FCO,UD,FCI,LD,D,Q);
 input UD,FCI,LD,D,PRE,CLR,E,CLK;
 output FCO;
 output Q;
 wire NET_0_0,NET_0_1,NET_0_2,NET_0_3,NET_1_0,NET_1_1,NET_1_2,NET_1_3;
 reg NOTIFY_REG;

 not	INV_316(UD_, UD);
 not	INV_317(LD_, LD);
	// create Logics for combinatorial output Logics! 
 and      U1754(NET_1_0, Q, UD_);
 or       U1755(NET_1_2, NET_1_0, NET_1_1);
 and      U1757(NET_1_1, Q, FCI);
 or       U1758(FCO, NET_1_2, NET_1_3);
 and      U1760(NET_1_3, UD_, FCI);

	// create the sequential logic -- DFF flip-flop plus comb input logic
 xor      U1765(NET_0_0, Q, UD_);
 xor      U1766(NET_0_1, NET_0_0, FCI);
 UDP_MUX2   U1767(NET_0_4, NET_0_1, D, LD_);

 Dffpr DF_0(Q, NET_0_4,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_Q_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_UD_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);

        // checking timing path for combinatorial output

	//(Q => FCO) = (tpdLH_Q_to_FCO, tpdHL_Q_to_FCO);
	(UD => FCO) = (tpdLH_UD_to_FCO, tpdHL_UD_to_FCO);
	(FCI => FCO) = (tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO);

	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge Q,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge Q,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge Q,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge Q,0.0, NOTIFY_REG);
	$setup(posedge UD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge UD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge UD,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge UD,0.0, NOTIFY_REG);
	$setup(posedge FCI,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge FCI,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge FCI,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge FCI,0.0, NOTIFY_REG);
	$setup(posedge LD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge LD,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge LD,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge LD,0.0, NOTIFY_REG);
	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : SUB1
 CELL TYPE : comb
 CELL LOGIC : S = A ^ !B ^ FCI ; FCO = A & !B + A & FCI + !B & FCI
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module SUB1(S,FCO,A,B,FCI);
 input A,B,FCI;
 output S,FCO;
 wire NET_0_0;
 wire NET_1_0, NET_1_1, NET_1_2, NET_1_3;

 not	INV_318(A_, A);
 not	INV_319(B_, B);
 UDP_MUX2   U1772(NET_0_0, B_, B, A_);
 xor      U1774(S, NET_0_0, FCI);
 not	INV_320(A_, A);
 not	INV_321(B_, B);
 and      U1779(NET_1_0, A, B_);
 or       U1780(NET_1_2, NET_1_0, NET_1_1);
 and      U1782(NET_1_1, A, FCI);
 or       U1783(FCO, NET_1_2, NET_1_3);
 and      U1785(NET_1_3, B_, FCI);

       specify

		specparam tpdLH_A_to_S = (0.1:0.1:0.1);
		specparam tpdHL_A_to_S = (0.1:0.1:0.1);
		specparam tpdLH_B_to_S = (0.1:0.1:0.1);
		specparam tpdHL_B_to_S = (0.1:0.1:0.1);
		specparam tpdLH_FCI_to_S = (0.1:0.1:0.1);
		specparam tpdHL_FCI_to_S = (0.1:0.1:0.1);
		specparam tpdLH_A_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_A_to_FCO = (0.1:0.1:0.1);
		specparam tpdLH_B_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_B_to_FCO = (0.1:0.1:0.1);
		specparam tpdLH_FCI_to_FCO = (0.1:0.1:0.1);
		specparam tpdHL_FCI_to_FCO = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => S ) = ( tpdLH_A_to_S, tpdHL_A_to_S );
		(B => S ) = ( tpdLH_B_to_S, tpdHL_B_to_S );
		(FCI => S ) = ( tpdLH_FCI_to_S, tpdHL_FCI_to_S );
		(A => FCO ) = ( tpdLH_A_to_FCO, tpdHL_A_to_FCO );
		(B => FCO ) = ( tpdLH_B_to_FCO, tpdHL_B_to_FCO );
		(FCI => FCO ) = ( tpdLH_FCI_to_FCO, tpdHL_FCI_to_FCO );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : TF1A
 CELL TYPE : TFF Logic
 CELL SEQ EQN : TFF[Q=Q,CLK =CLK, _CLR=CLR, T=T]
-----------------------------------------------------------------*/


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TF1A(CLR, CLK, Q,T);
 input T,CLR,CLK;
 output Q;
 reg NOTIFY_REG;

 not NT1 (Q_, Q_INT);
 UDP_MUX2 #(0.1:0.1:0.1) inst1 (D_EFF,Q_, Q_INT,T);

 UFPRB TFF_U0(Q_INT, D_EFF,CLK, CLR,NOTIFY_REG);
  buf QBUF(Q,Q_INT);

// some temp signals created for timing checking sections

        not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,CLR);
      buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   libname	= "AXCELERATOR";
	specparam   macrotype   = "T-flipflop";
	specparam   InputLoad$CLK = 0.0;
	specparam   InputLoad$T = 0.0;

	specparam    tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output




	if(T && CLR)
	(posedge CLK => (Q -:Q)) = (tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge T,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge T,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge T,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge T,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable1 , 0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable1 , 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checking the recovery data

	$recovery(posedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : TF1B
 CELL TYPE : TFF Logic
 CELL SEQ EQN : TFF[Q=Q,_CLK=CLK, _CLR=CLR, T=T]
-----------------------------------------------------------------*/


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TF1B(CLR, CLK, Q,T);
 input T,CLR,CLK;
 output Q;
 reg NOTIFY_REG;

 not NT1 (Q_, Q_INT);
 UDP_MUX2 #(0.1:0.1:0.1) inst1 (D_EFF,Q_, Q_INT,T);

 UFNRB TFF_U0(Q_INT, D_EFF,CLK, CLR,NOTIFY_REG);
  buf QBUF(Q,Q_INT);

// some temp signals created for timing checking sections

        not U_I0 (_CLK, CLK);
        not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,CLR);
      buf U_c6 (Enable7, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   libname	= "AXCELERATOR";
	specparam   macrotype   = "T-flipflop";
	specparam   InputLoad$CLK = 0.0;
	specparam   InputLoad$T = 0.0;

	specparam    tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output




	if(T && CLR)
	(negedge CLK => (Q -:Q)) = (tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge T,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge T,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge T,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge T,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable1 , 0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable1 , 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checking the recovery data

	$recovery(posedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1788(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_8(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1791(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_8D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_8D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1794(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_8U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_8U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1797(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_12(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1800(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_12D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_12D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1803(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_12U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_12U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1806(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_16(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1809(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_16D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_16D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1812(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_16U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_16U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1815(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_24(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1818(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_24D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_24D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1821(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_S_24U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_S_24U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1824(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_8
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_8(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1827(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_8D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_8D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1830(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_8U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_8U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1833(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_12
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_12(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1836(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_12D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_12D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1839(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_12U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_12U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1842(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_16
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_16(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1845(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_16D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_16D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1848(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_16U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_16U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1851(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_24
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_24(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1854(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_24D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_24D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1857(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_F_24U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_F_24U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1860(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS25
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS25(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1863(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS25D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS25D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1866(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS25U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS25U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1869(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS18
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS18(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1872(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS18D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS18D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1875(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS18U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS18U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1878(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS15
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS15(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1881(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS15D
 CELL TYPE : comb
 CELL LOGIC : PAD#Down=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS15D(PAD,D,E);
 input D,E;
 output PAD;

 tri0 PAD;
 bufif1   U1884(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_LVCMOS15U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_LVCMOS15U(PAD,D,E);
 input D,E;
 output PAD;

 tri1 PAD;
 bufif1   U1887(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_PCI
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_PCI(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1890(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_PCIX
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_PCIX(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1893(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_GTLP33
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_GTLP33(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1896(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_GTLP25
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_GTLP25(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U1899(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : VCC
 CELL TYPE : comb
 CELL LOGIC : Y=1
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module VCC(Y);
 output Y;

 supply1    Y;

       specify

		specparam MacroType = "comb";

		//pin to pin path delay 

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XA1
 CELL TYPE : comb
 CELL LOGIC : Y = (A ^ B) & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XA1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_322(A_, A);
 not	INV_323(B_, B);
 UDP_MUX2   U1903(NET_0_0, B, B_, A_);
 and      U1905(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XA1A
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B) & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XA1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_324(A_, A);
 not	INV_325(B_, B);
 UDPN_MUX2  U1909(NET_0_0, B, B_, A_);
 and      U1911(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XA1B
 CELL TYPE : comb
 CELL LOGIC : Y = (A ^ B) & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XA1B(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_326(A_, A);
 not	INV_327(B_, B);
 not	INV_328(C_, C);
 UDP_MUX2   U1915(NET_0_0, B, B_, A_);
 and      U1917(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XA1C
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B) & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XA1C(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_329(A_, A);
 not	INV_330(B_, B);
 not	INV_331(C_, C);
 UDPN_MUX2  U1921(NET_0_0, B, B_, A_);
 and      U1923(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XAI1
 CELL TYPE : comb
 CELL LOGIC : Y = !((A ^ B) & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XAI1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_332(A_, A);
 not	INV_333(B_, B);
 UDP_MUX2   U1927(NET_0_0, B, B_, A_);
 nand     U1929(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XAI1A
 CELL TYPE : comb
 CELL LOGIC : Y = !(!(A ^ B) & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XAI1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_334(A_, A);
 not	INV_335(B_, B);
 UDPN_MUX2  U1933(NET_0_0, B, B_, A_);
 nand     U1935(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XNOR2
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XNOR2(Y,A,B);
 input A,B;
 output Y;

 not	INV_336(A_, A);
 not	INV_337(B_, B);
 UDPN_MUX2  U1938(Y, B, B_, A_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XNOR3
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B ^ C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XNOR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_338(A_, A);
 not	INV_339(B_, B);
 UDP_MUX2   U1943(NET_0_0, B, B_, A_);
 xnor     U1945(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XNOR4
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B ^ C ^ D)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XNOR4(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_340(A_, A);
 not	INV_341(B_, B);
 UDP_MUX2   U1950(NET_0_0, B, B_, A_);
 xor      U1952(NET_0_1, NET_0_0, C);
 xnor     U1953(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XO1
 CELL TYPE : comb
 CELL LOGIC : Y = (A ^ B) + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XO1(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_342(A_, A);
 not	INV_343(B_, B);
 UDP_MUX2   U1957(NET_0_0, B, B_, A_);
 or       U1959(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XO1A
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B) + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XO1A(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_344(A_, A);
 not	INV_345(B_, B);
 UDPN_MUX2  U1963(NET_0_0, B, B_, A_);
 or       U1965(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XOR2
 CELL TYPE : comb
 CELL LOGIC : Y = A ^ B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XOR2(Y,A,B);
 input A,B;
 output Y;

 not	INV_346(A_, A);
 not	INV_347(B_, B);
 UDP_MUX2   U1968(Y, B, B_, A_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XOR3
 CELL TYPE : comb
 CELL LOGIC : Y = A ^ B ^ C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XOR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_348(A_, A);
 not	INV_349(B_, B);
 UDP_MUX2   U1973(NET_0_0, B, B_, A_);
 xor      U1975(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XOR4
 CELL TYPE : comb
 CELL LOGIC : Y = A ^ B ^ C ^ D
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XOR4(Y,A,B,C,D);
 input A,B,C,D;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_350(A_, A);
 not	INV_351(B_, B);
 UDP_MUX2   U1980(NET_0_0, B, B_, A_);
 xor      U1982(NET_0_1, NET_0_0, C);
 xor      U1983(Y, NET_0_1, D);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_D_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_D_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(D => Y ) = ( tpdLH_D_to_Y, tpdHL_D_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XOR4_FCI
 CELL TYPE : comb
 CELL LOGIC : Y = A ^ B ^ C ^ FCI
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XOR4_FCI(Y,A,B,C,FCI);
 input A,B,C,FCI;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_352(A_, A);
 not	INV_353(B_, B);
 UDP_MUX2   U1988(NET_0_0, B, B_, A_);
 xor      U1990(NET_0_1, NET_0_0, C);
 xor      U1991(Y, NET_0_1, FCI);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_FCI_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_FCI_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(FCI => Y ) = ( tpdLH_FCI_to_Y, tpdHL_FCI_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : ZOR3
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C + !A & !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module ZOR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_354(A_, A);
 not	INV_355(B_, B);
 not	INV_356(C_, C);
 and      U1995(NET_0_0, A, B);
 UDP_MUX2   U1996(Y, NET_0_0, NET_0_2, C);
 and      U1999(NET_0_2, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : ZOR3I
 CELL TYPE : comb
 CELL LOGIC : Y = !(A & B & C + !A & !B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module ZOR3I(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3;

 not	INV_357(A_, A);
 not	INV_358(B_, B);
 not	INV_359(C_, C);
 and      U2003(NET_0_0, A, B);
 UDPN_MUX2  U2004(Y, NET_0_0, NET_0_2, C);
 and      U2007(NET_0_2, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOFIFO_BIBUF
 CELL TYPE : comb
 CELL LOGIC : YIN=AIN ; YOUT=AOUT
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOFIFO_BIBUF(YIN,YOUT,AIN,AOUT);
 input AIN,AOUT;
 output YIN,YOUT;

 buf	BUF_U_00(YIN,AIN);
 buf	BUF_U_01(YOUT,AOUT);

       specify

		specparam tpdLH_AIN_to_YIN = (0.1:0.1:0.1);
		specparam tpdHL_AIN_to_YIN = (0.1:0.1:0.1);
		specparam tpdLH_AOUT_to_YOUT = (0.1:0.1:0.1);
		specparam tpdHL_AOUT_to_YOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(AIN => YIN ) = ( tpdLH_AIN_to_YIN, tpdHL_AIN_to_YIN );
		(AOUT => YOUT ) = ( tpdLH_AOUT_to_YOUT, tpdHL_AOUT_to_YOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOI_FCLK_EN_BUFF
 CELL TYPE : comb
 CELL LOGIC : Y=A ; ENOUT=EN ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOI_FCLK_EN_BUFF(Y,ENOUT,CLKOUT,A,EN,CLK);
 input A,EN,CLK;
 output Y,ENOUT,CLKOUT;

 buf	BUF_U_00(Y,A);
 buf	BUF_U_01(ENOUT,EN);
 buf	BUF_U_02(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(EN => ENOUT ) = ( tpdLH_EN_to_ENOUT, tpdHL_EN_to_ENOUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOI_FCLK_BUFF
 CELL TYPE : comb
 CELL LOGIC : Y=A ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOI_FCLK_BUFF(Y,CLKOUT,A,CLK);
 input A,CLK;
 output Y,CLKOUT;

 buf	BUF_U_00(Y,A);
 buf	BUF_U_01(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOI_RCLK_EN_BUFF
 CELL TYPE : comb
 CELL LOGIC : Y=A ; ENOUT=EN ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOI_RCLK_EN_BUFF(Y,ENOUT,CLKOUT,A,EN,CLK);
 input A,EN,CLK;
 output Y,ENOUT,CLKOUT;

 buf	BUF_U_00(Y,A);
 buf	BUF_U_01(ENOUT,EN);
 buf	BUF_U_02(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(EN => ENOUT ) = ( tpdLH_EN_to_ENOUT, tpdHL_EN_to_ENOUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOI_RCLK_BUFF
 CELL TYPE : comb
 CELL LOGIC : Y=A ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOI_RCLK_BUFF(Y,CLKOUT,A,CLK);
 input A,CLK;
 output Y,CLKOUT;

 buf	BUF_U_00(Y,A);
 buf	BUF_U_01(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_FCLK_EN_BUFF
 CELL TYPE : comb
 CELL LOGIC : YOUT=A ; ENOUT=EN ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_FCLK_EN_BUFF(YOUT,ENOUT,CLKOUT,A,EN,CLK);
 input A,EN,CLK;
 output YOUT,ENOUT,CLKOUT;

 buf	BUF_U_00(YOUT,A);
 buf	BUF_U_01(ENOUT,EN);
 buf	BUF_U_02(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdHL_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => YOUT ) = ( tpdLH_A_to_YOUT, tpdHL_A_to_YOUT );
		(EN => ENOUT ) = ( tpdLH_EN_to_ENOUT, tpdHL_EN_to_ENOUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_FCLK
 CELL TYPE : comb
 CELL LOGIC : CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_FCLK(CLKOUT,CLK);
 input CLK;
 output CLKOUT;

 buf	BUF_U_00(CLKOUT,CLK);

       specify

		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_RCLK_EN_BUFF
 CELL TYPE : comb
 CELL LOGIC : YOUT=A ; ENOUT=EN ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_RCLK_EN_BUFF(YOUT,ENOUT,CLKOUT,A,EN,CLK);
 input A,EN,CLK;
 output YOUT,ENOUT,CLKOUT;

 buf	BUF_U_00(YOUT,A);
 buf	BUF_U_01(ENOUT,EN);
 buf	BUF_U_02(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdHL_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => YOUT ) = ( tpdLH_A_to_YOUT, tpdHL_A_to_YOUT );
		(EN => ENOUT ) = ( tpdLH_EN_to_ENOUT, tpdHL_EN_to_ENOUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_RCLK_CLR_EN
 CELL TYPE : comb
 CELL LOGIC : CLROUT=CLR ; ENOUT=EN ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_RCLK_CLR_EN(CLROUT,ENOUT,CLKOUT,CLR,EN,CLK);
 input CLR,EN,CLK;
 output CLROUT,ENOUT,CLKOUT;

 buf	BUF_U_00(CLROUT,CLR);
 buf	BUF_U_01(ENOUT,EN);
 buf	BUF_U_02(CLKOUT,CLK);

       specify

		specparam tpdLH_CLR_to_CLROUT = (0.1:0.1:0.1);
		specparam tpdHL_CLR_to_CLROUT = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(CLR => CLROUT ) = ( tpdLH_CLR_to_CLROUT, tpdHL_CLR_to_CLROUT );
		(EN => ENOUT ) = ( tpdLH_EN_to_ENOUT, tpdHL_EN_to_ENOUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_RCLK_BUFF
 CELL TYPE : comb
 CELL LOGIC : YOUT=A ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_RCLK_BUFF(YOUT,CLKOUT,A,CLK);
 input A,CLK;
 output YOUT,CLKOUT;

 buf	BUF_U_00(YOUT,A);
 buf	BUF_U_01(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdHL_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => YOUT ) = ( tpdLH_A_to_YOUT, tpdHL_A_to_YOUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_RCLK
 CELL TYPE : comb
 CELL LOGIC : CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_RCLK(CLKOUT,CLK);
 input CLK;
 output CLKOUT;

 buf	BUF_U_00(CLKOUT,CLK);

       specify

		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : PLLINT
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module PLLINT(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : PLLOUT
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module PLLOUT(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_HSTL_I
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_HSTL_I(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U2010(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_SSTL3_I
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_SSTL3_I(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U2013(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_SSTL3_II
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_SSTL3_II(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U2016(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_SSTL2_I
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_SSTL2_I(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U2019(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BIBUF_SSTL2_II
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIBUF_SSTL2_II(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 bufif1   U2022(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BUFF
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BUFF(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKINT
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKINT(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKINT_W
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKINT_W(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKOUT_E
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKOUT_E(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : CLKOUT_W
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKOUT_W(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFM
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFM(CLK, Q,S,A,B);
 input S,A,B,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not	INV_360(S_, S);
 UDP_MUX2   U2025(NET_0_2, A, B, S_);

 Dffpr DF_0(Q, NET_0_2,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge S,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge S,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge A,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge A,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge B,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge B,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFM3B
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _CLR=CLR, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFM3B(CLR, CLK, Q,S,A,B);
 input S,A,B,CLR,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not	INV_361(S_, S);
 UDP_MUX2   U2029(NET_0_2, A, B, S_);

 Dffpf DF_0(Q, NET_0_2,CLK,CLR, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,CLR);
       buf U_c2 (Enable2, CLR);
      buf U_c6 (Enable5, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFM4A
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _PRE=PRE, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFM4A(PRE, CLK, Q,S,A,B);
 input S,A,B,PRE,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not	INV_362(S_, S);
 UDP_MUX2   U2033(NET_0_2, A, B, S_);

 Dffpr DF_0(Q, NET_0_2,CLK,VCC_0, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      buf U_c0 (Enable1, PRE);       buf U_c4 (Enable4, PRE);
       buf U_c6 (Enable5, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFM4B
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _PRE=PRE, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFM4B(PRE, CLK, Q,S,A,B);
 input S,A,B,PRE,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not	INV_363(S_, S);
 UDP_MUX2   U2037(NET_0_2, A, B, S_);

 Dffpf DF_0(Q, NET_0_2,CLK,VCC_0, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      buf U_c0 (Enable1, PRE);       buf U_c4 (Enable4, PRE);
       buf U_c6 (Enable5, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFMA
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFMA(CLK, Q,S,A,B);
 input S,A,B,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not	INV_364(S_, S);
 UDP_MUX2   U2041(NET_0_2, A, B, S_);

 Dffpf DF_0(Q, NET_0_2,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge S,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge S,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge A,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge A,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge B,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge B,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFMB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _CLR=CLR, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFMB(CLR, CLK, Q,S,A,B);
 input S,A,B,CLR,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not	INV_365(S_, S);
 UDP_MUX2   U2045(NET_0_2, A, B, S_);

 Dffpr DF_0(Q, NET_0_2,CLK,CLR, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,CLR);
       buf U_c2 (Enable2, CLR);
      buf U_c6 (Enable5, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFME1A
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFME1A(E, CLK, Q,S,A,B);
 input S,A,B,E,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not	INV_366(S_, S);
 UDP_MUX2   U2049(NET_0_2, A, B, S_);

 Dffpr DF_0(Q, NET_0_2,CLK,VCC_0, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I3 (_E, E);
      buf U_c0 (Enable1,_E);
      buf U_c2 (Enable2, _E);
      buf U_c4 (Enable4, _E);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK,  0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFME1B
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFME1B(E, CLK, Q,S,A,B);
 input S,A,B,E,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not	INV_367(S_, S);
 UDP_MUX2   U2053(NET_0_2, A, B, S_);

 Dffpf DF_0(Q, NET_0_2,CLK,VCC_0, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I3 (_E, E);
      buf U_c0 (Enable1,_E);
      buf U_c2 (Enable2, _E);
      buf U_c4 (Enable4, _E);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK,  0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge E,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFME2A
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _PRE=PRE, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFME2A(PRE, E, CLK, Q,S,A,B);
 input S,A,B,PRE,E,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not	INV_368(S_, S);
 UDP_MUX2   U2057(NET_0_2, A, B, S_);

 Dffpr DF_0(Q, NET_0_2,CLK,VCC_0, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, PRE);
      buf U_c2 (Enable2, _E);
      and U_c4 (Enable4, _E, PRE);
       buf U_c6 (Enable5, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFME2B
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _PRE=PRE, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFME2B(PRE, E, CLK, Q,S,A,B);
 input S,A,B,PRE,E,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not	INV_369(S_, S);
 UDP_MUX2   U2061(NET_0_2, A, B, S_);

 Dffpf DF_0(Q, NET_0_2,CLK,VCC_0, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, PRE);
      buf U_c2 (Enable2, _E);
      and U_c4 (Enable4, _E, PRE);
       buf U_c6 (Enable5, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge PRE, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFME3A
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _CLR=CLR, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFME3A(CLR, E, CLK, Q,S,A,B);
 input S,A,B,CLR,E,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not	INV_370(S_, S);
 UDP_MUX2   U2065(NET_0_2, A, B, S_);

 Dffpr DF_0(Q, NET_0_2,CLK,CLR, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR);
      and U_c2 (Enable2, _E, CLR);
      buf U_c4 (Enable4, _E);
      buf U_c6 (Enable5, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFME3B
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _CLR=CLR, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFME3B(CLR, E, CLK, Q,S,A,B);
 input S,A,B,CLR,E,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply1 VCC_0;
 reg NOTIFY_REG;

 not	INV_371(S_, S);
 UDP_MUX2   U2069(NET_0_2, A, B, S_);

 Dffpf DF_0(Q, NET_0_2,CLK,CLR, VCC_0, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR);
      and U_c2 (Enable2, _E, CLR);
      buf U_c4 (Enable4, _E);
      buf U_c6 (Enable5, CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFMEG
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _E=E, _CLR=CLR, _PRE=PRE, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFMEG(PRE, CLR, E, CLK, Q,S,A,B);
 input S,A,B,PRE,CLR,E,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 reg NOTIFY_REG;

 not	INV_372(S_, S);
 UDP_MUX2   U2073(NET_0_2, A, B, S_);

 Dffpr DF_0(Q, NET_0_2,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,posedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,posedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFMEH
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _E=E, _CLR=CLR, _PRE=PRE, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFMEH(PRE, CLR, E, CLK, Q,S,A,B);
 input S,A,B,PRE,CLR,E,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 reg NOTIFY_REG;

 not	INV_373(S_, S);
 UDP_MUX2   U2077(NET_0_2, A, B, S_);

 Dffpf DF_0(Q, NET_0_2,CLK,CLR, PRE, E, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      not U_I3 (_E, E);
      and U_c0 (Enable1, _E, CLR, PRE);
      and U_c2 (Enable2, _E, CLR);
      and U_c4 (Enable4, _E, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals

	$setup(posedge E,negedge CLK &&& Enable5,  0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, posedge E,0.0, NOTIFY_REG);
	$setup(negedge E,negedge CLK &&& Enable5, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable5, negedge E,0.0, NOTIFY_REG);

	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFMPCA
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, _CLR=CLR, _PRE=PRE, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFMPCA(PRE, CLR, CLK, Q,S,A,B);
 input S,A,B,PRE,CLR,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply0 GND_0;
 reg NOTIFY_REG;

 not	INV_374(S_, S);
 UDP_MUX2   U2081(NET_0_2, A, B, S_);

 Dffpr DF_0(Q, NET_0_2,CLK,CLR, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, CLR, PRE);
       buf U_c2 (Enable2, CLR);
       buf U_c4 (Enable4, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFMPCB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, _CLR=CLR, _PRE=PRE, D=!S & A + S & B ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFMPCB(PRE, CLR, CLK, Q,S,A,B);
 input S,A,B,PRE,CLR,CLK;
 output Q;
 wire NET_0_0,NET_0_1;
 supply0 GND_0;
 reg NOTIFY_REG;

 not	INV_375(S_, S);
 UDP_MUX2   U2085(NET_0_2, A, B, S_);

 Dffpf DF_0(Q, NET_0_2,CLK,CLR, PRE, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_PRE, PRE);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, CLR, PRE);
       buf U_c2 (Enable2, CLR);
       buf U_c4 (Enable4, PRE);
      and U_c6 (Enable5, CLR, PRE);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_PRE_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_PRE_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +:Q))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(negedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge PRE => (Q +: 1'b1)) = (tpdLH_PRE_to_Q, tpdHL_PRE_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge S,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge S,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge S,0.0, NOTIFY_REG);
	$setup(posedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge A,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge A,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge A,0.0, NOTIFY_REG);
	$setup(posedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge B,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge B,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge B,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK &&& Enable2, posedge PRE,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, posedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(negedge CLR, 0.0, 0, NOTIFY_REG);
	$width(negedge PRE &&& CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(posedge PRE, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(posedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : HCLKMUX
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKMUX(Y,A);
 input A;
 output Y;

 reg NOTIFY_REG;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
                specparam PATHPULSE$A$Y = (0.1, 0.1);
                $width(negedge A, 0.0, 0, NOTIFY_REG);
                $width(posedge A, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOFIFO_INBUF
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOFIFO_INBUF(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOFIFO_OUTBUF
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOFIFO_OUTBUF(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_FCLK_BUFF
 CELL TYPE : comb
 CELL LOGIC : YOUT=A ; CLKOUT =CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_FCLK_BUFF(YOUT,CLKOUT,A,CLK);
 input A,CLK;
 output YOUT,CLKOUT;

 buf	BUF_U_00(YOUT,A);
 buf	BUF_U_01(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdHL_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => YOUT ) = ( tpdLH_A_to_YOUT, tpdHL_A_to_YOUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_OUT_FCLK
 CELL TYPE : comb
 CELL LOGIC : YOUT=A ;CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_OUT_FCLK(YOUT,CLKOUT,A,CLK);
 input A,CLK;
 output YOUT,CLKOUT;

 buf	BUF_U_00(YOUT,A);
 buf	BUF_U_01(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdHL_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => YOUT ) = ( tpdLH_A_to_YOUT, tpdHL_A_to_YOUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_OUT_FCLK_CLR_EN
 CELL TYPE : comb
 CELL LOGIC : YOUT=A ; ENOUT=EN ; CLROUT=CLR ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_OUT_FCLK_CLR_EN(YOUT,ENOUT,CLROUT,CLKOUT,A,EN,CLR,CLK);
 input A,EN,CLR,CLK;
 output YOUT,ENOUT,CLROUT,CLKOUT;

 buf	BUF_U_00(YOUT,A);
 buf	BUF_U_01(ENOUT,EN);
 buf	BUF_U_02(CLROUT,CLR);
 buf	BUF_U_03(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdHL_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLR_to_CLROUT = (0.1:0.1:0.1);
		specparam tpdHL_CLR_to_CLROUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => YOUT ) = ( tpdLH_A_to_YOUT, tpdHL_A_to_YOUT );
		(EN => ENOUT ) = ( tpdLH_EN_to_ENOUT, tpdHL_EN_to_ENOUT );
		(CLR => CLROUT ) = ( tpdLH_CLR_to_CLROUT, tpdHL_CLR_to_CLROUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_OUT_RCLK
 CELL TYPE : comb
 CELL LOGIC : YOUT=A ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_OUT_RCLK(YOUT,CLKOUT,A,CLK);
 input A,CLK;
 output YOUT,CLKOUT;

 buf	BUF_U_00(YOUT,A);
 buf	BUF_U_01(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdHL_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => YOUT ) = ( tpdLH_A_to_YOUT, tpdHL_A_to_YOUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_OUT_RCLK_CLR_EN
 CELL TYPE : comb
 CELL LOGIC : YOUT=A ; ENOUT=EN ; CLROUT=CLR ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_OUT_RCLK_CLR_EN(YOUT,ENOUT,CLROUT,CLKOUT,A,EN,CLR,CLK);
 input A,EN,CLR,CLK;
 output YOUT,ENOUT,CLROUT,CLKOUT;

 buf	BUF_U_00(YOUT,A);
 buf	BUF_U_01(ENOUT,EN);
 buf	BUF_U_02(CLROUT,CLR);
 buf	BUF_U_03(CLKOUT,CLK);

       specify

		specparam tpdLH_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdHL_A_to_YOUT = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLR_to_CLROUT = (0.1:0.1:0.1);
		specparam tpdHL_CLR_to_CLROUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => YOUT ) = ( tpdLH_A_to_YOUT, tpdHL_A_to_YOUT );
		(EN => ENOUT ) = ( tpdLH_EN_to_ENOUT, tpdHL_EN_to_ENOUT );
		(CLR => CLROUT ) = ( tpdLH_CLR_to_CLROUT, tpdHL_CLR_to_CLROUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOOE_FCLK_CLR_EN
 CELL TYPE : comb
 CELL LOGIC : ENOUT=EN ; CLROUT=CLR ; CLKOUT=CLK
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOOE_FCLK_CLR_EN(ENOUT,CLROUT,CLKOUT,EN,CLR,CLK);
 input EN,CLR,CLK;
 output ENOUT,CLROUT,CLKOUT;

 buf	BUF_U_00(ENOUT,EN);
 buf	BUF_U_01(CLROUT,CLR);
 buf	BUF_U_02(CLKOUT,CLK);

       specify

		specparam tpdLH_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_ENOUT = (0.1:0.1:0.1);
		specparam tpdLH_CLR_to_CLROUT = (0.1:0.1:0.1);
		specparam tpdHL_CLR_to_CLROUT = (0.1:0.1:0.1);
		specparam tpdLH_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam tpdHL_CLK_to_CLKOUT = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(EN => ENOUT ) = ( tpdLH_EN_to_ENOUT, tpdHL_EN_to_ENOUT );
		(CLR => CLROUT ) = ( tpdLH_CLR_to_CLROUT, tpdHL_CLR_to_CLROUT );
		(CLK => CLKOUT ) = ( tpdLH_CLK_to_CLKOUT, tpdHL_CLK_to_CLKOUT );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_IN_U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_IN_U(Y,PAD);
 input PAD;
 output Y;

 reg NOTIFY_REG;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_IN_D
 CELL TYPE : comb
 CELL LOGIC : Y#DOWN=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_IN_D(Y,PAD);
 input PAD;
 output Y;

 reg NOTIFY_REG;

 pulldown	DN(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_TRI_U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_TRI_U(PAD,D,E);
 input D,E;
 output PAD;

 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U2089(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_TRI_D
 CELL TYPE : comb
 CELL LOGIC : PAD#DOWN=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_TRI_D(PAD,D,E);
 input D,E;
 output PAD;

 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U2092(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_BI_U
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_BI_U(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 reg NOTIFY_REG;

 tri1 PAD;
 bufif1   U2095(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                specparam PATHPULSE$D$Y = (0.1, 0.1);
                specparam PATHPULSE$E$Y = (0.1, 0.1);
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOPAD_BI_D
 CELL TYPE : comb
 CELL LOGIC : PAD#DOWN=D@E ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPAD_BI_D(Y,D,E,PAD);
 input D,E;
 output Y;
 inout PAD;

 reg NOTIFY_REG;

 tri0 PAD;
 bufif1   U2098(PAD, D, E);
 buf	BUF_U_01(Y,PAD);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
		(D => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(E => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                specparam PATHPULSE$D$Y = (0.1, 0.1);
                specparam PATHPULSE$E$Y = (0.1, 0.1);
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : RCLKMUX
 CELL TYPE : comb
 CELL LOGIC : Y=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module RCLKMUX(Y,A);
 input A;
 output Y;

 reg NOTIFY_REG;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
                specparam PATHPULSE$A$Y = (0.1, 0.1);
                $width(negedge A, 0.0, 0, NOTIFY_REG);
                $width(posedge A, 0.0, 0, NOTIFY_REG);

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_HSTL_I
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_HSTL_I(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U2101(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_SSTL3_I
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_SSTL3_I(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U2104(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_SSTL3_II
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_SSTL3_II(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U2107(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_SSTL2_I
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_SSTL2_I(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U2110(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : TRIBUFF_SSTL2_II
 CELL TYPE : comb
 CELL LOGIC : PAD=D@E
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module TRIBUFF_SSTL2_II(PAD,D,E);
 input D,E;
 output PAD;

 bufif1   U2113(PAD, D, E);

       specify

		specparam tpdLH_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdHL_E_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_E_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_D_to_PAD= (0.1:0.1:0.1);
		specparam tpdHL_D_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~D)
		(E => PAD ) = ( tpdLH_E_to_PAD,tpdHL_E_to_PAD,tpdLZ_E_to_PAD,tpdZH_E_to_PAD,tpdHZ_E_to_PAD,tpdZL_E_to_PAD);

	        (D => PAD ) = ( tpdLH_D_to_PAD,tpdHL_D_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME  : NOR5D
 CELL TYPE  : structure
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR5D(Y,A,B,C,D,E);

 input A,B,C,D,E;
 output Y;



 AND5A U1(. A (E), . B (D), . C (C), . D (B), . E (A), . Y (Y));

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module ADDSUB1(S,FCO,A,FCI,B,AS);
 input A,FCI,B,AS;
 output S,FCO;

   wire NET0,NET1;
  
    XOR2      XR1  (.Y(NET0), .A(B), .B(AS));
    XNOR2     XNR1 (.Y(NET2),.A(A), .B(NET0));
    XOR2      XR2  (.Y(S),.A(NET2), .B(FCI));
    AO13      ao (.Y(FCO),.A(A),.B(FCI),.C(NET0));
 

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME  : NAND5D
 CELL TYPE  : structure
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND5D(Y,A,B,C,D,E);

 input A,B,C,D,E;
 output Y;



 OR5A U1(. A (E), . B (D), . C (C), . D (B), . E (A), . Y (Y));

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : FA1A
 CELL TYPE : comb
 CELL LOGIC : CO=(CI & !B & !A) + (A & !B ) + (B & CI & A) % S=!CI & ( !A & B + A & !B ) + CI & ( !A & !B + A & B )
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FA1A(CO,S,CI,B,A);
 input CI,B,A;
 output CO,S;

     not     NT4    (B_INT, B);
    xnor    XNR1    (S, A, B_INT, CI);
    U_MAJ_3 inst1  (CO, A, B_INT, CI);


        specify
                specparam tpdLH_CI_to_CO = (0.1:0.1:0.1);
                specparam tpdHL_CI_to_CO = (0.1:0.1:0.1);
                specparam tpdLH_B_to_CO = (0.1:0.1:0.1);
                specparam tpdHL_B_to_CO = (0.1:0.1:0.1);
                specparam tpdLH_A_to_CO = (0.1:0.1:0.1);
                specparam tpdHL_A_to_CO = (0.1:0.1:0.1);
                specparam tpdLH_CI_to_S = (0.1:0.1:0.1);
                specparam tpdHL_CI_to_S = (0.1:0.1:0.1);
                specparam tpdLH_A_to_S = (0.1:0.1:0.1);
                specparam tpdHL_A_to_S = (0.1:0.1:0.1);
                specparam tpdLH_B_to_S = (0.1:0.1:0.1);
                specparam tpdHL_B_to_S = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

                (CI => CO ) = ( tpdLH_CI_to_CO, tpdHL_CI_to_CO );
                (B => CO ) = ( tpdLH_B_to_CO, tpdHL_B_to_CO );
                (A => CO ) = ( tpdLH_A_to_CO, tpdHL_A_to_CO );
                (CI => S ) = ( tpdLH_CI_to_S, tpdHL_CI_to_S );
                (A => S ) = ( tpdLH_A_to_S, tpdHL_A_to_S );
                (B => S ) = ( tpdLH_B_to_S, tpdHL_B_to_S );
        endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults





/*--------------------------------------------------------------------
 CELL NAME : FA1B
 CELL TYPE : comb
 CELL LOGIC : CO=!A & (!B + B & CI) + A & (!B & CI) % S=!CI & ( !A & !B + A & B ) + CI & ( !A & B + A & !B )
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FA1B(CO,S,A,B,CI);
 input A,B,CI;
 output CO,S;



    not     NT3    (A_INT, A);
    not     NT4    (B_INT, B);
    xnor    XNR1   (S, A_INT, B_INT, CI);
    U_MAJ_3 inst1  (CO, A_INT, B_INT, CI);



        specify
                specparam tpdLH_A_to_CO = (0.1:0.1:0.1);
                specparam tpdHL_A_to_CO = (0.1:0.1:0.1);
                specparam tpdLH_B_to_CO = (0.1:0.1:0.1);
                specparam tpdHL_B_to_CO = (0.1:0.1:0.1);
                specparam tpdLH_CI_to_CO = (0.1:0.1:0.1);
                specparam tpdHL_CI_to_CO = (0.1:0.1:0.1);
                specparam tpdLH_CI_to_S = (0.1:0.1:0.1);
                specparam tpdHL_CI_to_S = (0.1:0.1:0.1);
                specparam tpdLH_A_to_S = (0.1:0.1:0.1);
                specparam tpdHL_A_to_S = (0.1:0.1:0.1);
                specparam tpdLH_B_to_S = (0.1:0.1:0.1);
                specparam tpdHL_B_to_S = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

                (A => CO ) = ( tpdLH_A_to_CO, tpdHL_A_to_CO );
                (B => CO ) = ( tpdLH_B_to_CO, tpdHL_B_to_CO );
                (CI => CO ) = ( tpdLH_CI_to_CO, tpdHL_CI_to_CO );
                (CI => S ) = ( tpdLH_CI_to_S, tpdHL_CI_to_S );
                (A => S ) = ( tpdLH_A_to_S, tpdHL_A_to_S );
                (B => S ) = ( tpdLH_B_to_S, tpdHL_B_to_S );
        endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : FA2A
 CELL TYPE : comb
 CELL LOGIC : CO=(CI & !B & !(A0+A1)) + (!B & (A0+A1)) + (B & CI & (A0+A1)) % S=!A0 & !A1 & ( !B & CI + B & !CI) + ( !B & !CI + B & CI )
& ( A0 + A1 )
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FA2A(CO,S,CI,B,A0,A1);
 input CI,B,A0,A1;
 output CO,S;



    or      OR1    (A_INT, A0, A1);
    not     NT3    (B_INT, B);
    xnor    XNR1   (S, A_INT, B_INT, CI);
    U_MAJ_3 inst1  (CO, A_INT, B_INT, CI);


        specify
                specparam tpdLH_CI_to_CO = (0.1:0.1:0.1);
                specparam tpdHL_CI_to_CO = (0.1:0.1:0.1);
                specparam tpdLH_B_to_CO = (0.1:0.1:0.1);
                specparam tpdHL_B_to_CO = (0.1:0.1:0.1);
                specparam tpdLH_A0_to_CO = (0.1:0.1:0.1);
                specparam tpdHL_A0_to_CO = (0.1:0.1:0.1);
                specparam tpdLH_A1_to_CO = (0.1:0.1:0.1);
                specparam tpdHL_A1_to_CO = (0.1:0.1:0.1);
                specparam tpdLH_A0_to_S = (0.1:0.1:0.1);
                specparam tpdHL_A0_to_S = (0.1:0.1:0.1);
                specparam tpdLH_A1_to_S = (0.1:0.1:0.1);
                specparam tpdHL_A1_to_S = (0.1:0.1:0.1);
                specparam tpdLH_B_to_S = (0.1:0.1:0.1);
                specparam tpdHL_B_to_S = (0.1:0.1:0.1);
                specparam tpdLH_CI_to_S = (0.1:0.1:0.1);
                specparam tpdHL_CI_to_S = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

                (CI => CO ) = ( tpdLH_CI_to_CO, tpdHL_CI_to_CO );
                (B => CO ) = ( tpdLH_B_to_CO, tpdHL_B_to_CO );
                (A0 => CO ) = ( tpdLH_A0_to_CO, tpdHL_A0_to_CO );
                (A1 => CO ) = ( tpdLH_A1_to_CO, tpdHL_A1_to_CO );
                (A0 => S ) = ( tpdLH_A0_to_S, tpdHL_A0_to_S );
                (A1 => S ) = ( tpdLH_A1_to_S, tpdHL_A1_to_S );
                (B => S ) = ( tpdLH_B_to_S, tpdHL_B_to_S );
                (CI => S ) = ( tpdLH_CI_to_S, tpdHL_CI_to_S );
        endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME  : CLKBUF_LVDS
---------------------------------------------------------------------*/
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVDS (PADP,PADN,Y);
    
    input PADP,PADN;
    output Y;

    reg temp;

    pmos p1(Y,temp,1'b0);
    always @(PADP or PADN) begin

    if((PADP == 1'b1) && (PADN == 1'b0))
       temp = 1'b1;
    else if((PADP == 1'b0) && (PADN == 1'b1))
       temp = 1'b0;
    else
       temp = 1'bx;
    end
 
      
    specify

         specparam   LibName       = "ax";
         specparam   InputLoad$PADP = 0;
         specparam   InputLoad$PADN = 0; 
         specparam   OutputLoad$Y  = 0;

         specparam   MacroType = "clkbuf_lvds";


        (PADP => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	  (PADN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);

    endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : CLKBUF_LVPECL
---------------------------------------------------------------------*/
     
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CLKBUF_LVPECL (PADP,PADN,Y);
    
    input PADP,PADN;
    output Y;
  
    buf b1(Y, PADP);
 
    always @(PADP or PADN) begin
       if (PADP != ~PADN) begin
        $display(" -- Error: two inputs should be complement with each other!\n");
        //$finish;
       end
    end 
      
    specify

         specparam   LibName       = "ax";
         specparam   InputLoad$PADP = 0;
         specparam   InputLoad$PADN = 0; 
         specparam   OutputLoad$Y  = 0;

         specparam   MacroType = "clkbuf_lvpecl";


        (PADP => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	  (PADN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);

    endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : CM8F
 CELL TYPE : comb
 CELL LOGIC : Y = (D0 & !(S00 & S01) + D1 & (S00 & S01)) & !(S10+S11) + (D2 & !(S00 & S01) + D3 & (S00 & S01)) & (S10+S11) % FY =(D0 & !(
S00 & S01) + D1 & (S00 & S01)) & !(S10+S11) + (D2 & !(S00 & S01) + D3 & (S00 & S01)) & (S10+S11)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module CM8F(Y,FY,D0,S00,S01,D1,S10,S11,D2,D3);
 input D0,S00,S01,D1,S10,S11,D2,D3;
 output Y,FY;
 wire NET_0_0, NET_0_1, NET_0_2, NET_0_3, NET_0_4, NET_0_5;
 wire NET_0_6, NET_0_7, NET_0_8, NET_0_9, NET_0_10, NET_0_11, NET_0_12, NET_0_13;
 wire NET_1_0, NET_1_1, NET_1_2, NET_1_3, NET_1_4, NET_1_5;
 wire NET_1_6, NET_1_7, NET_1_8, NET_1_9, NET_1_10, NET_1_11, NET_1_12, NET_1_13;

 UDP_MUX2   U580(NET_0_4, D0, D1, NET_0_0);
 nand     U582(NET_0_0, S00, S01);
 UDP_MUX2   U584(Y, NET_0_4, NET_0_11, NET_0_5);
 nor      U586(NET_0_5, S10, S11);
 UDP_MUX2   U589(NET_0_11, D2, D3, NET_0_7);
 nand     U591(NET_0_7, S00, S01);
 UDP_MUX2   U596(NET_1_4, D0, D1, NET_1_0);
 nand     U598(NET_1_0, S00, S01);
 UDP_MUX2   U600(FY, NET_1_4, NET_1_11, NET_1_5);
 nor      U602(NET_1_5, S10, S11);
 UDP_MUX2   U605(NET_1_11, D2, D3, NET_1_7);
 nand     U607(NET_1_7, S00, S01);
     specify
                specparam tpdLH_D0_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_D0_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_S00_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_S00_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_S01_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_S01_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_D1_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_D1_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_S10_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_S10_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_S11_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_S11_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_D2_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_D2_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_D3_to_Y = (0.1:0.1:0.1);
                specparam tpdHL_D3_to_Y = (0.1:0.1:0.1);
                specparam tpdLH_D0_to_FY = (0.1:0.1:0.1);
                specparam tpdHL_D0_to_FY = (0.1:0.1:0.1);
                specparam tpdLH_S00_to_FY = (0.1:0.1:0.1);
                specparam tpdHL_S00_to_FY = (0.1:0.1:0.1);
                specparam tpdLH_S01_to_FY = (0.1:0.1:0.1);
                specparam tpdHL_S01_to_FY = (0.1:0.1:0.1);
                specparam tpdLH_D1_to_FY = (0.1:0.1:0.1);
                specparam tpdHL_D1_to_FY = (0.1:0.1:0.1);
                specparam tpdLH_S10_to_FY = (0.1:0.1:0.1);
                specparam tpdHL_S10_to_FY = (0.1:0.1:0.1);
                specparam tpdLH_S11_to_FY = (0.1:0.1:0.1);
                specparam tpdHL_S11_to_FY = (0.1:0.1:0.1);
                specparam tpdLH_D2_to_FY = (0.1:0.1:0.1);
                specparam tpdHL_D2_to_FY = (0.1:0.1:0.1);
                specparam tpdLH_D3_to_FY = (0.1:0.1:0.1);
                specparam tpdHL_D3_to_FY = (0.1:0.1:0.1);
                specparam MacroType = "comb";

                //pin to pin path delay

                (D0 => Y ) = ( tpdLH_D0_to_Y, tpdHL_D0_to_Y );
                (S00 => Y ) = ( tpdLH_S00_to_Y, tpdHL_S00_to_Y );
                (S01 => Y ) = ( tpdLH_S01_to_Y, tpdHL_S01_to_Y );
                (D1 => Y ) = ( tpdLH_D1_to_Y, tpdHL_D1_to_Y );
                (S10 => Y ) = ( tpdLH_S10_to_Y, tpdHL_S10_to_Y );
                (S11 => Y ) = ( tpdLH_S11_to_Y, tpdHL_S11_to_Y );
                (D2 => Y ) = ( tpdLH_D2_to_Y, tpdHL_D2_to_Y );
                (D3 => Y ) = ( tpdLH_D3_to_Y, tpdHL_D3_to_Y );
                (D0 => FY ) = ( tpdLH_D0_to_FY, tpdHL_D0_to_FY );
                (S00 => FY ) = ( tpdLH_S00_to_FY, tpdHL_S00_to_FY );
                (S01 => FY ) = ( tpdLH_S01_to_FY, tpdHL_S01_to_FY );
                (D1 => FY ) = ( tpdLH_D1_to_FY, tpdHL_D1_to_FY );
                (S10 => FY ) = ( tpdLH_S10_to_FY, tpdHL_S10_to_FY );
                (S11 => FY ) = ( tpdLH_S11_to_FY, tpdHL_S11_to_FY );
                (D2 => FY ) = ( tpdLH_D2_to_FY, tpdHL_D2_to_FY );
                (D3 => FY ) = ( tpdLH_D3_to_FY, tpdHL_D3_to_FY );
        endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults




/*--------------------------------------------------------------------
 CELL NAME  : FIFO64K36
---------------------------------------------------------------------*/
      

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FIFO64K36 (DEPTH3,DEPTH2,DEPTH1,DEPTH0,WIDTH2,WIDTH1,WIDTH0,AEVAL7,AEVAL6,AEVAL5,AEVAL4,AEVAL3,AEVAL2,AEVAL1,AEVAL0,
                 AFVAL7,AFVAL6,AFVAL5,AFVAL4,AFVAL3,AFVAL2,AFVAL1,AFVAL0,
                 REN,RCLK,WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,
                 WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0,WEN,WCLK,CLR,RD35,RD34,RD33,RD32,RD31,RD30,RD29,
                 RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,
                 RD5,RD4,RD3,RD2,RD1,RD0,FULL,AFULL,EMPTY,AEMPTY);

input DEPTH3,DEPTH2,DEPTH1,DEPTH0,WIDTH2,WIDTH1,WIDTH0;
input AEVAL7,AEVAL6,AEVAL5,AEVAL4,AEVAL3,AEVAL2,AEVAL1,AEVAL0;
input AFVAL7,AFVAL6,AFVAL5,AFVAL4,AFVAL3,AFVAL2,AFVAL1,AFVAL0;
input REN,RCLK;
input WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17;
input WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0;
input CLR;
input WEN,WCLK;
output RD35,RD34,RD33,RD32,RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15;
output RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0;
output FULL,AFULL,EMPTY,AEMPTY;

reg FULL_temp,AFULL_temp,EMPTY_temp,AEMPTY_temp;
reg [35:0] FIFO[0:65535];
reg NOTIFY_REG;
wire WCLK1,RCLK1;
wire  CLR1;
reg wen_int,ren_int;
wire wen_tmp,ren_tmp;
wire AEVAL7P,AEVAL6P,AEVAL5P,AEVAL4P,AEVAL3P,AEVAL2P,AEVAL1P,AEVAL0P;
wire AFVAL7P,AFVAL6P,AFVAL5P,AFVAL4P,AFVAL3P,AFVAL2P,AFVAL1P,AFVAL0P;
reg RCLK1_previous,WCLK1_previous,wen_previous,ren_previous,CLR1_previous;
   
wire wenable, renable;

reg RD35_P,RD34_P,RD33_P,RD32_P,RD31_P,RD30_P,RD29_P,RD28_P,RD27_P,RD26_P,RD25_P,RD24_P,RD23_P,RD22_P,RD21_P,RD20_P,RD19_P;
reg RD18_P,RD17_P,RD16_P,RD15_P,RD14_P,RD13_P,RD12_P,RD11_P,RD10_P,RD9_P,RD8_P,RD7_P,RD6_P,RD5_P,RD4_P,RD3_P,RD2_P,RD1_P,RD0_P;

 /********************* TEXT MACRO DEFINITIONS ******************/

`define DEPTH_CFG_VECTOR        {DEPTH3,DEPTH2,DEPTH1,DEPTH0}
`define WIDTH_CFG_VECTOR        {WIDTH2,WIDTH1,WIDTH0}
`define ALMOST_EMPTY_CFG_VECTOR {AEVAL7P,AEVAL6P,AEVAL5P,AEVAL4P,AEVAL3P,AEVAL2P,AEVAL1P,AEVAL0P}
`define ALMOST_FULL_CFG_VECTOR  {AFVAL7P,AFVAL6P,AFVAL5P,AFVAL4P,AFVAL3P,AFVAL2P,AFVAL1P,AFVAL0P}
`define RDATAP_WIDTH_36         {RD35_P,RD34_P,RD33_P,RD32_P,RD31_P,RD30_P,RD29_P,RD28_P,RD27_P,RD26_P,RD25_P,                                                            RD24_P,RD23_P,RD22_P,RD21_P,RD20_P,RD19_P,RD18_P,RD17_P,RD16_P,RD15_P,RD14_P,                                                             RD13_P,RD12_P,RD11_P,RD10_P,RD9_P,RD8_P,RD7_P,RD6_P,RD5_P,RD4_P,RD3_P,RD2_P,RD1_P,RD0_P} 
`define WDATA_WIDTH_36          {WD35_ipd,WD34_ipd,WD33_ipd,WD32_ipd,WD31_ipd,WD30_ipd,WD29_ipd,WD28_ipd,WD27_ipd,WD26_ipd,WD25_ipd,WD24_ipd,WD23_ipd,WD22_ipd,WD21_ipd,WD20_ipd,WD19_ipd,WD18_ipd,WD17_ipd, WD16_ipd,WD15_ipd,WD14_ipd,WD13_ipd,WD12_ipd,WD11_ipd,WD10_ipd,WD9_ipd,WD8_ipd,WD7_ipd,WD6_ipd,WD5_ipd,WD4_ipd,WD3_ipd,WD2_ipd,WD1_ipd,WD0_ipd}

/********************* END of MACRO DEFINITION ****************/

integer MAX_ADDR;
integer WADDR,WADDR_P1,WADDR_P2, WADDR_wrap;
integer RADDR,RADDR_P1,RADDR_P2, RADDR_wrap;
integer AEVAL;
integer AFVAL;

initial begin
  WADDR = 0;
  RADDR = 0;
  WADDR_P1 =0;
  WADDR_P2 =0;
  RADDR_P1 =0;
  RADDR_P2 =0;
  WADDR_wrap = 0;
  RADDR_wrap = 0;
  EMPTY_temp = 1'b1;
  AEMPTY_temp = 1'b1;
  FULL_temp = 1'b0;
  AFULL_temp = 1'b0;
 end

/*
assign  wen_int = FULL_temp ? 1'b0 : wen_tmp; 
assign  ren_int = EMPTY_temp ? 1'b0 : ren_tmp;
*/


buf  wenU (wen_tmp,WEN);
buf  renU (ren_tmp,REN);

/*assign  wen_int = FULL_temp ? 1'b0 : WEN;
  assign  ren_int = EMPTY_temp ? 1'b0 : WEN;
*/

assign wenable = wen_int && !CLR1;
assign renable = ren_int && !CLR1;


buf  AFU0 (AFVAL0P,AFVAL0);
buf  AFU1 (AFVAL1P,AFVAL1);
buf  AFU2 (AFVAL2P,AFVAL2);
buf  AFU3 (AFVAL3P,AFVAL3);
buf  AFU4 (AFVAL4P,AFVAL4);
buf  AFU5 (AFVAL5P,AFVAL5);
buf  AFU6 (AFVAL6P,AFVAL6);
buf  AFU7 (AFVAL7P,AFVAL7);

buf  AEU0 (AEVAL0P,AEVAL0);
buf  AEU1 (AEVAL1P,AEVAL1);
buf  AEU2 (AEVAL2P,AEVAL2);
buf  AEU3 (AEVAL3P,AEVAL3);
buf  AEU4 (AEVAL4P,AEVAL4);
buf  AEU5 (AEVAL5P,AEVAL5);
buf  AEU6 (AEVAL6P,AEVAL6);
buf  AEU7 (AEVAL7P,AEVAL7);

buf wd0 (WD0_ipd, WD0) ;
buf wd1 (WD1_ipd, WD1) ;  
buf wd2 (WD2_ipd, WD2) ;
buf wd3 (WD3_ipd, WD3) ;
buf wd4 (WD4_ipd, WD4) ;
buf wd5 (WD5_ipd, WD5) ;
buf wd6 (WD6_ipd, WD6) ;
buf wd7 (WD7_ipd, WD7) ;
buf wd8 (WD8_ipd, WD8) ;
buf wd9 (WD9_ipd, WD9) ;
buf wd10 (WD10_ipd, WD10) ;
buf wd11 (WD11_ipd, WD11) ;
buf wd12 (WD12_ipd, WD12) ;
buf wd13 (WD13_ipd, WD13) ;
buf wd14 (WD14_ipd, WD14) ;
buf wd15 (WD15_ipd, WD15) ;
buf wd16 (WD16_ipd, WD16) ;
buf wd17 (WD17_ipd, WD17) ;
buf wd18 (WD18_ipd, WD18) ;
buf wd19 (WD19_ipd, WD19) ;
buf wd20 (WD20_ipd, WD20) ;
buf wd21 (WD21_ipd, WD21) ;
buf wd22 (WD22_ipd, WD22) ;
buf wd23 (WD23_ipd, WD23) ;
buf wd24 (WD24_ipd, WD24) ;
buf wd25 (WD25_ipd, WD25) ;
buf wd26 (WD26_ipd, WD26) ;
buf wd27 (WD27_ipd, WD27) ;
buf wd28 (WD28_ipd, WD28) ;
buf wd29 (WD29_ipd, WD29) ;
buf wd30 (WD30_ipd, WD30) ;
buf wd31 (WD31_ipd, WD31) ;
buf wd32 (WD32_ipd, WD32) ;
buf wd33 (WD33_ipd, WD33) ;
buf wd34 (WD34_ipd, WD34) ;
buf wd35 (WD35_ipd, WD35) ;  

      
pmos p1(EMPTY, EMPTY_temp,0);
pmos p2(AEMPTY,AEMPTY_temp,0);
pmos p3(FULL, FULL_temp,0);
pmos p4(AFULL, AFULL_temp,0);

buf inst1(WCLK1, WCLK);
buf inst2(RCLK1, RCLK);
buf inst100(CLR1,CLR);


pmos inst3(RD35,RD35_P, 0);
pmos inst4(RD34,RD34_P, 0);
pmos inst7(RD33,RD33_P, 0);
pmos inst8(RD32,RD32_P, 0);
pmos inst9(RD31,RD31_P, 0);
pmos inst10(RD30,RD30_P, 0);
pmos inst11(RD29,RD29_P, 0);
pmos inst12(RD28,RD28_P, 0);
pmos inst13(RD27,RD27_P, 0);

pmos inst5(RD26,RD26_P, 0);
pmos inst6(RD25,RD25_P, 0);
pmos inst14(RD24,RD24_P, 0);
pmos inst15(RD23,RD23_P, 0);
pmos inst16(RD22,RD22_P, 0);
pmos inst17(RD21,RD21_P, 0);
pmos inst18(RD20,RD20_P, 0);
pmos inst19(RD19,RD19_P, 0);
pmos inst20(RD18,RD18_P, 0);

pmos inst21(RD17,RD17_P, 0);
pmos inst22(RD16,RD16_P, 0);
pmos inst23(RD15,RD15_P, 0);
pmos inst24(RD14,RD14_P, 0);
pmos inst25(RD13,RD13_P, 0);
pmos inst26(RD12,RD12_P, 0);
pmos inst27(RD11,RD11_P, 0);
pmos inst28(RD10,RD10_P, 0);
pmos inst29(RD9,RD9_P, 0);

pmos inst30(RD8,RD8_P, 0);
pmos inst31(RD7,RD7_P, 0);
pmos inst32(RD6,RD6_P, 0);
pmos inst33(RD5,RD5_P, 0);
pmos inst34(RD4,RD4_P, 0);
pmos inst35(RD3,RD3_P, 0);
pmos inst36(RD2,RD2_P, 0);
pmos inst37(RD1,RD1_P, 0);
pmos inst38(RD0,RD0_P, 0);



always @(WCLK1)
begin
  if(WCLK1 === 1'bx) begin
  if($time > 0) begin
      $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
   end
  end
end

always @(RCLK1)
begin
  if(RCLK1 === 1'bx) begin
  if($time > 0) begin
   $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
   if (REN == 1'b1) begin
      `RDATAP_WIDTH_36 = 36'bx;
   end 
  end 
  end 
end // always @ (RCLK1)   

  always @(CLR1)
      begin
	  if(CLR1 === 1'bx)
	      begin
		  if($time > 0) begin
		      $display("Warning : CLR went unknown at time %0.1f\n",$realtime);
		  end 
	      end 
      end // always @ (CLR1)   


// FIFO WRITE behavior section 

always @(CLR1) begin
 if(CLR1) begin
   WADDR  = 0;
   RADDR  = 0;
   //WADDR_P1 =0;
   //WADDR_P2 =0;
   RADDR_P1 =0;
   RADDR_P2 =0;
   WADDR_wrap = 0;
   RADDR_wrap = 0;
   FULL_temp   = 1'b0;
   AFULL_temp  = 1'b0;
   EMPTY_temp  =1'b1;
   AEMPTY_temp =1'b1;
   `RDATAP_WIDTH_36 = 36'bx;     
  end
end

always @(DEPTH3 or DEPTH2 or DEPTH1 or DEPTH0 or WIDTH2 or WIDTH1 or WIDTH0)
   MAX_ADDR = get_max_address(`DEPTH_CFG_VECTOR,`WIDTH_CFG_VECTOR);

always @(AEVAL7P or AEVAL6P or AEVAL5P or AEVAL4P or AEVAL3P or AEVAL2P or AEVAL1P or AEVAL0P or WIDTH2 or WIDTH1 or WIDTH0)
   AEVAL    = get_Almost_Empty_value( `ALMOST_EMPTY_CFG_VECTOR,`WIDTH_CFG_VECTOR);

always @(AFVAL7P or AFVAL6P or AFVAL5P or AFVAL4P or AFVAL3P or AFVAL2P or AFVAL1P or AFVAL0P or WIDTH2 or WIDTH1 or WIDTH0)
    AFVAL    = get_Almost_Full_value( `ALMOST_FULL_CFG_VECTOR,`WIDTH_CFG_VECTOR);


always@(FULL_temp or wen_tmp)
begin
   if(FULL_temp == 1'b1) begin
      wen_int <= 1'b0;
   end else begin
      wen_int <=wen_tmp;
   end
end

always@(EMPTY_temp or ren_tmp)
begin
   if(EMPTY_temp == 1'b1) begin
      ren_int <= 1'b0;
   end else begin
      ren_int <=ren_tmp;
   end
end

always @(WCLK1)
   WCLK1_previous <= WCLK1;
   
always @(RCLK1)
   RCLK1_previous <= RCLK1;
   
always @(posedge WCLK1 ) begin            // pipeline the read address
  if(WCLK1 == 1'b1 && WCLK1_previous == 1'b0)
     begin
   RADDR_P1 <= RADDR;
   RADDR_P2 <= RADDR_P1;
   if((wen_int == 1'b1) && (CLR1 == 1'b0)) begin
     FIFO[WADDR] <= `WDATA_WIDTH_36;
     if(WADDR <MAX_ADDR-1  ) begin
      WADDR <= WADDR + 1;
    //  WADDR_wrap =0;
     end else begin
      WADDR <=(WADDR +1) % MAX_ADDR;
      WADDR_wrap =1-WADDR_wrap;
     end // else: !if(WADDR <MAX_ADDR-1  )
      wen_previous <= wen_int;      
   end // if ((wen_int == 1'b1) && (CLR1 == 1'b0))
   else if(wen_int === 1'bx && CLR==1'b0 && wen_previous !== 1'bx)
      begin
	 $display("Warning : WEN went unknown at time %0.1f\n",$realtime);
      end // if (wen_int === 1'bx && CLR==1'b0 && wen_previous !== 1'bx)	 	
     end // if (WCLK1 == 1'b1 && WCLK_previous == 1'b0)
end // always @ (posedge WCLK1 )
   

// modeling silicon specification and implementation mis-match, aka, silicon failure
// for EMPTY assertion when CLR goes low with RCLK high
always @(CLR1)
   CLR1_previous <= CLR1;
   
always @(negedge CLR1) begin
  if(RCLK1 && !CLR1 && (CLR1_previous !== 1'bX)) begin
    WADDR_P1 <= 32'h7FFF_FFFF;
    WADDR_P2 <= 32'h7FFF_FFFF;
  end
end

always @(posedge RCLK1 or posedge CLR1) begin            // pipeline the write address
  if(CLR1) begin
    WADDR_P1 <= 0;
    WADDR_P2 <= 0;
  end
  else if(RCLK1 == 1'b1 && RCLK1_previous == 1'b0) begin
    WADDR_P1 <= WADDR;
    WADDR_P2 <= WADDR_P1;
    if((ren_int == 1'b1) && (CLR1 == 1'b0)) begin
      `RDATAP_WIDTH_36 <= FIFO[RADDR];
      if(RADDR < MAX_ADDR-1 ) begin
        //RADDR_wrap =0;
        RADDR <= RADDR + 1;
      end
      else begin
        RADDR <= (RADDR + 1) % MAX_ADDR;
        RADDR_wrap =1-RADDR_wrap;
      end // else: !if(RADDR < MAX_ADDR-1 )
    end // if ((ren_int == 1'b1) && (CLR1 == 1'b0))     
    else if(ren_int === 1'bx && CLR1== 1'b0 && ren_previous !== 1'bx)
       begin
	  $display("Warning : REN went unknown at time %0.1f\n",$realtime);
       end // if (ren_int === 1'bx && CLR1== 1'b0 && ren_previous !== 1'bx)

     ren_previous <= ren_int;     
  end // if (RCLK1 == 1'b1 && RCLK1_previous == 1'b0)   
end // always @ (posedge RCLK1 or posedge CLR1)   

always @(WADDR or RADDR_P2) begin
 if(WADDR   == RADDR_P2 ) begin
   if(RADDR_wrap != WADDR_wrap)
     FULL_temp = 1'b1;
 end else
     FULL_temp = 1'b0;
end

always @(RADDR or WADDR_P2) begin
  if(RADDR == WADDR_P2 ) begin
   if(RADDR_wrap == WADDR_wrap)
     EMPTY_temp = 1'b1;
   else
     EMPTY_temp = 1'b0;
  end else 
     EMPTY_temp = 1'b0;
end

always @(WADDR or RADDR ) begin
  if(WADDR_wrap == RADDR_wrap ) begin
   if((WADDR - RADDR) >=AFVAL )
      AFULL_temp = 1'b1;
   else
      AFULL_temp = 1'b0;

   if((WADDR - RADDR) <= AEVAL)
      AEMPTY_temp = 1'b1;
   else
      AEMPTY_temp = 1'b0;
  end else begin
    if((MAX_ADDR + WADDR - RADDR) >=AFVAL )
      AFULL_temp = 1'b1;
   else
      AFULL_temp = 1'b0;

   if((MAX_ADDR + WADDR - RADDR) <= AEVAL)
      AEMPTY_temp = 1'b1;
   else
      AEMPTY_temp = 1'b0;
  end
end


/*************************** functions definition section*********************/

 // function to get the depth

function integer get_depth;
 input [3:0] DEPTH_cfg;
 begin
  get_depth = DEPTH_cfg[3]*8 + DEPTH_cfg[2]*4 + DEPTH_cfg[1]*2 + DEPTH_cfg[0]*1;
 end
endfunction

// function to get the maximum address

function integer get_max_address;
  input [3:0] DEPTH_cfg;
  input [2:0] WIDTH_cfg;
  integer depth;
  integer WWIDTH,HEIGHT;
  integer max_addr;
  begin
   depth = get_depth(DEPTH_cfg );
   case(WIDTH_cfg)

    3'b000 : begin WWIDTH = 1;
                   HEIGHT = 4096;
             end
    3'b001 : begin WWIDTH = 2;
                   HEIGHT = 2048;
             end
    3'b010 : begin WWIDTH = 4;
                   HEIGHT = 1024;
             end
    3'b011 : begin WWIDTH = 9;
                   HEIGHT = 512;
             end
    3'b100 : begin WWIDTH = 18;
                   HEIGHT = 256;
             end
    3'b101 : begin WWIDTH = 36;
                   HEIGHT = 128;
             end
    default: begin $display("Warning : WIDTH value invalid! at time %d", $time);
                  // $finish;
             end
   endcase
   max_addr = (HEIGHT * (depth +1)) ;
   get_max_address = max_addr;
  end
endfunction

// function to get Almost Empty threshold value

 function integer get_Almost_Empty_value;
  input [7:0] AEmpty_cfg;
  input [2:0] WIDTH_cfg;
  integer temp;
  integer temp2;
  begin
   case(WIDTH_cfg)

    3'b000 : temp = 1;
    3'b001 : temp = 2;
    3'b010 : temp = 4;
    3'b011 : temp = 8;
    3'b100 : temp = 16;
    3'b101 : temp = 32;
    default: begin $display("WARNING : WIDTH value invalid! width = %b",WIDTH_cfg);
             end
   endcase

   temp2 =AEmpty_cfg[7]*128 + AEmpty_cfg[6]*64 + AEmpty_cfg[5]*32 + AEmpty_cfg[4]*16 + AEmpty_cfg[3]*8                                             + AEmpty_cfg[2]*4 + AEmpty_cfg[1]*2 + AEmpty_cfg[0]*1;
   get_Almost_Empty_value =temp2 * (256/temp);
  end
endfunction

// function to get the Almost Full threshold value

 function integer get_Almost_Full_value;
  input [7:0] AFull_cfg;
  input [2:0] WIDTH_cfg;
  integer temp;
  integer temp2;

  begin
   case(WIDTH_cfg)

    3'b000 : temp = 1;
    3'b001 : temp = 2;
    3'b010 : temp = 4;
    3'b011 : temp = 8;
    3'b100 : temp = 16;
    3'b101 : temp = 32;
    default: begin $display("Warning : WIDTH value invalid! at time %d",$time);
                   //$finish;
             end
   endcase

   temp2 = AFull_cfg[7]*128 + AFull_cfg[6]*64 + AFull_cfg[5]*32 + AFull_cfg[4]*16 + AFull_cfg[3]*8                                             + AFull_cfg[2]*4 + AFull_cfg[1]*2 + AFull_cfg[0]*1;
   get_Almost_Full_value = temp2 * (256/temp); 
   end
 endfunction


//========================================================================
//
//   timing check
//
//=======================================================================

specify
      specparam   LibName     = "ax";

      (posedge RCLK => (RD35+:RD35) ) = (0.1:0.1:0.1, 0.1:0.1:0.1); 
      (posedge RCLK => (RD34+:RD34) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD33+:RD33) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD32+:RD32) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD31+:RD31) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD30+:RD30) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD29+:RD29) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD28+:RD28) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD27+:RD27) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (RD26+:RD26) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD25+:RD25) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD24+:RD24) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD23+:RD23) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD22+:RD22) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD21+:RD21) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD20+:RD20) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD19+:RD19) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD18+:RD18) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
 
      (posedge RCLK => (RD17+:RD17) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD16+:RD16) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD15+:RD15) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD14+:RD14) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD13+:RD13) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD12+:RD12) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD11+:RD11) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD10+:RD10) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD9+:RD9) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (RD8+:RD8) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD7+:RD7) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD6+:RD6) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD5+:RD5) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD4+:RD4) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD3+:RD3) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD2+:RD2) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD1+:RD1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD0+:RD0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (EMPTY+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (AEMPTY+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (AFULL+:1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge WCLK => (FULL+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge WCLK => (AFULL+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge WCLK => (AEMPTY+:1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge CLR => (EMPTY+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge CLR => (AEMPTY+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge CLR => (FULL+:1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge CLR => (AFULL+:1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);


      $width(posedge WCLK, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK, 0.0, 0, NOTIFY_REG);

      $setup(posedge WD35, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD35, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD35, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD35, 0.0, NOTIFY_REG);
      $setup(posedge WD34, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD34, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD34, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD34, 0.0, NOTIFY_REG);
      $setup(posedge WD33, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD33, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD33, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD33, 0.0, NOTIFY_REG);
      $setup(posedge WD32, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD32, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD32, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD32, 0.0, NOTIFY_REG);
      $setup(posedge WD31, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD31, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD31, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD31, 0.0, NOTIFY_REG);
      $setup(posedge WD30, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD30, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD30, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD30, 0.0, NOTIFY_REG);
      $setup(posedge WD29, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD29, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD29, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD29, 0.0, NOTIFY_REG);
      $setup(posedge WD28, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD28, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD28, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD28, 0.0, NOTIFY_REG);
      $setup(posedge WD27, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD27, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD27, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD27, 0.0, NOTIFY_REG);
      $setup(posedge WD26, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD26, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD26, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD26, 0.0, NOTIFY_REG);
      $setup(posedge WD25, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD25, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD25, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD25, 0.0, NOTIFY_REG);
      $setup(posedge WD24, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD24, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD24, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD24, 0.0, NOTIFY_REG);
      $setup(posedge WD23, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD23, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD23, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD23, 0.0, NOTIFY_REG);
      $setup(posedge WD22, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD22, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD22, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD22, 0.0, NOTIFY_REG);
      $setup(posedge WD21, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD21, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD21, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD21, 0.0, NOTIFY_REG);
      $setup(posedge WD20, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD20, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD20, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD20, 0.0, NOTIFY_REG);
      $setup(posedge WD19, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD19, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD19, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD19, 0.0, NOTIFY_REG);
      $setup(posedge WD18, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD18, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD18, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD18, 0.0, NOTIFY_REG);
      $setup(posedge WD17, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD17, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD17, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD17, 0.0, NOTIFY_REG);
      $setup(posedge WD16, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD16, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD16, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD16, 0.0, NOTIFY_REG);
      $setup(posedge WD15, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD15, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD15, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD15, 0.0, NOTIFY_REG);
      $setup(posedge WD14, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD14, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD14, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD14, 0.0, NOTIFY_REG);
      $setup(posedge WD13, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD13, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD13, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD13, 0.0, NOTIFY_REG);
      $setup(posedge WD12, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD12, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD12, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD12, 0.0, NOTIFY_REG);
      $setup(posedge WD11, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD11, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD11, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD11, 0.0, NOTIFY_REG);
      $setup(posedge WD10, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD10, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD10, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD10, 0.0, NOTIFY_REG);
      $setup(posedge WD9, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD9, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD9, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD9, 0.0, NOTIFY_REG);
      $setup(posedge WD8, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD8, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD8, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD8, 0.0, NOTIFY_REG);
      $setup(posedge WD7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD7, 0.0, NOTIFY_REG);
      $setup(posedge WD6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD6, 0.0, NOTIFY_REG);
      $setup(posedge WD5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD5, 0.0, NOTIFY_REG);
      $setup(posedge WD4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD4, 0.0, NOTIFY_REG);
      $setup(posedge WD3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD3, 0.0, NOTIFY_REG);
      $setup(posedge WD2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD2, 0.0, NOTIFY_REG);
      $setup(posedge WD1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD1, 0.0, NOTIFY_REG);
      $setup(posedge WD0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge WD0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge WD0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD0, 0.0, NOTIFY_REG);




      $setup(posedge DEPTH3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge DEPTH3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge DEPTH3, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge DEPTH2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge DEPTH2, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge DEPTH1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge DEPTH1, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge DEPTH0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge DEPTH0, 0.0, NOTIFY_REG);

      $setup(posedge DEPTH3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge DEPTH3, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge DEPTH3, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge DEPTH2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge DEPTH2, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge DEPTH1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge DEPTH1, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge DEPTH0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge DEPTH0, 0.0, NOTIFY_REG);



      $setup(posedge AEVAL7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL7, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL6, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL5, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL4, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL3, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL2, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL1, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL0, 0.0, NOTIFY_REG);

      $setup(posedge AEVAL7, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL7, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL7, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL7, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL6, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL6, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL6, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL6, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL5, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL5, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL5, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL5, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL4, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL4, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL4, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL4, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL3, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL3, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL2, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL1, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL0, 0.0, NOTIFY_REG);


      $setup(posedge AFVAL7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL7, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL6, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL5, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL4, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL3, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL2, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL1, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL0, 0.0, NOTIFY_REG);

      $setup(posedge AFVAL7, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL7, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL7, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL7, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL6, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL6, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL6, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL6, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL5, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL5, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL5, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL5, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL4, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL4, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL4, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL4, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL3, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL3, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL2, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL1, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL0, 0.0, NOTIFY_REG);



      $setup(posedge WIDTH2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge WIDTH2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WIDTH2, 0.0, NOTIFY_REG);
      $setup(posedge WIDTH1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge WIDTH1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WIDTH1, 0.0, NOTIFY_REG);
      $setup(posedge WIDTH0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge WIDTH0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WIDTH0, 0.0, NOTIFY_REG);

      $setup(posedge WIDTH2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge WIDTH2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge WIDTH2, 0.0, NOTIFY_REG);
      $setup(posedge WIDTH1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge WIDTH1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge WIDTH1, 0.0, NOTIFY_REG);
      $setup(posedge WIDTH0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge WIDTH0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge WIDTH0, 0.0, NOTIFY_REG);


      $setup(posedge REN, posedge RCLK &&& ~CLR1, 0.0, NOTIFY_REG);
      $setup(negedge REN, posedge RCLK &&& ~CLR1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& ~CLR1, posedge REN, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& ~CLR1, negedge REN, 0.0, NOTIFY_REG);

      $setup(posedge WEN, posedge WCLK &&& ~CLR1, 0.0, NOTIFY_REG);
      $setup(negedge WEN, posedge WCLK &&& ~CLR1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& ~CLR1, posedge WEN, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& ~CLR1, negedge WEN, 0.0, NOTIFY_REG);

      $recovery(posedge CLR, posedge WCLK, 0.0, NOTIFY_REG);
      $recovery(posedge CLR, posedge RCLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, posedge CLR, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, posedge CLR, 0.0, NOTIFY_REG);
 
 endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME  : FIFO64K36P
---------------------------------------------------------------------*/
      

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module FIFO64K36P (DEPTH3,DEPTH2,DEPTH1,DEPTH0,WIDTH2,WIDTH1,WIDTH0,AEVAL7,AEVAL6,AEVAL5,AEVAL4,AEVAL3,AEVAL2,AEVAL1,AEVAL0,
                 AFVAL7,AFVAL6,AFVAL5,AFVAL4,AFVAL3,AFVAL2,AFVAL1,AFVAL0,
                 REN,RCLK,WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,
                 WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0,WEN,WCLK,CLR,RD35,RD34,RD33,RD32,RD31,RD30,RD29,
                 RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,
                 RD5,RD4,RD3,RD2,RD1,RD0,FULL,AFULL,EMPTY,AEMPTY);

input DEPTH3,DEPTH2,DEPTH1,DEPTH0,WIDTH2,WIDTH1,WIDTH0;
input AEVAL7,AEVAL6,AEVAL5,AEVAL4,AEVAL3,AEVAL2,AEVAL1,AEVAL0;
input AFVAL7,AFVAL6,AFVAL5,AFVAL4,AFVAL3,AFVAL2,AFVAL1,AFVAL0;
input REN,RCLK;
input WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17;
input WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0;
input CLR;
input WEN,WCLK;
output RD35,RD34,RD33,RD32,RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15;
output RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0;
output FULL,AFULL,EMPTY,AEMPTY;

reg FULL_temp,AFULL_temp,EMPTY_temp,AEMPTY_temp;
reg [35:0] FIFO[0:65535];
reg NOTIFY_REG;
wire WCLK1,RCLK1;
wire  CLR1;
reg wen_int,ren_int;
wire wen_tmp,ren_tmp;
wire AEVAL7P,AEVAL6P,AEVAL5P,AEVAL4P,AEVAL3P,AEVAL2P,AEVAL1P,AEVAL0P;
wire AFVAL7P,AFVAL6P,AFVAL5P,AFVAL4P,AFVAL3P,AFVAL2P,AFVAL1P,AFVAL0P;
reg RCLK1_previous,WCLK1_previous,wen_previous,ren_previous,CLR1_previous;
   
wire wenable, renable;

reg RD35_P,RD34_P,RD33_P,RD32_P,RD31_P,RD30_P,RD29_P,RD28_P,RD27_P,RD26_P,RD25_P,RD24_P,RD23_P,RD22_P,RD21_P,RD20_P,RD19_P;
reg RD18_P,RD17_P,RD16_P,RD15_P,RD14_P,RD13_P,RD12_P,RD11_P,RD10_P,RD9_P,RD8_P,RD7_P,RD6_P,RD5_P,RD4_P,RD3_P,RD2_P,RD1_P,RD0_P;

reg RD35P,RD34P,RD33P,RD32P,RD31P,RD30P,RD29P,RD28P,RD27P,RD26P,RD25P,RD24P,RD23P,RD22P,RD21P,RD20P,RD19P;
reg RD18P,RD17P,RD16P,RD15P,RD14P,RD13P,RD12P,RD11P,RD10P,RD9P,RD8P,RD7P,RD6P,RD5P,RD4P,RD3P,RD2P,RD1P,RD0P;

 /********************* TEXT MACRO DEFINITIONS ******************/

`define DEPTH_CFG_VECTOR        {DEPTH3,DEPTH2,DEPTH1,DEPTH0}
`define WIDTH_CFG_VECTOR        {WIDTH2,WIDTH1,WIDTH0}
`define ALMOST_EMPTY_CFG_VECTOR {AEVAL7P,AEVAL6P,AEVAL5P,AEVAL4P,AEVAL3P,AEVAL2P,AEVAL1P,AEVAL0P}
`define ALMOST_FULL_CFG_VECTOR  {AFVAL7P,AFVAL6P,AFVAL5P,AFVAL4P,AFVAL3P,AFVAL2P,AFVAL1P,AFVAL0P}
`define RDATAP_WIDTH_36         {RD35_P,RD34_P,RD33_P,RD32_P,RD31_P,RD30_P,RD29_P,RD28_P,RD27_P,RD26_P,RD25_P,                                                            RD24_P,RD23_P,RD22_P,RD21_P,RD20_P,RD19_P,RD18_P,RD17_P,RD16_P,RD15_P,RD14_P,                                                             RD13_P,RD12_P,RD11_P,RD10_P,RD9_P,RD8_P,RD7_P,RD6_P,RD5_P,RD4_P,RD3_P,RD2_P,RD1_P,RD0_P} 
`define RDATA_WIDTH_36          {RD35P,RD34P,RD33P,RD32P,RD31P,RD30P,RD29P,RD28P,RD27P,RD26P,RD25P,                                                                                           RD24P,RD23P,RD22P,RD21P,RD20P,RD19P,RD18P,RD17P,RD16P,RD15P,RD14P,                                                                                           RD13P,RD12P,RD11P,RD10P,RD9P,RD8P,RD7P,RD6P,RD5P,RD4P,RD3P,RD2P,RD1P,RD0P} 
`define WDATA_WIDTH_36          {WD35_ipd,WD34_ipd,WD33_ipd,WD32_ipd,WD31_ipd,WD30_ipd,WD29_ipd,WD28_ipd,WD27_ipd,WD26_ipd,WD25_ipd,WD24_ipd,WD23_ipd,WD22_ipd,WD21_ipd,WD20_ipd,WD19_ipd,WD18_ipd,WD17_ipd, WD16_ipd,WD15_ipd,WD14_ipd,WD13_ipd,WD12_ipd,WD11_ipd,WD10_ipd,WD9_ipd,WD8_ipd,WD7_ipd,WD6_ipd,WD5_ipd,WD4_ipd,WD3_ipd,WD2_ipd,WD1_ipd,WD0_ipd}

/********************* END of MACRO DEFINITION ****************/

integer MAX_ADDR;
integer WADDR,WADDR_P1,WADDR_P2, WADDR_wrap;
integer RADDR,RADDR_P1,RADDR_P2, RADDR_wrap;
integer AEVAL;
integer AFVAL;

initial begin
  WADDR = 0;
  RADDR = 0;
  WADDR_P1 =0;
  WADDR_P2 =0;
  RADDR_P1 =0;
  RADDR_P2 =0;
  WADDR_wrap = 0;
  RADDR_wrap = 0;
  EMPTY_temp = 1'b1;
  AEMPTY_temp = 1'b1;
  FULL_temp = 1'b0;
  AFULL_temp = 1'b0;
 end

/*
assign  wen_int = FULL_temp ? 1'b0 : WEN; 
assign  ren_int = EMPTY_temp ? 1'b0 : REN;
*/


buf  wenU (wen_tmp,WEN);
buf  renU (ren_tmp,REN);

/*assign  wen_int = FULL_temp ? 1'b0 : wen_tmp;
  assign  ren_int = EMPTY_temp ? 1'b0 : wen_tmp;
*/

assign wenable = wen_int && !CLR1;
assign renable = ren_int && !CLR1;


buf  AFU0 (AFVAL0P,AFVAL0);
buf  AFU1 (AFVAL1P,AFVAL1);
buf  AFU2 (AFVAL2P,AFVAL2);
buf  AFU3 (AFVAL3P,AFVAL3);
buf  AFU4 (AFVAL4P,AFVAL4);
buf  AFU5 (AFVAL5P,AFVAL5);
buf  AFU6 (AFVAL6P,AFVAL6);
buf  AFU7 (AFVAL7P,AFVAL7);

buf  AEU0 (AEVAL0P,AEVAL0);
buf  AEU1 (AEVAL1P,AEVAL1);
buf  AEU2 (AEVAL2P,AEVAL2);
buf  AEU3 (AEVAL3P,AEVAL3);
buf  AEU4 (AEVAL4P,AEVAL4);
buf  AEU5 (AEVAL5P,AEVAL5);
buf  AEU6 (AEVAL6P,AEVAL6);
buf  AEU7 (AEVAL7P,AEVAL7);

buf wd0 (WD0_ipd, WD0) ;
buf wd1 (WD1_ipd, WD1) ;  
buf wd2 (WD2_ipd, WD2) ;
buf wd3 (WD3_ipd, WD3) ;
buf wd4 (WD4_ipd, WD4) ;
buf wd5 (WD5_ipd, WD5) ;
buf wd6 (WD6_ipd, WD6) ;
buf wd7 (WD7_ipd, WD7) ;
buf wd8 (WD8_ipd, WD8) ;
buf wd9 (WD9_ipd, WD9) ;
buf wd10 (WD10_ipd, WD10) ;
buf wd11 (WD11_ipd, WD11) ;
buf wd12 (WD12_ipd, WD12) ;
buf wd13 (WD13_ipd, WD13) ;
buf wd14 (WD14_ipd, WD14) ;
buf wd15 (WD15_ipd, WD15) ;
buf wd16 (WD16_ipd, WD16) ;
buf wd17 (WD17_ipd, WD17) ;
buf wd18 (WD18_ipd, WD18) ;
buf wd19 (WD19_ipd, WD19) ;
buf wd20 (WD20_ipd, WD20) ;
buf wd21 (WD21_ipd, WD21) ;
buf wd22 (WD22_ipd, WD22) ;
buf wd23 (WD23_ipd, WD23) ;
buf wd24 (WD24_ipd, WD24) ;
buf wd25 (WD25_ipd, WD25) ;
buf wd26 (WD26_ipd, WD26) ;
buf wd27 (WD27_ipd, WD27) ;
buf wd28 (WD28_ipd, WD28) ;
buf wd29 (WD29_ipd, WD29) ;
buf wd30 (WD30_ipd, WD30) ;
buf wd31 (WD31_ipd, WD31) ;
buf wd32 (WD32_ipd, WD32) ;
buf wd33 (WD33_ipd, WD33) ;
buf wd34 (WD34_ipd, WD34) ;
buf wd35 (WD35_ipd, WD35) ;  

pmos p1(EMPTY, EMPTY_temp,0);
pmos p2(AEMPTY,AEMPTY_temp,0);
pmos p3(FULL, FULL_temp,0);
pmos p4(AFULL, AFULL_temp,0);

buf inst1(WCLK1, WCLK);
buf inst2(RCLK1, RCLK);
buf inst100(CLR1,CLR);


pmos inst3(RD35,RD35_P, 0);
pmos inst4(RD34,RD34_P, 0);
pmos inst7(RD33,RD33_P, 0);
pmos inst8(RD32,RD32_P, 0);
pmos inst9(RD31,RD31_P, 0);
pmos inst10(RD30,RD30_P, 0);
pmos inst11(RD29,RD29_P, 0);
pmos inst12(RD28,RD28_P, 0);
pmos inst13(RD27,RD27_P, 0);

pmos inst5(RD26,RD26_P, 0);
pmos inst6(RD25,RD25_P, 0);
pmos inst14(RD24,RD24_P, 0);
pmos inst15(RD23,RD23_P, 0);
pmos inst16(RD22,RD22_P, 0);
pmos inst17(RD21,RD21_P, 0);
pmos inst18(RD20,RD20_P, 0);
pmos inst19(RD19,RD19_P, 0);
pmos inst20(RD18,RD18_P, 0);

pmos inst21(RD17,RD17_P, 0);
pmos inst22(RD16,RD16_P, 0);
pmos inst23(RD15,RD15_P, 0);
pmos inst24(RD14,RD14_P, 0);
pmos inst25(RD13,RD13_P, 0);
pmos inst26(RD12,RD12_P, 0);
pmos inst27(RD11,RD11_P, 0);
pmos inst28(RD10,RD10_P, 0);
pmos inst29(RD9,RD9_P, 0);

pmos inst30(RD8,RD8_P, 0);
pmos inst31(RD7,RD7_P, 0);
pmos inst32(RD6,RD6_P, 0);
pmos inst33(RD5,RD5_P, 0);
pmos inst34(RD4,RD4_P, 0);
pmos inst35(RD3,RD3_P, 0);
pmos inst36(RD2,RD2_P, 0);
pmos inst37(RD1,RD1_P, 0);
pmos inst38(RD0,RD0_P, 0);



always @(WCLK1)
   begin
      if(WCLK1 === 1'bx) begin
  if($time > 0) begin
      $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
   end
  end
end

  always @(RCLK1)
      begin
	  if(RCLK1 === 1'bx) begin
	      if($time > 0) begin
		  $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
		  `RDATAP_WIDTH_36 = 36'bx;
		  if (REN == 1'b1) begin
		      `RDATA_WIDTH_36 = 36'bx;
		  end 
	      end 
	  end 
      end // always @ (RCLK1)         
   
always @(CLR1)
   begin
      if(CLR1 === 1'bx) begin
  if($time > 0) begin
      $display("Warning : CLR went unknown at time %0.1f\n",$realtime);
   end
      end 
   end // always @ (CLR1)
   


// FIFO WRITE behavior section 

  always @(CLR1) begin
      if(CLR1) begin
	  WADDR  = 0;
	  RADDR  = 0;
	  //WADDR_P1 =0;
	  //WADDR_P2 =0;
	  RADDR_P1 =0;
	  RADDR_P2 =0;
	  WADDR_wrap = 0;
	  RADDR_wrap = 0;
	  FULL_temp   = 1'b0;
	  AFULL_temp  = 1'b0;
	  EMPTY_temp  =1'b1;
	  AEMPTY_temp =1'b1;
	  `RDATA_WIDTH_36 = 36'bx;
	  
      end
  end

always @(DEPTH3 or DEPTH2 or DEPTH1 or DEPTH0 or WIDTH2 or WIDTH1 or WIDTH0)
   MAX_ADDR = get_max_address(`DEPTH_CFG_VECTOR,`WIDTH_CFG_VECTOR);

always @(AEVAL7P or AEVAL6P or AEVAL5P or AEVAL4P or AEVAL3P or AEVAL2P or AEVAL1P or AEVAL0P or WIDTH2 or WIDTH1 or WIDTH0)
   AEVAL    = get_Almost_Empty_value( `ALMOST_EMPTY_CFG_VECTOR,`WIDTH_CFG_VECTOR);

always @(AFVAL7P or AFVAL6P or AFVAL5P or AFVAL4P or AFVAL3P or AFVAL2P or AFVAL1P or AFVAL0P or WIDTH2 or WIDTH1 or WIDTH0)
    AFVAL    = get_Almost_Full_value( `ALMOST_FULL_CFG_VECTOR,`WIDTH_CFG_VECTOR);


always@(FULL_temp or wen_tmp)
begin
   if(FULL_temp == 1'b1) begin
      wen_int <= 1'b0;
   end else begin
      wen_int <=wen_tmp;
   end
end

always@(EMPTY_temp or ren_tmp)
begin
   if(EMPTY_temp == 1'b1) begin
      ren_int <= 1'b0;
   end else begin
      ren_int <=ren_tmp;
   end
end

always @(WCLK1)
   WCLK1_previous <= WCLK1;
   
always @(RCLK1)
   RCLK1_previous <= RCLK1;

always @(posedge WCLK1 ) begin            // pipeline the read address
  if(WCLK1 == 1'b1 && WCLK1_previous == 1'b0)
     begin
   RADDR_P1 <= RADDR;
   RADDR_P2 <= RADDR_P1;
   if((wen_int == 1'b1) && (CLR1 == 1'b0)) begin
     FIFO[WADDR] <= `WDATA_WIDTH_36;
     if(WADDR <MAX_ADDR-1  ) begin
      WADDR <= WADDR + 1;
    //  WADDR_wrap =0;
     end else begin
      WADDR <=(WADDR +1) % MAX_ADDR;
      WADDR_wrap =1-WADDR_wrap;
     end // else: !if(WADDR <MAX_ADDR-1  )
      wen_previous <= wen_int;      
   end // if ((wen_int == 1'b1) && (CLR1 == 1'b0))
   else if(wen_int === 1'bx && CLR==1'b0 && wen_previous !== 1'bx)
      begin
	 $display("Warning : WEN went unknown at time %0.1f\n",$realtime);
      end // if (wen_int === 1'bx && CLR==1'b0 && wen_previous !== 1'bx)	 	
     end // if (WCLK1 == 1'b1 && WCLK_previous == 1'b0)
end // always @ (posedge WCLK1 )   


// modeling silicon specification and implementation mis-match, aka, silicon failure
// for EMPTY assertion when CLR goes low with RCLK high

always @(CLR1)
   CLR1_previous <= CLR1;   
   
always @(negedge CLR1) begin
  if(RCLK1 && !CLR1 && (CLR1_previous !== 1'bX)) begin
    WADDR_P1 <= 32'h7FFF_FFFF;
    WADDR_P2 <= 32'h7FFF_FFFF;
  end
end


// pipeline read data

always @(posedge RCLK1) begin
   if(RCLK1 == 1'b1 && RCLK1_previous == 1'b0)
      `RDATAP_WIDTH_36 <= `RDATA_WIDTH_36;  
end

always @(posedge RCLK1 or posedge CLR1) begin            // pipeline the write address
  if(CLR1) begin
    WADDR_P1 <= 0;
    WADDR_P2 <= 0;
  end
  else if(RCLK1 == 1'b1 && RCLK1_previous == 1'b0) begin
    WADDR_P1 <= WADDR;
    WADDR_P2 <= WADDR_P1;
    if((ren_int == 1'b1) && (CLR1 == 1'b0)) begin
      `RDATA_WIDTH_36 <= FIFO[RADDR];
      if(RADDR < MAX_ADDR-1 ) begin
        //RADDR_wrap =0;
        RADDR <= RADDR + 1;
      end
      else begin
        RADDR <= (RADDR + 1) % MAX_ADDR;
        RADDR_wrap =1-RADDR_wrap;
      end // else: !if(RADDR < MAX_ADDR-1 )       
    end // if ((ren_int == 1'b1) && (CLR1 == 1'b0))
    else if(ren_int === 1'bx && CLR1== 1'b0 && ren_previous !== 1'bx)
       begin
	  $display("Warning : REN went unknown at time %0.1f\n",$realtime);
       end // if (ren_int === 1'bx && CLR1== 1'b0 && ren_previous !== 1'bx)

      ren_previous <= ren_int;
  end // if (RCLK1 == 1'b1 && RCLK1_previous == 1'b0)   
end // always @ (posedge RCLK1 or posedge CLR1)   

always @(WADDR or RADDR_P2) begin
 if(WADDR   == RADDR_P2 ) begin
   if(RADDR_wrap != WADDR_wrap)
     FULL_temp = 1'b1;
 end else
     FULL_temp = 1'b0;
end

always @(RADDR or WADDR_P2) begin
  if(RADDR == WADDR_P2 ) begin
   if(RADDR_wrap == WADDR_wrap)
     EMPTY_temp = 1'b1;
   else
     EMPTY_temp = 1'b0;
  end else 
     EMPTY_temp = 1'b0;
end

always @(WADDR or RADDR ) begin
  if(WADDR_wrap == RADDR_wrap ) begin
   if((WADDR - RADDR) >=AFVAL )
      AFULL_temp = 1'b1;
   else
      AFULL_temp = 1'b0;

   if((WADDR - RADDR) <= AEVAL)
      AEMPTY_temp = 1'b1;
   else
      AEMPTY_temp = 1'b0;
  end else begin
    if((MAX_ADDR + WADDR - RADDR) >=AFVAL )
      AFULL_temp = 1'b1;
   else
      AFULL_temp = 1'b0;

   if((MAX_ADDR + WADDR - RADDR) <= AEVAL)
      AEMPTY_temp = 1'b1;
   else
      AEMPTY_temp = 1'b0;
  end
end


/*************************** functions definition section*********************/

 // function to get the depth

function integer get_depth;
 input [3:0] DEPTH_cfg;
 begin
  get_depth = DEPTH_cfg[3]*8 + DEPTH_cfg[2]*4 + DEPTH_cfg[1]*2 + DEPTH_cfg[0]*1;
 end
endfunction

// function to get the maximum address

function integer get_max_address;
  input [3:0] DEPTH_cfg;
  input [2:0] WIDTH_cfg;
  integer depth;
  integer WWIDTH,HEIGHT;
  integer max_addr;
  begin
   depth = get_depth(DEPTH_cfg );
   case(WIDTH_cfg)

    3'b000 : begin WWIDTH = 1;
                   HEIGHT = 4096;
             end
    3'b001 : begin WWIDTH = 2;
                   HEIGHT = 2048;
             end
    3'b010 : begin WWIDTH = 4;
                   HEIGHT = 1024;
             end
    3'b011 : begin WWIDTH = 9;
                   HEIGHT = 512;
             end
    3'b100 : begin WWIDTH = 18;
                   HEIGHT = 256;
             end
    3'b101 : begin WWIDTH = 36;
                   HEIGHT = 128;
             end
    default: begin $display("Warning : WIDTH value invalid! at time %d", $time);
                  // $finish;
             end
   endcase
   max_addr = (HEIGHT * (depth +1)) ;
   get_max_address = max_addr;
  end
endfunction

// function to get Almost Empty threshold value

 function integer get_Almost_Empty_value;
  input [7:0] AEmpty_cfg;
  input [2:0] WIDTH_cfg;
  integer temp;
  integer temp2;
  begin
   case(WIDTH_cfg)

    3'b000 : temp = 1;
    3'b001 : temp = 2;
    3'b010 : temp = 4;
    3'b011 : temp = 8;
    3'b100 : temp = 16;
    3'b101 : temp = 32;
    default: begin $display("WARNING : WIDTH value invalid! width = %b",WIDTH_cfg);
             end
   endcase

   temp2 =AEmpty_cfg[7]*128 + AEmpty_cfg[6]*64 + AEmpty_cfg[5]*32 + AEmpty_cfg[4]*16 + AEmpty_cfg[3]*8                                             + AEmpty_cfg[2]*4 + AEmpty_cfg[1]*2 + AEmpty_cfg[0]*1;
   get_Almost_Empty_value =temp2 * (256/temp);
  end
endfunction

// function to get the Almost Full threshold value

 function integer get_Almost_Full_value;
  input [7:0] AFull_cfg;
  input [2:0] WIDTH_cfg;
  integer temp;
  integer temp2;

  begin
   case(WIDTH_cfg)

    3'b000 : temp = 1;
    3'b001 : temp = 2;
    3'b010 : temp = 4;
    3'b011 : temp = 8;
    3'b100 : temp = 16;
    3'b101 : temp = 32;
    default: begin $display("Warning : WIDTH value invalid! at time %d",$time);
                   //$finish;
             end
   endcase

   temp2 = AFull_cfg[7]*128 + AFull_cfg[6]*64 + AFull_cfg[5]*32 + AFull_cfg[4]*16 + AFull_cfg[3]*8                                             + AFull_cfg[2]*4 + AFull_cfg[1]*2 + AFull_cfg[0]*1;
   get_Almost_Full_value = temp2 * (256/temp); 
   end
 endfunction


//========================================================================
//
//   timing check
//
//=======================================================================

specify
      specparam   LibName     = "ax";

      (posedge RCLK => (RD35+:RD35) ) = (0.1:0.1:0.1, 0.1:0.1:0.1); 
      (posedge RCLK => (RD34+:RD34) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD33+:RD33) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD32+:RD32) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD31+:RD31) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD30+:RD30) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD29+:RD29) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD28+:RD28) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD27+:RD27) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (RD26+:RD26) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD25+:RD25) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD24+:RD24) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD23+:RD23) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD22+:RD22) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD21+:RD21) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD20+:RD20) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD19+:RD19) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD18+:RD18) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
 
      (posedge RCLK => (RD17+:RD17) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD16+:RD16) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD15+:RD15) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD14+:RD14) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD13+:RD13) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD12+:RD12) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD11+:RD11) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD10+:RD10) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD9+:RD9) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (RD8+:RD8) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD7+:RD7) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD6+:RD6) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD5+:RD5) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD4+:RD4) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD3+:RD3) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD2+:RD2) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD1+:RD1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD0+:RD0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (EMPTY+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (AEMPTY+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (AFULL+:1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    
      (posedge WCLK => (FULL+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge WCLK => (AFULL+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge WCLK => (AEMPTY+:1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge CLR => (EMPTY+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge CLR => (AEMPTY+:1'b1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge CLR => (FULL+:1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge CLR => (AFULL+:1'b0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);


      $width(posedge WCLK, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK, 0.0, 0, NOTIFY_REG);

      $setup(posedge WD35, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD35, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD35, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD35, 0.0, NOTIFY_REG);
      $setup(posedge WD34, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD34, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD34, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD34, 0.0, NOTIFY_REG);
      $setup(posedge WD33, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD33, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD33, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD33, 0.0, NOTIFY_REG);
      $setup(posedge WD32, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD32, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD32, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD32, 0.0, NOTIFY_REG);
      $setup(posedge WD31, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD31, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD31, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD31, 0.0, NOTIFY_REG);
      $setup(posedge WD30, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD30, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD30, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD30, 0.0, NOTIFY_REG);
      $setup(posedge WD29, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD29, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD29, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD29, 0.0, NOTIFY_REG);
      $setup(posedge WD28, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD28, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD28, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD28, 0.0, NOTIFY_REG);
      $setup(posedge WD27, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD27, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD27, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD27, 0.0, NOTIFY_REG);
      $setup(posedge WD26, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD26, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD26, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD26, 0.0, NOTIFY_REG);
      $setup(posedge WD25, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD25, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD25, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD25, 0.0, NOTIFY_REG);
      $setup(posedge WD24, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD24, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD24, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD24, 0.0, NOTIFY_REG);
      $setup(posedge WD23, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD23, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD23, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD23, 0.0, NOTIFY_REG);
      $setup(posedge WD22, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD22, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD22, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD22, 0.0, NOTIFY_REG);
      $setup(posedge WD21, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD21, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD21, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD21, 0.0, NOTIFY_REG);
      $setup(posedge WD20, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD20, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD20, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD20, 0.0, NOTIFY_REG);
      $setup(posedge WD19, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD19, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD19, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD19, 0.0, NOTIFY_REG);
      $setup(posedge WD18, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD18, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD18, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD18, 0.0, NOTIFY_REG);
      $setup(posedge WD17, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD17, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD17, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD17, 0.0, NOTIFY_REG);
      $setup(posedge WD16, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD16, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD16, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD16, 0.0, NOTIFY_REG);
      $setup(posedge WD15, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD15, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD15, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD15, 0.0, NOTIFY_REG);
      $setup(posedge WD14, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD14, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD14, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD14, 0.0, NOTIFY_REG);
      $setup(posedge WD13, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD13, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD13, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD13, 0.0, NOTIFY_REG);
      $setup(posedge WD12, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD12, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD12, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD12, 0.0, NOTIFY_REG);
      $setup(posedge WD11, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD11, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD11, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD11, 0.0, NOTIFY_REG);
      $setup(posedge WD10, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD10, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD10, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD10, 0.0, NOTIFY_REG);
      $setup(posedge WD9, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD9, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD9, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD9, 0.0, NOTIFY_REG);
      $setup(posedge WD8, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD8, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD8, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD8, 0.0, NOTIFY_REG);
      $setup(posedge WD7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD7, 0.0, NOTIFY_REG);
      $setup(posedge WD6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD6, 0.0, NOTIFY_REG);
      $setup(posedge WD5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD5, 0.0, NOTIFY_REG);
      $setup(posedge WD4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD4, 0.0, NOTIFY_REG);
      $setup(posedge WD3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD3, 0.0, NOTIFY_REG);
      $setup(posedge WD2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD2, 0.0, NOTIFY_REG);
      $setup(posedge WD1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);     
      $setup(negedge WD1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& wenable, posedge WD1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD1, 0.0, NOTIFY_REG);
      $setup(posedge WD0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge WD0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge WD0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WD0, 0.0, NOTIFY_REG);




      $setup(posedge DEPTH3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge DEPTH3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge DEPTH3, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge DEPTH2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge DEPTH2, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge DEPTH1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge DEPTH1, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge DEPTH0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge DEPTH0, 0.0, NOTIFY_REG);

      $setup(posedge DEPTH3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge DEPTH3, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge DEPTH3, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge DEPTH2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge DEPTH2, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge DEPTH1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge DEPTH1, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge DEPTH0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge DEPTH0, 0.0, NOTIFY_REG);



      $setup(posedge AEVAL7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL7, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL6, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL5, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL4, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL3, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL2, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL1, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AEVAL0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AEVAL0, 0.0, NOTIFY_REG);

      $setup(posedge AEVAL7, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL7, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL7, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL7, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL6, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL6, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL6, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL6, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL5, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL5, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL5, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL5, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL4, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL4, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL4, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL4, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL3, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL3, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL2, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL1, 0.0, NOTIFY_REG);
      $setup(posedge AEVAL0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AEVAL0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AEVAL0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AEVAL0, 0.0, NOTIFY_REG);


      $setup(posedge AFVAL7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL7, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL7, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL6, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL6, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL5, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL5, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL4, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL4, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL3, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL3, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL2, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL1, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge AFVAL0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge AFVAL0, 0.0, NOTIFY_REG);

      $setup(posedge AFVAL7, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL7, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL7, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL7, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL6, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL6, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL6, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL6, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL5, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL5, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL5, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL5, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL4, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL4, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL4, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL4, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL3, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL3, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL3, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL2, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL1, 0.0, NOTIFY_REG);
      $setup(posedge AFVAL0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge AFVAL0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge AFVAL0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge AFVAL0, 0.0, NOTIFY_REG);



      $setup(posedge WIDTH2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH2, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge WIDTH2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WIDTH2, 0.0, NOTIFY_REG);
      $setup(posedge WIDTH1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH1, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge WIDTH1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WIDTH1, 0.0, NOTIFY_REG);
      $setup(posedge WIDTH0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH0, posedge WCLK &&& wenable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, posedge WIDTH0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& wenable, negedge WIDTH0, 0.0, NOTIFY_REG);

      $setup(posedge WIDTH2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH2, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge WIDTH2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge WIDTH2, 0.0, NOTIFY_REG);
      $setup(posedge WIDTH1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH1, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge WIDTH1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge WIDTH1, 0.0, NOTIFY_REG);
      $setup(posedge WIDTH0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $setup(negedge WIDTH0, posedge RCLK &&& renable, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, posedge WIDTH0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& renable, negedge WIDTH0, 0.0, NOTIFY_REG);


      $setup(posedge REN, posedge RCLK &&& ~CLR1, 0.0, NOTIFY_REG);
      $setup(negedge REN, posedge RCLK &&& ~CLR1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& ~CLR1, posedge REN, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& ~CLR1, negedge REN, 0.0, NOTIFY_REG);

      $setup(posedge WEN, posedge WCLK &&& ~CLR1, 0.0, NOTIFY_REG);
      $setup(negedge WEN, posedge WCLK &&& ~CLR1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& ~CLR1, posedge WEN, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& ~CLR1, negedge WEN, 0.0, NOTIFY_REG);

      $recovery(posedge CLR, posedge WCLK, 0.0, NOTIFY_REG);
      $recovery(posedge CLR, posedge RCLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, posedge CLR, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, posedge CLR, 0.0, NOTIFY_REG);
 
 endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME  : HCLKBUF_LVDS
---------------------------------------------------------------------*/ 
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_LVDS (PADP,PADN,Y);
    
    input PADP,PADN;
    output Y;
    reg temp; 
  pmos p1(Y, temp,1'b0); 
    always @(PADP or PADN) begin
 
    if((PADP == 1'b1) && (PADN == 1'b0)) 
       temp = 1'b1;
    else if((PADP == 1'b0) && (PADN == 1'b1))
       temp = 1'b0;
    else
       temp = 1'bx;
    end
 
      
    specify

         specparam   LibName       = "ax";
         specparam   InputLoad$PADP = 0;
         specparam   InputLoad$PADN = 0; 
         specparam   OutputLoad$Y  = 0;

         specparam   MacroType = "Hclkbuf_lvds";


        (PADP => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (PADN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);

    endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : HCLKBUF_LVPECL
---------------------------------------------------------------------*/
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module HCLKBUF_LVPECL (PADP,PADN,Y);
    
    input PADP,PADN;
    output Y;
    reg temp; 
   pmos p1(Y,temp,1'b0);   
    always @(PADP or PADN) begin
 
    if((PADP == 1'b1) && (PADN == 1'b0)) 
       temp = 1'b1;
    else if((PADP == 1'b0) && (PADN == 1'b1))
       temp = 1'b0;
    else
       temp = 1'bx;
    end
 
      
    specify

         specparam   LibName       = "ax";
         specparam   InputLoad$PADP = 0;
         specparam   InputLoad$PADN = 0; 
         specparam   OutputLoad$Y  = 0;

         specparam   MacroType = "Hclkbuf_lvpecl";


        (PADP => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (PADN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);

    endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults
      
/*--------------------------------------------------------------------
 CELL NAME  : INBUF_LVDS
---------------------------------------------------------------------*/
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVDS (PADP,PADN,Y);
    
    input PADP,PADN;
    output Y;
    reg temp; 
   
   pmos p1(Y,temp,1'b0);  
    always @(PADP or PADN) begin
 
    if((PADP == 1'b1) && (PADN == 1'b0)) 
       temp = 1'b1;
    else if((PADP == 1'b0) && (PADN == 1'b1))
       temp = 1'b0;
    else
       temp = 1'bx;
    end
 
      
    specify

         specparam   LibName       = "ax";
         specparam   InputLoad$PADP = 0;
         specparam   InputLoad$PADN = 0; 
         specparam   OutputLoad$Y  = 0;

         specparam   MacroType = "inbuf_lvds";


        (PADP => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (PADN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);

    endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults
      
     
/*--------------------------------------------------------------------
 CELL NAME  : INBUF_LVPECL
---------------------------------------------------------------------*/      
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INBUF_LVPECL (PADP,PADN,Y);
    
    input PADP,PADN;
    output Y;
    reg temp; 

    pmos p1(Y,temp,1'b0);    
    always @(PADP or PADN) begin
 
    if((PADP == 1'b1) && (PADN == 1'b0)) 
       temp = 1'b1;
    else if((PADP == 1'b0) && (PADN == 1'b1))
       temp = 1'b0;
    else
       temp = 1'bx;
    end
 
      
    specify

         specparam   LibName       = "ax";
         specparam   InputLoad$PADP = 0;
         specparam   InputLoad$PADN = 0; 
         specparam   OutputLoad$Y  = 0;

         specparam   MacroType = "inbuf_lvpecl";


        (PADP => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
        (PADN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOFIFO_BIDIRINFIFO
---------------------------------------------------------------------*/
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOFIFO_BIDIRINFIFO(A,D,WENB,WCLK,RENB,RCLK,CLRB,Q,Y);

input D;
input A;
input WENB;
input WCLK;
input RENB;
input RCLK;
input CLRB;

output Q;
output Y;
reg Q_temp;
reg CLRB_temp;
reg NOTIFY_REG;

wire WE_,RE_;
wire WCLK1,RCLK1,CLRB1,WENB1,RENB1,D1;
wire enable1, enable2;

reg DUAL_PORT_RAM[63 : 0];
integer WADDR;
integer RADDR;

buf #1 inst3(WCLK1,WCLK);
buf #1 inst4(RCLK1,RCLK);
buf #1 inst5(CLRB1,CLRB);
buf #1 inst6(WENB1,WENB);
buf #1 inst7(RENB1,RENB);
buf #1 inst8(D1,D);

buf #1 inst9(Y, A);

        
not inst1(WE_,WENB1);
not inst2(RE_,RENB1);

assign enable1 = !WENB && CLRB;
assign enable2 = !RENB && CLRB;

initial begin
  WADDR = -1;
  RADDR = -1;
  CLRB_temp = 1'b0;
end

pmos b1(Q, Q_temp, 1'b0);

always @(CLRB1)
begin
     CLRB_temp = CLRB1;
end


always @(WCLK1 === 1'bx )
begin
  if($time > 0) begin
   if(WENB1 == 1'b0) begin
    $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(RCLK1 === 1'bx )
begin
  if($time > 0) begin
   if (RENB1 == 1'b0) begin
    $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(CLRB_temp === 1'bx )
begin
  if($time > 0) begin
      $display("Warning : CLRB went unknown at time %0.1f\n",$realtime);
      //$finish;
   end
end


 always @(posedge WCLK1 or negedge CLRB_temp) begin
  if(CLRB_temp == 1'b0) begin
     WADDR = -1;
     RADDR = -1;
     Q_temp = 1'bx;
    end
  else begin
   if(WENB1 == 1'b0) begin
     WADDR = WADDR + 1;
     if ((WADDR-RADDR) > 64) begin
       $display("Warning : Write invalid  -- FIFO Full");
       WADDR = WADDR -1;
      end
      else
       DUAL_PORT_RAM [WADDR%64] = D1;
    end
    else if( WENB1 == 1'b1) begin
     //  $display(" : No write opertion was executed, WENB high!");
    end
    else begin
          $display("WENB went unknown");
    end
   end                     // end of the if (CLRB == 1'b0) else block
 end                       // end of the always block


always @(posedge RCLK1 or negedge CLRB_temp) begin
 if(CLRB_temp == 1'b0) begin
   WADDR = -1;
   RADDR = -1;
   Q_temp = 1'bx;
  end
  else begin
   if (RENB1 == 1'b0) begin
      RADDR = RADDR + 1;
     if(RADDR > WADDR)  begin
      $display(" : Read invalid -- FIFO empty, WADDR=%d, RADDR=%d",WADDR,RADDR);
      RADDR = RADDR - 1;
      Q_temp = 1'bx;
     end
     else begin
       Q_temp =DUAL_PORT_RAM[(RADDR % 64)];
     end
    end
    else if(RENB1 != 1'b1) begin
      $display("Warning : RENB unknown, output data bit corrupted!");
      Q_temp <=1'bx;
     end else begin
      Q_temp = Q_temp;
    end
   end
  end                     // end of the always block

     

 specify

      specparam  LibName = "ax";

      (posedge RCLK => (Q+:Q) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge CLRB => (Q+: 1'bx)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      $width(posedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge CLRB, 0.0, 0, NOTIFY_REG);

      $setup(posedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, posedge D, 0.0, NOTIFY_REG);
      $setup(negedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, negedge D, 0.0, NOTIFY_REG);

      $setup(posedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, posedge WENB, 0.0, NOTIFY_REG);
      $setup(negedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, negedge WENB, 0.0, NOTIFY_REG);


      $setup(posedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, posedge RENB, 0.0, NOTIFY_REG);
      $setup(negedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, negedge RENB, 0.0, NOTIFY_REG);


      $recovery(posedge CLRB, posedge RCLK &&& RE_, 0.0, NOTIFY_REG);
      $recovery(posedge CLRB, posedge WCLK &&& WE_, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RE_, posedge CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WE_, posedge CLRB, 0.0, NOTIFY_REG);



 endspecify

 endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : BIOFIFO_BIDIRINFIFO
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIOFIFO_BIDIRINFIFO(A,D,WENB,WCLK,RENB,RCLK,CLRB,Q,Y);

input D;
input A;
input WENB;
input WCLK;
input RENB;
input RCLK;
input CLRB;

output Q;
output Y;
reg Q_temp;
reg CLRB_temp;
reg NOTIFY_REG;

wire WE_,RE_;
wire WCLK1,RCLK1,CLRB1,WENB1,RENB1,D1;
wire enable;

reg DUAL_PORT_RAM[63 : 0];
integer WADDR;
integer RADDR;

buf #1 inst3(WCLK1,WCLK);
buf #1 inst4(RCLK1,RCLK);
buf #1 inst5(CLRB1,CLRB);
buf #1 inst6(WENB1,WENB);
buf #1 inst7(RENB1,RENB);
buf #1 inst8(D1,D);

buf #1 inst9(Y, A);

not inst1(WE_,WENB1);
not inst2(RE_,RENB1);

assign enable = !WENB && CLRB;

initial begin
  WADDR = -1;
  RADDR = -1;
  CLRB_temp = 1'b0;
end

pmos b1(Q, Q_temp, 1'b0);

always @(CLRB1)
begin
     CLRB_temp = CLRB1;
end


always @(WCLK1 === 1'bx )
begin
  if($time > 0) begin
   if(WENB1 == 1'b0) begin
    $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(RCLK1 === 1'bx )
begin
  if($time > 0) begin
   if (RENB1 == 1'b0) begin
    $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(CLRB_temp === 1'bx )
begin
  if($time > 0) begin
      $display("Warning : CLRB went unknown at time %0.1f\n",$realtime);
      //$finish;
   end
end



 always @(posedge WCLK1 or negedge CLRB_temp) begin
  if(CLRB_temp == 1'b0) begin
     WADDR = -1;
     RADDR = -1;
     Q_temp = 1'bx;
    end
  else begin
   if(WENB1 == 1'b0) begin
     WADDR = WADDR + 1;
     if ((WADDR-RADDR) > 64) begin
       $display("Warning : Write invalid  -- FIFO Full");
       WADDR = WADDR -1;
      end
      else
       DUAL_PORT_RAM [WADDR%64] = D1;
    end
    else if( WENB1 == 1'b1) begin
     //  $display(" : No write opertion was executed, WENB high!");
    end
    else begin
          $display("WENB went unknown");
    end
   end                     // end of the if (CLRB == 1'b0) else block
 end                       // end of the always block


always @(posedge RCLK1 or negedge CLRB_temp) begin
 if(CLRB_temp == 1'b0) begin
   WADDR = -1;
   RADDR = -1;
   Q_temp = 1'bx;
  end
  else begin
   if (RENB1 == 1'b0) begin
      RADDR = RADDR + 1;
     if(RADDR > WADDR)  begin
      $display(" : Read invalid -- FIFO empty, WADDR=%d, RADDR=%d",WADDR,RADDR);
      RADDR = RADDR - 1;
      Q_temp = 1'bx;
     end
     else begin
       Q_temp =DUAL_PORT_RAM[(RADDR % 64)];
     end
    end
    else if(RENB1 != 1'b1) begin
      $display("Warning : RENB unknown, output data bit corrupted!");
      Q_temp <=1'bx;
     end else begin
      Q_temp = Q_temp;
    end
   end
  end                     // end of the always block


 

 specify

      specparam  LibName = "ax";

      (posedge RCLK => (Q+:Q) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge CLRB => (Q+: 1'bx)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      $width(posedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge CLRB, 0.0, 0, NOTIFY_REG);

      $setup(posedge D, posedge WCLK &&& enable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable, posedge D, 0.0, NOTIFY_REG);
      $setup(negedge D, posedge WCLK &&& enable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable, negedge D, 0.0, NOTIFY_REG);

      $setup(posedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, posedge WENB, 0.0, NOTIFY_REG);
      $setup(negedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, negedge WENB, 0.0, NOTIFY_REG);


      $setup(posedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, posedge RENB, 0.0, NOTIFY_REG);
      $setup(negedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, negedge RENB, 0.0, NOTIFY_REG);


      $recovery(posedge CLRB, posedge RCLK &&& RE_, 0.0, NOTIFY_REG);
      $recovery(posedge CLRB, posedge WCLK &&& WE_, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RE_, posedge CLRB , 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WE_, posedge CLRB , 0.0, NOTIFY_REG);


 endspecify

 endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

     
/*--------------------------------------------------------------------
 CELL NAME  : IOFIFO_INFIFO
---------------------------------------------------------------------*/          
     
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOFIFO_INFIFO(D,WENB,WCLK,RENB,RCLK,CLRB,Q);

input D;
input WENB;
input WCLK;
input RENB;
input RCLK;
input CLRB;

output Q;
reg Q_temp;
reg CLRB_temp;
reg NOTIFY_REG;

wire WE_,RE_;
wire WCLK1,RCLK1,CLRB1,WENB1,RENB1,D1;
wire enable;

reg DUAL_PORT_RAM[63 : 0];
integer WADDR;
integer RADDR;

buf #1 inst3(WCLK1,WCLK);
buf #1 inst4(RCLK1,RCLK);
buf #1 inst5(CLRB1,CLRB);
buf #1 inst6(WENB1,WENB);
buf #1 inst7(RENB1,RENB);
buf #1 inst8(D1,D);

not inst1(WE_,WENB1);
not inst2(RE_,RENB1);
 
assign enable = !WENB && CLRB;

initial begin
  WADDR = -1;
  RADDR = -1;
  CLRB_temp = 1'b0;
end

pmos b1(Q,Q_temp,1'b0);

always @(CLRB1)
begin
     CLRB_temp = CLRB1;
end

 
always @(WCLK1 === 1'bx )
begin
  if($time > 0) begin
   if(WENB1 == 1'b0) begin
    $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(RCLK1 === 1'bx )
begin
  if($time > 0) begin
   if (RENB1 == 1'b0) begin
    $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(CLRB_temp === 1'bx )
begin
  if($time > 0) begin
      $display("Warning : CLRB went unknown at time %0.1f\n",$realtime);
      //$finish;
   end
end



 
always @(posedge WCLK1 or negedge CLRB_temp) begin
  if(CLRB_temp == 1'b0) begin
     WADDR = -1;
     RADDR = -1;
     Q_temp = 1'bx;
    end
  else begin
   if(WENB1 == 1'b0) begin
     WADDR = WADDR + 1;
     if ((WADDR-RADDR) > 64) begin
       $display("Warning : Write invalid  -- FIFO Full");
       WADDR = WADDR -1;
      end
      else 
       DUAL_PORT_RAM [WADDR%64] = D1;
    end
    else if( WENB1 == 1'b1) begin
     //  $display(" : No write opertion was executed, WENB high!");
    end
    else begin
          $display("WENB went unknown");
    end 
   end                     // end of the if (CLRB == 1'b0) else block 
 end                       // end of the always block   


always @(posedge RCLK1 or negedge CLRB_temp) begin
 if(CLRB_temp == 1'b0) begin
   WADDR = -1;
   RADDR = -1;
   Q_temp = 1'bx;
  end
  else begin
   if (RENB1 == 1'b0) begin
      RADDR = RADDR + 1;
     if(RADDR > WADDR)  begin
      $display(" : Read invalid -- FIFO empty, WADDR=%d, RADDR=%d",WADDR,RADDR);
      RADDR = RADDR - 1;
      Q_temp = 1'bx;
     end
     else begin
       Q_temp =DUAL_PORT_RAM[(RADDR % 64)];
     end
    end
    else if(RENB1 != 1'b1) begin
      $display("Warning : RENB unknown, output data bit corrupted!");
      Q_temp <=1'bx;
     end else begin
      Q_temp = Q_temp;
    end
   end
  end                     // end of the always block

 specify
   
      specparam  LibName = "ax";

      (posedge RCLK => (Q+:Q) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge CLRB => (Q+: 1'bx)) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      $width(posedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge CLRB, 0.0, 0, NOTIFY_REG);

      $setup(posedge D, posedge WCLK &&& enable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable, posedge D, 0.0, NOTIFY_REG);
      $setup(negedge D, posedge WCLK &&& enable, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable, negedge D, 0.0, NOTIFY_REG);

      $setup(posedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, posedge WENB, 0.0, NOTIFY_REG);
      $setup(negedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, negedge WENB, 0.0, NOTIFY_REG);


      $setup(posedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, posedge RENB, 0.0, NOTIFY_REG);
      $setup(negedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, negedge RENB, 0.0, NOTIFY_REG);

      $recovery(posedge CLRB, posedge RCLK &&& RE_, 0.0, NOTIFY_REG);
      $recovery(posedge CLRB, posedge WCLK &&& WE_, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RE_, posedge CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WE_, posedge CLRB, 0.0, NOTIFY_REG);


 endspecify

 endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOFIFO_OUTFIFO
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOFIFO_OUTFIFO(D,WENB,WCLK,RENB,RCLK,CLRB,Q);

input D;
input WENB;
input WCLK;
input RENB;
input RCLK;
input CLRB;

output Q;
reg Q_temp;
reg CLRB_temp;
reg NOTIFY_REG;

wire WE_,RE_;
wire WCLK1,RCLK1,CLRB1,WENB1,RENB1,D1;
wire enable1;

reg DUAL_PORT_RAM[63 : 0];
integer WADDR;
integer RADDR;

buf #1 inst3(WCLK1,WCLK);
buf #1 inst4(RCLK1,RCLK);
buf #1 inst5(CLRB1,CLRB);
buf #1 inst6(WENB1,WENB);
buf #1 inst7(RENB1,RENB);
buf #1 inst8(D1,D);

not inst1(WE_,WENB1);
not inst2(RE_,RENB1);

assign enable1 = !WENB && CLRB;

initial begin
  WADDR = -1;
  RADDR = -1;
  CLRB_temp = 1'b0;
end

pmos b1(Q,Q_temp,1'b0);

always @(CLRB1)
begin
     CLRB_temp = CLRB1;
end

 
always @(WCLK1 === 1'bx )
begin
  if($time > 0) begin
   if(WENB == 1'b0) begin
    $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(RCLK1 === 1'bx )
begin
  if($time > 0) begin
   if (RENB == 1'b0) begin
    $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(CLRB_temp === 1'bx )
begin
  if($time > 0) begin
      $display("Warning : CLRB went unknown at time %0.1f\n",$realtime);
      //$finish;
   end
end



 
always @(posedge WCLK1 or negedge CLRB_temp) begin
  if(CLRB_temp == 1'b0) begin
     WADDR = -1;
     RADDR = -1;
     Q_temp = 1'bx;
    end
  else begin
   if(WENB == 1'b0) begin
     WADDR = WADDR + 1;
     if ((WADDR-RADDR) > 64) begin
       $display("Warning : Write invalid  -- FIFO Full");
       WADDR = WADDR -1;
      end
      else 
       DUAL_PORT_RAM [WADDR%64] = D1;
    end
    else if( WENB == 1'b1) begin
     //  $display(" : No write opertion was executed, WENB high!");
    end
    else begin
          $display("WENB went unknown");
    end 
   end                     // end of the if (CLRB == 1'b0) else block 
 end                       // end of the always block   


always @(posedge RCLK1 or negedge CLRB_temp) begin
 if(CLRB_temp == 1'b0) begin
   WADDR = -1;
   RADDR = -1;
   Q_temp = 1'bx;
  end
  else begin
   if (RENB == 1'b0) begin
      RADDR = RADDR + 1;
     if(RADDR > WADDR)  begin
      $display(" : Read invalid -- FIFO empty, WADDR=%d, RADDR=%d",WADDR,RADDR);
      RADDR = RADDR - 1;
      Q_temp = 1'bx;
     end
     else begin
       Q_temp =DUAL_PORT_RAM[(RADDR % 64)];
     end
    end
    else if(RENB != 1'b1) begin
      $display("Warning : RENB unknown, output data bit corrupted!");
      Q_temp <=1'bx;
     end else begin
      Q_temp = Q_temp;
    end
   end
  end                     // end of the always block

 specify
   
      specparam  LibName = "ax";

      (posedge RCLK => (Q+:Q) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge CLRB => (Q+:1'bx)) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      $width(posedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge CLRB, 0.0, 0, NOTIFY_REG);

      $setup(posedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, posedge D, 0.0, NOTIFY_REG);
      $setup(negedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, negedge D, 0.0, NOTIFY_REG);

      $setup(posedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, posedge WENB, 0.0, NOTIFY_REG);
      $setup(negedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, negedge WENB, 0.0, NOTIFY_REG);


      $setup(posedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, posedge RENB, 0.0, NOTIFY_REG);
      $setup(negedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, negedge RENB, 0.0, NOTIFY_REG);


      $recovery(posedge CLRB, posedge RCLK &&& RE_, 0.0, NOTIFY_REG);
      $recovery(posedge CLRB, posedge WCLK &&& WE_, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RE_, posedge CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WE_, posedge CLRB, 0.0, NOTIFY_REG);


 endspecify

 endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOFIFO_BIDIROUTFIFO
---------------------------------------------------------------------*/ 

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOFIFO_BIDIROUTFIFO(A,D,WENB,WCLK,RENB,RCLK,CLRB,Q,Y);

input D;
input A;
input WENB;
input WCLK;
input RENB;
input RCLK;
input CLRB;

output Q;
output Y;
reg Q_temp;
reg CLRB_temp;
reg NOTIFY_REG;

wire WE_,RE_;
wire WCLK1,RCLK1,CLRB1,WENB1,RENB1,D1;
wire enable1;

reg DUAL_PORT_RAM[63 : 0];
integer WADDR;
integer RADDR;

buf #1 inst3(WCLK1,WCLK);
buf #1 inst4(RCLK1,RCLK);
buf #1 inst5(CLRB1,CLRB);
buf #1 inst6(WENB1,WENB);
buf #1 inst7(RENB1,RENB);
buf #1 inst8(D1,D);
buf #1 inst9(Y, A);

not inst1(WE_,WENB1);
not inst2(RE_,RENB1);

assign enable1 = !WENB && CLRB;

initial begin
  WADDR = -1;
  RADDR = -1;
  CLRB_temp = 1'b0;
end

pmos b1(Q,Q_temp,1'b0);
      
always @(CLRB1)
begin
     CLRB_temp = CLRB1;
end


always @(WCLK1 === 1'bx )
begin
  if($time > 0) begin
   if(WENB == 1'b0) begin
    $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(RCLK1 === 1'bx )
begin
  if($time > 0) begin
   if (RENB == 1'b0) begin
    $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(CLRB_temp === 1'bx )
begin
  if($time > 0) begin
      $display("Warning : CLRB went unknown at time %0.1f\n",$realtime);
      //$finish;
   end
end


always @(posedge WCLK1 or negedge CLRB_temp) begin
  if(CLRB_temp == 1'b0) begin
     WADDR = -1;
     RADDR = -1;
     Q_temp = 1'bx;
    end
  else begin
   if(WENB == 1'b0) begin
     WADDR = WADDR + 1;
     if ((WADDR-RADDR) > 64) begin
       $display("Warning : Write invalid  -- FIFO Full");
       WADDR = WADDR -1;
      end
      else
       DUAL_PORT_RAM [WADDR%64] = D1;
    end
    else if( WENB == 1'b1) begin
     //  $display(" : No write opertion was executed, WENB high!");
    end
    else begin
          $display("WENB went unknown");
    end
   end                     // end of the if (CLRB == 1'b0) else block
 end                       // end of the always block


always @(posedge RCLK1 or negedge CLRB_temp) begin
 if(CLRB_temp == 1'b0) begin
   WADDR = -1;
   RADDR = -1;
   Q_temp = 1'bx;
  end
  else begin
   if (RENB == 1'b0) begin
      RADDR = RADDR + 1;
     if(RADDR > WADDR)  begin
      $display(" : Read invalid -- FIFO empty, WADDR=%d, RADDR=%d",WADDR,RADDR);
      RADDR = RADDR - 1;
      Q_temp = 1'bx;
     end
     else begin
       Q_temp =DUAL_PORT_RAM[(RADDR % 64)];
     end
    end
    else if(RENB != 1'b1) begin
      $display("Warning : RENB unknown, output data bit corrupted!");
      Q_temp <=1'bx;
     end else begin
      Q_temp = Q_temp;
    end
   end
  end                     // end of the always block


 specify

      specparam  LibName = "ax";

      (posedge RCLK => (Q+:Q) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge CLRB => (Q+:1'bx)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      $width(posedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);

      $setup(posedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, posedge D, 0.0, NOTIFY_REG);
      $setup(negedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, negedge D, 0.0, NOTIFY_REG);

      $setup(posedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, posedge WENB, 0.0, NOTIFY_REG);
      $setup(negedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, negedge WENB, 0.0, NOTIFY_REG);


      $setup(posedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, posedge RENB, 0.0, NOTIFY_REG);
      $setup(negedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, negedge RENB, 0.0, NOTIFY_REG);


      $recovery(posedge CLRB, posedge RCLK &&& RE_, 0.0, NOTIFY_REG);
      $recovery(posedge CLRB, posedge WCLK &&& WE_, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RE_, posedge CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WE_, posedge CLRB, 0.0, NOTIFY_REG);


 endspecify

 endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : BIOFIFO_BIDIROUTFIFO
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIOFIFO_BIDIROUTFIFO(A,D,WENB,WCLK,RENB,RCLK,CLRB,Q,Y);

input D;
input A;
input WENB;
input WCLK;
input RENB;
input RCLK;
input CLRB;

output Q;
output Y;
reg Q_temp;
reg CLRB_temp;
reg NOTIFY_REG;

wire WE_,RE_;
wire WCLK1,RCLK1,CLRB1,WENB1,RENB1,D1;
wire enable1;

reg DUAL_PORT_RAM[63 : 0];
integer WADDR;
integer RADDR;

buf #1 inst3(WCLK1,WCLK);
buf #1 inst4(RCLK1,RCLK);
buf #1 inst5(CLRB1,CLRB);
buf #1 inst6(WENB1,WENB);
buf #1 inst7(RENB1,RENB);
buf #1 inst8(D1,D);
buf #1 inst9(Y, A);

not inst1(WE_,WENB1);
not inst2(RE_,RENB1);

initial begin
  WADDR = -1;
  RADDR = -1;
  CLRB_temp = 1'b0;
end

pmos b1(Q,Q_temp,1'b0);

always @(CLRB1)
begin
     CLRB_temp = CLRB1;
end

assign enable1 = !WENB && CLRB;
always @(WCLK1 === 1'bx )
begin
  if($time > 0) begin
   if(WENB == 1'b0) begin
    $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(RCLK1 === 1'bx )
begin
  if($time > 0) begin
   if (RENB == 1'b0) begin
    $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(CLRB_temp === 1'bx )
begin
  if($time > 0) begin
      $display("Warning : CLRB went unknown at time %0.1f\n",$realtime);
      //$finish;
   end
end


always @(posedge WCLK1 or negedge CLRB_temp) begin
  if(CLRB_temp == 1'b0) begin
     WADDR = -1;
     RADDR = -1;
     Q_temp = 1'bx;
    end
  else begin
   if(WENB == 1'b0) begin
     WADDR = WADDR + 1;
     if ((WADDR-RADDR) > 64) begin
       $display("Warning : Write invalid  -- FIFO Full");
       WADDR = WADDR -1;
      end
      else
       DUAL_PORT_RAM [WADDR%64] = D1;
    end
    else if( WENB == 1'b1) begin
     //  $display(" : No write opertion was executed, WENB high!");
    end
     else begin
          $display("WENB went unknown");
    end
   end                     // end of the if (CLRB == 1'b0) else block
 end                       // end of the always block


always @(posedge RCLK1 or negedge CLRB_temp) begin
 if(CLRB_temp == 1'b0) begin
   WADDR = -1;
   RADDR = -1;
   Q_temp = 1'bx;
  end
  else begin
   if (RENB == 1'b0) begin
      RADDR = RADDR + 1;
     if(RADDR > WADDR)  begin
      $display(" : Read invalid -- FIFO empty, WADDR=%d, RADDR=%d",WADDR,RADDR);
      RADDR = RADDR - 1;
      Q_temp = 1'bx;
     end
     else begin
       Q_temp =DUAL_PORT_RAM[(RADDR % 64)];
     end
    end
    else if(RENB != 1'b1) begin
      $display("Warning : RENB unknown, output data bit corrupted!");
      Q_temp <=1'bx;
     end else begin
      Q_temp = Q_temp;
    end
   end
  end                     // end of the always block
 
 specify

      specparam  LibName = "ax";

      (posedge RCLK => (Q+:Q) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge CLRB => (Q+:1'bx)) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      $width(posedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge CLRB, 0.0, 0, NOTIFY_REG);

      $setup(posedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, posedge D, 0.0, NOTIFY_REG);
      $setup(negedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, negedge D, 0.0, NOTIFY_REG);

      $setup(posedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, posedge WENB, 0.0, NOTIFY_REG);
      $setup(negedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, negedge WENB, 0.0, NOTIFY_REG);


      $setup(posedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, posedge RENB, 0.0, NOTIFY_REG);
      $setup(negedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, negedge RENB, 0.0, NOTIFY_REG);


      $recovery(posedge CLRB, posedge RCLK &&& RE_, 0.0, NOTIFY_REG);
      $recovery(posedge CLRB, posedge WCLK &&& WE_, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RE_, posedge CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WE_, posedge CLRB,  0.0, NOTIFY_REG);

 endspecify

 endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME  : BIOFIFO_INFIFO
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIOFIFO_INFIFO(D,WENB,WCLK,RENB,RCLK,CLRB,Q);

input D;
input WENB;
input WCLK;
input RENB;
input RCLK;
input CLRB;

output Q;
reg Q_temp;
reg CLRB_temp;
reg NOTIFY_REG;

wire WE_,RE_;
wire WCLK1,RCLK1,CLRB1,WENB1,RENB1,D1;
wire enable1, enable2;

reg DUAL_PORT_RAM[63 : 0];
integer WADDR;
integer RADDR;

buf inst3(WCLK1,WCLK);
buf inst4(RCLK1,RCLK);
buf inst5(CLRB1,CLRB);
buf inst6(WENB1,WENB);
buf inst7(RENB1,RENB);
buf inst8(D1,D);

not inst1(WE_,WENB1);
not inst2(RE_,RENB1);

assign enable1 = !WENB && CLRB;
assign enable2 = !RENB && CLRB;

initial begin
  WADDR = -1;
  RADDR = -1;
  CLRB_temp = 1'b0;
end

pmos b1(Q,Q_temp,1'b0);

always @(CLRB1)
begin
     CLRB_temp = CLRB1;
end

 
always @(WCLK1 === 1'bx )
begin
  if($time > 0) begin
   if(WENB1 == 1'b0) begin
    $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(RCLK1 === 1'bx )
begin
  if($time > 0) begin
   if (RENB1 == 1'b0) begin
    $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(CLRB1 === 1'bx )
begin
  if($time > 0) begin
      $display("Warning : CLRB went unknown at time %0.1f\n",$realtime);
      //$finish;
   end
end



 
always @(posedge WCLK1 or negedge CLRB_temp) begin
  if(CLRB_temp == 1'b0) begin
     WADDR = -1;
     RADDR = -1;
     Q_temp = 1'bx;
    end
  else begin
   if(WENB1 == 1'b0) begin
     WADDR = WADDR + 1;
     if ((WADDR-RADDR) > 64) begin
       $display("Warning : Write invalid  -- FIFO Full");
       WADDR = WADDR -1;
      end
      else 
       DUAL_PORT_RAM [WADDR%64] = D1;
    end
    else if( WENB1 == 1'b1) begin
     //  $display(" : No write opertion was executed, WENB high!");
    end
    else begin
          $display("WENB went unknown");
    end 
   end                     // end of the if (CLRB == 1'b0) else block 
 end                       // end of the always block   


always @(posedge RCLK1 or negedge CLRB_temp) begin
 if(CLRB_temp == 1'b0) begin
   WADDR = -1;
   RADDR = -1;
   Q_temp = 1'bx;
  end
  else begin
   if (RENB1 == 1'b0) begin
      RADDR = RADDR + 1;
     if(RADDR > WADDR)  begin
      $display(" : Read invalid -- FIFO empty, WADDR=%d, RADDR=%d",WADDR,RADDR);
      RADDR = RADDR - 1;
      Q_temp = 1'bx;
     end
     else begin
       Q_temp =DUAL_PORT_RAM[(RADDR % 64)];
     end
    end
    else if(RENB1 != 1'b1) begin
      $display("Warning : RENB unknown, output data bit corrupted!");
      Q_temp <=1'bx;
     end else begin
      Q_temp = Q_temp;
    end
   end
  end                     // end of the always block

 specify
   
      specparam  LibName = "ax";

      (posedge RCLK => (Q+:Q) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge CLRB =>(Q+:1'bx)) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      $width(posedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge CLRB, 0.0, 0, NOTIFY_REG);

      $setup(posedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, posedge D, 0.0, NOTIFY_REG);
      $setup(negedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, negedge D, 0.0, NOTIFY_REG);

      $setup(posedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, posedge WENB, 0.0, NOTIFY_REG);
      $setup(negedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, negedge WENB, 0.0, NOTIFY_REG);


      $setup(posedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, posedge RENB, 0.0, NOTIFY_REG);
      $setup(negedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, negedge RENB, 0.0, NOTIFY_REG);


      $recovery(posedge CLRB, posedge RCLK &&& RE_, 0.0, NOTIFY_REG);
      $recovery(posedge CLRB, posedge WCLK &&& WE_, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RE_, posedge CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WE_, posedge CLRB, 0.0, NOTIFY_REG);


 endspecify

 endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : BIOFIFO_OUTFIFO
---------------------------------------------------------------------*/      

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BIOFIFO_OUTFIFO(D,WENB,WCLK,RENB,RCLK,CLRB,Q);

input D;
input WENB;
input WCLK;
input RENB;
input RCLK;
input CLRB;

output Q;
reg Q_temp;
reg CLRB_temp;
reg NOTIFY_REG;

wire WE_,RE_;
wire WCLK1,RCLK1,CLRB1,WENB1,RENB1,D1;
wire enable1;

reg DUAL_PORT_RAM[63 : 0];
integer WADDR;
integer RADDR;


buf inst3(WCLK1,WCLK);
buf inst4(RCLK1,RCLK);
buf inst5(CLRB1,CLRB);
buf inst6(WENB1,WENB);
buf inst7(RENB1,RENB);
buf inst8(D1,D);

not inst1(WE_,WENB1);
not inst2(RE_,RENB1);



initial begin
  WADDR = -1;
  RADDR = -1;
  CLRB_temp = 1'b0;
end

pmos b1(Q,Q_temp,1'b0);

always @(CLRB1)
begin
     CLRB_temp = CLRB1;
end

assign enable1 = !WENB && CLRB;

always @(WCLK1 === 1'bx )
begin
  if($time > 0) begin
   if(WENB1 == 1'b0) begin
    $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(RCLK1 === 1'bx )
begin
  if($time > 0) begin
   if (RENB1 == 1'b0) begin
    $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
    //$finish;
   end
  end
end

always @(CLRB_temp === 1'bx )
begin
  if($time > 0) begin
      $display("Warning : CLRB went unknown at time %0.1f\n",$realtime);
      //$finish;
   end
end



 
always @(posedge WCLK1 or negedge CLRB_temp) begin
  if(CLRB_temp == 1'b0) begin
     WADDR = -1;
     RADDR = -1;
     Q_temp = 1'bx;
    end
  else begin
   if(WENB1 == 1'b0) begin
     WADDR = WADDR + 1;
     if ((WADDR-RADDR) > 64) begin
       $display("Warning : Write invalid  -- FIFO Full");
       WADDR = WADDR -1;
      end
      else 
       DUAL_PORT_RAM [WADDR%64] = D1;
    end
    else if( WENB1 == 1'b1) begin
     //  $display(" : No write opertion was executed, WENB high!");
    end
    else begin
          $display("WENB went unknown");
    end 
   end                     // end of the if (CLRB == 1'b0) else block 
 end                       // end of the always block   


always @(posedge RCLK1 or negedge CLRB_temp) begin
 if(CLRB_temp == 1'b0) begin
   WADDR = -1;
   RADDR = -1;
   Q_temp = 1'bx;
  end
  else begin
   if (RENB1 == 1'b0) begin
      RADDR = RADDR + 1;
     if(RADDR > WADDR)  begin
      $display(" : Read invalid -- FIFO empty, WADDR=%d, RADDR=%d",WADDR,RADDR);
      RADDR = RADDR - 1;
      Q_temp = 1'bx;
     end
     else begin
       Q_temp =DUAL_PORT_RAM[(RADDR % 64)];
     end
    end
    else if(RENB1 != 1'b1) begin
      $display("Warning : RENB unknown, output data bit corrupted!");
      Q_temp <=1'bx;
     end else begin
      Q_temp = Q_temp;
    end
   end
  end                     // end of the always block

 specify
   
      specparam  LibName = "ax";

      (posedge RCLK => (Q+:Q) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (negedge CLRB => (Q+: 1'bx)) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      $width(posedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK &&& CLRB, 0.0, 0, NOTIFY_REG);
      $width(negedge CLRB, 0.0, 0, NOTIFY_REG);

      $setup(posedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, posedge D, 0.0, NOTIFY_REG);
      $setup(negedge D, posedge WCLK &&& enable1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& enable1, negedge D, 0.0, NOTIFY_REG);

      $setup(posedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, posedge WENB, 0.0, NOTIFY_REG);
      $setup(negedge WENB, posedge WCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& CLRB, negedge WENB, 0.0, NOTIFY_REG);


      $setup(posedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, posedge RENB, 0.0, NOTIFY_REG);
      $setup(negedge RENB, posedge RCLK &&& CLRB, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& CLRB, negedge RENB, 0.0, NOTIFY_REG);

      $recovery(posedge CLRB, posedge RCLK &&& RE_, 0.0, NOTIFY_REG);
      $recovery(posedge CLRB, posedge WCLK &&& WE_, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& RE_, posedge CLRB,  0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WE_, posedge CLRB, 0.0, NOTIFY_REG);


 endspecify

 endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOPADP_IN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADP_IN(PAD,N2PIN,Y);

output  Y;
input  PAD,N2PIN;
    
 reg NOTIFY_REG;

     buf          BF1   (Y, PAD);

specify 
    specparam   LibName       = "ax";
    specparam   InputLoad$PAD = 1;
    specparam   OutputLoad$Y  = 0;
    specparam   MacroType     = "io";

 
        (PAD => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1); 
        (N2PIN => Y) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                specparam PATHPULSE$N2PIN$Y = (0.1, 0.1);
                specparam PATHPULSE$PAD$Y = (0.1, 0.1);
                $width(negedge N2PIN, 0.0, 0, NOTIFY_REG);
                $width(posedge N2PIN, 0.0, 0, NOTIFY_REG);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);


endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOPADN_IN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADN_IN(PAD,N2POUT);

output  N2POUT;
input  PAD;

 reg NOTIFY_REG;
    
     buf          BF1   (N2POUT, PAD);

specify 
    specparam   LibName       = "ax";
    specparam   InputLoad$PAD = 1;
    specparam   OutputLoad$Y  = 0;
    specparam   MacroType     = "io";

 
        (PAD => N2POUT) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                specparam PATHPULSE$PAD$N2POUT = (0.1, 0.1);
                $width(negedge PAD, 0.0, 0, NOTIFY_REG);
                $width(posedge PAD, 0.0, 0, NOTIFY_REG);

endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOPADP_TRI
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADP_TRI(D, E, PAD);

output  PAD;
input  D, E;

 reg NOTIFY_REG;

   bufif1       BF1   (PAD, D, E);

specify 
 
         specparam   LibName     = "ax";
         specparam   OutputLoad$PAD = 0;
         specparam   InputLoad$D = 1;
         specparam   InputLoad$E = 1;
 
         specparam   MacroType = "io";

        (E => PAD) = (0.0:0.0:0.0,0.0:0.0:0.0,0.1:0.1:0.1,0.1:0.1:0.1,0.1:0.1:0.1,0.1:0.1:0.1); 
        (D => PAD) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                specparam PATHPULSE$D$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                $width(negedge D, 0.0, 0, NOTIFY_REG);
                $width(posedge D, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

 
endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : IOPADN_TRI
---------------------------------------------------------------------*/      

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOPADN_TRI(DB, E, PAD);

output  PAD;
input  DB, E;

 reg NOTIFY_REG;

   not          INVT (net1,DB);
   bufif1       BF1  (PAD, net1, E);

specify 
 
         specparam   LibName     = "ax";
         specparam   OutputLoad$PAD = 0;
         specparam   InputLoad$DB = 1;
         specparam   InputLoad$E = 1;
 
         specparam   MacroType = "io";

 
        (E  => PAD) = (0.1:0.1:0.1,0.1:0.1:0.1,0.1:0.1:0.1,0.1:0.1:0.1,0.1:0.1:0.1,0.1:0.1:0.1); 
        (DB => PAD) = (0.1:0.1:0.1, 0.1:0.1:0.1);
                specparam PATHPULSE$DB$PAD = (0.1, 0.1);
                specparam PATHPULSE$E$PAD = (0.1, 0.1);
                $width(negedge DB, 0.0, 0, NOTIFY_REG);
                $width(posedge DB, 0.0, 0, NOTIFY_REG);
                $width(negedge E, 0.0, 0, NOTIFY_REG);
                $width(posedge E, 0.0, 0, NOTIFY_REG);

 
endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : OUTBUF_LVDS
---------------------------------------------------------------------*/
     
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVDS(D, PADP,PADN);

input   D;
output  PADP,PADN;


        buf b1(PADP,D);
        not n1(PADN,D); 

specify 
 
         specparam   LibName        = "ax";
         specparam   InputLoad$D    = 1;
         specparam   OutputLoad$PADP = 0;
         specparam   OutputLoad$PADN = 0;
         specparam   MacroType      = "io";
 
	(D => PADP) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	(D => PADN) = (0.1:0.1:0.1, 0.1:0.1:0.1);

endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults
      
/*--------------------------------------------------------------------
 CELL NAME  : OUTBUF_LVPECL
---------------------------------------------------------------------*/     
    
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OUTBUF_LVPECL(D, PADP,PADN);

input   D;
output  PADP,PADN;


        buf b1(PADP,D);
        not n1(PADN,D); 
specify 
 
         specparam   LibName        = "ax";
         specparam   InputLoad$D    = 1;
         specparam   OutputLoad$PADP = 0;
         specparam   OutputLoad$PADN = 0;
         specparam   MacroType      = "io";
 
	(D => PADP) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	(D => PADN) = (0.1:0.1:0.1, 0.1:0.1:0.1);

endspecify

endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : PLL
---------------------------------------------------------------------*/
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ps / 1 ps

module PLL (PWRDWN, REFCLK, LOWFREQ, OSC2, OSC1, OSC0,
            DIVI5, DIVI4, DIVI3, DIVI2, DIVI1, DIVI0, 
            DIVJ5, DIVJ4, DIVJ3, DIVJ2, DIVJ1, DIVJ0,
            DELAYLINE4, DELAYLINE3, DELAYLINE2, DELAYLINE1, DELAYLINE0,
            LOCK, CLK1, CLK2);
              
parameter f_REFCLK_LOCK = 3;

input PWRDWN;
input REFCLK;
input LOWFREQ;
input OSC2, OSC1, OSC0;
input DIVI5, DIVI4, DIVI3, DIVI2, DIVI1, DIVI0;
input DIVJ5, DIVJ4, DIVJ3, DIVJ2, DIVJ1, DIVJ0;
input DELAYLINE4, DELAYLINE3, DELAYLINE2, DELAYLINE1, DELAYLINE0;

output LOCK;
output CLK1;
output CLK2;

reg LOCK_temp;
reg CLK1_temp;
reg CLK2_temp;

integer DIV;
integer MULT;
integer REFCLK_num_re;
integer DelayVal;
integer DivVal;
integer MultVal;

real DELAY;
real REFCLK_previous_period;
real REFCLK_re;
real REFCLK_previous_re;
real REFCLK_period;
real REFCLK_last_re;

real CLK1_pw;
real CLK2_pw;

// `define MINPER 71.429 // 14 MHz
// `define MAXPER 5.00   // 200 MHz

// Internal signals

reg REFCLK_period_stable;
reg REFCLK_prev;

reg start_CLK1;
reg restart_CLK1;
reg start_CLK2;
reg restart_CLK2;

// Assign CLK2 and CLK1 output signals

pmos p1(CLK2, CLK2_temp, 0);
pmos p2(CLK1, CLK1_temp, 0);
pmos p3(LOCK, LOCK_temp, 0);

// -- Check the legality of these three parameters
// -- Initialize Variables

initial begin  // Initialize internal variables

  REFCLK_previous_period = -1.00 ;
  REFCLK_re = 0.00 ;
  REFCLK_previous_re = 0.000 ;
  REFCLK_period = 0.000 ;
  REFCLK_last_re = 0.00 ;

  DelayVal = 0;
  DivVal = 0;
  MultVal = 0;
  DELAY = 0.000;

end // of initialization section

  always @(DELAYLINE4 or DELAYLINE3 or DELAYLINE2 or DELAYLINE1 or DELAYLINE0)

  begin
  
    DelayVal = 0;
    if (DELAYLINE0 == 1'b1)
      DelayVal = DelayVal + 1;
    if (DELAYLINE1 == 1'b1)
      DelayVal = DelayVal + 2;
    if (DELAYLINE2 == 1'b1)
      DelayVal = DelayVal + 4;
    if (DELAYLINE3 == 1'b1)
      DelayVal = DelayVal + 8;
    if (DELAYLINE4 == 1'b1)
      DelayVal = 0 - DelayVal;

    DELAY = DelayVal * 250;

  end  // of Get DELAY

 // --
 // -- Get DIV
 // --

  always @(DIVJ5 or DIVJ4 or DIVJ3 or DIVJ2 or DIVJ1 or DIVJ0)

  begin
  
    DivVal = 0;
    if (DIVJ0 == 1'b1)
      DivVal = DivVal + 1;
    if (DIVJ1 == 1'b1)
      DivVal = DivVal + 2;
    if (DIVJ2 == 1'b1)
      DivVal = DivVal + 4;
    if (DIVJ3 == 1'b1)
      DivVal = DivVal + 8;
    if (DIVJ4 == 1'b1)
      DivVal = DivVal + 16;
    if (DIVJ5 == 1'b1)
      DivVal = DivVal + 32;

    DIV = DivVal + 1;  // "000000" means 1 and "111111" means 64

  end  // of Get DIV

 // --
 // -- Get MULT
 // --

  always @(DIVI5 or DIVI4 or DIVI3 or DIVI2 or DIVI1 or DIVI0)

  begin
  
    MultVal = 0;
    if (DIVI0 == 1'b1)
      MultVal = MultVal + 1;
    if (DIVI1 == 1'b1)
      MultVal = MultVal + 2;
    if (DIVI2 == 1'b1)
      MultVal = MultVal + 4;
    if (DIVI3 == 1'b1)
      MultVal = MultVal + 8;
    if (DIVI4 == 1'b1)
      MultVal = MultVal + 16;
    if (DIVI5 == 1'b1)
      MultVal = MultVal + 32;

    MULT = MultVal + 1;  // "000000" means 1 and "111111" means 64

  end  // of Get MULT

 // --
 // -- Get REFCLK Period
 // --

 always @(posedge REFCLK or negedge PWRDWN)
 
 begin

    if (PWRDWN == 1'b1) begin
      if (REFCLK == 1'b1) begin
         REFCLK_previous_re = REFCLK_re;
         REFCLK_re = $time ;
         REFCLK_period = REFCLK_re - REFCLK_previous_re;

         if (REFCLK_previous_period != REFCLK_period) begin
           REFCLK_previous_period = REFCLK_period;
           REFCLK_period_stable = 1'b0;
         end else
           REFCLK_period_stable = 1'b1;
      end
    end else begin
       REFCLK_previous_period = -1.000;
       REFCLK_period_stable = 1'b0;
    end
    
 end // of Get REFCLK Period

 // --
 // -- Raise Lock
 // --

 always @(REFCLK_period_stable or posedge REFCLK)
 
 begin
 
   if ((REFCLK_period_stable == 1'b1) && (REFCLK == 1'b1))
     REFCLK_num_re = REFCLK_num_re + 1;
   else
     REFCLK_num_re = -1 ;
   if (REFCLK_num_re > f_REFCLK_LOCK) 
     LOCK_temp = 1'b1; 
   else
     LOCK_temp = 1'b0;

 end // of Raise Lock

 // --
 // -- Set CLK2 pulse width
 // --

 always @( PWRDWN or REFCLK_period_stable or restart_CLK2)
          
 begin

    if ((REFCLK_period_stable == 1'b1) && (PWRDWN == 1'b1)) begin
      if (MULT > 0) begin
        CLK2_pw =  (REFCLK_period / (MULT * 2.0));
        start_CLK2 = 1'b1;
      end else begin
        CLK2_pw <=  (REFCLK_period / 2.0);
        start_CLK2 = 1'b1;
      end
    end else begin
      start_CLK2 = 1'b0;
      restart_CLK2 = 1'b0;
    end
    if (PWRDWN == 1'b0) begin
      start_CLK2 = 1'b0;
      restart_CLK2 = 1'b0;
    end

 end // of Set CLK2 pulse width

 always @( PWRDWN ) 
 
 begin
 
    if ((REFCLK_period_stable == 1'b1) && (PWRDWN == 1'b1)) begin
      if (MULT > 0) begin
        CLK2_pw =  (REFCLK_period / (MULT * 2.0));
        start_CLK2 = 1'b1;
      end else begin
        CLK2_pw <=  (REFCLK_period / 2.0);
        start_CLK2 = 1'b1;
      end
      if (DIV > 0) begin
        CLK1_pw =  (CLK2_pw * DIV);
        start_CLK1 = 1'b1;
      end else begin
        CLK1_pw <=  (REFCLK_period / 2.0);
        start_CLK1 = 1'b1;
      end
    end else begin
      start_CLK1 <= 1'b0;
      restart_CLK1 <= 1'b0;
      start_CLK2 <= 1'b0;
      restart_CLK2 <= 1'b0;
    end

 end

 always @(restart_CLK2) begin
      if (REFCLK_period > 0.0) begin
          start_CLK2 = 1'b1;
          #REFCLK_period restart_CLK2 = 1'b0;
      end
 end

 always @(restart_CLK1) begin
      if (REFCLK_period > 0.0) begin
          start_CLK1 = 1'b1;
          #REFCLK_period restart_CLK1 = 1'b0;
      end
 end

 always @(DELAY) begin
          start_CLK1 = 1'b0;
          start_CLK2 = 1'b0;
          #REFCLK_period restart_CLK1 = 1'b1;
          restart_CLK2 = 1'b1;
 end 
        
 // --
 // -- Set CLK1 pulse width
 // --

 always @( PWRDWN or REFCLK_period_stable or restart_CLK1)
          
 begin

    if ((REFCLK_period_stable == 1'b1) && (PWRDWN == 1'b1)) begin
      if (DIV > 0) begin
        CLK1_pw =  (CLK2_pw * DIV);
        start_CLK1 = 1'b1;
      end else begin
        CLK1_pw <=  (REFCLK_period / 2.0);
        start_CLK1 = 1'b1;
      end
    end else begin
      start_CLK1 = 1'b0;
      restart_CLK1 = 1'b0;
    end

 end // of Set CLK1 pulse width

  // --
  // -- Ouptut CLK1
  // --

  always @(posedge start_CLK1) 
  
  begin

    @(posedge REFCLK) begin
      #((4 * REFCLK_period) + DELAY);
    end
    while (start_CLK1 == 1'b1) begin
      CLK1_temp = 1'b1;
      #CLK1_pw;
      CLK1_temp = 1'b0;
      #CLK1_pw;
    end

    CLK1_temp = 1'bx;

  end // Output CLK1

  // --
  // -- Output CLK2
  // --

  always @(posedge start_CLK2) 

  begin

    @(posedge REFCLK) begin
      #((4 * REFCLK_period) + DELAY);
    end
    while (start_CLK2 == 1'b1) begin
      CLK2_temp = 1'b1;
      #CLK2_pw;
      CLK2_temp = 1'b0;
      #CLK2_pw;
    end

    CLK2_temp = 1'bx;

  end // Output CLK2

  // --
  // -- Check for stopped REFCLK
  // --

  always @(CLK1_temp or CLK2_temp) 

  begin
    if ($time > 100000) begin
      if (($time - 100000) > REFCLK_re) begin
        REFCLK_period_stable = 1'b0;
        LOCK_temp = 1'b0;
      end
    end
  end

specify

    (REFCLK => LOCK) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    //(REFCLK => CLK1) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    //(REFCLK => CLK2) = (0.0:0.0:0.0, 0.0:0.0:0.0);  

endspecify

   
endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME  : PLLFB
---------------------------------------------------------------------*/
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ps / 1 ps

module PLLFB (PWRDWN, REFCLK, FB, LOWFREQ, OSC2, OSC1, OSC0,
              DIVI5, DIVI4, DIVI3, DIVI2, DIVI1, DIVI0, 
              DIVJ5, DIVJ4, DIVJ3, DIVJ2, DIVJ1, DIVJ0,
              DELAYLINE4, DELAYLINE3, DELAYLINE2, DELAYLINE1, DELAYLINE0,
              LOCK, CLK1, CLK2);
              
parameter f_REFCLK_LOCK = 3;

input PWRDWN;
input REFCLK;
input FB;
input LOWFREQ;
input OSC2, OSC1, OSC0;
input DIVI5, DIVI4, DIVI3, DIVI2, DIVI1, DIVI0;
input DIVJ5, DIVJ4, DIVJ3, DIVJ2, DIVJ1, DIVJ0;
input DELAYLINE4, DELAYLINE3, DELAYLINE2, DELAYLINE1, DELAYLINE0;

output LOCK;
output CLK1;
output CLK2;

reg LOCK_temp;
reg CLK1_temp;
reg CLK2_temp;

integer DIV;
integer MULT;
integer REFCLK_num_re;
integer DelayVal;
integer DivVal;
integer MultVal;
integer FB_delay_determined;

real DELAY;
real REFCLK_previous_period;
real REFCLK_re;
real REFCLK_previous_re;
real REFCLK_period;
real REFCLK_last_re;

real FB_previous_period;
real FB_re;
real FB_previous_re;
real FB_period;
real FB_delay;
real FB_prev_delay;
 
real CLK1_pw;
real CLK2_pw;

// `define MINPER 71.429 // 14 MHz
// `define MAXPER 5.00   // 200 MHz

// Internal signals

reg REFCLK_period_stable;
reg FB_period_stable;

reg start_CLK1;
reg restart_CLK1;
reg start_CLK2;
reg restart_CLK2;

// Assign CLK2 and CLK1 output signals

pmos p1(CLK2, CLK2_temp, 0);
pmos p2(CLK1, CLK1_temp, 0);
pmos p3(LOCK, LOCK_temp, 0);

// -- Check the legality of these three parameters
// -- Initialize Variables

initial begin  // Initialize internal variables

  REFCLK_previous_period = -1.00 ;
  REFCLK_re = 0.00 ;
  REFCLK_previous_re = 0.000 ;
  REFCLK_period = 0.000 ;
  REFCLK_last_re = 0.00 ;

  FB_previous_period = -1.00 ;
  FB_re = 0.00 ;
  FB_previous_re = 0.000 ;
  FB_delay = -1.000 ;
  FB_prev_delay = -1.000 ;
  FB_period = -1.000 ;
  FB_delay_determined = 0;

  DelayVal = 0;
  DivVal = 0;
  MultVal = 0;
  DELAY = 0.000;

end // of initialization section

 // --
 // -- Get DELAY
 // --

  always @(DELAYLINE4 or DELAYLINE3 or DELAYLINE2 or DELAYLINE1 or DELAYLINE0)

  begin
  
    DelayVal = 0;
    if (DELAYLINE0 == 1'b1)
      DelayVal = DelayVal + 1;
    if (DELAYLINE1 == 1'b1)
      DelayVal = DelayVal + 2;
    if (DELAYLINE2 == 1'b1)
      DelayVal = DelayVal + 4;
    if (DELAYLINE3 == 1'b1)
      DelayVal = DelayVal + 8;
    if (DELAYLINE4 == 1'b1)
      DelayVal = 0 - DelayVal;

    DELAY = DelayVal * 250;

  end  // of Get DELAY

 // --
 // -- Get DIV
 // --

  always @(DIVJ5 or DIVJ4 or DIVJ3 or DIVJ2 or DIVJ1 or DIVJ0)

  begin
  
    DivVal = 0;
    if (DIVJ0 == 1'b1)
      DivVal = DivVal + 1;
    if (DIVJ1 == 1'b1)
      DivVal = DivVal + 2;
    if (DIVJ2 == 1'b1)
      DivVal = DivVal + 4;
    if (DIVJ3 == 1'b1)
      DivVal = DivVal + 8;
    if (DIVJ4 == 1'b1)
      DivVal = DivVal + 16;
    if (DIVJ5 == 1'b1)
      DivVal = DivVal + 32;

    DIV = DivVal + 1;  // "000000" means 1 and "111111" means 64

  end  // of Get DIV

 // --
 // -- Get MULT
 // --

  always @(DIVI5 or DIVI4 or DIVI3 or DIVI2 or DIVI1 or DIVI0)

  begin
  
    MultVal = 0;
    if (DIVI0 == 1'b1)
      MultVal = MultVal + 1;
    if (DIVI1 == 1'b1)
      MultVal = MultVal + 2;
    if (DIVI2 == 1'b1)
      MultVal = MultVal + 4;
    if (DIVI3 == 1'b1)
      MultVal = MultVal + 8;
    if (DIVI4 == 1'b1)
      MultVal = MultVal + 16;
    if (DIVI5 == 1'b1)
      MultVal = MultVal + 32;

    MULT = MultVal + 1;  // "000000" means 1 and "111111" means 64

  end  // of Get MULT

 // --
 // -- Get REFCLK Period
 // --

 always @(posedge REFCLK or negedge PWRDWN)
 
 begin

    if (PWRDWN == 1'b1) begin
      if (REFCLK == 1'b1) begin
         REFCLK_previous_re = REFCLK_re;
         REFCLK_re = $time ;
         REFCLK_period = REFCLK_re - REFCLK_previous_re;

         if (REFCLK_previous_period != REFCLK_period) begin
           REFCLK_previous_period = REFCLK_period;
           REFCLK_period_stable = 1'b0;
         end
         else
           REFCLK_period_stable = 1'b1;
      end
    end else begin
       REFCLK_previous_period = -1.000;
       REFCLK_period_stable = 1'b0;
    end
    
 end // of Get REFCLK Period

 // --
 // -- Get FB Period
 // --

 always @(FB or PWRDWN)
 
 begin
 
    if (PWRDWN == 1'b1) begin
      if (FB == 1'b1) begin
        FB_previous_re = FB_re;
        FB_re = $time ;
        FB_period = FB_re - FB_previous_re;

        if (FB_previous_period != FB_period) begin
          FB_previous_period = FB_period;
          FB_period_stable = 1'b0;
        end
        else
          FB_period_stable = 1'b1;
      end else if (FB == 1'b0) begin
        // No op.
      end else /* if (FB == 1'bx) */ begin
        FB_previous_period = -1.000;
        FB_period_stable = 1'b0;
      end  
    end else begin
       FB_previous_period = -1.000;
       FB_period_stable = 1'b0;
    end
    
 end // of Get FB Period
 
 // --
 // -- Get FB Delay
 // --

 always @(FB_period_stable or REFCLK_period_stable or negedge PWRDWN)
 
 begin
 
    if (PWRDWN == 1'b1) begin
      if ((FB_period_stable == 1'b1) && (REFCLK_period_stable == 1'b1) &&
          (FB_delay_determined == 0)) begin
        if (FB_re > REFCLK_re) begin
          FB_delay = FB_re - REFCLK_re;
          if (FB_delay != FB_prev_delay) begin
            FB_prev_delay = FB_delay;
            FB_delay_determined = 1;
          end
        end
      end
    end
    
 end // of Get FB Delay

 // --
 // -- Raise Lock
 // --

 always @(REFCLK_period_stable or REFCLK or FB_delay_determined)
 
 begin
 
   if (FB_delay_determined == 1) begin
     if (REFCLK_period_stable == 1'b0)
       REFCLK_num_re = 0;
     if (FB_period_stable == 1'b0)
       REFCLK_num_re = 0;
     if (REFCLK_period_stable == 1'b1 && FB_period_stable == 1'b1) begin
       if (REFCLK == 1'b1) 
         REFCLK_num_re = REFCLK_num_re + 1;
     end else
       REFCLK_num_re = 0;
     if (REFCLK_num_re > f_REFCLK_LOCK) 
       LOCK_temp = 1'b1; 
     else
       LOCK_temp = 1'b0;
   end
   
 end // of Raise Lock

 // --
 // -- Set CLK2 pulse width
 // --

 always @( PWRDWN or REFCLK_period_stable or restart_CLK2)
          
 begin

    if ((REFCLK_period_stable == 1'b1) && (PWRDWN == 1'b1)) begin
      if (FB_delay_determined == 1) begin
        if (MULT > 0) begin
          CLK2_pw =  (REFCLK_period / (MULT * 2.0));
          start_CLK2 = 1'b1;
        end else begin
          CLK2_pw <=  (REFCLK_period / 2.0);
          start_CLK2 = 1'b1;
        end
      end else begin
        CLK2_pw =  (REFCLK_period / 2.0);
        start_CLK2 = 1'b1;
      end
    end else begin
      start_CLK2 = 1'b0;
      restart_CLK2 = 1'b0;
    end
    if (PWRDWN == 1'b0) begin
      start_CLK2 = 1'b0;
      restart_CLK2 = 1'b0;
    end

 end // of Set CLK2 pulse width

 always @( PWRDWN ) 
 
 begin
 
    if ((REFCLK_period_stable == 1'b1) && (PWRDWN == 1'b1)) begin
      if (FB_delay_determined == 1) begin
        if (MULT > 0) begin
          CLK2_pw =  (REFCLK_period / (MULT * 2.0));
          start_CLK2 = 1'b1;
        end else begin
          CLK2_pw <=  (REFCLK_period / 2.0);
          start_CLK2 = 1'b1;
        end
        if (DIV > 0) begin
          CLK1_pw =  (CLK2_pw * DIV);
          start_CLK1 = 1'b1;
        end else begin
          CLK1_pw <=  (REFCLK_period / 2.0);
          start_CLK1 = 1'b1;
        end
      end else begin
        CLK1_pw <= (REFCLK_period / 2.0);
        start_CLK1 <= 1'b1;
        CLK2_pw <= (REFCLK_period / 2.0);
        start_CLK2 <= 1'b1;
      end
    end else begin
      start_CLK1 <= 1'b0;
      restart_CLK1 <= 1'b0;
      start_CLK2 <= 1'b0;
      restart_CLK2 <= 1'b0;
    end

 end

 always @(FB_delay_determined) begin
          start_CLK2 = 1'b0;
          start_CLK1 = 1'b0;
          #REFCLK_period restart_CLK1 = 1'b1;
          restart_CLK2 = 1'b1;
 end

 always @(restart_CLK2) begin
      if (REFCLK_period > 0.0) begin
          start_CLK2 = 1'b1;
          #REFCLK_period restart_CLK2 = 1'b0;
      end
 end

 always @(restart_CLK1) begin
      if (REFCLK_period > 0.0) begin
          start_CLK1 = 1'b1;
          #REFCLK_period restart_CLK1 = 1'b0;
      end
 end

 always @(DELAY) begin
          start_CLK1 = 1'b0;
          start_CLK2 = 1'b0;
          #REFCLK_period restart_CLK1 = 1'b1;
          restart_CLK2 = 1'b1;
 end 
        
 // --
 // -- Set CLK1 pulse width
 // --

 always @( PWRDWN or REFCLK_period_stable or restart_CLK1)
          
 begin

    if ((REFCLK_period_stable == 1'b1) && (PWRDWN == 1'b1)) begin
      if (FB_delay_determined == 1) begin
        if (DIV > 0) begin
          CLK1_pw =  (CLK2_pw * DIV);
          start_CLK1 = 1'b1;
        end else begin
          CLK1_pw <=  (REFCLK_period / 2.0);
          start_CLK1 = 1'b1;
        end
      end else begin
        CLK1_pw =  (REFCLK_period / 2.0);
        start_CLK1 = 1'b1;
      end
    end else begin
      start_CLK1 = 1'b0;
      restart_CLK1 = 1'b0;
    end

 end // of Set CLK1 pulse width

  // --
  // -- Ouptut CLK1
  // --

  always @(start_CLK1) 
  
  begin

    @(posedge REFCLK) begin
      if (FB_delay_determined == 1)
        #((4 * REFCLK_period) + DELAY - FB_delay);
    end
    while (start_CLK1 == 1'b1) begin
      CLK1_temp = 1'b1;
      #CLK1_pw;
      CLK1_temp = 1'b0;
      #CLK1_pw;
    end

    CLK1_temp = 1'bx;

  end // Output CLK1

  // --
  // -- Output CLK2
  // --

  always @(start_CLK2) 

  begin

    @(posedge REFCLK) begin
      if (FB_delay_determined == 1)
        #((4 * REFCLK_period) + DELAY - FB_delay);
    end
    while (start_CLK2 == 1'b1) begin
      CLK2_temp = 1'b1;
      #CLK2_pw;
      CLK2_temp = 1'b0;
      #CLK2_pw;
    end

    CLK2_temp = 1'bx;

  end // Output CLK2

  // --
  // -- Check for stopped REFCLK
  // --

  always @(CLK1_temp or CLK2_temp)

  begin
    if ($time > 100000) begin
      if (($time - 100000) > REFCLK_re) begin
        REFCLK_period_stable = 1'b0;
        LOCK_temp = 1'b0;
      end
    end
  end

specify

    (REFCLK => LOCK) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    //(REFCLK => CLK1) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    //(REFCLK => CLK2) = (0.0:0.0:0.0, 0.0:0.0:0.0);  

endspecify

   
endmodule
`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME  : RAM64K36
---------------------------------------------------------------------*/
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

`define RCLK_TO_RD 5.0

module RAM64K36(DEPTH3,DEPTH2,DEPTH1,DEPTH0,WRAD15,WRAD14,WRAD13,WRAD12,
                WRAD11,WRAD10,WRAD9,WRAD8,WRAD7,WRAD6,WRAD5,WRAD4,
                WRAD3,WRAD2,WRAD1,WRAD0,
                WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26,
                WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,
                WD15,WD14,WD13,WD12,WD11,WD10,WD9 ,WD8 ,WD7 ,WD6,
                WD5, WD4, WD3, WD2, WD1, WD0,
                WW2,WW1,WW0,WEN,
                WCLK,RDAD15,RDAD14,RDAD13,RDAD12,RDAD11,RDAD10,RDAD9,
                RDAD8,RDAD7,RDAD6,RDAD5,RDAD4,RDAD3,RDAD2, RDAD1,RDAD0,
                RW2,RW1,RW0,REN,
                RCLK,
                RD35,RD34,RD33,RD32,RD31,RD30,RD29,RD28,RD27,RD26,
                RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,
                RD15,RD14,RD13,RD12,RD11,RD10,RD9, RD8, RD7, RD6,
                RD5, RD4, RD3, RD2, RD1, RD0);

input WRAD15,WRAD14,WRAD13,WRAD12,WRAD11,WRAD10,WRAD9,WRAD8,WRAD7,WRAD6,WRAD5,WRAD4,WRAD3,WRAD2,WRAD1,WRAD0;
input WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26;
input WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16;
input WD15,WD14,WD13,WD12,WD11,WD10,WD9 ,WD8 ,WD7 ,WD6;
input WD5, WD4, WD3, WD2, WD1, WD0;

input WW2,WW1,WW0;
input WCLK,WEN;

input RCLK,REN;
input RW2,RW1,RW0;
input RDAD15,RDAD14,RDAD13,RDAD12,RDAD11,RDAD10,RDAD9,RDAD8,RDAD7,RDAD6,RDAD5,RDAD4,RDAD3,RDAD2,RDAD1,RDAD0;

input DEPTH3,DEPTH2,DEPTH1,DEPTH0;

output RD35,RD34,RD33,RD32,RD31,RD30,RD29,RD28,RD27,RD26;
output RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16;
output RD15,RD14,RD13,RD12,RD11,RD10,RD9, RD8, RD7, RD6;
output RD5,RD4,RD3,RD2,RD1,RD0;

reg RD35P,RD34P,RD33P,RD32P,RD31P,RD30P,RD29P,RD28P,RD27P,RD26P;
reg RD25P,RD24P,RD23P,RD22P,RD21P,RD20P,RD19P,RD18P,RD17P,RD16P;
reg RD15P,RD14P,RD13P,RD12P,RD11P,RD10P,RD9P, RD8P, RD7P, RD6P;
reg RD5P,RD4P,RD3P,RD2P,RD1P,RD0P;

wire RCLK1,WCLK1;
wire WEN1,REN1;

reg [8:0]  MEM_8K_9 [0:8191];

reg NOTIFY_REG;

integer WADDR;            // Write Address
   integer MAX_WADDR;  
integer RADDR;            // Read address
   integer MAX_RADDR;  
integer DEPTH;
integer MAXADD;

time    WCLK1_re, RCLK1_re;
reg     WEN_lat, REN_lat;

 /********************* TEXT MACRO DEFINITIONS ******************/

`define WRITE_WIDTH_CFG {WW2,WW1,WW0}
`define READ_WIDTH_CFG  {RW2,RW1,RW0}
`define WRITE_ADDR      {WRAD15,WRAD14,WRAD13,WRAD12,WRAD11,WRAD10,WRAD9,WRAD8,WRAD7,WRAD6,WRAD5,WRAD4,WRAD3,WRAD2,WRAD1,WRAD0}
`define READ_ADDR       {RDAD15,RDAD14,RDAD13,RDAD12,RDAD11,RDAD10,RDAD9,RDAD8,RDAD7,RDAD6,RDAD5,RDAD4,RDAD3,RDAD2,RDAD1,RDAD0} 
`define DATA_WIDTH_1    RD0P 
`define DATA_WIDTH_2   {RD1P,RD0P}
`define DATA_WIDTH_4   {RD3P,RD2P,RD1P,RD0P}
`define DATA_WIDTH_9   {RD8P,RD7P,RD6P,RD5P,RD4P,RD3P,RD2P,RD1P,RD0P}
`define DATA_WIDTH_18  {RD17P,RD16P,RD15P,RD14P,RD13P,RD12P,RD11P,RD10P,RD9P,RD8P,RD7P,RD6P,RD5P,RD4P,RD3P,RD2P,RD1P,RD0P}
`define DATA_WIDTH_36  {RD35P,RD34P,RD33P,RD32P,RD31P,RD30P,RD29P,RD28P,RD27P,RD26P,RD25P,RD24P,                                                              RD23P,RD22P,RD21P,RD20P,RD19P,RD18P,RD17P,RD16P,RD15P,RD14P,RD13P,RD12P,                                                              RD11P,RD10P,RD9P,RD8P,RD7P,RD6P,RD5P,RD4P,RD3P,RD2P,RD1P,RD0P}

/***************************************************************/

buf inst3(WCLK1, WCLK);
buf inst4(RCLK1, RCLK);
buf inst50(WEN1,WEN);
buf inst60(REN1,REN);


pmos inst5(RD35, RD35P, 0);
pmos inst6(RD34, RD34P, 0);
pmos inst7(RD33, RD33P, 0);
pmos inst8(RD32, RD32P, 0);
pmos inst9(RD31, RD31P, 0);
pmos inst10(RD30, RD30P, 0);
pmos inst11(RD29, RD29P, 0);
pmos inst12(RD28, RD28P, 0);
pmos inst13(RD27, RD27P, 0);

pmos inst14(RD26, RD26P, 0);
pmos inst15(RD25, RD25P, 0);
pmos inst16(RD24, RD24P, 0);
pmos inst17(RD23, RD23P, 0);
pmos inst18(RD22, RD22P, 0);
pmos inst19(RD21, RD21P, 0);
pmos inst20(RD20, RD20P, 0);
pmos inst21(RD19, RD19P, 0);
pmos inst22(RD18, RD18P, 0);

pmos inst23(RD17, RD17P, 0);
pmos inst24(RD16, RD16P, 0);
pmos inst25(RD15, RD15P, 0);
pmos inst26(RD14, RD14P, 0);
pmos inst27(RD13, RD13P, 0);
pmos inst28(RD12, RD12P, 0);
pmos inst29(RD11, RD11P, 0);
pmos inst30(RD10, RD10P, 0);
pmos inst31(RD9, RD9P, 0);


pmos inst32(RD8, RD8P, 0);
pmos inst33(RD7, RD7P, 0);
pmos inst34(RD6, RD6P, 0);
pmos inst35(RD5, RD5P, 0);
pmos inst36(RD4, RD4P,0);
pmos inst37(RD3, RD3P, 0);
pmos inst38(RD2, RD2P, 0);
pmos inst39(RD1, RD1P, 0);
pmos inst40(RD0, RD0P, 0);

parameter MEMORYFILE = "";

  initial
    begin
      if ( MEMORYFILE != "")
        $readmemb ( MEMORYFILE, MEM_8K_9 );
      else
        begin
          //$display ( "Warning: %m, No memory initialization file parameter MEMORYFILE defined\n");
        end
    end


always @(WCLK1 === 1'bx )
begin
  if($time > 0) begin
   if(WEN1 == 1'b1) begin
      $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
      //$finish;
   end
  end
end

always @(RCLK1 === 1'bx )
begin
  if($time > 0) begin
   if (REN1 == 1'b1) begin
      $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
      //$finish;
   end
  end
end

always @(DEPTH3 or DEPTH2 or DEPTH1 or DEPTH0 or WW2 or WW1 or WW0)
   MAX_WADDR = get_max_address(DEPTH3, DEPTH2, DEPTH1, DEPTH0,`WRITE_WIDTH_CFG);

always @(DEPTH3 or DEPTH2 or DEPTH1 or DEPTH0 or RW2 or RW1 or RW0)
   MAX_RADDR = get_max_address(DEPTH3, DEPTH2, DEPTH1, DEPTH0,`READ_WIDTH_CFG);
  
// start the RAM write behavior section

always @(posedge WCLK1) begin 
    WCLK1_re = $time;
    WEN_lat  = WEN1;
    if(WEN1 == 1'b1)  begin
      WADDR = get_address(`WRITE_ADDR);         // call address calculation function to get write address
      if(WADDR < 0) begin
         $display(" Warning: Write Address WADDR is unknown at time %0.1f!", $realtime);
       //  $finish;
      end else if (WADDR >= MAX_WADDR) begin // if (WADDR < 0)
	  $display ("Warning : WRITE ADDRESS IS OUT OF RANGE at time %0.1f", $realtime);
	  $display ("WADDR = %0d, MAX WRITE ADDRESS = %0d,\n",WADDR, MAX_WADDR - 1);	  
	  
      end else begin                                             // -- if (WADDR >=0) legal address range 
       // Check for Write and Read to the same address, write is not affected
       if ( (REN_lat == 1'b1) && same_addr(WADDR, RADDR, `WRITE_WIDTH_CFG, `READ_WIDTH_CFG) &&
                                                         ((RCLK1_re + `RCLK_TO_RD) > WCLK1_re) ) begin
        $display (" ** Warning: Read and Write to same address at same time.  RD is unpredictable, driving RD to X ");
        $display (" Time: %0.1f Instance: %m ", $realtime );
        `DATA_WIDTH_36 = drive_rd_x (WADDR, RADDR, `WRITE_WIDTH_CFG, `READ_WIDTH_CFG, `DATA_WIDTH_36);
       end
       case ({WW2,WW1,WW0})
            3'b000 : MEM_8K_9 [ WADDR[15:3] ] [ WADDR[2:0] ] <= WD0; 

            3'b001 : begin
                     MEM_8K_9 [ WADDR[14:2] ] [ WADDR[1:0] * 2 ] <= WD0;
                     MEM_8K_9 [ WADDR[14:2] ] [ WADDR[1:0] * 2 + 1 ] <= WD1;
                end
            3'b010 : begin
                     MEM_8K_9 [ WADDR[13:1] ] [ WADDR[0] * 4 ] <= WD0;
                     MEM_8K_9 [ WADDR[13:1] ] [ WADDR[0] * 4 + 1 ]  <= WD1;
                     MEM_8K_9 [ WADDR[13:1] ] [ WADDR[0] * 4 + 2 ]  <= WD2;
                     MEM_8K_9 [ WADDR[13:1] ] [ WADDR[0] * 4 + 3 ]  <= WD3;
                end 
            3'b011 : begin
                     MEM_8K_9 [ WADDR[12:0] ]  <= { WD8, WD7, WD6, WD5, WD4, WD3, WD2, WD1, WD0 };
                end 
            3'b100 : begin
                     MEM_8K_9 [ WADDR[11:0] * 2 ]  <= { WD8, WD7, WD6, WD5, WD4, WD3, WD2, WD1, WD0 };
                     MEM_8K_9 [ WADDR[11:0] * 2 + 1 ]  <= { WD17, WD16, WD15, WD14, WD13, WD12, WD11, WD10, WD9 };
                end
            3'b101 : begin
                     MEM_8K_9 [ WADDR[10:0] * 4 ]  <= { WD8, WD7, WD6, WD5, WD4, WD3, WD2, WD1, WD0 };
                     MEM_8K_9 [ WADDR[10:0] * 4 + 1 ]  <= { WD17, WD16, WD15, WD14, WD13, WD12, WD11, WD10, WD9 };
                     MEM_8K_9 [ WADDR[10:0] * 4 + 2 ]  <= { WD26, WD25, WD24, WD23, WD22, WD21, WD20, WD19, WD18 };
                     MEM_8K_9 [ WADDR[10:0] * 4 + 3 ]  <= { WD35, WD34, WD33, WD32, WD31, WD30, WD29, WD28, WD27 };
               end
            default : begin
                 $display("Warning: WWIDTH value invalid at time %d",$time);
                // $finish;
               end
       endcase
    end
   end else if (WEN1 == 1'b0) begin
       // $display("MSG :  WEN are Low!  No memory writing at time =%d", $time); 
   end else begin
       $display ("Warning: WEN went unknown at time %d ns", $time);
      // $finish;
   end
 end


// start the RAM READING behaviour section

 always @(posedge RCLK1) begin
   RCLK1_re = $time;
   REN_lat  = REN1;
   if(REN1 == 1'b0 ) begin 
   // Output remains unchanged
   end
   else if(REN1 == 1'b1 )  begin
    RADDR =get_address(`READ_ADDR);      //  call address calculation function 
    if (RADDR < 0) begin
     $display ("MSG :  Invalid  READ ADDRESS!");
     case(`READ_WIDTH_CFG)
      3'b000 :  `DATA_WIDTH_1 = 1'bx;
      3'b001 :  `DATA_WIDTH_2 = 2'bx;
      3'b010 :  `DATA_WIDTH_4 = 4'bx;
      3'b011 :  `DATA_WIDTH_9 = 9'bx;
      3'b100 :  `DATA_WIDTH_18  = 18'bx;
      3'b101 :  `DATA_WIDTH_36  = 36'bx; 
      default : begin
                 $display("Warning : Invalid READ WIDTH at time %d ns,Legal Width: 1,2,4,9,18,36",$time);
                 //$finish;
                end
     endcase
      end else if (RADDR >= MAX_RADDR) begin 
	  $display ("Warning : READ ADDRESS IS OUT OF RANGE at time %0.1f", $realtime);
	  $display ("RADDR = %0d, MAX READ ADDRESS = %0d,\n",RADDR, MAX_RADDR - 1);
     case(`READ_WIDTH_CFG)
      3'b000 :  `DATA_WIDTH_1 = 1'bx;
      3'b001 :  `DATA_WIDTH_2 = 2'bx;
      3'b010 :  `DATA_WIDTH_4 = 4'bx;
      3'b011 :  `DATA_WIDTH_9 = 9'bx;
      3'b100 :  `DATA_WIDTH_18  = 18'bx;
      3'b101 :  `DATA_WIDTH_36  = 36'bx; 
      default : begin
                 $display("Warning : Invalid READ WIDTH at time %d ns,Legal Width: 1,2,4,9,18,36",$time);
                 //$finish;
                end	  
     endcase	  
    end else begin
     case(`READ_WIDTH_CFG)
       3'b000 : RD0P = MEM_8K_9 [ RADDR[15:3] ] [ RADDR[2:0] ];
       3'b001 : begin 
                 RD0P = MEM_8K_9 [ RADDR[14:2] ] [ RADDR[1:0] * 2 ];
                 RD1P = MEM_8K_9 [ RADDR[14:2] ] [ RADDR[1:0] * 2 + 1]; 
                end
       3'b010 : begin 
                 RD0P = MEM_8K_9 [ RADDR[13:1] ] [ RADDR[0] * 4 ];
                 RD1P = MEM_8K_9 [ RADDR[13:1] ] [ RADDR[0] * 4 + 1 ];
                 RD2P = MEM_8K_9 [ RADDR[13:1] ] [ RADDR[0] * 4 + 2 ];
                 RD3P = MEM_8K_9 [ RADDR[13:1] ] [ RADDR[0] * 4 + 3 ];
                end
       3'b011 : begin
                 { RD8P, RD7P, RD6P, RD5P, RD4P, RD3P, RD2P, RD1P, RD0P } = MEM_8K_9 [ RADDR[12:0] ];
                end
       3'b100 : begin
                 { RD8P, RD7P, RD6P, RD5P, RD4P, RD3P, RD2P, RD1P, RD0P } = MEM_8K_9 [ RADDR[11:0] * 2 ];
                 { RD17P, RD16P, RD15P, RD14P, RD13P, RD12P, RD11P, RD10P, RD9P } = MEM_8K_9 [ RADDR[11:0] * 2 + 1 ];
                end
       3'b101 : begin
                 { RD8P, RD7P, RD6P, RD5P, RD4P, RD3P, RD2P, RD1P, RD0P } = MEM_8K_9 [ RADDR[10:0] * 4 ];
                 { RD17P, RD16P, RD15P, RD14P, RD13P, RD12P, RD11P, RD10P, RD9P } = MEM_8K_9 [ RADDR[10:0] * 4 + 1 ];
                 { RD26P, RD25P, RD24P, RD23P, RD22P, RD21P, RD20P, RD19P, RD18P } = MEM_8K_9 [ RADDR[10:0] * 4 + 2 ];
                 { RD35P, RD34P, RD33P, RD32P, RD31P, RD30P, RD29P, RD28P, RD27P } = MEM_8K_9 [ RADDR[10:0] * 4 + 3 ];
                end 
       default : begin
                  $display ("Warning: invalid READ WIDTH at time %d ns, Legal Width: 1,2,4,9,18,36", $time);
                 end
     endcase

     // Check for Write and Read to the same address
     if ( (WEN_lat == 1'b1) && same_addr(WADDR, RADDR, `WRITE_WIDTH_CFG, `READ_WIDTH_CFG) &&
                                                       ((WCLK1_re + `RCLK_TO_RD) > RCLK1_re) ) begin
       $display (" ** Warning: Write and Read to same address at same time.  RD is unpredictable, driving RD to X");
       $display (" Time: %0.1f Instance: %m ", $realtime );
       `DATA_WIDTH_36 = drive_rd_x (WADDR, RADDR, `WRITE_WIDTH_CFG, `READ_WIDTH_CFG, `DATA_WIDTH_36);
     end // check for Write and Read to the same address
   end // end block : REN = 1'b0 or 1'b1
  end else begin // REN = 1'bx
    $display("Warning: REN is unknown at time %d ns", $time); 
    case(`READ_WIDTH_CFG)
      3'b000 :  `DATA_WIDTH_1 = 1'bx;
      3'b001 :  `DATA_WIDTH_2 = 2'bx;
      3'b010 :  `DATA_WIDTH_4 = 4'bx;
      3'b011 :  `DATA_WIDTH_9 = 9'bx;
      3'b100 :  `DATA_WIDTH_18 = 18'bx;
      3'b101 :  `DATA_WIDTH_36 = 36'bx;
      default : begin
                 $display("Warning : Invalid READ WIDTH at time %d,Legal Width: 1,2,4,9,18,36", $time);
                 //$finish;
               end
    endcase
  end 
 end

// function to check if write and read operations are accessing the same memory location

function same_addr;
  input [15:0] waddr, raddr;
  input [2:0]  ww, rw;
  integer      wr_addr, rd_addr;
  begin
    same_addr = 1'b0;
    if ( ww > rw ) begin
      rd_addr = raddr >> (  ww - rw );
      wr_addr = waddr; 
    end
    else if ( rw > ww )begin
      rd_addr = raddr;
      wr_addr = waddr >> (  rw - ww );
    end
    else begin
      rd_addr = raddr;
      wr_addr = waddr; 
    end
    if ( wr_addr == rd_addr ) begin
      same_addr = 1'b1;
    end
  end
endfunction


// function to drive read data bus to "x" depending on width configuration

function [35:0] drive_rd_x;
  input [15:0] waddr, raddr;
  input [2:0]  ww, rw;
  input [35:0] rd_data;
  integer      index, i;
  begin
    drive_rd_x = rd_data;
    case(rw)
      3'b000 : begin
                 drive_rd_x [0] =  1'bx;
               end
      3'b001 : begin
                 if ( ww == 3'b000 )
                   drive_rd_x [ waddr[0] ] =  1'bx;
                 else
                   drive_rd_x [ 1:0 ] =  2'bx;
               end
      3'b010 : begin
                 if ( ww == 3'b000 )
                   drive_rd_x [ waddr[1:0] ] =  1'bx;
                 else if ( ww == 3'b001 ) begin
                   index = waddr[0] * 2;
                   for ( i=index; i<index+2; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else
                   drive_rd_x [ 3:0 ] =  4'bx;
               end
      3'b011 : begin
                 if ( ww == 3'b000 )
                   drive_rd_x [ waddr[2:0] ] =  1'bx;
                 else if ( ww == 3'b001 ) begin
                   index = waddr[1:0] * 2;
                   for ( i=index; i<index+2; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b010 ) begin
                   index = waddr[0] * 4;
                   for ( i=index; i<index+4; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else
                   drive_rd_x [ 8:0 ] =  9'bx;
               end
      3'b100 : begin
                 if ( ww == 3'b000 )
                   drive_rd_x [ waddr[3:0] ] =  1'bx;
                 else if ( ww == 3'b001 ) begin
                   index = waddr[2:0] * 2;
                   for ( i=index; i<index+2; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b010 ) begin
                   index = waddr[1:0] * 4;
                   for ( i=index; i<index+4; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b011 ) begin
                   index = waddr[0] * 9;
                   for ( i=index; i<index+9; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else
                   drive_rd_x [ 17:0 ] =  18'bx;
               end
      3'b101 : begin
                 if ( ww == 3'b000 )
                   drive_rd_x [ waddr[4:0] ] =  1'bx;
                 else if ( ww == 3'b001 ) begin
                   //drive_rd_x [ waddr[3:0] * 2 + 1 : waddr[2:0] * 2 ] =  2'bx;
                   index = waddr[3:0] * 2;
                   for ( i=index; i<index+2; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b010 ) begin
                   //drive_rd_x [ waddr[2:0] * 4 + 3 : waddr[1:0] * 4 ] =  4'bx;
                   index = waddr[2:0] * 4;
                   for ( i=index; i<index+4; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b011 ) begin
                   //drive_rd_x [ waddr[1:0] * 9 + 8 : waddr[1:0] * 9 ] =  9'bx;
                   index = waddr[1:0] * 9;
                   for ( i=index; i<index+9; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b100 ) begin
                   //drive_rd_x [ waddr[0] * 18 + 17 : waddr[0] * 18 ] =  18'bx;
                   index = waddr[0] * 18;
                   for ( i=index; i<index+18; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else
                   drive_rd_x [ 35:0 ] =  36'bx;
               end
      default: begin
                $display("Warning : Invalid READ WIDTH at time %d ns,Legal Width: 1,2,4,9,18,36",$time);
               end
     endcase
  end

endfunction

// function  to calculate the read/write address  get_address

function integer get_address;
  input [15:0] addr_signal;
//  input [2 :0] width_cfg;
  integer ADDR;
begin
    // the address calculation is based on both width and depth, here we only consider width, but we assume that
    // users will connect upper used address pin to GND (1'b0), otherwise it may cause problem !
   // case (width_cfg)
          ADDR = addr_signal[15]*32768 + addr_signal[14]*16384 + addr_signal[13]*8192 + addr_signal[12]*4096
               + addr_signal[11]*2048 + addr_signal[10]*1024 + addr_signal[9]*512 + addr_signal[8]*256
               + addr_signal[7]*128 + addr_signal[6]*64 + addr_signal[5]*32 + addr_signal[4]*16
               + addr_signal[3]*8 + addr_signal[2]*4 + addr_signal[1]*2 + addr_signal[0]*1;
  /*  3'b001 :ADDR = addr_signal[14]*16384 + addr_signal[13]*8192 + addr_signal[12]*4096  
                 + addr_signal[11]*2048 + addr_signal[10]*1024 + addr_signal[9]*512 + addr_signal[8]*256
                 + addr_signal[7]*128 + addr_signal[6]*64 + addr_signal[5]*32 + addr_signal[4]*16
                 + addr_signal[3]*8 + addr_signal[2]*4 + addr_signal[1]*2 + addr_signal[0]*1;  
    3'b010 :ADDR =  addr_signal[13]*8192 + addr_signal[12]*4096  + addr_signal[11]*2048 + addr_signal[10]*1024 
                 + addr_signal[9]*512 + addr_signal[8]*256+ addr_signal[7]*128 + addr_signal[6]*64 
                 + addr_signal[5]*32 + addr_signal[4]*16 + addr_signal[3]*8 + addr_signal[2]*4 
                 + addr_signal[1]*2 + addr_signal[0]*1;  
    3'b011: ADDR = addr_signal[12]*4096  + addr_signal[11]*2048 + addr_signal[10]*1024
                 + addr_signal[9]*512 + addr_signal[8]*256+ addr_signal[7]*128 + addr_signal[6]*64
                 + addr_signal[5]*32 + addr_signal[4]*16 + addr_signal[3]*8 + addr_signal[2]*4 
                 + addr_signal[1]*2 + addr_signal[0]*1; 
    3'b100 :ADDR = addr_signal[11]*2048 + addr_signal[10]*1024 + addr_signal[9]*512  + addr_signal[8]*256
                 + addr_signal[7]*128 + addr_signal[6]*64  + addr_signal[5]*32 + addr_signal[4]*16 
                 + addr_signal[3]*8 + addr_signal[2]*4  + addr_signal[1]*2 + addr_signal[0]*1;
    3'b101 :ADDR = addr_signal[10]*1024 + addr_signal[9]*512  + addr_signal[8]*256
                 + addr_signal[7]*128 + addr_signal[6]*64  + addr_signal[5]*32 + addr_signal[4]*16
                 + addr_signal[3]*8 + addr_signal[2]*4  + addr_signal[1]*2 + addr_signal[0]*1;
    default : begin
             $display("Warning:   invalid WIDTH Configuration");
             if((width_cfg[2] === 1'bx ) || ( width_cfg[1]=== 1'bx ) || (width_cfg[0] === 1'bx ))
               $display("Warning : Width configuration signal WW/RW  went unknown!");
             else
               $display("Warning : Invalid READ WIDTH, Legal Width: 1,2,4,9,18,36.");
             ADDR = -1;
           //  $finish;
             end
  endcase
 */

  get_address =ADDR;
 end
endfunction

// function to get the depth

function integer get_depth;
  input DEPTH3,DEPTH2,DEPTH1,DEPTH0;
  integer depth;
begin
  get_depth = DEPTH3*8 + DEPTH2*4 + DEPTH1*2 + DEPTH0*1;
end 
endfunction

// function to get the maximum address

function integer get_max_address;
  input DEPTH3,DEPTH2,DEPTH1,DEPTH0;
  input [2:0] width_cfg;
  integer depth;
  begin
   depth = get_depth( DEPTH3,DEPTH2,DEPTH1,DEPTH0 );
   case (width_cfg)
   3'b000 : get_max_address = 4096 * (depth +1);
   3'b001 : get_max_address = 2048 * (depth +1);
   3'b010 : get_max_address = 1024 * (depth +1);
   3'b011 : get_max_address = 512 *  (depth +1);
   3'b100 : get_max_address = 256  * (depth +1);
   3'b101 : get_max_address = 128  * (depth +1);
   default : begin
             $display("Warning: Illegal WIDTH PORT configuration at time %d ns!",$time);
             //$finish;
             end
   endcase 
  end
endfunction



specify
      specparam   LibName     = "ax";
      (posedge RCLK => (RD35+:RD35) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD34+:RD24) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD33+:RD33) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD32+:RD32) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD31+:RD31) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD30+:RD30) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD29+:RD29) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD28+:RD28) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD27+:RD27) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (RD26+:RD26) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD25+:RD25) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD24+:RD24) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD23+:RD23) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD22+:RD22) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD21+:RD21) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD20+:RD20) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD19+:RD19) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD18+:RD18) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (RD17+:RD17) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD16+:RD16) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD15+:RD15) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD14+:RD14) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD13+:RD13) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD12+:RD12) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD11+:RD11) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD10+:RD10) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD9+:RD9) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (RD8+:RD8) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD7+:RD7) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD6+:RD6) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD5+:RD5) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD4+:RD4) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD3+:RD3) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD2+:RD2) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD1+:RD1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD0+:RD0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

    if ( WEN1 )
      (posedge WCLK => (RD35+:RD35) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD34+:RD24) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD33+:RD33) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD32+:RD32) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD31+:RD31) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD30+:RD30) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD29+:RD29) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD28+:RD28) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD27+:RD27) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);

    if ( WEN1 )
      (posedge WCLK => (RD26+:RD26) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD25+:RD25) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD24+:RD24) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD23+:RD23) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD22+:RD22) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD21+:RD21) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD20+:RD20) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD19+:RD19) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD18+:RD18) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);

    if ( WEN1 )
      (posedge WCLK => (RD17+:RD17) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD16+:RD16) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD15+:RD15) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD14+:RD14) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD13+:RD13) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD12+:RD12) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD11+:RD11) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD10+:RD10) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD9+:RD9) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);


    if ( WEN1 )
      (posedge WCLK => (RD8+:RD8) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD7+:RD7) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD6+:RD6) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD5+:RD5) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD4+:RD4) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD3+:RD3) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD2+:RD2) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD1+:RD1) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD0+:RD0) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);

      $width(posedge WCLK &&& WEN1, 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK &&& WEN1, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK &&& REN1, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK &&& REN1, 0.0, 0, NOTIFY_REG);

      $setup(posedge WRAD15, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD15, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD15, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD15, 0.0, NOTIFY_REG);
      $setup(posedge WRAD14, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD14, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD14, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD14, 0.0, NOTIFY_REG);
      $setup(posedge WRAD13, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD13, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD13, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD13, 0.0, NOTIFY_REG);
      $setup(posedge WRAD12, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD12, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD12, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD12, 0.0, NOTIFY_REG);
      $setup(posedge WRAD11, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD11, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD11, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD11, 0.0, NOTIFY_REG);
      $setup(posedge WRAD10, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD10, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD10, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD10, 0.0, NOTIFY_REG);
      $setup(posedge WRAD9, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD9, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD9, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD9, 0.0, NOTIFY_REG);
      $setup(posedge WRAD8, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD8, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD8, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD8, 0.0, NOTIFY_REG);
      $setup(posedge WRAD7, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD7, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD7, 0.0, NOTIFY_REG);
      $setup(posedge WRAD6, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD6, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD6, 0.0, NOTIFY_REG);
      $setup(posedge WRAD5, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD5, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD5, 0.0, NOTIFY_REG);
      $setup(posedge WRAD4, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD4, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD4, 0.0, NOTIFY_REG);
      $setup(posedge WRAD3, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD3, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD3, 0.0, NOTIFY_REG);
      $setup(posedge WRAD2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD2, 0.0, NOTIFY_REG);
      $setup(posedge WRAD1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);  
      $hold(posedge WCLK &&& WEN1, posedge WRAD1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD1, 0.0, NOTIFY_REG);
      $setup(posedge WRAD0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge WRAD0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);  
      $hold(posedge WCLK &&& WEN1, posedge WRAD0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD0, 0.0, NOTIFY_REG);


      $setup(posedge WD35, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD35, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD35, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD35, 0.0, NOTIFY_REG);
      $setup(posedge WD34, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD34, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD34, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD34, 0.0, NOTIFY_REG);
      $setup(posedge WD33, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD33, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD33, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD33, 0.0, NOTIFY_REG);
      $setup(posedge WD32, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD32, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD32, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD32, 0.0, NOTIFY_REG);
      $setup(posedge WD31, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD31, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD31, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD31, 0.0, NOTIFY_REG);
      $setup(posedge WD30, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD30, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD30, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD30, 0.0, NOTIFY_REG);
      $setup(posedge WD29, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD29, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD29, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD29, 0.0, NOTIFY_REG);
      $setup(posedge WD28, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD28, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD28, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD28, 0.0, NOTIFY_REG);
      $setup(posedge WD27, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD27, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD27, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD27, 0.0, NOTIFY_REG);
      $setup(posedge WD26, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD26, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD26, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD26, 0.0, NOTIFY_REG);
      $setup(posedge WD25, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD25, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD25, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD25, 0.0, NOTIFY_REG);
      $setup(posedge WD24, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD24, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD24, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD24, 0.0, NOTIFY_REG);
      $setup(posedge WD23, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD23, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD23, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD23, 0.0, NOTIFY_REG);
      $setup(posedge WD22, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD22, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD22, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD22, 0.0, NOTIFY_REG);
      $setup(posedge WD21, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD21, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD21, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD21, 0.0, NOTIFY_REG);
      $setup(posedge WD20, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD20, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD20, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD20, 0.0, NOTIFY_REG);
      $setup(posedge WD19, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD19, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD19, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD19, 0.0, NOTIFY_REG);
      $setup(posedge WD18, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD18, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD18, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD18, 0.0, NOTIFY_REG);
      $setup(posedge WD17, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD17, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD17, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD17, 0.0, NOTIFY_REG);
      $setup(posedge WD16, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD16, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD16, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD16, 0.0, NOTIFY_REG);
      $setup(posedge WD15, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD15, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD15, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD15, 0.0, NOTIFY_REG);
      $setup(posedge WD14, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD14, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD14, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD14, 0.0, NOTIFY_REG);
      $setup(posedge WD13, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD13, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD13, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD13, 0.0, NOTIFY_REG);
      $setup(posedge WD12, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD12, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD12, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD12, 0.0, NOTIFY_REG);
      $setup(posedge WD11, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD11, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD11, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD11, 0.0, NOTIFY_REG);
      $setup(posedge WD10, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD10, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD10, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD10, 0.0, NOTIFY_REG);
      $setup(posedge WD9, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD9, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD9, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD9, 0.0, NOTIFY_REG);
      $setup(posedge WD8, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD8, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD8, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD8, 0.0, NOTIFY_REG);
      $setup(posedge WD7, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD7, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD7, 0.0, NOTIFY_REG);
      $setup(posedge WD6, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD6, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD6, 0.0, NOTIFY_REG);
      $setup(posedge WD5, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD5, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD5, 0.0, NOTIFY_REG);
      $setup(posedge WD4, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD4, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD4, 0.0, NOTIFY_REG);
      $setup(posedge WD3, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD3, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD3, 0.0, NOTIFY_REG);
      $setup(posedge WD2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD2, 0.0, NOTIFY_REG);
      $setup(posedge WD1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD1, 0.0, NOTIFY_REG);
      $setup(posedge WD0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge WD0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge WD0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD0, 0.0, NOTIFY_REG);
 

      $setup(posedge WEN, posedge WCLK, 0.0, NOTIFY_REG);
      $setup(negedge WEN, posedge WCLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, posedge WEN, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, negedge WEN, 0.0, NOTIFY_REG);

      $setup(posedge WW2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge WW2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge WW2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WW2, 0.0, NOTIFY_REG);
      $setup(posedge WW1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge WW1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge WW1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WW1, 0.0, NOTIFY_REG);
      $setup(posedge WW0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge WW0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge WW0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WW0, 0.0, NOTIFY_REG);

      $setup(posedge RW2, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge RW2, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge RW2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RW2, 0.0, NOTIFY_REG);
      $setup(posedge RW1, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge RW1, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge RW1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RW1, 0.0, NOTIFY_REG);
      $setup(posedge RW0, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge RW0, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge RW0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RW0, 0.0, NOTIFY_REG);

      $setup(posedge RDAD15, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD15, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD15, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD15, 0.0, NOTIFY_REG);
      $setup(posedge RDAD14, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD14, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD14, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD14, 0.0, NOTIFY_REG);
      $setup(posedge RDAD13, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD13, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD13, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD13, 0.0, NOTIFY_REG);
      $setup(posedge RDAD12, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD12, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD12, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD12, 0.0, NOTIFY_REG);
      $setup(posedge RDAD11, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD11, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD11, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD11, 0.0, NOTIFY_REG);
      $setup(posedge RDAD10, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD10, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD10, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD10, 0.0, NOTIFY_REG);
      $setup(posedge RDAD9, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD9, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD9, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD9, 0.0, NOTIFY_REG);
      $setup(posedge RDAD8, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD8, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD8, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD8, 0.0, NOTIFY_REG);
      $setup(posedge RDAD7, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD7, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD7, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD7, 0.0, NOTIFY_REG);
      $setup(posedge RDAD6, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD6, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD6, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD6, 0.0, NOTIFY_REG);
      $setup(posedge RDAD5, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD5, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD5, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD5, 0.0, NOTIFY_REG);
      $setup(posedge RDAD4, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD4, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD4, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD4, 0.0, NOTIFY_REG);
      $setup(posedge RDAD3, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD3, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD3, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD3, 0.0, NOTIFY_REG);
      $setup(posedge RDAD2, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD2, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD2, 0.0, NOTIFY_REG);
      $setup(posedge RDAD1, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD1, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD1, 0.0, NOTIFY_REG);
      $setup(posedge RDAD0, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge RDAD0, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge RDAD0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD0, 0.0, NOTIFY_REG);

     

      $setup(posedge REN, posedge RCLK, 0.0, NOTIFY_REG);
      $setup(negedge REN, posedge RCLK, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, posedge REN, 0.0, NOTIFY_REG);
      $hold(posedge RCLK, negedge REN, 0.0, NOTIFY_REG);

      $setup(posedge DEPTH3, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH3, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge DEPTH3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge DEPTH3, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge DEPTH2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge DEPTH2, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge DEPTH1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge DEPTH1, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge DEPTH0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge DEPTH0, 0.0, NOTIFY_REG);

      $setup(posedge DEPTH3, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH3, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge DEPTH3, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge DEPTH3, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH2, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH2, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge DEPTH2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge DEPTH2, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH1, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH1, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge DEPTH1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge DEPTH1, 0.0, NOTIFY_REG);
      $setup(posedge DEPTH0, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge DEPTH0, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge DEPTH0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge DEPTH0, 0.0, NOTIFY_REG);


endspecify

 endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME  : RAM64K36P
---------------------------------------------------------------------*/
`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

`define RCLK_TO_RD 5.0

module RAM64K36P(DEPTH3,DEPTH2,DEPTH1,DEPTH0,WRAD15,WRAD14,WRAD13,WRAD12,
                WRAD11,WRAD10,WRAD9,WRAD8,WRAD7,WRAD6,WRAD5,WRAD4,
                WRAD3,WRAD2,WRAD1,WRAD0,
                WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26,
                WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,
                WD15,WD14,WD13,WD12,WD11,WD10,WD9 ,WD8 ,WD7 ,WD6,
                WD5, WD4, WD3, WD2, WD1, WD0,
                WW2,WW1,WW0,WEN,
                WCLK,RDAD15,RDAD14,RDAD13,RDAD12,RDAD11,RDAD10,RDAD9,
                RDAD8,RDAD7,RDAD6,RDAD5,RDAD4,RDAD3,RDAD2, RDAD1,RDAD0,
                RW2,RW1,RW0,REN,
                RCLK,
                RD35,RD34,RD33,RD32,RD31,RD30,RD29,RD28,RD27,RD26,
                RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,
                RD15,RD14,RD13,RD12,RD11,RD10,RD9, RD8, RD7, RD6,
                RD5, RD4, RD3, RD2, RD1, RD0);

input WRAD15,WRAD14,WRAD13,WRAD12,WRAD11,WRAD10,WRAD9,WRAD8,WRAD7,WRAD6,WRAD5,WRAD4,WRAD3,WRAD2,WRAD1,WRAD0;
input WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26;
input WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16;
input WD15,WD14,WD13,WD12,WD11,WD10,WD9 ,WD8 ,WD7 ,WD6;
input WD5, WD4, WD3, WD2, WD1, WD0;

input WW2,WW1,WW0;
input WCLK,WEN;

input RCLK,REN;
input RW2,RW1,RW0;
input RDAD15,RDAD14,RDAD13,RDAD12,RDAD11,RDAD10,RDAD9,RDAD8,RDAD7,RDAD6,RDAD5,RDAD4,RDAD3,RDAD2,RDAD1,RDAD0;

input DEPTH3,DEPTH2,DEPTH1,DEPTH0;

output RD35,RD34,RD33,RD32,RD31,RD30,RD29,RD28,RD27,RD26;
output RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16;
output RD15,RD14,RD13,RD12,RD11,RD10,RD9, RD8, RD7, RD6;
output RD5,RD4,RD3,RD2,RD1,RD0;

reg RD35P_stg1,RD34P_stg1,RD33P_stg1,RD32P_stg1,RD31P_stg1,RD30P_stg1,RD29P_stg1,RD28P_stg1,RD27P_stg1,RD26P_stg1;
reg RD25P_stg1,RD24P_stg1,RD23P_stg1,RD22P_stg1,RD21P_stg1,RD20P_stg1,RD19P_stg1,RD18P_stg1,RD17P_stg1,RD16P_stg1;
reg RD15P_stg1,RD14P_stg1,RD13P_stg1,RD12P_stg1,RD11P_stg1,RD10P_stg1,RD9P_stg1, RD8P_stg1, RD7P_stg1, RD6P_stg1;
reg RD5P_stg1,RD4P_stg1,RD3P_stg1,RD2P_stg1,RD1P_stg1,RD0P_stg1;

reg RD35PP,RD34PP,RD33PP,RD32PP,RD31PP,RD30PP,RD29PP,RD28PP,RD27PP,RD26PP;
reg RD25PP,RD24PP,RD23PP,RD22PP,RD21PP,RD20PP,RD19PP,RD18PP,RD17PP,RD16PP;
reg RD15PP,RD14PP,RD13PP,RD12PP,RD11PP,RD10PP,RD9PP, RD8PP, RD7PP, RD6PP;
reg RD5PP,RD4PP,RD3PP,RD2PP,RD1PP,RD0PP;

reg REN_stg1;

wire RCLK1,WCLK1;

reg [8:0] MEM_8K_9 [0:8191];

reg NOTIFY_REG;

integer WADDR;            // Write Address
   integer MAX_WADDR;  
integer RADDR;            // Read address
     integer MAX_RADDR;  
integer DEPTH;
integer MAXADD;

time    WCLK1_re, RCLK1_re;
reg     WEN_lat, REN_lat;

 /********************* TEXT MACRO DEFINITIONS ******************/

`define WRITE_WIDTH_CFG_P {WW2,WW1,WW0}
`define READ_WIDTH_CFG_P  {RW2,RW1,RW0}
`define WRITE_ADDR_P      {WRAD15,WRAD14,WRAD13,WRAD12,WRAD11,WRAD10,WRAD9,WRAD8,WRAD7,WRAD6,WRAD5,WRAD4,WRAD3,WRAD2,WRAD1,WRAD0}
`define READ_ADDR_P       {RDAD15,RDAD14,RDAD13,RDAD12,RDAD11,RDAD10,RDAD9,RDAD8,RDAD7,RDAD6,RDAD5,RDAD4,RDAD3,RDAD2,RDAD1,RDAD0}
`define DATAP_WIDTH_1    RD0P_stg1
`define DATAP_WIDTH_2   {RD1P_stg1,RD0P_stg1}
`define DATAP_WIDTH_4   {RD3P_stg1,RD2P_stg1,RD1P_stg1,RD0P_stg1}
`define DATAP_WIDTH_9   {RD8P_stg1,RD7P_stg1,RD6P_stg1,RD5P_stg1,RD4P_stg1,RD3P_stg1,RD2P_stg1,RD1P_stg1,RD0P_stg1}
`define DATAP_WIDTH_18  {RD17P_stg1,RD16P_stg1,RD15P_stg1,RD14P_stg1,RD13P_stg1,RD12P_stg1,RD11P_stg1,RD10P_stg1,RD9P_stg1,                                    RD8P_stg1,RD7P_stg1,RD6P_stg1,RD5P_stg1,RD4P_stg1,RD3P_stg1,RD2P_stg1,RD1P_stg1,RD0P_stg1}
`define DATAP_WIDTH_36  {RD35P_stg1,RD34P_stg1,RD33P_stg1,RD32P_stg1,RD31P_stg1,RD30P_stg1,                                                                    RD29P_stg1,RD28P_stg1,RD27P_stg1,RD26P_stg1,RD25P_stg1,RD24P_stg1,                                                                    RD23P_stg1,RD22P_stg1,RD21P_stg1,RD20P_stg1,RD19P_stg1,RD18P_stg1,                                                                    RD17P_stg1,RD16P_stg1,RD15P_stg1,RD14P_stg1,RD13P_stg1,RD12P_stg1,                                                                    RD11P_stg1,RD10P_stg1,RD9P_stg1,RD8P_stg1,RD7P_stg1,RD6P_stg1,                                                                        RD5P_stg1,RD4P_stg1,RD3P_stg1,RD2P_stg1,RD1P_stg1,RD0P_stg1} 

`define DATAPP_WIDTH_1   RD0PP
`define DATAPP_WIDTH_2  {RD1PP,RD0PP}
`define DATAPP_WIDTH_4  {RD3PP,RD2PP,RD1PP,RD0PP}
`define DATAPP_WIDTH_9  {RD8PP,RD7PP,RD6PP,RD5PP,RD4PP,RD3PP,RD2PP,RD1PP,RD0PP}
`define DATAPP_WIDTH_18 {RD17PP,RD16PP,RD15PP,RD14PP,RD13PP,RD12PP,RD11PP,RD10PP,RD9PP,                                                                        RD8PP,RD7PP,RD6PP,RD5PP,RD4PP,RD3PP,RD2PP,RD1PP,RD0PP}
`define DATAPP_WIDTH_36 {RD35PP,RD34PP,RD33PP,RD32PP,RD31PP,RD30PP,                                                                                            RD29PP,RD28PP,RD27PP,RD26PP,RD25PP,RD24PP,                                                                                            RD23PP,RD22PP,RD21PP,RD20PP,RD19PP,RD18PP,                                                                                            RD17PP,RD16PP,RD15PP,RD14PP,RD13PP,RD12PP,                                                                                            RD11PP,RD10PP,RD9PP,RD8PP,RD7PP,RD6PP,                                                                                                RD5PP,RD4PP,RD3PP,RD2PP,RD1PP,RD0PP}
 
/**************************************************************/

buf inst3(WCLK1,WCLK);
buf inst4(RCLK1, RCLK);
buf inst50(WEN1,WEN);
buf inst60(REN1,REN);

pmos inst5(RD35, RD35PP, 0);
pmos inst6(RD34, RD34PP, 0);
pmos inst7(RD33, RD33PP, 0);
pmos inst8(RD32, RD32PP, 0);
pmos inst9(RD31, RD31PP, 0);
pmos inst10(RD30, RD30PP, 0);
pmos inst11(RD29, RD29PP, 0);
pmos inst12(RD28, RD28PP, 0);
pmos inst13(RD27, RD27PP, 0);

pmos inst14(RD26, RD26PP, 0);
pmos inst15(RD25, RD25PP, 0);
pmos inst16(RD24, RD24PP, 0);
pmos inst17(RD23, RD23PP, 0);
pmos inst18(RD22, RD22PP, 0);
pmos inst19(RD21, RD21PP, 0);
pmos inst20(RD20, RD20PP, 0);
pmos inst21(RD19, RD19PP, 0);
pmos inst22(RD18, RD18PP, 0);

pmos inst23(RD17, RD17PP, 0);
pmos inst24(RD16, RD16PP, 0);
pmos inst25(RD15, RD15PP, 0);
pmos inst26(RD14, RD14PP, 0);
pmos inst27(RD13, RD13PP, 0);
pmos inst28(RD12, RD12PP, 0);
pmos inst29(RD11, RD11PP, 0);
pmos inst30(RD10, RD10PP, 0);
pmos inst31(RD9, RD9PP, 0);


pmos inst32(RD8, RD8PP, 0);
pmos inst33(RD7, RD7PP, 0);
pmos inst34(RD6, RD6PP, 0);
pmos inst35(RD5, RD5PP, 0);
pmos inst36(RD4, RD4PP,0);
pmos inst37(RD3, RD3PP, 0);
pmos inst38(RD2, RD2PP, 0);
pmos inst39(RD1, RD1PP, 0);
pmos inst40(RD0, RD0PP, 0);


parameter MEMORYFILE = "";

  initial
    begin
      if ( MEMORYFILE != "")
        $readmemb ( MEMORYFILE, MEM_8K_9 );
      else
        begin
          //$display ( "Warning: %m, No memory initialization file parameter MEMORYFILE defined\n");
        end
    end


always @(WCLK1 === 1'bx )
begin
  if($time > 0) begin
   if(WEN1 == 1'b1) begin
      $display("Warning : WCLK went unknown at time %0.1f\n",$realtime);
     // $finish;
   end
  end
end

always @(RCLK1 === 1'bx )
begin
  if($time > 0) begin
   //if (REN1 == 1'b1) begin
      $display("Warning : RCLK went unknown at time %0.1f\n",$realtime);
      case(`READ_WIDTH_CFG_P)
        3'b000 :  `DATAP_WIDTH_1 = 1'bx;
        3'b001 :  `DATAP_WIDTH_2 = 2'bx;
        3'b010 :  `DATAP_WIDTH_4 = 4'bx;
        3'b011 :  `DATAP_WIDTH_9 = 9'bx;
        3'b100 :  `DATAP_WIDTH_18  = 18'bx;
        3'b101 :  `DATAP_WIDTH_36  = 36'bx;
        default : begin
                    $display("Warning : Invalid READ WIDTH,Legal Width: 1,2,4,9,18,36");
                  end
      endcase
   //end
  end
end

always @(DEPTH3 or DEPTH2 or DEPTH1 or DEPTH0 or WW2 or WW1 or WW0)
   MAX_WADDR = get_max_address(DEPTH3, DEPTH2, DEPTH1, DEPTH0,`WRITE_WIDTH_CFG);

always @(DEPTH3 or DEPTH2 or DEPTH1 or DEPTH0 or RW2 or RW1 or RW0)
   MAX_RADDR = get_max_address(DEPTH3, DEPTH2, DEPTH1, DEPTH0,`READ_WIDTH_CFG);

// start the RAM write behavior section

always @(posedge WCLK1) begin 
    WCLK1_re = $time;
    WEN_lat  = WEN1;
    if(WEN1 == 1'b1)  begin
      WADDR = get_address(`WRITE_ADDR_P);         // call address calculation function to get write address
      if(WADDR < 0) begin
         $display("Warning: WADDR is  Unkown at time %d", $time);
        // $finish;
      end else if (WADDR >= MAX_WADDR) begin 
	  $display ("Warning : WRITE ADDRESS IS OUT OF RANGE at time %0.1f", $realtime);
	  $display ("WADDR = %0d, MAX WRITE ADDRESS = %0d,\n",WADDR, MAX_WADDR - 1);	  
      end else begin                                             // -- if (WADDR >=0) legal address range 
        // Check for Write and Read to the same address, write is not affected
        if ( (REN_lat == 1'b1) && same_addr(WADDR, RADDR, `WRITE_WIDTH_CFG_P, `READ_WIDTH_CFG_P) &&
                                                              ((RCLK1_re + `RCLK_TO_RD) > WCLK1_re) ) begin
         $display (" ** Warning: Read and Write to same address at same time.  RD is unpredictable, driving RD to X ");
         $display (" Time: %0.1f Instance: %m ", $realtime );
         `DATAP_WIDTH_36 = drive_rd_x (WADDR, RADDR, `WRITE_WIDTH_CFG_P, `READ_WIDTH_CFG_P, `DATAP_WIDTH_36);
        end
        case ({WW2,WW1,WW0})
            3'b000 : MEM_8K_9 [ WADDR[15:3] ] [ WADDR[2:0] ] <= WD0;

            3'b001 : begin
                     MEM_8K_9 [ WADDR[14:2] ] [ WADDR[1:0] * 2 ] <= WD0;
                     MEM_8K_9 [ WADDR[14:2] ] [ WADDR[1:0] * 2 + 1 ] <= WD1;
                end
            3'b010 : begin
                     MEM_8K_9 [ WADDR[13:1] ] [ WADDR[0] * 4 ] <= WD0;
                     MEM_8K_9 [ WADDR[13:1] ] [ WADDR[0] * 4 + 1 ]  <= WD1;
                     MEM_8K_9 [ WADDR[13:1] ] [ WADDR[0] * 4 + 2 ]  <= WD2;
                     MEM_8K_9 [ WADDR[13:1] ] [ WADDR[0] * 4 + 3 ]  <= WD3;
                end
            3'b011 : begin
                     MEM_8K_9 [ WADDR[12:0] ]  <= {WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
                end
            3'b100 : begin
                     MEM_8K_9 [ WADDR[11:0] * 2 ]  <= { WD8, WD7, WD6, WD5, WD4, WD3, WD2, WD1, WD0 };
                     MEM_8K_9 [ WADDR[11:0] * 2 + 1 ]  <= { WD17, WD16, WD15, WD14, WD13, WD12, WD11, WD10, WD9 };
                end
            3'b101 : begin
                     MEM_8K_9 [ WADDR[10:0] * 4 ]  <= { WD8, WD7, WD6, WD5, WD4, WD3, WD2, WD1, WD0 };
                     MEM_8K_9 [ WADDR[10:0] * 4 + 1 ]  <= { WD17, WD16, WD15, WD14, WD13, WD12, WD11, WD10, WD9 };
                     MEM_8K_9 [ WADDR[10:0] * 4 + 2 ]  <= { WD26, WD25, WD24, WD23, WD22, WD21, WD20, WD19, WD18 };
                     MEM_8K_9 [ WADDR[10:0] * 4 + 3 ]  <= { WD35, WD34, WD33, WD32, WD31, WD30, WD29, WD28, WD27 };
               end
      default : begin
                 $display("Warning: WWIDTH value invalid");
                // $finish;
                end
    endcase
    end
   end else if (WEN1 == 1'b0) begin
      // $display("MSG :  WEN are Low!  No memory writing at time =%d", $time);
   end else begin
       $display ("Warning: WEN went unknown at time %d ns", $time);
      // $finish;
   end
 end


  // start the RAM read behaviour section

 always @(posedge RCLK1) begin                                // BLOCK :  at the rise edge of READ CLOCK RCLK1 
   RCLK1_re = $time;
   REN_lat  = REN1;
   if ( REN_stg1 == 1'b1 ) begin 
     case(`READ_WIDTH_CFG_P)
       3'b000 :  `DATAPP_WIDTH_1 = `DATAP_WIDTH_1;
       3'b001 :  `DATAPP_WIDTH_2 = `DATAP_WIDTH_2;
       3'b010 :  `DATAPP_WIDTH_4 = `DATAP_WIDTH_4;
       3'b011 :  `DATAPP_WIDTH_9 = `DATAP_WIDTH_9;
       3'b100 :  `DATAPP_WIDTH_18= `DATAP_WIDTH_18;
       3'b101 :  `DATAPP_WIDTH_36= `DATAP_WIDTH_36;
       default :  $display("Warning : Invalid READ WIDTH, Legal Width: 1,2,4,9,18,36");
     endcase
   end else if ( REN_stg1 == 1'bx ) begin
     case(`READ_WIDTH_CFG_P)
       3'b000 :  `DATAPP_WIDTH_1  = 1'bx;
       3'b001 :  `DATAPP_WIDTH_2  = 2'bx;
       3'b010 :  `DATAPP_WIDTH_4  = 4'bx;
       3'b011 :  `DATAPP_WIDTH_9  = 9'bx;
       3'b100 :  `DATAPP_WIDTH_18 = 18'bx;
       3'b101 :  `DATAPP_WIDTH_36 = 36'bx;
       default :  $display("Warning : Invalid READ WIDTH, Legal Width: 1,2,4,9,18,36");
     endcase
   end
     
  if(REN1 == 1'b0 ) begin 
                                             //BLOCK: REN == 1'b0
   /*case(`READ_WIDTH_CFG_P)
      3'b000 :  `DATAPP_WIDTH_1 = `DATAP_WIDTH_1;
      3'b001 :  `DATAPP_WIDTH_2 = `DATAP_WIDTH_2;
      3'b010 :  `DATAPP_WIDTH_4 = `DATAP_WIDTH_4;
      3'b011 :  `DATAPP_WIDTH_9 = `DATAP_WIDTH_9;
      3'b100 :  `DATAPP_WIDTH_18= `DATAP_WIDTH_18;
      3'b101 :  `DATAPP_WIDTH_36= `DATAP_WIDTH_36;
      default :  $display("Warning : Invalid READ WIDTH, Legal Width: 1,2,4,9,18,36");
   endcase

    //$display ("MSG: REN is low at time = %d ",$time);
    case(`READ_WIDTH_CFG_P)
     3'b000 :  `DATAP_WIDTH_1 = 1'bx;
     3'b001 :  `DATAP_WIDTH_2 = 2'bx;
     3'b010 :  `DATAP_WIDTH_4 = 4'bx;
     3'b011 :  `DATAP_WIDTH_9 = 9'bx;
     3'b100 :  `DATAP_WIDTH_18= 18'bx;
     3'b101 :  `DATAP_WIDTH_36= 36'bx;
      default :  $display("Warning : Invalid READ WIDTH, Legal Width: 1,2,4,9,18,36");
    endcase*/

  end
  else if(REN1 == 1'b1 )  begin      // BLOCK: REN == 1'b1

     RADDR =get_address(`READ_ADDR_P);                                     //  call address calculation function
    if (RADDR < 0) begin                                                                 // BLOCK: RADDR < 0
     $display ("Warning :  Invalid  READ ADDRESS! -- address unknown X at time = %d",$time);
     case(`READ_WIDTH_CFG_P)
      3'b000 :  `DATAP_WIDTH_1 = 1'bx;
      3'b001 :  `DATAP_WIDTH_2 = 2'bx;
      3'b010 :  `DATAP_WIDTH_4 = 4'bx;
      3'b011 :  `DATAP_WIDTH_9 = 9'bx;
      3'b100 :  `DATAP_WIDTH_18  = 18'bx;
      3'b101 :  `DATAP_WIDTH_36  = 36'bx;
      default : begin
                 $display("Warning : Invalid READ WIDTH at time %d ns,Legal Width: 1,2,4,9,18,36", $time);
                 //$finish;
                end
     endcase
      end else if (RADDR >= MAX_RADDR) begin 
	  $display ("Warning : READ ADDRESS IS OUT OF RANGE at time %0.1f", $realtime);
	  $display ("RADDR = %0d, MAX READ ADDRESS = %0d,\n",RADDR, MAX_RADDR - 1);
     case(`READ_WIDTH_CFG)
      3'b000 :  `DATAP_WIDTH_1 = 1'bx;
      3'b001 :  `DATAP_WIDTH_2 = 2'bx;
      3'b010 :  `DATAP_WIDTH_4 = 4'bx;
      3'b011 :  `DATAP_WIDTH_9 = 9'bx;
      3'b100 :  `DATAP_WIDTH_18  = 18'bx;
      3'b101 :  `DATAP_WIDTH_36  = 36'bx; 
      default : begin
                 $display("Warning : Invalid READ WIDTH at time %d ns,Legal Width: 1,2,4,9,18,36",$time);
                 //$finish;
                end	  
     endcase	  
    end else begin                                                                           // BLOCK: RADDR >0 and RADDR <MAXADD
      case(`READ_WIDTH_CFG_P)

        3'b000 : RD0P_stg1 = MEM_8K_9 [ RADDR[15:3] ] [ RADDR[2:0] ];
        3'b001 : begin
                  RD0P_stg1 = MEM_8K_9 [ RADDR[14:2] ] [ RADDR[1:0] * 2 ];
                  RD1P_stg1 = MEM_8K_9 [ RADDR[14:2] ] [ RADDR[1:0] * 2 + 1];
                 end
        3'b010 : begin
                  RD0P_stg1 = MEM_8K_9 [ RADDR[13:1] ] [ RADDR[0] * 4 ];
                  RD1P_stg1 = MEM_8K_9 [ RADDR[13:1] ] [ RADDR[0] * 4 + 1 ];
                  RD2P_stg1 = MEM_8K_9 [ RADDR[13:1] ] [ RADDR[0] * 4 + 2 ];
                  RD3P_stg1 = MEM_8K_9 [ RADDR[13:1] ] [ RADDR[0] * 4 + 3 ];
                 end
        3'b011 : begin
                  { RD8P_stg1, RD7P_stg1, RD6P_stg1, RD5P_stg1, RD4P_stg1,
                               RD3P_stg1, RD2P_stg1, RD1P_stg1, RD0P_stg1 } = MEM_8K_9 [ RADDR[12:0] ];
                 end
        3'b100 : begin
                  { RD8P_stg1, RD7P_stg1, RD6P_stg1, RD5P_stg1, RD4P_stg1, 
                               RD3P_stg1, RD2P_stg1, RD1P_stg1, RD0P_stg1 } = MEM_8K_9 [ RADDR[11:0] * 2 ];
                  { RD17P_stg1, RD16P_stg1, RD15P_stg1, RD14P_stg1, RD13P_stg1, 
                                RD12P_stg1, RD11P_stg1, RD10P_stg1, RD9P_stg1 } = MEM_8K_9 [ RADDR[11:0] * 2 + 1 ];
                 end
        3'b101 : begin
                  { RD8P_stg1, RD7P_stg1, RD6P_stg1, RD5P_stg1, RD4P_stg1, 
                          RD3P_stg1, RD2P_stg1, RD1P_stg1, RD0P_stg1 } = MEM_8K_9 [ RADDR[10:0] * 4 ];
                  { RD17P_stg1, RD16P_stg1, RD15P_stg1, RD14P_stg1, RD13P_stg1,
                           RD12P_stg1, RD11P_stg1, RD10P_stg1, RD9P_stg1 } = MEM_8K_9 [ RADDR[10:0] * 4 + 1 ];
                  { RD26P_stg1, RD25P_stg1, RD24P_stg1, RD23P_stg1, RD22P_stg1,
                           RD21P_stg1, RD20P_stg1, RD19P_stg1, RD18P_stg1 } = MEM_8K_9 [ RADDR[10:0] * 4 + 2 ];
                  { RD35P_stg1, RD34P_stg1, RD33P_stg1, RD32P_stg1, RD31P_stg1, 
                           RD30P_stg1, RD29P_stg1, RD28P_stg1, RD27P_stg1 } = MEM_8K_9 [ RADDR[10:0] * 4 + 3 ];
                 end
       default : begin
                  $display ("Warning: invalid READ WIDTH, Legal Width: 1,2,4,9,18,36");
                 end
      endcase

      // Check for Write and Read to the same address
      if ( (WEN_lat == 1'b1) && same_addr(WADDR, RADDR, `WRITE_WIDTH_CFG_P, `READ_WIDTH_CFG_P) &&
                                                        ((WCLK1_re + `RCLK_TO_RD) > RCLK1_re)) begin
        $display (" ** Warning: Write and Read to same address at same time.  RD is unpredictable, driving RD to X");
        $display (" Time: %0.1f Instance: %m ", $realtime );
        `DATAP_WIDTH_36 = drive_rd_x (WADDR, RADDR, `WRITE_WIDTH_CFG_P, `READ_WIDTH_CFG_P, `DATAP_WIDTH_36);
      end // check for Write and Read to the same address
    end
  end                                        // END OF BLOCK: REN == 1'b1
  else begin                                 //  START OF BLOCK: REN unknow (x), both pipeline stages are x output
    $display("Warning: REN is unknown at time  %d ns", $time);
    case(`READ_WIDTH_CFG_P)
      3'b000 :  begin
                 `DATAP_WIDTH_1 = 1'bx;
                end
      3'b001 :  begin
                 `DATAP_WIDTH_2 = 2'bx;
                end
      3'b010 :  begin
                 `DATAP_WIDTH_4 = 4'bx;
                end
      3'b011 :  begin
                 `DATAP_WIDTH_9 = 9'bx;
                end
      3'b100 :  begin
                 `DATAP_WIDTH_18 = 18'bx;
                end
      3'b101 :  begin
                 `DATAP_WIDTH_36 = 36'bx;
                end
      default : begin
                 $display("Warning : Invalid READ WIDTH,Legal Width: 1,2,4,9,18,36");
                // $finish;
               end
    endcase
 end 
 REN_stg1 = REN1;
end                              // end of the RCLK1 scope


// function to check if write and read operations are accessing the same memory location

function same_addr;
  input [15:0] waddr, raddr;
  input [2:0]  ww, rw;
  integer      wr_addr, rd_addr;
  begin
    same_addr = 1'b0;
    if ( ww > rw ) begin
      rd_addr = raddr >> (  ww - rw );
      wr_addr = waddr; 
    end
    else if ( rw > ww )begin
      rd_addr = raddr;
      wr_addr = waddr >> (  rw - ww );
    end
    else begin
      rd_addr = raddr;
      wr_addr = waddr; 
    end
    if ( wr_addr == rd_addr ) begin
      same_addr = 1'b1;
    end
  end
endfunction


// function to drive read data bus to "x" depending on width configuration

function [35:0] drive_rd_x;
  input [15:0]  waddr, raddr;
  input [2:0]   ww, rw;
  input [35:0]  rd_data;
  integer       index, i;
  begin
    drive_rd_x = rd_data;
    case(rw)
      3'b000 : begin
                 drive_rd_x [0] =  1'bx;
               end
      3'b001 : begin
                 if ( ww == 3'b000 )
                   drive_rd_x [ waddr[0] ] =  1'bx;
                 else
                   drive_rd_x [ 1:0 ] =  2'bx;
               end
      3'b010 : begin
                 if ( ww == 3'b000 )
                   drive_rd_x [ waddr[1:0] ] =  1'bx;
                 else if ( ww == 3'b001 ) begin
                   index = waddr[0] * 2;
                   for ( i=index; i<index+2; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else
                   drive_rd_x [ 3:0 ] =  4'bx;
               end
      3'b011 : begin
                 if ( ww == 3'b000 )
                   drive_rd_x [ waddr[2:0] ] =  1'bx;
                 else if ( ww == 3'b001 ) begin
                   index = waddr[1:0] * 2;
                   for ( i=index; i<index+2; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b010 ) begin
                   index = waddr[0] * 4;
                   for ( i=index; i<index+4; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else
                   drive_rd_x [ 8:0 ] =  9'bx;
               end
      3'b100 : begin
                 if ( ww == 3'b000 )
                   drive_rd_x [ waddr[3:0] ] =  1'bx;
                 else if ( ww == 3'b001 ) begin
                   index = waddr[2:0] * 2;
                   for ( i=index; i<index+2; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b010 ) begin
                   index = waddr[1:0] * 4;
                   for ( i=index; i<index+4; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b011 ) begin
                   index = waddr[0] * 9;
                   for ( i=index; i<index+9; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else
                   drive_rd_x [ 17:0 ] =  18'bx;
               end
      3'b101 : begin
                 if ( ww == 3'b000 )
                   drive_rd_x [ waddr[4:0] ] =  1'bx;
                 else if ( ww == 3'b001 ) begin
                   //drive_rd_x [ waddr[3:0] * 2 + 1 : waddr[2:0] * 2 ] =  2'bx;
                   index = waddr[3:0] * 2;
                   for ( i=index; i<index+2; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b010 ) begin
                   //drive_rd_x [ waddr[2:0] * 4 + 3 : waddr[1:0] * 4 ] =  4'bx;
                   index = waddr[2:0] * 4;
                   for ( i=index; i<index+4; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b011 ) begin
                   //drive_rd_x [ waddr[1:0] * 9 + 8 : waddr[1:0] * 9 ] =  9'bx;
                   index = waddr[1:0] * 9;
                   for ( i=index; i<index+9; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else if ( ww == 3'b100 ) begin
                   //drive_rd_x [ waddr[0] * 18 + 17 : waddr[0] * 18 ] =  18'bx;
                   index = waddr[0] * 18;
                   for ( i=index; i<index+18; i=i+1 )
                     drive_rd_x [ i ] =  1'bx;
                 end else
                   drive_rd_x [ 35:0 ] =  36'bx;
               end
      default: begin
                $display("Warning : Invalid READ WIDTH at time %d ns,Legal Width: 1,2,4,9,18,36",$time);
               end
     endcase
  end
endfunction

// function  to calculate the read/write address  get_address

function integer get_address;
  input [15:0] addr_signal;
  integer ADDR;
begin

          ADDR = addr_signal[15]*32768 + addr_signal[14]*16384 + addr_signal[13]*8192 + addr_signal[12]*4096
               + addr_signal[11]*2048 + addr_signal[10]*1024 + addr_signal[9]*512 + addr_signal[8]*256
               + addr_signal[7]*128 + addr_signal[6]*64 + addr_signal[5]*32 + addr_signal[4]*16
               + addr_signal[3]*8 + addr_signal[2]*4 + addr_signal[1]*2 + addr_signal[0]*1;
  get_address =ADDR;
 end
endfunction

 // function to get the depth

function integer get_depth;
  input DEPTH3,DEPTH2,DEPTH1,DEPTH0;
  integer depth;
begin
  get_depth = DEPTH3*8 + DEPTH2*4 + DEPTH1*2 + DEPTH0*1;
end
endfunction


// function to get the maximum address
function integer get_max_address;
  input DEPTH3,DEPTH2,DEPTH1,DEPTH0;
  input [2:0] width_cfg;
  integer depth;
  begin
   depth = get_depth( DEPTH3,DEPTH2,DEPTH1,DEPTH0 );
   case (width_cfg)
   3'b000 : get_max_address = 4096 * (depth +1);
   3'b001 : get_max_address = 2048 * (depth +1);
   3'b010 : get_max_address = 1024 * (depth +1);
   3'b011 : get_max_address = 512 *  (depth +1);
   3'b100 : get_max_address = 256  * (depth +1);
   3'b101 : get_max_address = 128  * (depth +1);
   default : begin
             $display("Illegal WIDTH PORT configuration!");
             $finish;
             end
   endcase
  end
endfunction


/*************************** TIMING CHECK SECTION ************************/
 
specify
      specparam   LibName     = "ax";
      (posedge RCLK => (RD35+:RD35) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD34+:RD24) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD33+:RD33) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD32+:RD32) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD31+:RD31) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD30+:RD30) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD29+:RD29) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD28+:RD28) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD27+:RD27) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (RD26+:RD26) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD25+:RD25) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD24+:RD24) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD23+:RD23) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD22+:RD22) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD21+:RD21) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD20+:RD20) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD19+:RD19) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD18+:RD18) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (RD17+:RD17) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD16+:RD16) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD15+:RD15) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD14+:RD14) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD13+:RD13) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD12+:RD12) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD11+:RD11) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD10+:RD10) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD9+:RD9) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

      (posedge RCLK => (RD8+:RD8) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD7+:RD7) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD6+:RD6) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD5+:RD5) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD4+:RD4) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD3+:RD3) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD2+:RD2) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD1+:RD1) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
      (posedge RCLK => (RD0+:RD0) ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

    if ( WEN1 )
      (posedge WCLK => (RD35+:RD35) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD34+:RD24) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD33+:RD33) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD32+:RD32) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD31+:RD31) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD30+:RD30) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD29+:RD29) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD28+:RD28) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD27+:RD27) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);

    if ( WEN1 )
      (posedge WCLK => (RD26+:RD26) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD25+:RD25) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD24+:RD24) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD23+:RD23) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD22+:RD22) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD21+:RD21) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD20+:RD20) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD19+:RD19) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD18+:RD18) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);

    if ( WEN1 )
      (posedge WCLK => (RD17+:RD17) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD16+:RD16) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD15+:RD15) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD14+:RD14) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD13+:RD13) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD12+:RD12) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD11+:RD11) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD10+:RD10) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD9+:RD9) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);


    if ( WEN1 )
      (posedge WCLK => (RD8+:RD8) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD7+:RD7) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD6+:RD6) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD5+:RD5) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD4+:RD4) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD3+:RD3) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD2+:RD2) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD1+:RD1) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);
    if ( WEN1 )
      (posedge WCLK => (RD0+:RD0) ) = (0.0:0.0:0.0, 0.0:0.0:0.0);

      $width(posedge WCLK &&& WEN1 , 0.0, 0, NOTIFY_REG);
      $width(negedge WCLK &&& WEN1, 0.0, 0, NOTIFY_REG);
      $width(posedge RCLK &&& REN1, 0.0, 0, NOTIFY_REG);
      $width(negedge RCLK &&& REN1, 0.0, 0, NOTIFY_REG);

      $setup(posedge WRAD15, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD15, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD15, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD15, 0.0, NOTIFY_REG);
      $setup(posedge WRAD14, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD14, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD14, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD14, 0.0, NOTIFY_REG);
      $setup(posedge WRAD13, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD13, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD13, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD13, 0.0, NOTIFY_REG);
      $setup(posedge WRAD12, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD12, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD12, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD12, 0.0, NOTIFY_REG);
      $setup(posedge WRAD11, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD11, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD11, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD11, 0.0, NOTIFY_REG);
      $setup(posedge WRAD10, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD10, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD10, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD10, 0.0, NOTIFY_REG);
      $setup(posedge WRAD9, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD9, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD9, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD9, 0.0, NOTIFY_REG);
      $setup(posedge WRAD8, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD8, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD8, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD8, 0.0, NOTIFY_REG);
      $setup(posedge WRAD7, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD7, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD7, 0.0, NOTIFY_REG);
      $setup(posedge WRAD6, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD6, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD6, 0.0, NOTIFY_REG);
      $setup(posedge WRAD5, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD5, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD5, 0.0, NOTIFY_REG);
      $setup(posedge WRAD4, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD4, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD4, 0.0, NOTIFY_REG);
      $setup(posedge WRAD3, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD3, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD3, 0.0, NOTIFY_REG);
      $setup(posedge WRAD2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD2, 0.0, NOTIFY_REG);
      $setup(posedge WRAD1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WRAD1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WRAD1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD1, 0.0, NOTIFY_REG);
      $setup(posedge WRAD0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge WRAD0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge WRAD0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WRAD0, 0.0, NOTIFY_REG);




      $setup(posedge WD35, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD35, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD35, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD35, 0.0, NOTIFY_REG);
      $setup(posedge WD34, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD34, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD34, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD34, 0.0, NOTIFY_REG);
      $setup(posedge WD33, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD33, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD33, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD33, 0.0, NOTIFY_REG);
      $setup(posedge WD32, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD32, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD32, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD32, 0.0, NOTIFY_REG);
      $setup(posedge WD31, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD31, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD31, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD31, 0.0, NOTIFY_REG);
      $setup(posedge WD30, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD30, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD30, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD30, 0.0, NOTIFY_REG);
      $setup(posedge WD29, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD29, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD29, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD29, 0.0, NOTIFY_REG);
      $setup(posedge WD28, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD28, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD28, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD28, 0.0, NOTIFY_REG);
      $setup(posedge WD27, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD27, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD27, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD27, 0.0, NOTIFY_REG);
      $setup(posedge WD26, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD26, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD26, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD26, 0.0, NOTIFY_REG);
      $setup(posedge WD25, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD25, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD25, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD25, 0.0, NOTIFY_REG);
      $setup(posedge WD24, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD24, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD24, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD24, 0.0, NOTIFY_REG);
      $setup(posedge WD23, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD23, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD23, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD23, 0.0, NOTIFY_REG);
      $setup(posedge WD22, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD22, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD22, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD22, 0.0, NOTIFY_REG);
      $setup(posedge WD21, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD21, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD21, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD21, 0.0, NOTIFY_REG);
      $setup(posedge WD20, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD20, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD20, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD20, 0.0, NOTIFY_REG);
      $setup(posedge WD19, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD19, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD19, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD19, 0.0, NOTIFY_REG);
      $setup(posedge WD18, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD18, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD18, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD18, 0.0, NOTIFY_REG);
      $setup(posedge WD17, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD17, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD17, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD17, 0.0, NOTIFY_REG);
      $setup(posedge WD16, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD16, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD16, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD16, 0.0, NOTIFY_REG);
      $setup(posedge WD15, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD15, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD15, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD15, 0.0, NOTIFY_REG);
      $setup(posedge WD14, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD14, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD14, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD14, 0.0, NOTIFY_REG);
      $setup(posedge WD13, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD13, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD13, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD13, 0.0, NOTIFY_REG);
      $setup(posedge WD12, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD12, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD12, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD12, 0.0, NOTIFY_REG);
      $setup(posedge WD11, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD11, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD11, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD11, 0.0, NOTIFY_REG);
      $setup(posedge WD10, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD10, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD10, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD10, 0.0, NOTIFY_REG);
      $setup(posedge WD9, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD9, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD9, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD9, 0.0, NOTIFY_REG);
      $setup(posedge WD8, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD8, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD8, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD8, 0.0, NOTIFY_REG);
      $setup(posedge WD7, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD7, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD7, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD7, 0.0, NOTIFY_REG);
      $setup(posedge WD6, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD6, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD6, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD6, 0.0, NOTIFY_REG);
      $setup(posedge WD5, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD5, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD5, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD5, 0.0, NOTIFY_REG);
      $setup(posedge WD4, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD4, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD4, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD4, 0.0, NOTIFY_REG);
      $setup(posedge WD3, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD3, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD3, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD3, 0.0, NOTIFY_REG);
      $setup(posedge WD2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD2, 0.0, NOTIFY_REG);
      $setup(posedge WD1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);     
      $setup(negedge WD1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);      
      $hold(posedge WCLK &&& WEN1, posedge WD1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD1, 0.0, NOTIFY_REG);
      $setup(posedge WD0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge WD0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge WD0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WD0, 0.0, NOTIFY_REG);


      $setup(posedge WEN, posedge WCLK, 0.0, NOTIFY_REG);
      $setup(negedge WEN, posedge WCLK, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, posedge WEN, 0.0, NOTIFY_REG);
      $hold(posedge WCLK, negedge WEN, 0.0, NOTIFY_REG);

      $setup(posedge WW2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge WW2, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge WW2, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WW2, 0.0, NOTIFY_REG);
      $setup(posedge WW1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge WW1, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge WW1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WW1, 0.0, NOTIFY_REG);
      $setup(posedge WW0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $setup(negedge WW0, posedge WCLK &&& WEN1, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, posedge WW0, 0.0, NOTIFY_REG);
      $hold(posedge WCLK &&& WEN1, negedge WW0, 0.0, NOTIFY_REG);

      $setup(posedge RW2, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge RW2, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge RW2, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RW2, 0.0, NOTIFY_REG);
      $setup(posedge RW1, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge RW1, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge RW1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RW1, 0.0, NOTIFY_REG);
      $setup(posedge RW0, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $setup(negedge RW0, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, posedge RW0, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RW0, 0.0, NOTIFY_REG);

      $setup(posedge RDAD15, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(negedge RDAD15, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);      
      $hold(posedge RCLK &&& REN1, posedge RDAD15, 0.0, NOTIFY_REG);
      $hold(posedge RCLK &&& REN1, negedge RDAD15, 0.0, NOTIFY_REG);
      $setup(posedge RDAD14, posedge RCLK &&& REN1, 0.0, NOTIFY_REG);     
      $setup(nege